/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.client.internal;

import com.dre.brewery.depend.bson.RawBsonDocument;
import com.dre.brewery.depend.bson.conversions.Bson;
import com.dre.brewery.depend.mongodb.AutoEncryptionSettings;
import com.dre.brewery.depend.mongodb.MongoClientException;
import com.dre.brewery.depend.mongodb.MongoException;
import com.dre.brewery.depend.mongodb.MongoOperationTimeoutException;
import com.dre.brewery.depend.mongodb.MongoTimeoutException;
import com.dre.brewery.depend.mongodb.ReadConcern;
import com.dre.brewery.depend.mongodb.ReadPreference;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.MongoClient;
import com.dre.brewery.depend.mongodb.client.MongoClients;
import com.dre.brewery.depend.mongodb.client.MongoDatabase;
import com.dre.brewery.depend.mongodb.client.internal.TimeoutHelper;
import com.dre.brewery.depend.mongodb.internal.capi.MongoCryptHelper;
import com.dre.brewery.depend.mongodb.internal.crypt.capi.MongoCrypt;
import com.dre.brewery.depend.mongodb.internal.time.Timeout;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.io.Closeable;
import java.util.Map;

class CommandMarker
implements Closeable {
    private static final String TIMEOUT_ERROR_MESSAGE = "Command marker exceeded the timeout limit.";
    @Nullable
    private final MongoClient client;
    @Nullable
    private final ProcessBuilder processBuilder;

    CommandMarker(MongoCrypt mongoCrypt, AutoEncryptionSettings settings) {
        if (MongoCryptHelper.isMongocryptdSpawningDisabled(mongoCrypt.getCryptSharedLibVersionString(), settings)) {
            this.processBuilder = null;
            this.client = null;
        } else {
            Map<String, Object> extraOptions = settings.getExtraOptions();
            boolean mongocryptdBypassSpawn = (Boolean)extraOptions.getOrDefault("mongocryptdBypassSpawn", false);
            if (!mongocryptdBypassSpawn) {
                this.processBuilder = MongoCryptHelper.createProcessBuilder(extraOptions);
                MongoCryptHelper.startProcess(this.processBuilder);
            } else {
                this.processBuilder = null;
            }
            this.client = MongoClients.create(MongoCryptHelper.createMongocryptdClientSettings((String)extraOptions.get("mongocryptdURI")));
        }
    }

    RawBsonDocument mark(String databaseName, RawBsonDocument command, @Nullable Timeout operationTimeout) {
        if (this.client != null) {
            try {
                try {
                    return this.executeCommand(databaseName, command, operationTimeout);
                }
                catch (MongoOperationTimeoutException e) {
                    throw e;
                }
                catch (MongoTimeoutException e) {
                    if (this.processBuilder == null) {
                        throw e;
                    }
                    MongoCryptHelper.startProcess(this.processBuilder);
                    return this.executeCommand(databaseName, command, operationTimeout);
                }
            }
            catch (MongoException e) {
                throw this.wrapInClientException(e);
            }
        }
        return command;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private RawBsonDocument executeCommand(String databaseName, RawBsonDocument markableCommand, @Nullable Timeout operationTimeout) {
        Assertions.assertNotNull(this.client);
        MongoDatabase mongoDatabase = this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary());
        return TimeoutHelper.databaseWithTimeout(mongoDatabase, TIMEOUT_ERROR_MESSAGE, operationTimeout).runCommand((Bson)markableCommand, RawBsonDocument.class);
    }

    private MongoClientException wrapInClientException(MongoException e) {
        return new MongoClientException("Exception in encryption library: " + e.getMessage(), e);
    }
}

