/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.bson.codecs;

import com.dre.brewery.depend.bson.BsonReader;
import com.dre.brewery.depend.bson.BsonWriter;
import com.dre.brewery.depend.bson.codecs.Codec;
import com.dre.brewery.depend.bson.codecs.DecoderContext;
import com.dre.brewery.depend.bson.codecs.EncoderContext;
import com.dre.brewery.depend.bson.json.JsonObject;
import com.dre.brewery.depend.bson.json.JsonReader;
import com.dre.brewery.depend.bson.json.JsonWriter;
import com.dre.brewery.depend.bson.json.JsonWriterSettings;
import java.io.StringWriter;

public class JsonObjectCodec
implements Codec<JsonObject> {
    private final JsonWriterSettings writerSettings;

    public JsonObjectCodec() {
        this(JsonWriterSettings.builder().build());
    }

    public JsonObjectCodec(JsonWriterSettings writerSettings) {
        this.writerSettings = writerSettings;
    }

    @Override
    public void encode(BsonWriter writer, JsonObject value, EncoderContext encoderContext) {
        writer.pipe(new JsonReader(value.getJson()));
    }

    @Override
    public JsonObject decode(BsonReader reader, DecoderContext decoderContext) {
        StringWriter stringWriter = new StringWriter();
        new JsonWriter(stringWriter, this.writerSettings).pipe(reader);
        return new JsonObject(stringWriter.toString());
    }

    @Override
    public Class<JsonObject> getEncoderClass() {
        return JsonObject.class;
    }
}

