/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.bson.codecs;

import com.dre.brewery.depend.bson.BsonBinary;
import com.dre.brewery.depend.bson.BsonBinarySubType;
import com.dre.brewery.depend.bson.BsonInvalidOperationException;
import com.dre.brewery.depend.bson.BsonReader;
import com.dre.brewery.depend.bson.BsonWriter;
import com.dre.brewery.depend.bson.Float32Vector;
import com.dre.brewery.depend.bson.codecs.Codec;
import com.dre.brewery.depend.bson.codecs.DecoderContext;
import com.dre.brewery.depend.bson.codecs.EncoderContext;

final class Float32VectorCodec
implements Codec<Float32Vector> {
    Float32VectorCodec() {
    }

    @Override
    public void encode(BsonWriter writer, Float32Vector vectorToEncode, EncoderContext encoderContext) {
        writer.writeBinaryData(new BsonBinary(vectorToEncode));
    }

    @Override
    public Float32Vector decode(BsonReader reader, DecoderContext decoderContext) {
        byte subType = reader.peekBinarySubType();
        if (subType != BsonBinarySubType.VECTOR.getValue()) {
            throw new BsonInvalidOperationException("Expected vector binary subtype " + BsonBinarySubType.VECTOR.getValue() + " but found: " + subType);
        }
        return reader.readBinaryData().asBinary().asVector().asFloat32Vector();
    }

    @Override
    public Class<Float32Vector> getEncoderClass() {
        return Float32Vector.class;
    }
}

