/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.bson;

import com.dre.brewery.depend.bson.BSONCallback;
import com.dre.brewery.depend.bson.BSONCallbackAdapter;
import com.dre.brewery.depend.bson.BSONDecoder;
import com.dre.brewery.depend.bson.BSONObject;
import com.dre.brewery.depend.bson.BasicBSONCallback;
import com.dre.brewery.depend.bson.Bits;
import com.dre.brewery.depend.bson.BsonBinaryReader;
import com.dre.brewery.depend.bson.BsonWriterSettings;
import com.dre.brewery.depend.bson.ByteBufNIO;
import com.dre.brewery.depend.bson.UuidRepresentation;
import com.dre.brewery.depend.bson.assertions.Assertions;
import com.dre.brewery.depend.bson.io.ByteBufferBsonInput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class BasicBSONDecoder
implements BSONDecoder {
    private static volatile UuidRepresentation defaultUuidRepresentation = UuidRepresentation.JAVA_LEGACY;

    public static void setDefaultUuidRepresentation(UuidRepresentation uuidRepresentation) {
        defaultUuidRepresentation = Assertions.notNull("uuidRepresentation", uuidRepresentation);
    }

    public static UuidRepresentation getDefaultUuidRepresentation() {
        return defaultUuidRepresentation;
    }

    @Override
    public BSONObject readObject(byte[] bytes) {
        BasicBSONCallback bsonCallback = new BasicBSONCallback();
        this.decode(bytes, (BSONCallback)bsonCallback);
        return (BSONObject)bsonCallback.get();
    }

    @Override
    public BSONObject readObject(InputStream in) throws IOException {
        return this.readObject(this.readFully(in));
    }

    @Override
    public int decode(byte[] bytes, BSONCallback callback) {
        try (BsonBinaryReader reader = new BsonBinaryReader(new ByteBufferBsonInput(new ByteBufNIO(ByteBuffer.wrap(bytes))));){
            BSONCallbackAdapter writer = new BSONCallbackAdapter(new BsonWriterSettings(), callback);
            writer.pipe(reader);
            int n = reader.getBsonInput().getPosition();
            return n;
        }
    }

    @Override
    public int decode(InputStream in, BSONCallback callback) throws IOException {
        return this.decode(this.readFully(in), callback);
    }

    private byte[] readFully(InputStream input) throws IOException {
        byte[] sizeBytes = new byte[4];
        Bits.readFully(input, sizeBytes);
        int size = Bits.readInt(sizeBytes);
        byte[] buffer = new byte[size];
        System.arraycopy(sizeBytes, 0, buffer, 0, 4);
        Bits.readFully(input, buffer, 4, size - 4);
        return buffer;
    }
}

