/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.configuration.sector;

import com.dre.brewery.depend.okaeri.configs.OkaeriConfig;
import com.dre.brewery.depend.okaeri.configs.annotation.CustomKey;
import com.dre.brewery.utility.Logging;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractOkaeriConfigSector<T extends OkaeriConfig>
extends OkaeriConfig {
    public Map<String, T> getCapsules() {
        LinkedHashMap<String, OkaeriConfig> map = new LinkedHashMap<String, OkaeriConfig>();
        Class<?> typeOfT = this.getTypeOfT();
        for (Field field : this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!Objects.equals(field.getType(), typeOfT)) continue;
            try {
                OkaeriConfig obj = (OkaeriConfig)field.get(this);
                if (field.isAnnotationPresent(CustomKey.class)) {
                    map.put(field.getAnnotation(CustomKey.class).value(), obj);
                    continue;
                }
                map.put(field.getName(), obj);
            }
            catch (IllegalAccessException e) {
                Logging.errorLog("Failed to access field: " + field.getName(), e);
            }
        }
        return map;
    }

    private Class<?> getTypeOfT() {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }
}

