/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.configuration.files;

import com.dre.brewery.configuration.AbstractOkaeriConfigFile;
import com.dre.brewery.configuration.annotation.DefaultCommentSpace;
import com.dre.brewery.configuration.annotation.Footer;
import com.dre.brewery.configuration.annotation.LocalizedComment;
import com.dre.brewery.configuration.annotation.OkaeriConfigFileOptions;
import com.dre.brewery.configuration.sector.WordsSector;
import com.dre.brewery.configuration.sector.capsule.ConfigCauldronIngredient;
import com.dre.brewery.configuration.sector.capsule.ConfigCustomItem;
import com.dre.brewery.configuration.sector.capsule.ConfigDistortWord;
import com.dre.brewery.configuration.sector.capsule.ConfigRecipe;
import com.dre.brewery.configuration.sector.capsule.ConfiguredDataManager;
import com.dre.brewery.depend.okaeri.configs.annotation.Header;
import com.dre.brewery.storage.DataManagerType;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.releases.ReleaseChecker;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Material;

@OkaeriConfigFileOptions(value="config.yml", removeOrphans=true)
@Header(value={"!!! IMPORTANT: BreweryX configuration files do NOT support external comments! If you add any comments, they will be overwritten !!!", "Our proper config guide can be found at: https://brewery.lumamc.net/en/guide/edit_config/", "Still have questions? Join our Discord: https://discord.gg/ZTGCzeKg45"})
@Footer(value={"", "Yep, that's it! The end of config.yml! I had so much fun! And you?..."})
@DefaultCommentSpace(value=1)
public class Config
extends AbstractOkaeriConfigFile {
    @LocalizedComment(value={"config.language"})
    private String language = "en";
    @LocalizedComment(value={"config.updateCheck"})
    private ReleaseChecker.ReleaseCheckerType resolveUpdatesFrom = ReleaseChecker.ReleaseCheckerType.GITHUB;
    @LocalizedComment(value={"config.autosave"})
    private int autosave = 10;
    @LocalizedComment(value={"config.pluginPrefix"})
    private String pluginPrefix = "&2[BreweryX]&f ";
    @LocalizedComment(value={"config.debug"})
    private boolean debug = false;
    @LocalizedComment(value={"config.storage.header"})
    private ConfiguredDataManager storage = ConfiguredDataManager.builder().type(DataManagerType.SQLITE).database("brewery-data").tablePrefix("brewery_").address("localhost").username("root").password("password").build();
    @LocalizedComment(value={"config.enableHome"})
    private boolean enableHome = true;
    @LocalizedComment(value={"config.homeType"})
    private String homeType = "cmd: home";
    @LocalizedComment(value={"config.enableWake"})
    private boolean enableWake = true;
    @LocalizedComment(value={"config.enableLoginDisallow"})
    private boolean enableLoginDisallow = true;
    @LocalizedComment(value={"config.enableKickOnOverdrink"})
    private boolean enableKickOnOverdrink = false;
    @LocalizedComment(value={"config.enablePuke"})
    private boolean enablePuke = true;
    @LocalizedComment(value={"config.pukeItem"})
    private Object pukeItem = List.of(Material.SOUL_SAND);
    @LocalizedComment(value={"config.pukeDespawntime"})
    private int pukeDespawntime = 60;
    @LocalizedComment(value={"config.stumblePercent"})
    private int stumblePercent = 100;
    @LocalizedComment(value={"config.showStatusOnDrink"})
    private boolean showStatusOnDrink = true;
    @LocalizedComment(value={"config.drainItems"})
    private List<String> drainItems = List.of("Bread/4", "Milk_Bucket/2");
    @LocalizedComment(value={"config.enableCauldronParticles"})
    private boolean enableCauldronParticles = true;
    @LocalizedComment(value={"config.minimalParticles"})
    private boolean minimalParticles = false;
    @LocalizedComment(value={"config.craft-enableSealingTable"})
    private boolean craftSealingTable = true;
    private boolean enableSealingTable = true;
    @LocalizedComment(value={"config.sealingTableBlock"})
    private Material sealingTableBlock = Material.SMOKER;
    @LocalizedComment(value={"config.alwaysShowQuality"})
    private boolean alwaysShowQuality = true;
    @LocalizedComment(value={"config.alwaysShowAlc"})
    private boolean alwaysShowAlc = false;
    @LocalizedComment(value={"config.alwaysShowAlcIndicator"})
    private boolean alwaysShowAlcIndicator = true;
    @LocalizedComment(value={"config.showRuinedBrewHints"})
    private boolean showRuinedBrewHints = false;
    @LocalizedComment(value={"config.showBrewer"})
    private boolean showBrewer = false;
    @LocalizedComment(value={"config.requireKeywordOnSigns"})
    private boolean requireKeywordOnSigns = true;
    @LocalizedComment(value={"config.ageInMCBarrels"})
    private boolean ageInMCBarrels = true;
    private int maxBrewsInMCBarrels = 6;
    @LocalizedComment(value={"config.agingYearDuration"})
    private int agingYearDuration = 20;
    @LocalizedComment(value={"config.newBarrelTypeAlgorithm"})
    private boolean newBarrelTypeAlgorithm = false;
    @LocalizedComment(value={"config.commandAliases"})
    private List<String> commandAliases = List.of("brewery", "brew");
    @LocalizedComment(value={"config.enableEncode"})
    private boolean enableEncode = false;
    private long encodeKey = new Random().nextLong();
    @LocalizedComment(value={"config.useOtherPlugins"})
    private boolean useWorldGuard = true;
    private boolean useLWC = true;
    private boolean useGriefPrevention = true;
    private boolean useTowny = true;
    private boolean useLands = true;
    private boolean useBlockLocker = true;
    private boolean useGMInventories = true;
    @LocalizedComment(value={"config.useVirtualChestPerms"})
    private boolean useVirtualChestPerms = false;
    @LocalizedComment(value={"config.useLogBlock"})
    private boolean useLogBlock = true;
    @LocalizedComment(value={"config.useOffhandForCauldron"})
    private boolean useOffhandForCauldron = false;
    @LocalizedComment(value={"config.loadDataAsync"})
    private boolean loadDataAsync = true;
    @LocalizedComment(value={"config.hangoverDays"})
    private int hangoverDays = 7;
    @LocalizedComment(value={"config.onlyAllowBrewsInBarrels"})
    private boolean onlyAllowBrewsInBarrels = false;
    private boolean exemptVanillaBarrels = true;
    @LocalizedComment(value={"config.colorInBarrels-Brewer"})
    private boolean colorInBarrels = true;
    private boolean colorInBrewer = true;
    @LocalizedComment(value={"config.openLargeBarrelEverywhere"})
    private boolean openLargeBarrelEverywhere = true;
    @LocalizedComment(value={"config.barrelInvSizes"})
    private int barrelInvSizeLarge = 3;
    private int barrelInvSizeSmall = 1;
    @LocalizedComment(value={"config.brewHopperDump"})
    private boolean brewHopperDump = true;
    @LocalizedComment(value={"config.enableChatDistortion"})
    private boolean enableChatDistortion = true;
    @LocalizedComment(value={"config.logRealChat"})
    private boolean logRealChat = false;
    @LocalizedComment(value={"config.distortCommands"})
    private List<String> distortCommands = List.of("/gl", "/global", "/fl", "/s", "/letter", "/g", "/l", "/lokal", "/local", "/mail send", "/m", "/msg", "/w", "/whisper", "/reply", "/r", "/t", "/tell");
    @LocalizedComment(value={"config.distortSignText"})
    private boolean distortSignText = false;
    @LocalizedComment(value={"config.distortBypass"})
    private List<String> distortBypass = List.of("*,*", "[,]");
    @LocalizedComment(value={"config.words"})
    private List<ConfigDistortWord> words = new WordsSector().getCapsules().values().stream().toList();
    @LocalizedComment(value={"config.useOtherFiles"})
    private Map<String, ConfigCustomItem> customItems = Map.of();
    @LocalizedComment(value={"config.useOtherFiles"})
    private Map<String, ConfigCauldronIngredient> cauldron = Map.of();
    @LocalizedComment(value={"config.useOtherFiles"})
    private Map<String, ConfigRecipe> recipes = Map.of();

    @Override
    public void onFirstCreation() {
        Logging.log("&9Creating a new &6config.yml&9!");
        Logging.log("&9If this is your first time using BreweryX, change config.yml#language to your language and run &6/brewery reload");
    }

    public List<Material> getPukeItem() {
        return BUtil.getListSafely(this.pukeItem, Material.class);
    }

    public float getStumblePercent() {
        return (float)this.stumblePercent / 100.0f;
    }

    public String getLanguage() {
        return this.language;
    }

    public ReleaseChecker.ReleaseCheckerType getResolveUpdatesFrom() {
        return this.resolveUpdatesFrom;
    }

    public int getAutosave() {
        return this.autosave;
    }

    public String getPluginPrefix() {
        return this.pluginPrefix;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public ConfiguredDataManager getStorage() {
        return this.storage;
    }

    public boolean isEnableHome() {
        return this.enableHome;
    }

    public String getHomeType() {
        return this.homeType;
    }

    public boolean isEnableWake() {
        return this.enableWake;
    }

    public boolean isEnableLoginDisallow() {
        return this.enableLoginDisallow;
    }

    public boolean isEnableKickOnOverdrink() {
        return this.enableKickOnOverdrink;
    }

    public boolean isEnablePuke() {
        return this.enablePuke;
    }

    public int getPukeDespawntime() {
        return this.pukeDespawntime;
    }

    public boolean isShowStatusOnDrink() {
        return this.showStatusOnDrink;
    }

    public List<String> getDrainItems() {
        return this.drainItems;
    }

    public boolean isEnableCauldronParticles() {
        return this.enableCauldronParticles;
    }

    public boolean isMinimalParticles() {
        return this.minimalParticles;
    }

    public boolean isCraftSealingTable() {
        return this.craftSealingTable;
    }

    public boolean isEnableSealingTable() {
        return this.enableSealingTable;
    }

    public Material getSealingTableBlock() {
        return this.sealingTableBlock;
    }

    public boolean isAlwaysShowQuality() {
        return this.alwaysShowQuality;
    }

    public boolean isAlwaysShowAlc() {
        return this.alwaysShowAlc;
    }

    public boolean isAlwaysShowAlcIndicator() {
        return this.alwaysShowAlcIndicator;
    }

    public boolean isShowRuinedBrewHints() {
        return this.showRuinedBrewHints;
    }

    public boolean isShowBrewer() {
        return this.showBrewer;
    }

    public boolean isRequireKeywordOnSigns() {
        return this.requireKeywordOnSigns;
    }

    public boolean isAgeInMCBarrels() {
        return this.ageInMCBarrels;
    }

    public int getMaxBrewsInMCBarrels() {
        return this.maxBrewsInMCBarrels;
    }

    public int getAgingYearDuration() {
        return this.agingYearDuration;
    }

    public boolean isNewBarrelTypeAlgorithm() {
        return this.newBarrelTypeAlgorithm;
    }

    public List<String> getCommandAliases() {
        return this.commandAliases;
    }

    public boolean isEnableEncode() {
        return this.enableEncode;
    }

    public long getEncodeKey() {
        return this.encodeKey;
    }

    public boolean isUseWorldGuard() {
        return this.useWorldGuard;
    }

    public boolean isUseLWC() {
        return this.useLWC;
    }

    public boolean isUseGriefPrevention() {
        return this.useGriefPrevention;
    }

    public boolean isUseTowny() {
        return this.useTowny;
    }

    public boolean isUseLands() {
        return this.useLands;
    }

    public boolean isUseBlockLocker() {
        return this.useBlockLocker;
    }

    public boolean isUseGMInventories() {
        return this.useGMInventories;
    }

    public boolean isUseVirtualChestPerms() {
        return this.useVirtualChestPerms;
    }

    public boolean isUseLogBlock() {
        return this.useLogBlock;
    }

    public boolean isUseOffhandForCauldron() {
        return this.useOffhandForCauldron;
    }

    public boolean isLoadDataAsync() {
        return this.loadDataAsync;
    }

    public int getHangoverDays() {
        return this.hangoverDays;
    }

    public boolean isOnlyAllowBrewsInBarrels() {
        return this.onlyAllowBrewsInBarrels;
    }

    public boolean isExemptVanillaBarrels() {
        return this.exemptVanillaBarrels;
    }

    public boolean isColorInBarrels() {
        return this.colorInBarrels;
    }

    public boolean isColorInBrewer() {
        return this.colorInBrewer;
    }

    public boolean isOpenLargeBarrelEverywhere() {
        return this.openLargeBarrelEverywhere;
    }

    public int getBarrelInvSizeLarge() {
        return this.barrelInvSizeLarge;
    }

    public int getBarrelInvSizeSmall() {
        return this.barrelInvSizeSmall;
    }

    public boolean isBrewHopperDump() {
        return this.brewHopperDump;
    }

    public boolean isEnableChatDistortion() {
        return this.enableChatDistortion;
    }

    public boolean isLogRealChat() {
        return this.logRealChat;
    }

    public List<String> getDistortCommands() {
        return this.distortCommands;
    }

    public boolean isDistortSignText() {
        return this.distortSignText;
    }

    public List<String> getDistortBypass() {
        return this.distortBypass;
    }

    public List<ConfigDistortWord> getWords() {
        return this.words;
    }

    public Map<String, ConfigCustomItem> getCustomItems() {
        return this.customItems;
    }

    public Map<String, ConfigCauldronIngredient> getCauldron() {
        return this.cauldron;
    }

    public Map<String, ConfigRecipe> getRecipes() {
        return this.recipes;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setResolveUpdatesFrom(ReleaseChecker.ReleaseCheckerType resolveUpdatesFrom) {
        this.resolveUpdatesFrom = resolveUpdatesFrom;
    }

    public void setAutosave(int autosave) {
        this.autosave = autosave;
    }

    public void setPluginPrefix(String pluginPrefix) {
        this.pluginPrefix = pluginPrefix;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setStorage(ConfiguredDataManager storage) {
        this.storage = storage;
    }

    public void setEnableHome(boolean enableHome) {
        this.enableHome = enableHome;
    }

    public void setHomeType(String homeType) {
        this.homeType = homeType;
    }

    public void setEnableWake(boolean enableWake) {
        this.enableWake = enableWake;
    }

    public void setEnableLoginDisallow(boolean enableLoginDisallow) {
        this.enableLoginDisallow = enableLoginDisallow;
    }

    public void setEnableKickOnOverdrink(boolean enableKickOnOverdrink) {
        this.enableKickOnOverdrink = enableKickOnOverdrink;
    }

    public void setEnablePuke(boolean enablePuke) {
        this.enablePuke = enablePuke;
    }

    public void setPukeItem(Object pukeItem) {
        this.pukeItem = pukeItem;
    }

    public void setPukeDespawntime(int pukeDespawntime) {
        this.pukeDespawntime = pukeDespawntime;
    }

    public void setStumblePercent(int stumblePercent) {
        this.stumblePercent = stumblePercent;
    }

    public void setShowStatusOnDrink(boolean showStatusOnDrink) {
        this.showStatusOnDrink = showStatusOnDrink;
    }

    public void setDrainItems(List<String> drainItems) {
        this.drainItems = drainItems;
    }

    public void setEnableCauldronParticles(boolean enableCauldronParticles) {
        this.enableCauldronParticles = enableCauldronParticles;
    }

    public void setMinimalParticles(boolean minimalParticles) {
        this.minimalParticles = minimalParticles;
    }

    public void setCraftSealingTable(boolean craftSealingTable) {
        this.craftSealingTable = craftSealingTable;
    }

    public void setEnableSealingTable(boolean enableSealingTable) {
        this.enableSealingTable = enableSealingTable;
    }

    public void setSealingTableBlock(Material sealingTableBlock) {
        this.sealingTableBlock = sealingTableBlock;
    }

    public void setAlwaysShowQuality(boolean alwaysShowQuality) {
        this.alwaysShowQuality = alwaysShowQuality;
    }

    public void setAlwaysShowAlc(boolean alwaysShowAlc) {
        this.alwaysShowAlc = alwaysShowAlc;
    }

    public void setAlwaysShowAlcIndicator(boolean alwaysShowAlcIndicator) {
        this.alwaysShowAlcIndicator = alwaysShowAlcIndicator;
    }

    public void setShowRuinedBrewHints(boolean showRuinedBrewHints) {
        this.showRuinedBrewHints = showRuinedBrewHints;
    }

    public void setShowBrewer(boolean showBrewer) {
        this.showBrewer = showBrewer;
    }

    public void setRequireKeywordOnSigns(boolean requireKeywordOnSigns) {
        this.requireKeywordOnSigns = requireKeywordOnSigns;
    }

    public void setAgeInMCBarrels(boolean ageInMCBarrels) {
        this.ageInMCBarrels = ageInMCBarrels;
    }

    public void setMaxBrewsInMCBarrels(int maxBrewsInMCBarrels) {
        this.maxBrewsInMCBarrels = maxBrewsInMCBarrels;
    }

    public void setAgingYearDuration(int agingYearDuration) {
        this.agingYearDuration = agingYearDuration;
    }

    public void setNewBarrelTypeAlgorithm(boolean newBarrelTypeAlgorithm) {
        this.newBarrelTypeAlgorithm = newBarrelTypeAlgorithm;
    }

    public void setCommandAliases(List<String> commandAliases) {
        this.commandAliases = commandAliases;
    }

    public void setEnableEncode(boolean enableEncode) {
        this.enableEncode = enableEncode;
    }

    public void setEncodeKey(long encodeKey) {
        this.encodeKey = encodeKey;
    }

    public void setUseWorldGuard(boolean useWorldGuard) {
        this.useWorldGuard = useWorldGuard;
    }

    public void setUseLWC(boolean useLWC) {
        this.useLWC = useLWC;
    }

    public void setUseGriefPrevention(boolean useGriefPrevention) {
        this.useGriefPrevention = useGriefPrevention;
    }

    public void setUseTowny(boolean useTowny) {
        this.useTowny = useTowny;
    }

    public void setUseLands(boolean useLands) {
        this.useLands = useLands;
    }

    public void setUseBlockLocker(boolean useBlockLocker) {
        this.useBlockLocker = useBlockLocker;
    }

    public void setUseGMInventories(boolean useGMInventories) {
        this.useGMInventories = useGMInventories;
    }

    public void setUseVirtualChestPerms(boolean useVirtualChestPerms) {
        this.useVirtualChestPerms = useVirtualChestPerms;
    }

    public void setUseLogBlock(boolean useLogBlock) {
        this.useLogBlock = useLogBlock;
    }

    public void setUseOffhandForCauldron(boolean useOffhandForCauldron) {
        this.useOffhandForCauldron = useOffhandForCauldron;
    }

    public void setLoadDataAsync(boolean loadDataAsync) {
        this.loadDataAsync = loadDataAsync;
    }

    public void setHangoverDays(int hangoverDays) {
        this.hangoverDays = hangoverDays;
    }

    public void setOnlyAllowBrewsInBarrels(boolean onlyAllowBrewsInBarrels) {
        this.onlyAllowBrewsInBarrels = onlyAllowBrewsInBarrels;
    }

    public void setExemptVanillaBarrels(boolean exemptVanillaBarrels) {
        this.exemptVanillaBarrels = exemptVanillaBarrels;
    }

    public void setColorInBarrels(boolean colorInBarrels) {
        this.colorInBarrels = colorInBarrels;
    }

    public void setColorInBrewer(boolean colorInBrewer) {
        this.colorInBrewer = colorInBrewer;
    }

    public void setOpenLargeBarrelEverywhere(boolean openLargeBarrelEverywhere) {
        this.openLargeBarrelEverywhere = openLargeBarrelEverywhere;
    }

    public void setBarrelInvSizeLarge(int barrelInvSizeLarge) {
        this.barrelInvSizeLarge = barrelInvSizeLarge;
    }

    public void setBarrelInvSizeSmall(int barrelInvSizeSmall) {
        this.barrelInvSizeSmall = barrelInvSizeSmall;
    }

    public void setBrewHopperDump(boolean brewHopperDump) {
        this.brewHopperDump = brewHopperDump;
    }

    public void setEnableChatDistortion(boolean enableChatDistortion) {
        this.enableChatDistortion = enableChatDistortion;
    }

    public void setLogRealChat(boolean logRealChat) {
        this.logRealChat = logRealChat;
    }

    public void setDistortCommands(List<String> distortCommands) {
        this.distortCommands = distortCommands;
    }

    public void setDistortSignText(boolean distortSignText) {
        this.distortSignText = distortSignText;
    }

    public void setDistortBypass(List<String> distortBypass) {
        this.distortBypass = distortBypass;
    }

    public void setWords(List<ConfigDistortWord> words) {
        this.words = words;
    }

    public void setCustomItems(Map<String, ConfigCustomItem> customItems) {
        this.customItems = customItems;
    }

    public void setCauldron(Map<String, ConfigCauldronIngredient> cauldron) {
        this.cauldron = cauldron;
    }

    public void setRecipes(Map<String, ConfigRecipe> recipes) {
        this.recipes = recipes;
    }
}

