/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.configuration.configurer;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;

public record Translation(String fileName) {
    public static final Translation EN = new Translation("en.yml");
    private static final List<Translation> DEFAULT_TRANSLATIONS = Translation.compileTranslations();

    public static Translation getTranslation(String language) {
        return new Translation(language.toLowerCase(Locale.ROOT) + ".yml");
    }

    public static List<Translation> getDefaultTranslations() {
        return DEFAULT_TRANSLATIONS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Translation> compileTranslations() {
        try {
            URI uri = Translation.class.getResource("/languages").toURI();
            if (!uri.getScheme().equals("jar")) {
                Path myPath = Paths.get(uri);
                return Translation.fromPaths(Files.walk(myPath, 1, new FileVisitOption[0]));
            }
            try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                Path myPath = fileSystem.getPath("/languages", new String[0]);
                List<Translation> list = Translation.fromPaths(Files.walk(myPath, 1, new FileVisitOption[0]));
                return list;
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Translation> fromPaths(Stream<Path> pathStream) {
        return pathStream.map(Path::getFileName).map(Path::toString).filter(filename -> filename.endsWith(".yml")).map(Translation::new).toList();
    }
}

