/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.configuration;

import com.dre.brewery.Brew;
import com.dre.brewery.DistortChat;
import com.dre.brewery.configuration.AbstractOkaeriConfigFile;
import com.dre.brewery.configuration.ConfigHead;
import com.dre.brewery.configuration.annotation.OkaeriConfigFileOptions;
import com.dre.brewery.configuration.files.CauldronFile;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.configuration.files.RecipesFile;
import com.dre.brewery.configuration.sector.capsule.ConfigCauldronIngredient;
import com.dre.brewery.configuration.sector.capsule.ConfigDistortWord;
import com.dre.brewery.configuration.sector.capsule.ConfigRecipe;
import com.dre.brewery.depend.okaeri.configs.configurer.Configurer;
import com.dre.brewery.depend.okaeri.configs.serdes.OkaeriSerdesPack;
import com.dre.brewery.integration.Hook;
import com.dre.brewery.integration.item.BreweryPluginItem;
import com.dre.brewery.integration.item.ItemsAdderPluginItem;
import com.dre.brewery.integration.item.MMOItemsPluginItem;
import com.dre.brewery.integration.item.NexoPluginItem;
import com.dre.brewery.integration.item.OraxenPluginItem;
import com.dre.brewery.integration.item.SlimefunPluginItem;
import com.dre.brewery.recipe.BCauldronRecipe;
import com.dre.brewery.recipe.BRecipe;
import com.dre.brewery.recipe.PluginItem;
import com.dre.brewery.utility.Logging;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ConfigManager {
    private static final ConfigHead INSTANCE = new ConfigHead();
    public static final Map<Class<? extends AbstractOkaeriConfigFile>, AbstractOkaeriConfigFile> LOADED_CONFIGS = ConfigManager.INSTANCE.LOADED_CONFIGS;

    public static <T extends AbstractOkaeriConfigFile> T getConfig(Class<T> configClass) {
        return INSTANCE.getConfig(configClass);
    }

    public static <T extends AbstractOkaeriConfigFile> void newInstance(Class<T> configClass, boolean overwrite) {
        INSTANCE.newInstance(configClass, overwrite);
    }

    public static <T extends AbstractOkaeriConfigFile> Path getFilePath(Class<T> configClass) {
        return INSTANCE.getFilePath(configClass);
    }

    private static <T extends AbstractOkaeriConfigFile> T createConfig(Class<T> configClass, Path file, Configurer configurer, OkaeriSerdesPack serdesPack, boolean update, boolean removeOrphans) {
        return INSTANCE.createConfig(configClass, file, configurer, serdesPack, update, removeOrphans);
    }

    private static <T extends AbstractOkaeriConfigFile> T createConfig(Class<T> configClass) {
        return INSTANCE.createConfig(configClass);
    }

    @Nullable
    private static <T extends AbstractOkaeriConfigFile> T createBlankConfigInstance(Class<T> configClass) {
        return INSTANCE.createBlankConfigInstance(configClass);
    }

    public static void createFileFromResources(String resourcesPath, Path destination) {
        INSTANCE.createFileFromResources(resourcesPath, destination);
    }

    private static OkaeriConfigFileOptions getOkaeriConfigFileOptions(Class<? extends AbstractOkaeriConfigFile> configClass) {
        return INSTANCE.getOkaeriConfigFileOptions(configClass);
    }

    public static void loadRecipes() {
        List<BRecipe> configRecipes = BRecipe.getConfigRecipes();
        configRecipes.clear();
        for (Map.Entry<String, ConfigRecipe> recipeEntry : ConfigManager.getConfig(RecipesFile.class).getRecipes().entrySet()) {
            BRecipe recipe = BRecipe.fromConfig(recipeEntry.getKey(), recipeEntry.getValue());
            if (recipe != null && recipe.isValid()) {
                configRecipes.add(recipe);
            } else {
                Logging.errorLog("Loading the Recipe with id: '" + recipeEntry.getKey() + "' failed!");
            }
            BRecipe.setNumConfigRecipes(configRecipes.size());
        }
    }

    public static void loadCauldronIngredients() {
        List<BCauldronRecipe> configRecipes = BCauldronRecipe.getConfigRecipes();
        configRecipes.clear();
        for (Map.Entry<String, ConfigCauldronIngredient> entry : ConfigManager.getConfig(CauldronFile.class).getCauldronIngredients().entrySet()) {
            BCauldronRecipe recipe = BCauldronRecipe.fromConfig(entry.getKey(), entry.getValue());
            if (recipe != null) {
                configRecipes.add(recipe);
                continue;
            }
            Logging.errorLog("Loading the Cauldron-Recipe with id: '" + entry.getKey() + "' failed!");
        }
        BCauldronRecipe.setNumConfigRecipes(configRecipes.size());
        for (BRecipe bRecipe : BRecipe.getAddedRecipes()) {
            bRecipe.updateAcceptedLists();
        }
        for (BCauldronRecipe bCauldronRecipe : BCauldronRecipe.getAddedRecipes()) {
            bCauldronRecipe.updateAcceptedLists();
        }
    }

    public static void loadDistortWords() {
        Config config = ConfigManager.getConfig(Config.class);
        if (config.isEnableChatDistortion()) {
            for (ConfigDistortWord distortWord : config.getWords()) {
                new DistortChat(distortWord);
            }
            for (String bypass : config.getDistortBypass()) {
                DistortChat.getIgnoreText().add(bypass.split(","));
            }
            DistortChat.getCommands().addAll(config.getDistortCommands());
        }
    }

    public static void loadSeed() {
        Config config = ConfigManager.getConfig(Config.class);
        if (config.isEnableEncode()) {
            Brew.loadSeed(config.getEncodeKey());
        }
    }

    public static void registerDefaultPluginItems() {
        PluginItem.registerForConfig("brewery", BreweryPluginItem::new);
        if (Hook.MMOITEMS.isEnabled()) {
            PluginItem.registerForConfig("mmoitems", MMOItemsPluginItem::new);
        }
        if (Hook.SLIMEFUN.isEnabled()) {
            PluginItem.registerForConfig("slimefun", SlimefunPluginItem::new);
            PluginItem.registerForConfig("exoticgarden", SlimefunPluginItem::new);
        }
        if (Hook.ORAXEN.isEnabled()) {
            PluginItem.registerForConfig("oraxen", OraxenPluginItem::new);
        }
        if (Hook.ITEMSADDER.isEnabled()) {
            PluginItem.registerForConfig("itemsadder", ItemsAdderPluginItem::new);
        }
        if (Hook.NEXO.isEnabled()) {
            PluginItem.registerForConfig("nexo", NexoPluginItem::new);
        }
    }
}

