/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.commands.subcommands;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BSealer;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.commands.CommandUtil;
import com.dre.brewery.commands.SubCommand;
import com.dre.brewery.configuration.AbstractOkaeriConfigFile;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.configurer.TranslationManager;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.releases.ReleaseChecker;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

public class ReloadCommand
implements SubCommand {
    private static CommandSender reloader;

    @Override
    public void execute(BreweryPlugin breweryPlugin, Lang lang, CommandSender sender, String label, String[] args) {
        if (!sender.equals((Object)Bukkit.getConsoleSender())) {
            reloader = sender;
        }
        try {
            TranslationManager.newInstance(breweryPlugin.getDataFolder());
            TranslationManager.getInstance().updateTranslationFiles();
            for (AbstractOkaeriConfigFile abstractOkaeriConfigFile : ConfigManager.LOADED_CONFIGS.values()) {
                try {
                    abstractOkaeriConfigFile.reload();
                }
                catch (Throwable e) {
                    Logging.errorLog("Something went wrong trying to load " + String.valueOf(abstractOkaeriConfigFile.getBindFile().getFileName()) + "!", e);
                }
            }
            ConfigManager.loadCauldronIngredients();
            ConfigManager.loadRecipes();
            ConfigManager.loadSeed();
            BCauldron.reload();
            CommandUtil.reloadTabCompleter();
            BSealer.registerRecipe();
            BreweryPlugin.getAddonManager().reloadAddons();
            boolean successful = true;
            for (Brew brew : Brew.legacyPotions.values()) {
                if (brew.reloadRecipe()) continue;
                successful = false;
            }
            if (!successful) {
                lang.sendEntry(sender, "Error_Recipeload", new Object[0]);
            } else {
                lang.sendEntry(sender, "CMD_Reload", new Object[0]);
            }
            ReleaseChecker releaseChecker = ReleaseChecker.getInstance(true);
            releaseChecker.checkForUpdate().thenAccept(updateAvailable -> {
                if (!(sender instanceof ConsoleCommandSender)) {
                    releaseChecker.notify(sender);
                } else {
                    ConsoleCommandSender consoleSender = (ConsoleCommandSender)sender;
                    releaseChecker.notify((CommandSender)consoleSender);
                }
            });
        }
        catch (Throwable e) {
            Logging.errorLog("Something went wrong trying to reload Brewery!", e);
        }
        reloader = null;
    }

    @Override
    public List<String> tabComplete(BreweryPlugin breweryPlugin, CommandSender sender, String label, String[] args) {
        return null;
    }

    @Override
    public String permission() {
        return "brewery.cmd.reload";
    }

    @Override
    public boolean playerOnly() {
        return false;
    }

    public static CommandSender getReloader() {
        return reloader;
    }
}

