/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.commands.subcommands;

import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.commands.SubCommand;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.Logging;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;

public class DistillCommand
implements SubCommand {
    @Override
    public void execute(BreweryPlugin breweryPlugin, Lang lang, CommandSender sender, String label, String[] args) {
        if (args.length < 2) {
            DistillCommand.cmdDistill(lang, (Player)sender, 1);
        } else {
            int distillRuns = BUtil.parseInt(args[1]).orElse(0);
            if (distillRuns <= 0) {
                lang.sendEntry(sender, "CMD_Invalid_Distill_Runs", args[1]);
                return;
            }
            DistillCommand.cmdDistill(lang, (Player)sender, distillRuns);
        }
    }

    private static void cmdDistill(Lang lang, Player player, int distillRuns) {
        ItemStack item = player.getInventory().getItemInMainHand();
        Brew brew = Brew.get(item);
        if (brew == null) {
            lang.sendEntry((CommandSender)player, "Error_ItemNotPotion", new Object[0]);
            return;
        }
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        for (int i = 0; i < distillRuns; ++i) {
            brew.distillSlot(item, meta);
        }
        Logging.debugLog(String.format("distill: distilled for %d runs: %s", distillRuns, ChatColor.stripColor((String)brew.toString())));
        player.getInventory().setItemInMainHand(item);
        lang.sendEntry((CommandSender)player, "CMD_Distilled", distillRuns);
    }

    @Override
    public List<String> tabComplete(BreweryPlugin breweryPlugin, CommandSender sender, String label, String[] args) {
        return List.of();
    }

    @Override
    public String permission() {
        return "brewery.cmd.create";
    }

    @Override
    public boolean playerOnly() {
        return true;
    }
}

