/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.commands.subcommands;

import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.commands.SubCommand;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.utility.BUtil;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CopyCommand
implements SubCommand {
    @Override
    public void execute(BreweryPlugin breweryPlugin, Lang lang, CommandSender sender, String label, String[] args) {
        if (args.length > 1) {
            this.cmdCopy(sender, BUtil.getRandomIntInRange(args[1]), lang);
        } else {
            this.cmdCopy(sender, 1, lang);
        }
    }

    @Override
    public List<String> tabComplete(BreweryPlugin breweryPlugin, CommandSender sender, String label, String[] args) {
        return null;
    }

    @Override
    public String permission() {
        return "brewery.cmd.copy";
    }

    @Override
    public boolean playerOnly() {
        return true;
    }

    public void cmdCopy(CommandSender sender, int count, Lang lang) {
        if (count < 1 || count > 36) {
            lang.sendEntry(sender, "Etc_Usage", new Object[0]);
            lang.sendEntry(sender, "Help_Copy", new Object[0]);
            return;
        }
        Player player = (Player)sender;
        ItemStack hand = player.getItemInHand();
        if (hand != null && Brew.isBrew(hand)) {
            while (count > 0) {
                ItemStack item = hand.clone();
                if (!player.getInventory().addItem(new ItemStack[]{item}).isEmpty()) {
                    lang.sendEntry(sender, "CMD_Copy_Error", "" + count);
                    return;
                }
                --count;
            }
            return;
        }
        lang.sendEntry(sender, "Error_ItemNotPotion", new Object[0]);
    }
}

