/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.commands.subcommands;

import com.dre.brewery.BarrelWoodType;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.commands.SubCommand;
import com.dre.brewery.configuration.files.Lang;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.Logging;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.StringUtil;

public class AgeCommand
implements SubCommand {
    @Override
    public void execute(BreweryPlugin breweryPlugin, Lang lang, CommandSender sender, String label, String[] args) {
        if (args.length < 3) {
            lang.sendEntry(sender, "Etc_Usage", new Object[0]);
            lang.sendEntry(sender, "Help_Age", new Object[0]);
            return;
        }
        BarrelWoodType woodType = BarrelWoodType.fromName(args[1]);
        if (woodType == null || !woodType.isSpecific()) {
            lang.sendEntry(sender, "CMD_Invalid_Wood_Type", args[1]);
            return;
        }
        float ageTime = BUtil.parseFloat(args[2]).orElse(0.0f);
        if (ageTime <= 0.0f) {
            lang.sendEntry(sender, "CMD_Invalid_Age_Time", args[2]);
            return;
        }
        Player player = (Player)sender;
        ItemStack item = player.getInventory().getItemInMainHand();
        Brew brew = Brew.get(item);
        if (brew == null) {
            lang.sendEntry((CommandSender)player, "Error_ItemNotPotion", new Object[0]);
            return;
        }
        brew.age(item, ageTime, woodType);
        Logging.debugLog(String.format("age: aged for %s years in %s barrel: %s", args[2], woodType.getFormattedName(), ChatColor.stripColor((String)brew.toString())));
        lang.sendEntry(sender, "CMD_Aged", args[2]);
    }

    @Override
    public List<String> tabComplete(BreweryPlugin breweryPlugin, CommandSender sender, String label, String[] args) {
        if (args.length == 2) {
            return (List)StringUtil.copyPartialMatches((String)args[1], BarrelWoodType.TAB_COMPLETIONS, new ArrayList());
        }
        return List.of();
    }

    @Override
    public String permission() {
        return "brewery.cmd.create";
    }

    @Override
    public boolean playerOnly() {
        return true;
    }
}

