/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.api.addons;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.addons.AddonConfigManager;
import com.dre.brewery.api.addons.AddonFileManager;
import com.dre.brewery.api.addons.AddonInfo;
import com.dre.brewery.api.addons.AddonLogger;
import com.dre.brewery.api.addons.BreweryAddon;
import com.dre.brewery.utility.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;

public class AddonManager {
    public static final ConcurrentLinkedQueue<BreweryAddon> LOADED_ADDONS = new ConcurrentLinkedQueue();
    private final BreweryPlugin plugin;
    private final File addonsFolder;

    public AddonManager(BreweryPlugin plugin) {
        this.plugin = plugin;
        this.addonsFolder = new File(plugin.getDataFolder(), "addons");
        if (!this.addonsFolder.exists()) {
            this.addonsFolder.mkdirs();
        }
    }

    public void unloadAddons() {
        if (LOADED_ADDONS.isEmpty()) {
            return;
        }
        Logging.log("Disabling " + LOADED_ADDONS.size() + " loaded addon(s)...");
        for (BreweryAddon addon : LOADED_ADDONS) {
            this.unloadAddon(addon);
        }
    }

    public void unloadAddon(BreweryAddon addon) {
        if (addon == null) {
            Logging.warningLog("Tried to unload an addon that doesn't exist.");
            return;
        }
        String n = addon.getAddonInfo() == null ? addon.getClass().getSimpleName() : addon.getAddonInfo().name();
        try {
            addon.onAddonDisable();
        }
        catch (Throwable t) {
            Logging.errorLog("Failed to disable addon " + n, t);
        }
        try {
            addon.unregisterListeners();
            addon.unregisterCommands();
        }
        catch (Throwable t) {
            Logging.errorLog("Failed to unregister listeners/commands for addon " + n, t);
        }
        try {
            Field field = BreweryAddon.class.getDeclaredField("classLoader");
            field.setAccessible(true);
            URLClassLoader classLoader = (URLClassLoader)field.get(addon);
            classLoader.close();
            field.set(addon, null);
            LOADED_ADDONS.remove(addon);
        }
        catch (Throwable t) {
            Logging.errorLog("Failed to unload addon " + n, t);
            Logging.warningLog("Addon " + n + "'s ClassLoader has not been closed properly!");
        }
    }

    public void reloadAddons() {
        for (BreweryAddon addon : LOADED_ADDONS) {
            try {
                addon.onBreweryReload();
            }
            catch (Throwable t) {
                Logging.errorLog("Failed to reload addon " + addon.getClass().getSimpleName(), t);
            }
        }
        int loaded = LOADED_ADDONS.size();
        if (loaded > 0) {
            Logging.log("Reloaded " + loaded + " addon(s)");
        }
    }

    public ConcurrentLinkedQueue<BreweryAddon> getAddons() {
        return LOADED_ADDONS;
    }

    public void loadAddons() {
        File[] files = this.addonsFolder.listFiles((dir, name) -> name.endsWith(".jar"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            this.loadAddon(file);
        }
        int loaded = LOADED_ADDONS.size();
        if (loaded > 0) {
            Logging.log("Loaded " + loaded + " addon(s)");
        }
    }

    public void enableAddons() {
        for (BreweryAddon addon : LOADED_ADDONS) {
            try {
                addon.onAddonEnable();
            }
            catch (Throwable t) {
                Logging.errorLog("Failed to enable addon " + addon.getAddonInfo().name(), t);
                this.unloadAddon(addon);
            }
        }
    }

    public void loadAddon(File file) {
        try {
            BreweryAddon addon;
            URLClassLoader classLoader = new URLClassLoader(new URL[]{file.toURI().toURL()}, this.getClass().getClassLoader());
            Class<? extends BreweryAddon> mainClass = this.getMainClass(file, classLoader);
            try {
                addon = mainClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                Logging.errorLog("Failed to load addon: " + file.getName(), e);
                return;
            }
            try {
                Field infoField = BreweryAddon.class.getDeclaredField("addonInfo");
                infoField.setAccessible(true);
                infoField.set(addon, mainClass.getAnnotation(AddonInfo.class));
                if (addon.getAddonInfo() == null) {
                    Logging.errorLog("Addon " + mainClass.getSimpleName() + " is missing the AddonInfo annotation. It will not be loaded.");
                    return;
                }
                Field classLoaderField = BreweryAddon.class.getDeclaredField("classLoader");
                classLoaderField.setAccessible(true);
                Field loggerField = BreweryAddon.class.getDeclaredField("logger");
                loggerField.setAccessible(true);
                Field fileManagerField = BreweryAddon.class.getDeclaredField("addonFileManager");
                fileManagerField.setAccessible(true);
                Field addonConfigManagerField = BreweryAddon.class.getDeclaredField("addonConfigManager");
                addonConfigManagerField.setAccessible(true);
                Field addonFile = BreweryAddon.class.getDeclaredField("addonFile");
                addonFile.setAccessible(true);
                classLoaderField.set(addon, classLoader);
                loggerField.set(addon, new AddonLogger(addon.getAddonInfo()));
                fileManagerField.set(addon, new AddonFileManager(addon, file));
                addonConfigManagerField.set(addon, new AddonConfigManager(addon));
                addonFile.set(addon, file);
                addon.getAddonLogger().info("Loading &a" + addon.getAddonInfo().name() + " &f-&a v" + addon.getAddonInfo().version() + " &fby &a" + addon.getAddonInfo().author());
                LOADED_ADDONS.add(addon);
                addon.onAddonPreEnable();
            }
            catch (Exception e) {
                Logging.errorLog("Failed to load addon: " + file.getName(), e);
                this.unloadAddon(addon);
            }
        }
        catch (Throwable ex) {
            Logging.errorLog("Failed to load addon classes from jar " + file.getName(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class<? extends BreweryAddon> getMainClass(File jarFile, ClassLoader classLoader) {
        try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(jarFile));){
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                if (!jarEntry.getName().endsWith(".class")) continue;
                String className = jarEntry.getName().replaceAll("/", ".").replace(".class", "");
                try {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName(className, false, classLoader);
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        Logging.errorLog("An exception occurred while trying to load a class from an addon", e);
                        continue;
                    }
                    if (!BreweryAddon.class.isAssignableFrom(clazz)) continue;
                    classLoader.loadClass(className);
                    Class<BreweryAddon> clazz2 = clazz.asSubclass(BreweryAddon.class);
                    return clazz2;
                }
                catch (ClassNotFoundException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to load class " + className, e);
                }
            }
            throw new IllegalStateException("No class extending BreweryAddon found in jar " + jarFile.getName());
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load classes from jar " + jarFile.getName(), e);
        }
        throw new IllegalStateException("No class extending BreweryAddon found in jar " + jarFile.getName());
    }
}

