/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BarrelAsset;
import com.dre.brewery.BarrelFacing;
import com.dre.brewery.BarrelPart;
import com.dre.brewery.BarrelWoodType;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.BoundingBox;
import com.dre.brewery.utility.MinecraftVersion;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public abstract class BarrelBody {
    protected Block spigot;
    protected final BoundingBox bounds;
    protected byte signoffset;
    private static final Map<BlockVector, BarrelPart> UNTRANSFORMED_SMALL_BARREL_PART_MAP = Map.of(new BlockVector(1, 0, 0), BarrelPart.BOTTOM_RIGHT, new BlockVector(1, 0, 1), BarrelPart.BOTTOM_LEFT, new BlockVector(1, 1, 0), BarrelPart.TOP_RIGHT, new BlockVector(1, 1, 1), BarrelPart.TOP_LEFT, new BlockVector(2, 0, 0), BarrelPart.BOTTOM_RIGHT, new BlockVector(2, 0, 1), BarrelPart.BOTTOM_LEFT, new BlockVector(2, 1, 0), BarrelPart.TOP_RIGHT, new BlockVector(2, 1, 1), BarrelPart.TOP_LEFT);
    private static final Map<BlockVector, BarrelPart> UNTRANSFORMED_LARGE_BARREL_PART_MAP = new ImmutableMap.Builder().put((Object)new BlockVector(1, 0, -1), (Object)BarrelPart.BOTTOM_RIGHT).put((Object)new BlockVector(1, 0, 1), (Object)BarrelPart.BOTTOM_LEFT).put((Object)new BlockVector(1, 0, 0), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(1, 1, 1), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(1, 1, -1), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(1, 2, -1), (Object)BarrelPart.TOP_RIGHT).put((Object)new BlockVector(1, 2, 1), (Object)BarrelPart.TOP_LEFT).put((Object)new BlockVector(1, 2, 0), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(1, 1, 0), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(2, 0, -1), (Object)BarrelPart.BOTTOM_RIGHT).put((Object)new BlockVector(2, 0, 1), (Object)BarrelPart.BOTTOM_LEFT).put((Object)new BlockVector(2, 0, 0), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(2, 1, 1), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(2, 1, -1), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(2, 2, -1), (Object)BarrelPart.TOP_RIGHT).put((Object)new BlockVector(2, 2, 1), (Object)BarrelPart.TOP_LEFT).put((Object)new BlockVector(2, 2, 0), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(3, 0, -1), (Object)BarrelPart.BOTTOM_RIGHT).put((Object)new BlockVector(3, 0, 1), (Object)BarrelPart.BOTTOM_LEFT).put((Object)new BlockVector(3, 0, 0), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(3, 1, 1), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(3, 1, -1), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(3, 2, -1), (Object)BarrelPart.TOP_RIGHT).put((Object)new BlockVector(3, 2, 1), (Object)BarrelPart.TOP_LEFT).put((Object)new BlockVector(3, 2, 0), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(4, 0, -1), (Object)BarrelPart.BOTTOM_RIGHT).put((Object)new BlockVector(4, 0, 1), (Object)BarrelPart.BOTTOM_LEFT).put((Object)new BlockVector(4, 0, 0), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(4, 1, 1), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(4, 1, -1), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(4, 2, -1), (Object)BarrelPart.TOP_RIGHT).put((Object)new BlockVector(4, 2, 1), (Object)BarrelPart.TOP_LEFT).put((Object)new BlockVector(4, 2, 0), (Object)BarrelPart.BLOCK).put((Object)new BlockVector(4, 1, 0), (Object)BarrelPart.BLOCK).build();

    public BarrelBody(Block spigot, byte signoffset) {
        this.spigot = spigot;
        this.signoffset = signoffset;
        this.bounds = new BoundingBox(0, 0, 0, 0, 0, 0);
        if (MinecraftVersion.isFolia()) {
            BreweryPlugin.getScheduler().runTask(spigot.getLocation(), () -> {
                Block broken = this.getBrokenBlock(true);
                if (broken != null) {
                    this.remove(broken, null, true);
                }
            });
        }
    }

    public BarrelBody(Block spigot, byte signoffset, BoundingBox bounds) {
        this.spigot = spigot;
        this.signoffset = signoffset;
        this.bounds = bounds;
        if (this.bounds == null || this.bounds.isBad()) {
            BreweryPlugin.getScheduler().runTask(spigot.getLocation(), this::regenerateBounds);
        }
    }

    public void destroySign() {
        this.signoffset = 0;
    }

    @Nullable
    public static BarrelFacing getDirection(Block spigot) {
        BarrelFacing direction = null;
        Material type = spigot.getRelative(0, 0, 1).getType();
        if (BarrelAsset.isBarrelAsset(BarrelAsset.PLANKS, type) || BarrelAsset.isBarrelAsset(BarrelAsset.STAIRS, type)) {
            direction = BarrelFacing.SOUTH;
        }
        if (BarrelAsset.isBarrelAsset(BarrelAsset.PLANKS, type = spigot.getRelative(0, 0, -1).getType()) || BarrelAsset.isBarrelAsset(BarrelAsset.STAIRS, type)) {
            if (direction == null) {
                direction = BarrelFacing.NORTH;
            } else {
                return null;
            }
        }
        if (BarrelAsset.isBarrelAsset(BarrelAsset.PLANKS, type = spigot.getRelative(1, 0, 0).getType()) || BarrelAsset.isBarrelAsset(BarrelAsset.STAIRS, type)) {
            if (direction == null) {
                direction = BarrelFacing.EAST;
            } else {
                return null;
            }
        }
        if (BarrelAsset.isBarrelAsset(BarrelAsset.PLANKS, type = spigot.getRelative(-1, 0, 0).getType()) || BarrelAsset.isBarrelAsset(BarrelAsset.STAIRS, type)) {
            if (direction == null) {
                direction = BarrelFacing.WEST;
            } else {
                return null;
            }
        }
        return direction;
    }

    public BarrelWoodType getWood() {
        BarrelFacing direction = BarrelBody.getDirection(this.spigot);
        if (direction == null) {
            return BarrelWoodType.ANY;
        }
        Block wood = this.spigot.getRelative(direction.getFace());
        return BarrelWoodType.fromMaterial(wood.getType());
    }

    public boolean hasBlock(Block block) {
        if (block != null) {
            if (this.spigot.equals((Object)block)) {
                return true;
            }
            if (this.spigot.getWorld().equals((Object)block.getWorld())) {
                return this.bounds != null && this.bounds.contains(block.getX(), block.getY(), block.getZ());
            }
        }
        return false;
    }

    public boolean isSignOfBarrel(byte offset) {
        return offset == 0 || this.signoffset == 0 || this.signoffset == offset;
    }

    public Block getSignOfSpigot() {
        if (this.signoffset != 0) {
            if (BarrelAsset.isBarrelAsset(BarrelAsset.SIGN, this.spigot.getType())) {
                return this.spigot;
            }
            Block relative = this.spigot.getRelative(0, (int)this.signoffset, 0);
            if (BarrelAsset.isBarrelAsset(BarrelAsset.SIGN, relative.getType())) {
                return relative;
            }
            this.signoffset = 0;
        }
        return this.spigot;
    }

    public static Block getSpigotOfSign(Block block) {
        for (int y = -2; y <= 1; ++y) {
            Block relative = block.getRelative(0, y, 0);
            if (!BarrelAsset.isBarrelAsset(BarrelAsset.FENCE, relative.getType())) continue;
            return relative;
        }
        return block;
    }

    public abstract void remove(@Nullable Block var1, @Nullable Player var2, boolean var3);

    public abstract boolean regenerateBounds();

    public Block getBrokenBlock(boolean force) {
        if (force || BUtil.isChunkLoaded(this.spigot)) {
            if (BarrelAsset.isBarrelAsset(BarrelAsset.SIGN, this.spigot.getType())) {
                return this.checkSBarrel();
            }
            return this.checkLBarrel();
        }
        return null;
    }

    public Block checkSBarrel() {
        int dz2;
        int dz1;
        int dx2;
        BarrelFacing direction = BarrelBody.getDirection(this.spigot);
        if (direction == null) {
            return this.spigot;
        }
        BarrelFacing orthogonal = direction.rotate90degrees();
        int dx1 = direction.getDx();
        Block brokenBlock = this.validateStructure(direction, dx1, dx2 = orthogonal.getDx(), dz1 = direction.getDz(), dz2 = orthogonal.getDz(), UNTRANSFORMED_SMALL_BARREL_PART_MAP);
        if (brokenBlock != null) {
            return brokenBlock;
        }
        BlockVector spigotPos = this.spigot.getLocation().toVector().toBlockVector();
        BlockVector minBarrel = (BlockVector)new BlockVector(dx1, 0, dz1).add((Vector)spigotPos);
        BlockVector maxBarrel = (BlockVector)new BlockVector(2 * dx1 + dx2, 1, 2 * dz1 + dz2).add((Vector)spigotPos);
        this.bounds.resize(minBarrel.getBlockX(), minBarrel.getBlockY(), minBarrel.getBlockZ(), maxBarrel.getBlockX(), maxBarrel.getBlockY(), maxBarrel.getBlockZ());
        return null;
    }

    public Block checkLBarrel() {
        int dz2;
        int dz1;
        int dx2;
        BarrelFacing direction = BarrelBody.getDirection(this.spigot);
        if (direction == null) {
            return this.spigot;
        }
        BarrelFacing orthogonal = direction.rotate90degrees();
        int dx1 = direction.getDx();
        Block brokenBlock = this.validateStructure(direction, dx1, dx2 = orthogonal.getDx(), dz1 = direction.getDz(), dz2 = orthogonal.getDz(), UNTRANSFORMED_LARGE_BARREL_PART_MAP);
        if (brokenBlock != null) {
            return brokenBlock;
        }
        BlockVector spigotPos = this.spigot.getLocation().toVector().toBlockVector();
        BlockVector minBarrel = (BlockVector)new BlockVector(dx1 - dx2, 0, dz1 - dz2).add((Vector)spigotPos);
        BlockVector maxBarrel = (BlockVector)new BlockVector(4 * dx1 + dx2, 2, 4 * dz1 + dz2).add((Vector)spigotPos);
        this.bounds.resize(minBarrel.getBlockX(), minBarrel.getBlockY(), minBarrel.getBlockZ(), maxBarrel.getBlockX(), maxBarrel.getBlockY(), maxBarrel.getBlockZ());
        return null;
    }

    @Nullable
    private Block validateStructure(BarrelFacing direction, int dx1, int dx2, int dz1, int dz2, Map<BlockVector, BarrelPart> untransformedBarrelPartMap) {
        BarrelWoodType woodType = this.getWood();
        for (Map.Entry<BlockVector, BarrelPart> entry : untransformedBarrelPartMap.entrySet()) {
            int relativeX = dx1 * entry.getKey().getBlockX() + dx2 * entry.getKey().getBlockZ();
            int relativeZ = dz1 * entry.getKey().getBlockX() + dz2 * entry.getKey().getBlockZ();
            int relativeY = entry.getKey().getBlockY();
            Block block = this.spigot.getRelative(relativeX, relativeY, relativeZ);
            BlockData blockData = block.getBlockData();
            if (entry.getValue().matches(woodType, blockData, direction)) continue;
            return block;
        }
        return null;
    }

    public Block getSpigot() {
        return this.spigot;
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public byte getSignoffset() {
        return this.signoffset;
    }

    public void setSpigot(Block spigot) {
        this.spigot = spigot;
    }

    public void setSignoffset(byte signoffset) {
        this.signoffset = signoffset;
    }
}

