/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.storage.serialization;

import com.dre.brewery.depend.google.gson.Gson;
import com.dre.brewery.depend.google.gson.GsonBuilder;
import java.util.Base64;

public class SQLDataSerializer {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(8).create();

    public String serialize(Object object) {
        return Base64.getEncoder().encodeToString(this.gson.toJson(object).getBytes());
    }

    public <T> T deserialize(String data, Class<T> type) {
        return this.gson.fromJson(new String(Base64.getDecoder().decode(data)), type);
    }

    public <T> T deserialize(String data, Class<T> type, T defaultValue) {
        try {
            return this.deserialize(data, type);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

