/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.storage.impls;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Wakeup;
import com.dre.brewery.storage.DataManager;
import com.dre.brewery.storage.StorageInitException;
import com.dre.brewery.storage.records.BreweryMiscData;
import com.dre.brewery.storage.records.ConfiguredDataManager;
import com.dre.brewery.storage.records.SerializableBPlayer;
import com.dre.brewery.storage.records.SerializableBarrel;
import com.dre.brewery.storage.records.SerializableCauldron;
import com.dre.brewery.storage.records.SerializableThing;
import com.dre.brewery.storage.records.SerializableWakeup;
import com.dre.brewery.storage.serialization.SQLDataSerializer;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class SQLiteStorage
extends DataManager {
    private static final String URL = "jdbc:sqlite:";
    private static final String[] TABLES = new String[]{"misc (id VARCHAR(4) PRIMARY KEY, data LONGTEXT);", "barrels (id VARCHAR(36) PRIMARY KEY, data LONGTEXT);", "cauldrons (id VARCHAR(36) PRIMARY KEY, data LONGTEXT);", "players (id VARCHAR(36) PRIMARY KEY, data LONGTEXT);", "wakeups (id VARCHAR(36) PRIMARY KEY, data LONGTEXT);"};
    private final Connection connection;
    private final String tablePrefix;
    private final SQLDataSerializer serializer;

    public SQLiteStorage(ConfiguredDataManager record) throws StorageInitException {
        String fileName = record.database() + ".db";
        File rawFile = new File(plugin.getDataFolder(), fileName);
        if (!rawFile.exists()) {
            try {
                rawFile.createNewFile();
            }
            catch (IOException e) {
                throw new StorageInitException("Failed to create db file! " + fileName, e);
            }
        }
        try {
            this.connection = DriverManager.getConnection(URL + rawFile.getAbsolutePath());
            this.tablePrefix = record.tablePrefix();
            this.serializer = new SQLDataSerializer();
            for (String table : TABLES) {
                try (PreparedStatement statement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.tablePrefix + table);){
                    statement.execute();
                }
            }
        }
        catch (SQLException e) {
            throw new StorageInitException("Failed to connect or create tables!", e);
        }
    }

    @Override
    protected void closeConnection() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            plugin.errorLog("Failed to close SQLite connection!", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T getGeneric(UUID id, String table, Class<T> type) {
        String sql = "SELECT data FROM " + this.tablePrefix + table + " WHERE id = ?";
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            statement.setString(1, id.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                T t = this.serializer.deserialize(resultSet.getString("data"), type);
                return t;
            }
        }
        catch (SQLException e) {
            plugin.errorLog("Failed to retrieve object from table: " + table + ", from: SQLite!", e);
        }
        return null;
    }

    private <T> List<T> getAllGeneric(String table, Class<T> type) {
        String sql = "SELECT id, data FROM " + this.tablePrefix + table;
        ArrayList<T> objects = new ArrayList<T>();
        try (PreparedStatement statement = this.connection.prepareStatement(sql);
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                String data = resultSet.getString("data");
                objects.add(this.serializer.deserialize(data, type));
            }
        }
        catch (SQLException e) {
            plugin.errorLog("Failed to retrieve objects from table: " + table + ", from: SQLite!", e);
        }
        return objects;
    }

    private void saveAllGeneric(List<? extends SerializableThing> serializableThings, String table, boolean overwrite) {
        String sql = overwrite ? "INSERT INTO " + this.tablePrefix + table + " (id, data) VALUES (?, ?) ON CONFLICT(id) DO UPDATE SET data = excluded.data" : "INSERT INTO " + this.tablePrefix + table + " (id, data) VALUES (?, ?) ON CONFLICT(id) DO NOTHING";
        try (PreparedStatement insertStatement = this.connection.prepareStatement(sql);){
            for (SerializableThing serializableThing : serializableThings) {
                insertStatement.setString(1, serializableThing.getId());
                insertStatement.setString(2, this.serializer.serialize(serializableThing));
                insertStatement.addBatch();
            }
            insertStatement.executeBatch();
        }
        catch (SQLException e) {
            plugin.errorLog("Failed to save objects to SQLite!", e);
        }
    }

    private <T extends SerializableThing> void saveGeneric(T serializableThing, String table) {
        String sql = "INSERT INTO " + this.tablePrefix + table + " (id, data) VALUES (?, ?) ON CONFLICT(id) DO UPDATE SET data = excluded.data";
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            statement.setString(1, serializableThing.getId());
            statement.setString(2, this.serializer.serialize(serializableThing));
            statement.execute();
        }
        catch (SQLException e) {
            plugin.errorLog("Failed to save object to:" + table + ", to: SQLite!", e);
        }
    }

    private void deleteGeneric(UUID id, String table) {
        String sql = "DELETE FROM " + this.tablePrefix + table + " WHERE id = ?";
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            statement.setString(1, id.toString());
            statement.execute();
        }
        catch (SQLException e) {
            plugin.errorLog("Failed to delete object from: " + table + ", from: SQLite!", e);
        }
    }

    @Override
    public Barrel getBarrel(UUID id) {
        SerializableBarrel serializableBarrel = this.getGeneric(id, "barrels", SerializableBarrel.class);
        if (serializableBarrel != null) {
            return serializableBarrel.toBarrel();
        }
        return null;
    }

    @Override
    public Collection<Barrel> getAllBarrels() {
        return this.getAllGeneric("barrels", SerializableBarrel.class).stream().map(SerializableBarrel::toBarrel).toList();
    }

    @Override
    public void saveAllBarrels(Collection<Barrel> barrels, boolean overwrite) {
        List<SerializableBarrel> serializableBarrels = barrels.stream().map(SerializableBarrel::new).toList();
        this.saveAllGeneric(serializableBarrels, "barrels", overwrite);
    }

    @Override
    public void saveBarrel(Barrel barrel) {
        this.saveGeneric(new SerializableBarrel(barrel), "barrels");
    }

    @Override
    public void deleteBarrel(UUID id) {
        this.deleteGeneric(id, "barrels");
    }

    @Override
    public BCauldron getCauldron(UUID id) {
        SerializableCauldron serializableCauldron = this.getGeneric(id, "cauldrons", SerializableCauldron.class);
        if (serializableCauldron != null) {
            return serializableCauldron.toCauldron();
        }
        return null;
    }

    @Override
    public Collection<BCauldron> getAllCauldrons() {
        return this.getAllGeneric("cauldrons", SerializableCauldron.class).stream().map(SerializableCauldron::toCauldron).toList();
    }

    @Override
    public void saveAllCauldrons(Collection<BCauldron> cauldrons, boolean overwrite) {
        List<SerializableCauldron> serializableCauldrons = cauldrons.stream().map(SerializableCauldron::new).toList();
        this.saveAllGeneric(serializableCauldrons, "cauldrons", overwrite);
    }

    @Override
    public void saveCauldron(BCauldron cauldron) {
        this.saveGeneric(new SerializableCauldron(cauldron), "cauldrons");
    }

    @Override
    public void deleteCauldron(UUID id) {
        this.deleteGeneric(id, "cauldrons");
    }

    @Override
    public BPlayer getPlayer(UUID playerUUID) {
        SerializableBPlayer serializableBPlayer = this.getGeneric(playerUUID, "players", SerializableBPlayer.class);
        if (serializableBPlayer != null) {
            return serializableBPlayer.toBPlayer();
        }
        return null;
    }

    @Override
    public Collection<BPlayer> getAllPlayers() {
        return this.getAllGeneric("players", SerializableBPlayer.class).stream().map(SerializableBPlayer::toBPlayer).toList();
    }

    @Override
    public void saveAllPlayers(Collection<BPlayer> players, boolean overwrite) {
        List<SerializableBPlayer> serializableBPlayers = players.stream().map(SerializableBPlayer::new).toList();
        this.saveAllGeneric(serializableBPlayers, "players", overwrite);
    }

    @Override
    public void savePlayer(BPlayer player) {
        this.saveGeneric(new SerializableBPlayer(player), "players");
    }

    @Override
    public void deletePlayer(UUID playerUUID) {
        this.deleteGeneric(playerUUID, "players");
    }

    @Override
    public Wakeup getWakeup(UUID id) {
        SerializableWakeup serializableWakeup = this.getGeneric(id, "wakeups", SerializableWakeup.class);
        if (serializableWakeup != null) {
            return serializableWakeup.toWakeup();
        }
        return null;
    }

    @Override
    public Collection<Wakeup> getAllWakeups() {
        return this.getAllGeneric("wakeups", SerializableWakeup.class).stream().map(SerializableWakeup::toWakeup).toList();
    }

    @Override
    public void saveAllWakeups(Collection<Wakeup> wakeups, boolean overwrite) {
        List<SerializableWakeup> serializableWakeups = wakeups.stream().map(SerializableWakeup::new).toList();
        this.saveAllGeneric(serializableWakeups, "wakeups", overwrite);
    }

    @Override
    public void saveWakeup(Wakeup wakeup) {
        this.saveGeneric(new SerializableWakeup(wakeup), "wakeups");
    }

    @Override
    public void deleteWakeup(UUID id) {
        this.deleteGeneric(id, "wakeups");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BreweryMiscData getBreweryMiscData() {
        String sql = "SELECT CASE WHEN EXISTS (SELECT 1 FROM " + this.tablePrefix + "misc WHERE id = 'misc') THEN (SELECT data FROM " + this.tablePrefix + "misc WHERE id = 'misc') ELSE NULL END AS data";
        try (PreparedStatement statement = this.connection.prepareStatement(sql);
             ResultSet resultSet = statement.executeQuery();){
            if (!resultSet.next()) return new BreweryMiscData(System.currentTimeMillis(), 0L, new ArrayList<Long>(), new ArrayList<Integer>(), 0);
            if (resultSet.getString("data") == null) return new BreweryMiscData(System.currentTimeMillis(), 0L, new ArrayList<Long>(), new ArrayList<Integer>(), 0);
            BreweryMiscData breweryMiscData = this.serializer.deserialize(resultSet.getString("data"), BreweryMiscData.class);
            return breweryMiscData;
        }
        catch (SQLException e) {
            plugin.errorLog("Failed to retrieve misc data from SQLite!", e);
        }
        return new BreweryMiscData(System.currentTimeMillis(), 0L, new ArrayList<Long>(), new ArrayList<Integer>(), 0);
    }

    @Override
    public void saveBreweryMiscData(BreweryMiscData data) {
        String sql = "INSERT INTO " + this.tablePrefix + "misc (id, data) VALUES ('misc', ?) ON CONFLICT(id) DO UPDATE SET data = excluded.data";
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            statement.setString(1, this.serializer.serialize(data));
            statement.execute();
        }
        catch (SQLException e) {
            plugin.errorLog("Failed to save misc data to SQLite!", e);
        }
    }
}

