/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.storage.impls;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BIngredients;
import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Wakeup;
import com.dre.brewery.storage.DataManager;
import com.dre.brewery.storage.StorageInitException;
import com.dre.brewery.storage.records.BreweryMiscData;
import com.dre.brewery.storage.records.ConfiguredDataManager;
import com.dre.brewery.storage.serialization.BukkitSerialization;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.BoundingBox;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class FlatFileStorage
extends DataManager {
    private final File rawFile;
    private final YamlConfiguration dataFile;

    public FlatFileStorage(ConfiguredDataManager record) throws StorageInitException {
        String fileName = record.database() + ".yml";
        this.rawFile = new File(plugin.getDataFolder(), fileName);
        if (!this.rawFile.exists()) {
            try {
                this.rawFile.createNewFile();
            }
            catch (IOException e) {
                throw new StorageInitException("Failed to create file! " + fileName, e);
            }
        }
        this.dataFile = YamlConfiguration.loadConfiguration((File)this.rawFile);
    }

    private void save() {
        try {
            this.dataFile.save(this.rawFile);
        }
        catch (IOException e) {
            plugin.errorLog("Failed to save to Flatfile!", e);
        }
    }

    @Override
    public Barrel getBarrel(UUID id) {
        String path = "barrels." + id;
        Block spigot = FlatFileStorage.deserializeLocation(this.dataFile.getString(path + ".spigot")).getBlock();
        BoundingBox bounds = BoundingBox.fromPoints(this.dataFile.getIntegerList(path + ".bounds"));
        float time = (float)this.dataFile.getDouble(path + ".time", 0.0);
        byte sign = (byte)this.dataFile.getInt(path + ".sign", 0);
        ItemStack[] items = BukkitSerialization.itemStackArrayFromBase64(this.dataFile.getString(path + ".items", null));
        return new Barrel(spigot, sign, bounds, items, time, id);
    }

    @Override
    public Collection<Barrel> getAllBarrels() {
        ConfigurationSection section = this.dataFile.getConfigurationSection("barrels");
        if (section == null) {
            return Collections.emptyList();
        }
        ArrayList<Barrel> barrels = new ArrayList<Barrel>();
        for (String key : section.getKeys(false)) {
            Barrel barrel = this.getBarrel(BUtil.uuidFromString(key));
            if (barrel == null) continue;
            barrels.add(barrel);
        }
        return barrels;
    }

    @Override
    public void saveAllBarrels(Collection<Barrel> barrels, boolean overwrite) {
        if (overwrite) {
            this.dataFile.set("barrels", null);
        }
        for (Barrel barrel : barrels) {
            this.saveBarrel(barrel);
        }
    }

    @Override
    public void saveBarrel(Barrel barrel) {
        String path = "barrels." + barrel.getId();
        this.dataFile.set(path + ".spigot", (Object)FlatFileStorage.serializeLocation(barrel.getSpigot().getLocation()));
        this.dataFile.set(path + ".bounds", (Object)barrel.getBody().getBounds().serialize());
        this.dataFile.set(path + ".time", (Object)Float.valueOf(barrel.getTime()));
        this.dataFile.set(path + ".sign", (Object)barrel.getBody().getSignoffset());
        this.dataFile.set(path + ".items", (Object)BukkitSerialization.itemStackArrayToBase64(barrel.getInventory().getContents()));
        this.save();
    }

    @Override
    public void deleteBarrel(UUID id) {
        this.dataFile.set("barrels." + id, null);
        this.save();
    }

    @Override
    public BCauldron getCauldron(UUID id) {
        String path = "cauldrons." + id;
        Block block = FlatFileStorage.deserializeLocation(this.dataFile.getString(path + ".block")).getBlock();
        BIngredients ingredients = BIngredients.deserializeIngredients(this.dataFile.getString(path + ".ingredients"));
        int state = this.dataFile.getInt(path + ".state", 0);
        return new BCauldron(block, ingredients, state, id);
    }

    @Override
    public Collection<BCauldron> getAllCauldrons() {
        ConfigurationSection section = this.dataFile.getConfigurationSection("cauldrons");
        if (section == null) {
            return Collections.emptyList();
        }
        ArrayList<BCauldron> cauldrons = new ArrayList<BCauldron>();
        for (String key : section.getKeys(false)) {
            BCauldron cauldron = this.getCauldron(BUtil.uuidFromString(key));
            if (cauldron == null) continue;
            cauldrons.add(cauldron);
        }
        return cauldrons;
    }

    @Override
    public void saveAllCauldrons(Collection<BCauldron> cauldrons, boolean overwrite) {
        if (overwrite) {
            this.dataFile.set("cauldrons", null);
        }
        for (BCauldron cauldron : cauldrons) {
            this.saveCauldron(cauldron);
        }
    }

    @Override
    public void saveCauldron(BCauldron cauldron) {
        String path = "cauldrons." + cauldron.getId();
        this.dataFile.set(path + ".block", (Object)FlatFileStorage.serializeLocation(cauldron.getBlock().getLocation()));
        this.dataFile.set(path + ".ingredients", (Object)cauldron.getIngredients().serializeIngredients());
        this.dataFile.set(path + ".state", (Object)cauldron.getState());
        this.save();
    }

    @Override
    public void deleteCauldron(UUID id) {
        this.dataFile.set("cauldrons." + id, null);
        this.save();
    }

    @Override
    public BPlayer getPlayer(UUID playerUUID) {
        String path = "players." + playerUUID;
        int quality = this.dataFile.getInt(path + ".quality", 0);
        int drunkenness = this.dataFile.getInt(path + ".drunkenness", 0);
        int offlineDrunkenness = this.dataFile.getInt(path + ".offlineDrunkenness", 0);
        return new BPlayer(playerUUID, quality, drunkenness, offlineDrunkenness);
    }

    @Override
    public Collection<BPlayer> getAllPlayers() {
        ConfigurationSection section = this.dataFile.getConfigurationSection("players");
        if (section == null) {
            return Collections.emptyList();
        }
        ArrayList<BPlayer> players = new ArrayList<BPlayer>();
        for (String key : section.getKeys(false)) {
            BPlayer player = this.getPlayer(BUtil.uuidFromString(key));
            if (player == null) continue;
            players.add(player);
        }
        return players;
    }

    @Override
    public void saveAllPlayers(Collection<BPlayer> players, boolean overwrite) {
        if (overwrite) {
            this.dataFile.set("players", null);
        }
        for (BPlayer player : players) {
            this.savePlayer(player);
        }
    }

    @Override
    public void savePlayer(BPlayer player) {
        String path = "players." + player.getUuid();
        this.dataFile.set(path + ".quality", (Object)player.getQuality());
        this.dataFile.set(path + ".drunkenness", (Object)player.getDrunkeness());
        this.dataFile.set(path + ".offlineDrunkenness", (Object)player.getOfflineDrunkeness());
        this.save();
    }

    @Override
    public void deletePlayer(UUID playerUUID) {
        this.dataFile.set("players." + playerUUID, null);
        this.save();
    }

    @Override
    public Wakeup getWakeup(UUID id) {
        String path = "wakeups." + id;
        Location wakeupLocation = FlatFileStorage.deserializeLocation(this.dataFile.getString(path + ".location"), true);
        return new Wakeup(wakeupLocation, id);
    }

    @Override
    public Collection<Wakeup> getAllWakeups() {
        ConfigurationSection section = this.dataFile.getConfigurationSection("wakeups");
        if (section == null) {
            return Collections.emptyList();
        }
        ArrayList<Wakeup> wakeups = new ArrayList<Wakeup>();
        for (String key : section.getKeys(false)) {
            Wakeup wakeup = this.getWakeup(BUtil.uuidFromString(key));
            if (wakeup == null) continue;
            wakeups.add(wakeup);
        }
        return wakeups;
    }

    @Override
    public void saveAllWakeups(Collection<Wakeup> wakeups, boolean overwrite) {
        if (overwrite) {
            this.dataFile.set("wakeups", null);
        }
        for (Wakeup wakeup : wakeups) {
            this.saveWakeup(wakeup);
        }
    }

    @Override
    public void saveWakeup(Wakeup wakeup) {
        String path = "wakeups." + wakeup.getId();
        this.dataFile.set(path + ".location", (Object)FlatFileStorage.serializeLocation(wakeup.getLoc(), true));
        this.save();
    }

    @Override
    public void deleteWakeup(UUID id) {
        this.dataFile.set("wakeups." + id, null);
        this.save();
    }

    @Override
    public BreweryMiscData getBreweryMiscData() {
        return new BreweryMiscData(this.dataFile.getLong("misc.installTime", System.currentTimeMillis()), this.dataFile.getLong("misc.mcBarrelTime", 0L), this.dataFile.getLongList("misc.previousSaveSeeds"), this.dataFile.getIntegerList("misc.brewsCreated"), this.dataFile.getInt("misc.brewsCreatedHash", 0));
    }

    @Override
    public void saveBreweryMiscData(BreweryMiscData data) {
        this.dataFile.set("misc.installTime", (Object)data.installTime());
        this.dataFile.set("misc.mcBarrelTime", (Object)data.mcBarrelTime());
        this.dataFile.set("misc.previousSaveSeeds", data.prevSaveSeeds());
        this.dataFile.set("misc.brewsCreated", data.brewsCreated());
        this.dataFile.set("misc.brewsCreatedHash", (Object)data.brewsCreatedHash());
        this.save();
    }
}

