/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.storage;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.MCBarrel;
import com.dre.brewery.Wakeup;
import com.dre.brewery.filedata.BConfig;
import com.dre.brewery.integration.bstats.Stats;
import com.dre.brewery.storage.BData;
import com.dre.brewery.storage.StorageInitException;
import com.dre.brewery.storage.impls.FlatFileStorage;
import com.dre.brewery.storage.impls.MySQLStorage;
import com.dre.brewery.storage.impls.SQLiteStorage;
import com.dre.brewery.storage.records.BreweryMiscData;
import com.dre.brewery.storage.records.ConfiguredDataManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public abstract class DataManager {
    protected static BreweryPlugin plugin = BreweryPlugin.getInstance();
    protected static long lastAutoSave = System.currentTimeMillis();

    public abstract Barrel getBarrel(UUID var1);

    public abstract Collection<Barrel> getAllBarrels();

    public abstract void saveAllBarrels(Collection<Barrel> var1, boolean var2);

    public abstract void saveBarrel(Barrel var1);

    public abstract void deleteBarrel(UUID var1);

    public abstract BCauldron getCauldron(UUID var1);

    public abstract Collection<BCauldron> getAllCauldrons();

    public abstract void saveAllCauldrons(Collection<BCauldron> var1, boolean var2);

    public abstract void saveCauldron(BCauldron var1);

    public abstract void deleteCauldron(UUID var1);

    public abstract BPlayer getPlayer(UUID var1);

    public abstract Collection<BPlayer> getAllPlayers();

    public abstract void saveAllPlayers(Collection<BPlayer> var1, boolean var2);

    public abstract void savePlayer(BPlayer var1);

    public abstract void deletePlayer(UUID var1);

    public abstract Wakeup getWakeup(UUID var1);

    public abstract Collection<Wakeup> getAllWakeups();

    public abstract void saveAllWakeups(Collection<Wakeup> var1, boolean var2);

    public abstract void saveWakeup(Wakeup var1);

    public abstract void deleteWakeup(UUID var1);

    public abstract BreweryMiscData getBreweryMiscData();

    public abstract void saveBreweryMiscData(BreweryMiscData var1);

    public void tryAutoSave() {
        long interval = (long)BConfig.autoSaveInterval * 60000L;
        if (System.currentTimeMillis() - lastAutoSave > interval) {
            this.saveAll(true);
            lastAutoSave = System.currentTimeMillis();
            plugin.debugLog("Auto saved all data!");
        }
    }

    public void saveAll(boolean async) {
        this.saveAll(async, null);
    }

    public void saveAll(boolean async, Runnable callback) {
        List<Barrel> barrels = Barrel.getBarrels();
        Collection<BCauldron> cauldrons = BCauldron.getBcauldrons().values();
        Collection<BPlayer> bPlayers = BPlayer.getPlayers().values();
        List<Wakeup> wakeups = Wakeup.getWakeups();
        if (async) {
            BreweryPlugin.getScheduler().runTaskAsynchronously(() -> {
                this.doSave(barrels, cauldrons, bPlayers, wakeups);
                if (callback != null) {
                    callback.run();
                }
            });
        } else {
            this.doSave(barrels, cauldrons, bPlayers, wakeups);
            if (callback != null) {
                callback.run();
            }
        }
    }

    private void doSave(Collection<Barrel> barrels, Collection<BCauldron> cauldrons, Collection<BPlayer> players, Collection<Wakeup> wakeups) {
        this.saveBreweryMiscData(DataManager.getLoadedMiscData());
        this.saveAllBarrels(barrels, true);
        this.saveAllCauldrons(cauldrons, true);
        this.saveAllPlayers(players, true);
        this.saveAllWakeups(wakeups, true);
        plugin.debugLog("Saved all data!");
    }

    protected void closeConnection() {
    }

    public void exit(boolean save, boolean async) {
        this.exit(save, async, null);
    }

    public void exit(boolean save, boolean async, Runnable callback) {
        if (save) {
            this.saveAll(async, () -> {
                this.closeConnection();
                plugin.log("Closed connection from&7:&a " + this.getClass().getSimpleName());
                if (callback != null) {
                    callback.run();
                }
            });
        } else {
            this.closeConnection();
            plugin.log("Closed connection from&7:&a " + this.getClass().getSimpleName());
            if (callback != null) {
                callback.run();
            }
        }
    }

    public static DataManager createDataManager(ConfiguredDataManager record) throws StorageInitException {
        DataManager dataManager;
        switch (record.type()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case FLATFILE: {
                DataManager dataManager2 = new FlatFileStorage(record);
                break;
            }
            case MYSQL: {
                DataManager dataManager2 = new MySQLStorage(record);
                break;
            }
            case SQLITE: {
                DataManager dataManager2 = dataManager = new SQLiteStorage(record);
            }
        }
        if (BData.checkForLegacyData()) {
            long start = System.currentTimeMillis();
            plugin.log("&5Brewery is loading data from a legacy format!");
            BData.readData();
            BData.finalizeLegacyDataMigration();
            dataManager.saveAll(false);
            plugin.log("&5Finished migrating legacy data! Took&7: &a" + (System.currentTimeMillis() - start) + "ms&5! Join our discord if you need assistance: &ahttps://discord.gg/3FkNaNDnta");
            plugin.warningLog("BreweryX can only load legacy data from worlds that exist. If you're trying to migrate old cauldrons, barrels, etc. And the worlds they're in don't exist, you'll need to migrate manually.");
        }
        plugin.log("DataManager created&7:&a " + record.type().getFormattedName());
        return dataManager;
    }

    public static void loadMiscData(BreweryMiscData miscData) {
        Brew.installTime = miscData.installTime();
        MCBarrel.mcBarrelTime = miscData.mcBarrelTime();
        Brew.loadPrevSeeds(miscData.prevSaveSeeds());
        Stats stats = DataManager.plugin.stats;
        if (miscData.brewsCreated().size() == 7 && miscData.brewsCreatedHash() == miscData.brewsCreated().hashCode()) {
            stats.brewsCreated = miscData.brewsCreated().get(0);
            stats.brewsCreatedCmd = miscData.brewsCreated().get(1);
            stats.exc = miscData.brewsCreated().get(2);
            stats.good = miscData.brewsCreated().get(3);
            stats.norm = miscData.brewsCreated().get(4);
            stats.bad = miscData.brewsCreated().get(5);
            stats.terr = miscData.brewsCreated().get(6);
        }
    }

    public static BreweryMiscData getLoadedMiscData() {
        ArrayList<Integer> brewsCreated = new ArrayList<Integer>(7);
        Stats stats = DataManager.plugin.stats;
        brewsCreated.addAll(List.of(Integer.valueOf(stats.brewsCreated), Integer.valueOf(stats.brewsCreatedCmd), Integer.valueOf(stats.exc), Integer.valueOf(stats.good), Integer.valueOf(stats.norm), Integer.valueOf(stats.bad), Integer.valueOf(stats.terr)));
        return new BreweryMiscData(Brew.installTime, MCBarrel.mcBarrelTime, Brew.getPrevSeeds(), brewsCreated, brewsCreated.hashCode());
    }

    public static Location deserializeLocation(String locationString) {
        return DataManager.deserializeLocation(locationString, false);
    }

    public static String serializeLocation(Location location) {
        return DataManager.serializeLocation(location, false);
    }

    public static Location deserializeLocation(String string, boolean yawPitch) {
        if (string == null) {
            plugin.warningLog("Location is null!");
            return null;
        }
        String locationString = string;
        String worldName = null;
        if (locationString.contains("?=")) {
            String[] split = locationString.split("\\?=");
            locationString = split[0];
            worldName = split[1];
        }
        String[] loc = locationString.split(",");
        UUID worldUUID = null;
        try {
            worldUUID = UUID.fromString(loc[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        World world = null;
        if (worldUUID != null) {
            world = Bukkit.getWorld((UUID)worldUUID);
        }
        if (world == null && worldName != null) {
            world = Bukkit.getWorld((String)worldName);
        }
        if (world == null) {
            plugin.warningLog("World not found! " + loc[0]);
            return null;
        }
        if (yawPitch && loc.length == 6) {
            return new Location(world, (double)plugin.parseInt(loc[1]), (double)plugin.parseInt(loc[2]), (double)plugin.parseInt(loc[3]), plugin.parseFloat(loc[4]), plugin.parseFloat(loc[5]));
        }
        return new Location(world, (double)plugin.parseInt(loc[1]), (double)plugin.parseInt(loc[2]), (double)plugin.parseInt(loc[3]));
    }

    public static String serializeLocation(Location location, boolean yawPitch) {
        if (location.getWorld() == null) {
            plugin.errorLog("Location must have a world! " + location);
            return null;
        }
        String locationString = yawPitch ? location.getWorld().getUID() + "," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ() + "," + location.getYaw() + "," + location.getPitch() : location.getWorld().getUID() + "," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
        locationString = locationString + "?=" + location.getWorld().getName();
        return locationString;
    }
}

