/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.storage;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BIngredients;
import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.MCBarrel;
import com.dre.brewery.Wakeup;
import com.dre.brewery.filedata.BConfig;
import com.dre.brewery.lore.Base91DecoderStream;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.recipe.SimpleItem;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.BoundingBox;
import com.dre.brewery.utility.MinecraftVersion;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class BData {
    private static final MinecraftVersion VERSION = BreweryPlugin.getMCVersion();
    private static final BreweryPlugin plugin = BreweryPlugin.getInstance();
    public static AtomicInteger dataMutex = new AtomicInteger(0);
    public static FileConfiguration worldData = null;

    public static boolean checkForLegacyData() {
        File file = new File(plugin.getDataFolder(), "data.yml");
        File worldDataFile = new File(plugin.getDataFolder(), "worlddata.yml");
        return file.exists() || worldDataFile.exists();
    }

    public static void finalizeLegacyDataMigration() {
        File file = new File(plugin.getDataFolder(), "data.yml");
        File worldDataFile = new File(plugin.getDataFolder(), "worlddata.yml");
        File worldDataFileBackup = new File(plugin.getDataFolder(), "worlddataBackup.yml");
        if (file.exists()) {
            file.renameTo(new File(plugin.getDataFolder(), "data.yml.old"));
        }
        if (worldDataFile.exists()) {
            worldDataFile.renameTo(new File(plugin.getDataFolder(), "worlddata.yml.old"));
        }
        if (worldDataFileBackup.exists()) {
            worldDataFileBackup.renameTo(new File(plugin.getDataFolder(), "worlddataBackup.yml.old"));
        }
    }

    public static void readData() {
        YamlConfiguration data;
        File file = new File(BreweryPlugin.getInstance().getDataFolder(), "data.yml");
        File worldDataFile = new File(BreweryPlugin.getInstance().getDataFolder(), "worlddata.yml");
        if (file.exists()) {
            data = YamlConfiguration.loadConfiguration((File)file);
            Brew.installTime = data.getLong("installTime", System.currentTimeMillis());
            MCBarrel.mcBarrelTime = data.getLong("MCBarrelTime", 0L);
            Brew.loadPrevSeeds((ConfigurationSection)data);
            List brewsCreated = data.getIntegerList("brewsCreated");
            if (brewsCreated.size() == 7) {
                int hash = data.getInt("brewsCreatedH");
                if (brewsCreated.hashCode() == hash) {
                    BreweryPlugin.getInstance().stats.brewsCreated = (Integer)brewsCreated.get(0);
                    BreweryPlugin.getInstance().stats.brewsCreatedCmd = (Integer)brewsCreated.get(1);
                    BreweryPlugin.getInstance().stats.exc = (Integer)brewsCreated.get(2);
                    BreweryPlugin.getInstance().stats.good = (Integer)brewsCreated.get(3);
                    BreweryPlugin.getInstance().stats.norm = (Integer)brewsCreated.get(4);
                    BreweryPlugin.getInstance().stats.bad = (Integer)brewsCreated.get(5);
                    BreweryPlugin.getInstance().stats.terr = (Integer)brewsCreated.get(6);
                }
            }
        }
        if (worldDataFile.exists()) {
            int currentHoursAfterInstall;
            int purgeTime;
            data = YamlConfiguration.loadConfiguration((File)worldDataFile);
            HashMap<String, BIngredients> ingMap = new HashMap<String, BIngredients>();
            ConfigurationSection section = data.getConfigurationSection("Ingredients");
            if (section != null) {
                for (String id : section.getKeys(false)) {
                    if (section.isConfigurationSection(id + ".mats")) {
                        ConfigurationSection matSection = section.getConfigurationSection(id + ".mats");
                        if (matSection != null) {
                            List<Ingredient> ingredients = BData.oldDeserializeIngredients(matSection);
                            ingMap.put(id, new BIngredients(ingredients, section.getInt(id + ".cookedTime", 0), true));
                            continue;
                        }
                        BreweryPlugin.getInstance().errorLog("Ingredient id: '" + id + "' incomplete in data.yml");
                        continue;
                    }
                    ingMap.put(id, BData.deserializeIngredients(section.getString(id + ".mats")));
                }
            }
            if ((section = data.getConfigurationSection("Brew")) != null) {
                for (String uid : section.getKeys(false)) {
                    BIngredients ingredients = BData.getIngredients(ingMap, section.getString(uid + ".ingId"));
                    int quality = section.getInt(uid + ".quality", 0);
                    int alc = section.getInt(uid + ".alc", 0);
                    byte distillRuns = (byte)section.getInt(uid + ".distillRuns", 0);
                    float ageTime = (float)section.getDouble(uid + ".ageTime", 0.0);
                    float wood = (float)section.getDouble(uid + ".wood", -1.0);
                    String recipe = section.getString(uid + ".recipe", null);
                    boolean unlabeled = section.getBoolean(uid + ".unlabeled", false);
                    boolean persistent = section.getBoolean(uid + ".persist", false);
                    boolean stat = section.getBoolean(uid + ".stat", false);
                    int lastUpdate = section.getInt(uid + ".lastUpdate", 0);
                    Brew.loadLegacy(ingredients, BreweryPlugin.getInstance().parseInt(uid), quality, alc, distillRuns, ageTime, wood, recipe, unlabeled, persistent, stat, lastUpdate);
                }
            }
            if (BreweryPlugin.getInstance().stats.brewsCreated <= 0) {
                BreweryPlugin.getInstance().stats.brewsCreated = 0;
                BreweryPlugin.getInstance().stats.brewsCreatedCmd = 0;
                BreweryPlugin.getInstance().stats.exc = 0;
                BreweryPlugin.getInstance().stats.good = 0;
                BreweryPlugin.getInstance().stats.norm = 0;
                BreweryPlugin.getInstance().stats.bad = 0;
                BreweryPlugin.getInstance().stats.terr = 0;
                if (!Brew.noLegacy()) {
                    for (int i = Brew.legacyPotions.size(); i > 0; --i) {
                        BreweryPlugin.getInstance().stats.metricsForCreate(false);
                    }
                }
            }
            if (!Brew.noLegacy() && (purgeTime = (currentHoursAfterInstall = (int)((double)(System.currentTimeMillis() - Brew.installTime) / 3600000.0)) - 2880) > 0) {
                int removed = 0;
                Iterator<Brew> iterator = Brew.legacyPotions.values().iterator();
                while (iterator.hasNext()) {
                    Brew brew = iterator.next();
                    if (brew.getLastUpdate() >= purgeTime) continue;
                    iterator.remove();
                    ++removed;
                }
                if (removed > 0) {
                    BreweryPlugin.getInstance().log("Removed " + removed + " Legacy Brews older than 3 months");
                }
            }
            ArrayList<BPlayer> players = new ArrayList<BPlayer>();
            section = data.getConfigurationSection("Player");
            if (section != null) {
                for (String uuid : section.getKeys(false)) {
                    int quality = section.getInt(uuid + ".quality");
                    int drunk = section.getInt(uuid + ".drunk");
                    int offDrunk = section.getInt(uuid + ".offDrunk", 0);
                    players.add(new BPlayer(uuid, quality, drunk, offDrunk));
                }
            }
            BPlayer.getPlayers().putAll(players.stream().collect(Collectors.toMap(BPlayer::getUuid, Function.identity())));
            List worlds = BreweryPlugin.getInstance().getServer().getWorlds();
            for (World world : worlds) {
                BData.loadWorldData(world.getUID().toString(), world);
            }
        }
    }

    public static BIngredients deserializeIngredients(String mat) {
        BIngredients bIngredients;
        DataInputStream in = new DataInputStream(new Base91DecoderStream(new ByteArrayInputStream(mat.getBytes())));
        try {
            byte ver = in.readByte();
            bIngredients = BIngredients.load(in, ver);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new BIngredients();
            }
        }
        in.close();
        return bIngredients;
    }

    public static List<Ingredient> oldDeserializeIngredients(ConfigurationSection matSection) {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (String mat : matSection.getKeys(false)) {
            String[] matSplit = mat.split(",");
            Material m = Material.getMaterial((String)matSplit[0]);
            if (m == null && VERSION.isOrLater(MinecraftVersion.V1_13)) {
                m = matSplit[0].equals("LONG_GRASS") ? Material.GRASS : Material.matchMaterial((String)matSplit[0], (boolean)true);
                BreweryPlugin.getInstance().debugLog("converting Data Material from " + matSplit[0] + " to " + m);
            }
            if (m == null) continue;
            SimpleItem item = matSplit.length == 2 ? new SimpleItem(m, (short)BreweryPlugin.getInstance().parseInt(matSplit[1])) : new SimpleItem(m);
            item.setAmount(matSection.getInt(mat));
            ingredients.add(item);
        }
        return ingredients;
    }

    public static BIngredients getIngredients(Map<String, BIngredients> ingMap, String id) {
        if (!ingMap.isEmpty() && ingMap.containsKey(id)) {
            return ingMap.get(id);
        }
        BreweryPlugin.getInstance().errorLog("Ingredient id: '" + id + "' not found in data.yml");
        return new BIngredients();
    }

    public static BIngredients loadCauldronIng(ConfigurationSection section, String path) {
        if (section.isConfigurationSection(path)) {
            ConfigurationSection matSection = section.getConfigurationSection(path);
            if (matSection != null) {
                return new BIngredients(BData.oldDeserializeIngredients(section), 0);
            }
            BreweryPlugin.getInstance().errorLog("Cauldron is missing Ingredient Section");
            return new BIngredients();
        }
        return BData.deserializeIngredients(section.getString(path));
    }

    public static void lwDataTask(List<World> worlds) {
        if (!BData.acquireDataLoadMutex()) {
            return;
        }
        try {
            for (World world : worlds) {
                if (world.getName().startsWith("DXL_")) {
                    BData.loadWorldData(BUtil.getDxlName(world.getName()), world);
                    continue;
                }
                BData.loadWorldData(world.getUID().toString(), world);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            BData.releaseDataLoadMutex();
            if (BConfig.loadDataAsync && dataMutex.get() == 0) {
                BreweryPlugin.getInstance().log("Background data loading complete.");
            }
        }
    }

    public static void loadWorldData(String uuid, World world) {
        if (worldData == null) {
            File file = new File(BreweryPlugin.getInstance().getDataFolder(), "worlddata.yml");
            if (file.exists()) {
                long t1 = System.currentTimeMillis();
                worldData = YamlConfiguration.loadConfiguration((File)file);
                long t2 = System.currentTimeMillis();
                if (t2 - t1 > 15000L) {
                    BreweryPlugin.getInstance().log("Bukkit took " + (double)(t2 - t1) / 1000.0 + "s to load Inventories from the World-Data File (in the Background),");
                    BreweryPlugin.getInstance().log("consider switching to Paper, or have less items in Barrels if it takes a long time for Barrels to become available");
                } else {
                    BreweryPlugin.getInstance().debugLog("Loading worlddata.yml: " + (t2 - t1) + "ms");
                }
            } else {
                return;
            }
        }
        HashMap<Block, BCauldron> initCauldrons = new HashMap<Block, BCauldron>();
        if (worldData.contains("BCauldron." + uuid)) {
            ConfigurationSection section = worldData.getConfigurationSection("BCauldron." + uuid);
            for (String cauldron : section.getKeys(false)) {
                String block = section.getString(cauldron + ".block");
                if (block != null) {
                    String[] splitted = block.split("/");
                    if (splitted.length == 3) {
                        Block worldBlock = world.getBlockAt(BreweryPlugin.getInstance().parseInt(splitted[0]), BreweryPlugin.getInstance().parseInt(splitted[1]), BreweryPlugin.getInstance().parseInt(splitted[2]));
                        BIngredients ingredients = BData.loadCauldronIng(section, cauldron + ".ingredients");
                        int state = section.getInt(cauldron + ".state", 0);
                        initCauldrons.put(worldBlock, new BCauldron(worldBlock, ingredients, state, UUID.randomUUID()));
                        continue;
                    }
                    BreweryPlugin.getInstance().errorLog("Incomplete Block-Data in data.yml: " + section.getCurrentPath() + "." + cauldron);
                    continue;
                }
                BreweryPlugin.getInstance().errorLog("Missing Block-Data in data.yml: " + section.getCurrentPath() + "." + cauldron);
            }
        }
        ArrayList<Barrel> initBarrels = new ArrayList<Barrel>();
        if (worldData.contains("Barrel." + uuid)) {
            ConfigurationSection section = worldData.getConfigurationSection("Barrel." + uuid);
            for (String barrel : section.getKeys(false)) {
                String spigot = section.getString(barrel + ".spigot");
                if (spigot != null) {
                    String[] splitted = spigot.split("/");
                    if (splitted.length == 3) {
                        ConfigurationSection invSection = section.getConfigurationSection(barrel + ".inv");
                        Block block = world.getBlockAt(BreweryPlugin.getInstance().parseInt(splitted[0]), BreweryPlugin.getInstance().parseInt(splitted[1]), BreweryPlugin.getInstance().parseInt(splitted[2]));
                        float time = (float)section.getDouble(barrel + ".time", 0.0);
                        byte sign = (byte)section.getInt(barrel + ".sign", 0);
                        BoundingBox box = null;
                        if (section.contains(barrel + ".bounds")) {
                            String[] bds = section.getString(barrel + ".bounds", "").split(",");
                            if (bds.length == 6) {
                                box = new BoundingBox(BreweryPlugin.getInstance().parseInt(bds[0]), BreweryPlugin.getInstance().parseInt(bds[1]), BreweryPlugin.getInstance().parseInt(bds[2]), BreweryPlugin.getInstance().parseInt(bds[3]), BreweryPlugin.getInstance().parseInt(bds[4]), BreweryPlugin.getInstance().parseInt(bds[5]));
                            }
                        } else if (section.contains(barrel + ".st")) {
                            String[] st = section.getString(barrel + ".st", "").split(",");
                            String[] wo = section.getString(barrel + ".wo", "").split(",");
                            int woLength = wo.length;
                            if (woLength <= 1) {
                                woLength = 0;
                            }
                            String[] points = new String[st.length + woLength];
                            System.arraycopy(st, 0, points, 0, st.length);
                            if (woLength > 1) {
                                System.arraycopy(wo, 0, points, st.length, woLength);
                            }
                            int[] locs = Arrays.stream(points).mapToInt(s -> BreweryPlugin.getInstance().parseInt((String)s)).toArray();
                            try {
                                box = BoundingBox.fromPoints(locs);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        BoundingBox bbox = box;
                        Barrel b = invSection != null ? new Barrel(block, sign, bbox, invSection.getValues(true), time, UUID.randomUUID()) : new Barrel(block, sign, bbox, Collections.emptyMap(), time, UUID.randomUUID());
                        initBarrels.add(b);
                        continue;
                    }
                    BreweryPlugin.getInstance().errorLog("Incomplete Block-Data in data.yml: " + section.getCurrentPath() + "." + barrel);
                    continue;
                }
                BreweryPlugin.getInstance().errorLog("Missing Block-Data in data.yml: " + section.getCurrentPath() + "." + barrel);
            }
        }
        ArrayList<Wakeup> initWakeups = new ArrayList<Wakeup>();
        if (worldData.contains("Wakeup." + uuid)) {
            ConfigurationSection section = worldData.getConfigurationSection("Wakeup." + uuid);
            for (String wakeup : section.getKeys(false)) {
                String loc = section.getString(wakeup);
                if (loc == null) continue;
                String[] splitted = loc.split("/");
                if (splitted.length == 5) {
                    double x = BreweryPlugin.getInstance().parseDouble(splitted[0]);
                    double y = BreweryPlugin.getInstance().parseDouble(splitted[1]);
                    double z = BreweryPlugin.getInstance().parseDouble(splitted[2]);
                    float pitch = BreweryPlugin.getInstance().parseFloat(splitted[3]);
                    float yaw = BreweryPlugin.getInstance().parseFloat(splitted[4]);
                    Location location = new Location(world, x, y, z, yaw, pitch);
                    initWakeups.add(new Wakeup(location));
                    continue;
                }
                BreweryPlugin.getInstance().errorLog("Incomplete Location-Data in data.yml: " + section.getCurrentPath() + "." + wakeup);
            }
        }
        if (BreweryPlugin.getInstance().getServer().getWorld(world.getUID()) == null) {
            return;
        }
        if (!initCauldrons.isEmpty()) {
            BCauldron.bcauldrons.putAll(initCauldrons);
        }
        if (!initBarrels.isEmpty()) {
            Barrel.barrels.addAll(initBarrels);
        }
        if (!initWakeups.isEmpty()) {
            Wakeup.wakeups.addAll(initWakeups);
        }
    }

    public static boolean acquireDataLoadMutex() {
        int wait = 0;
        while (dataMutex.updateAndGet(i -> i >= 0 ? i + 1 : i) <= 0) {
            if (!BConfig.loadDataAsync || ++wait > 60) {
                BreweryPlugin.getInstance().errorLog("Could not load World Data, Mutex: " + dataMutex.get());
                return false;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return true;
    }

    public static void releaseDataLoadMutex() {
        dataMutex.decrementAndGet();
    }
}

