/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.recipe;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.utility.MinecraftVersion;
import org.bukkit.Color;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class PotionColor {
    private static final MinecraftVersion VERSION = BreweryPlugin.getMCVersion();
    public static final PotionColor PINK = new PotionColor(1, PotionType.REGEN, Color.FUCHSIA);
    public static final PotionColor CYAN = new PotionColor(2, PotionType.SPEED, Color.AQUA);
    public static final PotionColor ORANGE = new PotionColor(3, PotionType.FIRE_RESISTANCE, Color.ORANGE);
    public static final PotionColor GREEN = new PotionColor(4, PotionType.POISON, Color.GREEN);
    public static final PotionColor BRIGHT_RED = new PotionColor(5, PotionType.INSTANT_HEAL, Color.fromRGB((int)255, (int)0, (int)0));
    public static final PotionColor BLUE = new PotionColor(6, PotionType.NIGHT_VISION, Color.NAVY);
    public static final PotionColor BLACK = new PotionColor(8, PotionType.WEAKNESS, Color.BLACK);
    public static final PotionColor RED = new PotionColor(9, PotionType.STRENGTH, Color.fromRGB((int)196, (int)0, (int)0));
    public static final PotionColor GREY = new PotionColor(10, PotionType.SLOWNESS, Color.GRAY);
    public static final PotionColor WATER = new PotionColor(11, (PotionType)(VERSION.isOrLater(MinecraftVersion.V1_9) ? PotionType.WATER_BREATHING : null), Color.BLUE);
    public static final PotionColor DARK_RED = new PotionColor(12, PotionType.INSTANT_DAMAGE, Color.fromRGB((int)128, (int)0, (int)0));
    public static final PotionColor BRIGHT_GREY = new PotionColor(14, PotionType.INVISIBILITY, Color.SILVER);
    public static final PotionColor WHITE = new PotionColor(Color.WHITE);
    public static final PotionColor LIME = new PotionColor(Color.LIME);
    public static final PotionColor OLIVE = new PotionColor(Color.OLIVE);
    public static final PotionColor PURPLE = new PotionColor(Color.PURPLE);
    public static final PotionColor TEAL = new PotionColor(Color.TEAL);
    public static final PotionColor YELLOW = new PotionColor(Color.YELLOW);
    private final int colorId;
    private final PotionType type;
    private final Color color;

    PotionColor(int colorId, PotionType type, Color color) {
        this.colorId = colorId;
        this.type = type;
        this.color = color;
    }

    public PotionColor(Color color) {
        this.colorId = PotionColor.WATER.colorId;
        this.type = WATER.getType();
        this.color = color;
    }

    public short getColorId(boolean destillable) {
        if (destillable) {
            return (short)(this.colorId + 64);
        }
        return (short)(this.colorId + 32);
    }

    public PotionType getType() {
        return this.type;
    }

    public Color getColor() {
        return this.color;
    }

    public void colorBrew(PotionMeta meta, ItemStack potion, boolean destillable) {
        if (VERSION.isOrLater(MinecraftVersion.V1_9)) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_POTION_EFFECTS});
            if (VERSION.isOrLater(MinecraftVersion.V1_11)) {
                meta.setColor(this.getColor());
            } else {
                meta.setBasePotionType(this.getType());
            }
        } else {
            potion.setDurability(this.getColorId(destillable));
            meta.addCustomEffect(PotionEffectType.REGENERATION.createEffect(0, 0), true);
        }
    }

    public static PotionColor fromString(String string) {
        switch (string) {
            case "PINK": {
                return PINK;
            }
            case "CYAN": {
                return CYAN;
            }
            case "ORANGE": {
                return ORANGE;
            }
            case "GREEN": {
                return GREEN;
            }
            case "BRIGHT_RED": {
                return BRIGHT_RED;
            }
            case "BLUE": {
                return BLUE;
            }
            case "BLACK": {
                return BLACK;
            }
            case "RED": {
                return RED;
            }
            case "GREY": {
                return GREY;
            }
            case "WATER": {
                return WATER;
            }
            case "DARK_RED": {
                return DARK_RED;
            }
            case "BRIGHT_GREY": {
                return BRIGHT_GREY;
            }
            case "WHITE": {
                return WHITE;
            }
            case "LIME": {
                return LIME;
            }
            case "OLIVE": {
                return OLIVE;
            }
            case "PURPLE": {
                return PURPLE;
            }
            case "TEAL": {
                return TEAL;
            }
            case "YELLOW": {
                return YELLOW;
            }
        }
        try {
            if (string.length() >= 7) {
                string = string.substring(1);
            }
            return new PotionColor(Color.fromRGB((int)Integer.parseInt(string.substring(0, 2), 16), (int)Integer.parseInt(string.substring(2, 4), 16), (int)Integer.parseInt(string.substring(4, 6), 16)));
        }
        catch (Exception e) {
            return WATER;
        }
    }

    public static PotionColor fromColor(Color color) {
        return new PotionColor(color);
    }

    public String toString() {
        return super.toString();
    }
}

