/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.recipe;

import com.dre.brewery.BIngredients;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.filedata.BConfig;
import com.dre.brewery.recipe.BCauldronRecipe;
import com.dre.brewery.recipe.BEffect;
import com.dre.brewery.recipe.CustomItem;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.recipe.PluginItem;
import com.dre.brewery.recipe.PotionColor;
import com.dre.brewery.recipe.RecipeItem;
import com.dre.brewery.recipe.SimpleItem;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.LegacyUtil;
import com.dre.brewery.utility.MinecraftVersion;
import com.dre.brewery.utility.StringParser;
import com.dre.brewery.utility.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.milkbowl.vault.item.ItemInfo;
import net.milkbowl.vault.item.Items;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BRecipe
implements Cloneable {
    private static final List<BRecipe> recipes = new ArrayList<BRecipe>();
    public static int numConfigRecipes;
    private String[] name;
    private boolean saveInData;
    private String id;
    private List<RecipeItem> ingredients = new ArrayList<RecipeItem>();
    private int difficulty;
    private int cookingTime;
    private byte distillruns;
    private int distillTime;
    private byte wood;
    private int age;
    private PotionColor color;
    private int alcohol;
    private List<Tuple<Integer, String>> lore;
    private int[] cmData;
    private List<BEffect> effects = new ArrayList<BEffect>();
    @Nullable
    private List<Tuple<Integer, String>> playercmds;
    @Nullable
    private List<Tuple<Integer, String>> servercmds;
    private String drinkMsg;
    private String drinkTitle;
    private boolean glint;

    public BRecipe() {
    }

    public BRecipe(String name, @NotNull PotionColor color) {
        this.name = new String[]{name};
        this.color = color;
        this.difficulty = 5;
    }

    public BRecipe(String[] names, @NotNull PotionColor color) {
        this.name = names;
        this.color = color;
        this.difficulty = 5;
    }

    @Nullable
    public static BRecipe fromConfig(ConfigurationSection configSectionRecipes, String recipeId) {
        BRecipe recipe = new BRecipe();
        recipe.id = recipeId;
        String nameList = configSectionRecipes.getString(recipeId + ".name");
        if (nameList != null) {
            String[] name = nameList.split("/");
            if (name.length > 2) {
                recipe.name = name;
            } else {
                recipe.name = new String[1];
                recipe.name[0] = name[0];
            }
        } else {
            BreweryPlugin.getInstance().errorLog(recipeId + ": Recipe Name missing or invalid!");
            return null;
        }
        if (recipe.getRecipeName() == null || recipe.getRecipeName().isEmpty()) {
            BreweryPlugin.getInstance().errorLog(recipeId + ": Recipe Name invalid");
            return null;
        }
        recipe.ingredients = BRecipe.loadIngredients(configSectionRecipes, recipeId);
        if (recipe.ingredients == null || recipe.ingredients.isEmpty()) {
            BreweryPlugin.getInstance().errorLog("No ingredients for: " + recipe.getRecipeName());
            return null;
        }
        recipe.cookingTime = configSectionRecipes.getInt(recipeId + ".cookingtime", 1);
        int dis = configSectionRecipes.getInt(recipeId + ".distillruns", 0);
        recipe.distillruns = dis > 127 ? (byte)127 : (byte)dis;
        recipe.distillTime = configSectionRecipes.getInt(recipeId + ".distilltime", 0) * 20;
        recipe.wood = (byte)configSectionRecipes.getInt(recipeId + ".wood", 0);
        recipe.age = configSectionRecipes.getInt(recipeId + ".age", 0);
        recipe.difficulty = configSectionRecipes.getInt(recipeId + ".difficulty", 0);
        recipe.alcohol = configSectionRecipes.getInt(recipeId + ".alcohol", 0);
        String col = configSectionRecipes.getString(recipeId + ".color", "BLUE");
        recipe.color = PotionColor.fromString(col);
        if (recipe.color == PotionColor.WATER && !col.equals("WATER")) {
            BreweryPlugin.getInstance().errorLog("Invalid Color '" + col + "' in Recipe: " + recipe.getRecipeName());
            return null;
        }
        recipe.lore = BRecipe.loadQualityStringList(configSectionRecipes, recipeId + ".lore", StringParser.ParseType.LORE);
        recipe.servercmds = BRecipe.loadQualityStringList(configSectionRecipes, recipeId + ".servercommands", StringParser.ParseType.CMD);
        recipe.playercmds = BRecipe.loadQualityStringList(configSectionRecipes, recipeId + ".playercommands", StringParser.ParseType.CMD);
        recipe.drinkMsg = BreweryPlugin.getInstance().color(BUtil.loadCfgString(configSectionRecipes, recipeId + ".drinkmessage"));
        recipe.drinkTitle = BreweryPlugin.getInstance().color(BUtil.loadCfgString(configSectionRecipes, recipeId + ".drinktitle"));
        recipe.glint = configSectionRecipes.getBoolean(recipeId + ".glint", false);
        if (configSectionRecipes.isString(recipeId + ".customModelData")) {
            String[] cmdParts = configSectionRecipes.getString(recipeId + ".customModelData", "").split("/");
            if (cmdParts.length == 3) {
                recipe.cmData = new int[]{BreweryPlugin.getInstance().parseInt(cmdParts[0]), BreweryPlugin.getInstance().parseInt(cmdParts[1]), BreweryPlugin.getInstance().parseInt(cmdParts[2])};
                if (recipe.cmData[0] == 0 && recipe.cmData[1] == 0 && recipe.cmData[2] == 0) {
                    BreweryPlugin.getInstance().errorLog("Invalid customModelData in Recipe: " + recipe.getRecipeName());
                    recipe.cmData = null;
                }
            } else {
                BreweryPlugin.getInstance().errorLog("Invalid customModelData in Recipe: " + recipe.getRecipeName());
            }
        } else {
            int cmd = configSectionRecipes.getInt(recipeId + ".customModelData", 0);
            if (cmd != 0) {
                recipe.cmData = new int[]{cmd, cmd, cmd};
            }
        }
        List effectStringList = configSectionRecipes.getStringList(recipeId + ".effects");
        for (String effectString : effectStringList) {
            BEffect effect = new BEffect(effectString);
            if (effect.isValid()) {
                recipe.effects.add(effect);
                continue;
            }
            BreweryPlugin.getInstance().errorLog("Error adding Effect to Recipe: " + recipe.getRecipeName());
        }
        return recipe;
    }

    public static List<RecipeItem> loadIngredients(ConfigurationSection cfg, String recipeId) {
        ArrayList<String> ingredientsList;
        if (cfg.isString(recipeId + ".ingredients")) {
            ingredientsList = new ArrayList(1);
            ingredientsList.add(cfg.getString(recipeId + ".ingredients", "x"));
        } else {
            ingredientsList = cfg.getStringList(recipeId + ".ingredients");
        }
        return BRecipe.loadIngredients(ingredientsList, recipeId);
    }

    public static List<RecipeItem> loadIngredients(List<String> stringList, String recipeId) {
        ArrayList<RecipeItem> ingredients = new ArrayList<RecipeItem>(stringList.size());
        block2: for (String item : stringList) {
            String[] ingredParts = item.split("/");
            int amount = 1;
            if (ingredParts.length == 2 && (amount = BreweryPlugin.getInstance().parseInt(ingredParts[1])) < 1) {
                BreweryPlugin.getInstance().errorLog(recipeId + ": Invalid Item Amount: " + ingredParts[1]);
                return null;
            }
            String[] matParts = ingredParts[0].contains(",") ? ingredParts[0].split(",") : (ingredParts[0].contains(";") ? ingredParts[0].split(";") : ingredParts[0].split("\\."));
            if (BreweryPlugin.getMCVersion().isOrEarlier(MinecraftVersion.V1_14) && matParts[0].equalsIgnoreCase("sweet_berries")) {
                ingredients.add(new SimpleItem(Material.BEDROCK));
                continue;
            }
            String[] pluginItem = matParts[0].split(":");
            if (pluginItem.length > 1) {
                PluginItem custom = PluginItem.fromConfig(pluginItem[0], pluginItem[1]);
                if (custom != null) {
                    custom.setAmount(amount);
                    custom.makeImmutable();
                    ingredients.add(custom);
                    BCauldronRecipe.acceptedCustom.add(custom);
                    continue;
                }
                BreweryPlugin.getInstance().errorLog(recipeId + ": Could not Find Plugin: " + ingredParts[1]);
                return null;
            }
            for (RecipeItem custom : BConfig.customItems) {
                if (!custom.getConfigId().equalsIgnoreCase(matParts[0])) continue;
                custom = custom.getMutableCopy();
                custom.setAmount(amount);
                custom.makeImmutable();
                ingredients.add(custom);
                if (custom.hasMaterials()) {
                    BCauldronRecipe.acceptedMaterials.addAll(custom.getMaterials());
                }
                if (BCauldronRecipe.acceptedCustom.contains(custom)) continue block2;
                BCauldronRecipe.acceptedCustom.add(custom);
                continue block2;
            }
            Material mat = BUtil.getMaterialSafely(matParts[0]);
            short durability = -1;
            if (matParts.length == 2) {
                durability = (short)BreweryPlugin.getInstance().parseInt(matParts[1]);
            }
            if (mat == null && BConfig.hasVault) {
                try {
                    ItemInfo vaultItem = Items.itemByString((String)matParts[0]);
                    if (vaultItem != null) {
                        mat = vaultItem.getType();
                        if (durability == -1 && vaultItem.getSubTypeId() != 0) {
                            durability = vaultItem.getSubTypeId();
                        }
                        if (mat.name().contains("LEAVES") && durability > 3) {
                            durability = (short)(durability - 4);
                        }
                    }
                }
                catch (Throwable e) {
                    BreweryPlugin.getInstance().errorLog("Could not check vault for Item Name");
                    e.printStackTrace();
                }
            }
            if (mat != null) {
                SimpleItem rItem = durability > -1 ? new SimpleItem(mat, durability) : new SimpleItem(mat);
                rItem.setAmount(amount);
                rItem.makeImmutable();
                ingredients.add(rItem);
                BCauldronRecipe.acceptedMaterials.add(mat);
                BCauldronRecipe.acceptedSimple.add(mat);
                continue;
            }
            BreweryPlugin.getInstance().errorLog(recipeId + ": Unknown Material: " + ingredParts[0]);
            return null;
        }
        return ingredients;
    }

    @Nullable
    public static List<Tuple<Integer, String>> loadQualityStringList(ConfigurationSection cfg, String path, StringParser.ParseType parseType) {
        List<String> load = BUtil.loadCfgStringList(cfg, path);
        if (load != null) {
            return BRecipe.loadQualityStringList(load, parseType);
        }
        return null;
    }

    public static List<Tuple<Integer, String>> loadQualityStringList(List<String> stringList, StringParser.ParseType parseType) {
        ArrayList<Tuple<Integer, String>> result = new ArrayList<Tuple<Integer, String>>();
        for (String line : stringList) {
            result.add(StringParser.parseQuality(line, parseType));
        }
        return result;
    }

    public boolean isValid() {
        if (this.ingredients == null || this.ingredients.isEmpty()) {
            BreweryPlugin.getInstance().errorLog("No ingredients could be loaded for Recipe: " + this.getRecipeName());
            return false;
        }
        if (this.cookingTime < 1) {
            BreweryPlugin.getInstance().errorLog("Invalid cooking time '" + this.cookingTime + "' in Recipe: " + this.getRecipeName());
            return false;
        }
        if (this.distillruns < 0) {
            BreweryPlugin.getInstance().errorLog("Invalid distillruns '" + this.distillruns + "' in Recipe: " + this.getRecipeName());
            return false;
        }
        if (this.distillTime < 0) {
            BreweryPlugin.getInstance().errorLog("Invalid distilltime '" + this.distillTime + "' in Recipe: " + this.getRecipeName());
            return false;
        }
        if (this.wood < 0 || this.wood > LegacyUtil.TOTAL_WOOD_TYPES) {
            BreweryPlugin.getInstance().errorLog("Invalid wood type '" + this.wood + "' in Recipe: " + this.getRecipeName());
            return false;
        }
        if (this.age < 0) {
            BreweryPlugin.getInstance().errorLog("Invalid age time '" + this.age + "' in Recipe: " + this.getRecipeName());
            return false;
        }
        if (this.difficulty < 0 || this.difficulty > 10) {
            BreweryPlugin.getInstance().errorLog("Invalid difficulty '" + this.difficulty + "' in Recipe: " + this.getRecipeName());
            return false;
        }
        return true;
    }

    public int allowedCountDiff(int count) {
        int allowedCountDiff;
        if (count < 8) {
            count = 8;
        }
        if ((allowedCountDiff = Math.round((float)((11.0 - (double)this.difficulty) * ((double)count / 10.0)))) == 0) {
            return 1;
        }
        return allowedCountDiff;
    }

    public int allowedTimeDiff(int time) {
        int allowedTimeDiff;
        if (time < 8) {
            time = 8;
        }
        if ((allowedTimeDiff = Math.round((float)((11.0 - (double)this.difficulty) * ((double)time / 10.0)))) == 0) {
            return 1;
        }
        return allowedTimeDiff;
    }

    public float getWoodDiff(float wood) {
        return Math.abs(wood - (float)this.wood);
    }

    public boolean isCookingOnly() {
        return this.age == 0 && this.distillruns == 0;
    }

    public boolean needsDistilling() {
        return this.distillruns != 0;
    }

    public boolean needsToAge() {
        return this.age != 0;
    }

    public boolean isMissingIngredients(List<Ingredient> list) {
        if (list.size() < this.ingredients.size()) {
            return true;
        }
        for (RecipeItem rItem : this.ingredients) {
            boolean matches = false;
            for (Ingredient used : list) {
                if (!rItem.matches(used)) continue;
                matches = true;
                break;
            }
            if (matches) continue;
            return true;
        }
        return false;
    }

    public void applyDrinkFeatures(Player player, int quality) {
        List<String> serverCmdsForQuality;
        List<String> playerCmdsForQuality = this.getPlayercmdsForQuality(quality);
        if (playerCmdsForQuality != null) {
            for (String cmd : playerCmdsForQuality) {
                this.scheduleCommand(player, cmd, player.getName(), quality, false);
            }
        }
        if ((serverCmdsForQuality = this.getServercmdsForQuality(quality)) != null) {
            for (String cmd : serverCmdsForQuality) {
                this.scheduleCommand(player, cmd, player.getName(), quality, true);
            }
        }
        if (this.drinkMsg != null) {
            player.sendMessage(BUtil.applyPlaceholders(this.drinkMsg, player.getName(), quality));
        }
        if (this.drinkTitle != null) {
            player.sendTitle("", BUtil.applyPlaceholders(this.drinkTitle, player.getName(), quality), 10, 90, 30);
        }
    }

    private void scheduleCommand(final Player player, String cmd, final String playerName, final int quality, final boolean isServerCommand) {
        if (cmd.startsWith("/")) {
            cmd = cmd.substring(1);
        }
        if (cmd.contains("/")) {
            String[] parts = cmd.split("/");
            final String command = parts[0].trim();
            cmd = parts[0].trim();
            String delay = parts[1].trim();
            long delayTicks = this.parseDelayToTicks(delay);
            if (delayTicks > 0L) {
                new BukkitRunnable(){

                    public void run() {
                        BRecipe.this.executeCommand(player, command, playerName, quality, isServerCommand);
                    }
                }.runTaskLater((Plugin)BreweryPlugin.getInstance(), delayTicks);
                return;
            }
        }
        this.executeCommand(player, cmd, playerName, quality, isServerCommand);
    }

    private long parseDelayToTicks(String delay) {
        try {
            if (delay.endsWith("s")) {
                int seconds = Integer.parseInt(delay.substring(0, delay.length() - 1));
                return (long)seconds * 20L;
            }
            if (delay.endsWith("m")) {
                int minutes = Integer.parseInt(delay.substring(0, delay.length() - 1));
                return (long)minutes * 1200L;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0L;
    }

    private void executeCommand(Player player, String cmd, String playerName, int quality, boolean isServerCommand) {
        if (isServerCommand) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)BUtil.applyPlaceholders(cmd, playerName, quality));
        } else {
            player.performCommand(BUtil.applyPlaceholders(cmd, playerName, quality));
        }
    }

    public ItemStack create(int quality) {
        return this.createBrew(quality).createItem(this);
    }

    public Brew createBrew(int quality) {
        ArrayList<Ingredient> list = new ArrayList<Ingredient>(this.ingredients.size());
        for (RecipeItem rItem : this.ingredients) {
            Ingredient ing = rItem.toIngredientGeneric();
            ing.setAmount(rItem.getAmount());
            list.add(ing);
        }
        BIngredients bIngredients = new BIngredients(list, this.cookingTime);
        return new Brew(bIngredients, quality, 0, this.distillruns, this.getAge(), this.wood, this.getRecipeName(), false, true, 0);
    }

    public void updateAcceptedLists() {
        for (RecipeItem ingredient : this.getIngredients()) {
            if (ingredient.hasMaterials()) {
                BCauldronRecipe.acceptedMaterials.addAll(ingredient.getMaterials());
            }
            if (ingredient instanceof SimpleItem) {
                BCauldronRecipe.acceptedSimple.add(((SimpleItem)ingredient).getMaterial());
                continue;
            }
            if (BCauldronRecipe.acceptedCustom.contains(ingredient)) continue;
            BCauldronRecipe.acceptedCustom.add(ingredient);
        }
    }

    public int amountOf(Ingredient ing) {
        for (RecipeItem rItem : this.ingredients) {
            if (!rItem.matches(ing)) continue;
            return rItem.getAmount();
        }
        return 0;
    }

    public int amountOf(ItemStack item) {
        for (RecipeItem rItem : this.ingredients) {
            if (!rItem.matches(item)) continue;
            return rItem.getAmount();
        }
        return 0;
    }

    public String getRecipeName() {
        return this.getName(5);
    }

    public String getName(int quality) {
        if (this.name.length > 2) {
            if (quality <= 3) {
                return this.name[0];
            }
            if (quality <= 7) {
                return this.name[1];
            }
            return this.name[2];
        }
        return this.name[0];
    }

    public boolean hasName(String name) {
        for (String test : this.name) {
            if (!test.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public List<RecipeItem> getIngredients() {
        return this.ingredients;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public byte getDistillRuns() {
        return this.distillruns;
    }

    public int getDistillTime() {
        return this.distillTime;
    }

    @NotNull
    public PotionColor getColor() {
        return this.color;
    }

    public byte getWood() {
        return this.wood;
    }

    public float getAge() {
        return this.age;
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public int getAlcohol() {
        return this.alcohol;
    }

    public boolean hasLore() {
        return this.lore != null && !this.lore.isEmpty();
    }

    @Nullable
    public List<Tuple<Integer, String>> getLore() {
        return this.lore;
    }

    @Nullable
    public List<String> getLoreForQuality(int quality) {
        return this.getStringsForQuality(quality, this.lore);
    }

    @Nullable
    public List<String> getPlayercmdsForQuality(int quality) {
        return this.getStringsForQuality(quality, this.playercmds);
    }

    @Nullable
    public List<String> getServercmdsForQuality(int quality) {
        return this.getStringsForQuality(quality, this.servercmds);
    }

    @Nullable
    public List<String> getStringsForQuality(int quality, List<Tuple<Integer, String>> source) {
        if (source == null) {
            return null;
        }
        int plus = quality <= 3 ? 1 : (quality <= 7 ? 2 : 3);
        ArrayList<String> list = new ArrayList<String>(source.size());
        for (Tuple<Integer, String> line : source) {
            if (line.first() != 0 && line.first() != plus) continue;
            list.add(line.second());
        }
        return list;
    }

    public int[] getCmData() {
        return this.cmData;
    }

    @Nullable
    public List<Tuple<Integer, String>> getPlayercmds() {
        return this.playercmds;
    }

    @Nullable
    public List<Tuple<Integer, String>> getServercmds() {
        return this.servercmds;
    }

    public String getDrinkMsg() {
        return this.drinkMsg;
    }

    public String getDrinkTitle() {
        return this.drinkTitle;
    }

    public boolean hasGlint() {
        return this.glint;
    }

    public List<BEffect> getEffects() {
        return this.effects;
    }

    public boolean isSaveInData() {
        return this.saveInData;
    }

    public void setName(String[] name) {
        this.name = name;
    }

    public void setCmData(int[] cmData) {
        this.cmData = cmData;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDrinkTitle(String drinkTitle) {
        this.drinkTitle = drinkTitle;
    }

    public void setPlayercmds(@Nullable List<Tuple<Integer, String>> playercmds) {
        this.playercmds = playercmds;
    }

    public void setServercmds(@Nullable List<Tuple<Integer, String>> servercmds) {
        this.servercmds = servercmds;
    }

    public void setGlint(boolean glint) {
        this.glint = glint;
    }

    public void setDrinkMsg(String drinkMsg) {
        this.drinkMsg = drinkMsg;
    }

    public void setIngredients(List<RecipeItem> ingredients) {
        this.ingredients = ingredients;
    }

    public void setCookingTime(int cookingTime) {
        this.cookingTime = cookingTime;
    }

    public void setDistillRuns(byte distillRuns) {
        this.distillruns = distillRuns;
    }

    public void setDistillTime(int distillTime) {
        this.distillTime = distillTime;
    }

    public void setWood(byte wood) {
        this.wood = wood;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public void setColor(@NotNull PotionColor color) {
        this.color = color;
    }

    public void setDifficulty(int difficulty) {
        this.difficulty = difficulty;
    }

    public void setAlcohol(int alcohol) {
        this.alcohol = alcohol;
    }

    public void setLore(List<Tuple<Integer, String>> lore) {
        this.lore = lore;
    }

    public void setEffects(List<BEffect> effects) {
        this.effects = effects;
    }

    public void setSaveInData(boolean saveInData) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "BRecipe{name=" + Arrays.toString(this.name) + ", ingredients=" + this.ingredients + ", difficulty=" + this.difficulty + ", cookingTime=" + this.cookingTime + ", distillruns=" + this.distillruns + ", distillTime=" + this.distillTime + ", wood=" + this.wood + ", age=" + this.age + ", color=" + this.color + ", alcohol=" + this.alcohol + ", lore=" + this.lore + ", cmData=" + Arrays.toString(this.cmData) + ", effects=" + this.effects + ", playercmds=" + this.playercmds + ", servercmds=" + this.servercmds + ", drinkMsg='" + this.drinkMsg + "', drinkTitle='" + this.drinkTitle + "', glint=" + this.glint + "}";
    }

    public static List<BRecipe> getConfigRecipes() {
        return recipes.subList(0, numConfigRecipes);
    }

    public static List<BRecipe> getAddedRecipes() {
        return recipes.subList(numConfigRecipes, recipes.size());
    }

    public static List<BRecipe> getAllRecipes() {
        return recipes;
    }

    public String[] getName() {
        return this.name;
    }

    public boolean isGlint() {
        return this.glint;
    }

    @Nullable
    public static BRecipe getMatching(String name) {
        BRecipe mainNameRecipe = BRecipe.get(name);
        if (mainNameRecipe != null) {
            return mainNameRecipe;
        }
        for (BRecipe recipe : recipes) {
            if (recipe.getName(1).equalsIgnoreCase(name)) {
                return recipe;
            }
            if (!recipe.getName(10).equalsIgnoreCase(name)) continue;
            return recipe;
        }
        for (BRecipe recipe : recipes) {
            if (!name.equalsIgnoreCase(recipe.getId())) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public static BRecipe getById(String id) {
        for (BRecipe recipe : recipes) {
            if (!id.equals(recipe.getId())) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public static BRecipe get(String name) {
        for (BRecipe recipe : recipes) {
            if (!recipe.getRecipeName().equalsIgnoreCase(name)) continue;
            return recipe;
        }
        return null;
    }

    public BRecipe clone() {
        try {
            BRecipe clone = (BRecipe)super.clone();
            clone.name = (String[])this.name.clone();
            clone.ingredients = new ArrayList<RecipeItem>(this.ingredients.size());
            for (RecipeItem item : this.ingredients) {
                clone.ingredients.add(item.getMutableCopy());
            }
            clone.lore = this.lore != null ? new ArrayList<Tuple<Integer, String>>(this.lore) : null;
            clone.playercmds = this.playercmds != null ? new ArrayList<Tuple<Integer, String>>(this.playercmds) : null;
            clone.servercmds = this.servercmds != null ? new ArrayList<Tuple<Integer, String>>(this.servercmds) : null;
            clone.effects = new ArrayList<BEffect>(this.effects.size());
            for (BEffect effect : this.effects) {
                clone.effects.add(effect.clone());
            }
            clone.cmData = this.cmData != null ? (int[])this.cmData.clone() : null;
            clone.drinkMsg = this.drinkMsg;
            clone.drinkTitle = this.drinkTitle;
            clone.glint = this.glint;
            clone.saveInData = this.saveInData;
            clone.id = this.id;
            clone.difficulty = this.difficulty;
            clone.cookingTime = this.cookingTime;
            clone.distillruns = this.distillruns;
            clone.distillTime = this.distillTime;
            clone.wood = this.wood;
            clone.age = this.age;
            clone.color = this.color;
            clone.alcohol = this.alcohol;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public static class Builder {
        private BRecipe recipe;

        public Builder(String name) {
            this.recipe = new BRecipe(name, PotionColor.WATER);
        }

        public Builder(String ... names) {
            this.recipe = new BRecipe(names, PotionColor.WATER);
        }

        public Builder addIngredient(RecipeItem ... item) {
            Collections.addAll(this.recipe.ingredients, item);
            return this;
        }

        public Builder addIngredient(ItemStack ... item) {
            for (ItemStack i : item) {
                CustomItem customItem = new CustomItem(i);
                customItem.setAmount(i.getAmount());
                this.recipe.ingredients.add(customItem);
            }
            return this;
        }

        public Builder difficulty(int difficulty) {
            this.recipe.difficulty = difficulty;
            return this;
        }

        public Builder color(String colorString) {
            this.recipe.color = PotionColor.fromString(colorString);
            return this;
        }

        public Builder color(PotionColor color) {
            this.recipe.color = color;
            return this;
        }

        public Builder color(Color color) {
            this.recipe.color = PotionColor.fromColor(color);
            return this;
        }

        public Builder cook(int cookTime) {
            this.recipe.cookingTime = cookTime;
            return this;
        }

        public Builder distill(byte distillRuns, int distillTime) {
            this.recipe.distillruns = distillRuns;
            this.recipe.distillTime = distillTime;
            return this;
        }

        public Builder age(int age, byte wood) {
            this.recipe.age = age;
            this.recipe.wood = wood;
            return this;
        }

        public Builder alcohol(int alcohol) {
            this.recipe.alcohol = alcohol;
            return this;
        }

        public Builder addLore(String line) {
            return this.addLore(0, line);
        }

        public Builder addLore(int quality, String line) {
            if (quality < 0 || quality > 3) {
                throw new IllegalArgumentException("Lore Quality must be 0 - 3");
            }
            if (this.recipe.lore == null) {
                this.recipe.lore = new ArrayList<Tuple<Integer, String>>();
            }
            this.recipe.lore.add(new Tuple<Integer, String>(quality, line));
            return this;
        }

        public Builder addPlayerCmds(String ... cmds) {
            ArrayList<Tuple<Integer, String>> playercmds = new ArrayList<Tuple<Integer, String>>(cmds.length);
            for (String cmd : cmds) {
                playercmds.add(StringParser.parseQuality(cmd, StringParser.ParseType.CMD));
            }
            if (this.recipe.playercmds == null) {
                this.recipe.playercmds = playercmds;
            } else {
                this.recipe.playercmds.addAll(playercmds);
            }
            return this;
        }

        public Builder addServerCmds(String ... cmds) {
            ArrayList<Tuple<Integer, String>> servercmds = new ArrayList<Tuple<Integer, String>>(cmds.length);
            for (String cmd : cmds) {
                servercmds.add(StringParser.parseQuality(cmd, StringParser.ParseType.CMD));
            }
            if (this.recipe.servercmds == null) {
                this.recipe.servercmds = servercmds;
            } else {
                this.recipe.servercmds.addAll(servercmds);
            }
            return this;
        }

        public Builder drinkMsg(String msg) {
            this.recipe.drinkMsg = msg;
            return this;
        }

        public Builder drinkTitle(String title) {
            this.recipe.drinkTitle = title;
            return this;
        }

        public Builder glint(boolean glint) {
            this.recipe.glint = glint;
            return this;
        }

        public Builder setID(String id) {
            this.recipe.id = id;
            return this;
        }

        public Builder addCustomModelData(int bad, int normal, int good) {
            this.recipe.cmData = new int[]{bad, normal, good};
            return this;
        }

        public Builder addEffects(BEffect ... effects) {
            Collections.addAll(this.recipe.effects, effects);
            return this;
        }

        public BRecipe get() {
            if (this.recipe.name == null) {
                throw new IllegalArgumentException("Recipe name is null");
            }
            if (this.recipe.name.length != 1 && this.recipe.name.length != 3) {
                throw new IllegalArgumentException("Recipe name neither 1 nor 3");
            }
            if (this.recipe.color == null) {
                throw new IllegalArgumentException("Recipe has no color");
            }
            if (this.recipe.ingredients == null || this.recipe.ingredients.isEmpty()) {
                throw new IllegalArgumentException("Recipe has no ingredients");
            }
            if (!this.recipe.isValid()) {
                throw new IllegalArgumentException("Recipe has not valid");
            }
            for (RecipeItem ingredient : this.recipe.ingredients) {
                ingredient.makeImmutable();
            }
            return this.recipe;
        }
    }
}

