/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.lore;

import com.dre.brewery.BIngredients;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.filedata.BConfig;
import com.dre.brewery.recipe.BEffect;
import com.dre.brewery.recipe.BRecipe;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.MinecraftVersion;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class BrewLore {
    private final Brew brew;
    private final PotionMeta meta;
    private final List<String> lore;
    private boolean lineAddedOrRem = false;

    public BrewLore(Brew brew, PotionMeta meta) {
        this.brew = brew;
        this.meta = meta;
        this.lore = meta.hasLore() ? meta.getLore() : new ArrayList();
    }

    public PotionMeta write() {
        if (this.lineAddedOrRem) {
            this.updateSpacer();
        }
        this.meta.setLore(this.lore);
        return this.meta;
    }

    public void updateSpacer() {
        boolean hasCustom = false;
        boolean hasSpace = false;
        for (int i = 0; i < this.lore.size(); ++i) {
            Type t = Type.get(this.lore.get(i));
            if (t == Type.CUSTOM) {
                hasCustom = true;
                continue;
            }
            if (t == Type.SPACE) {
                hasSpace = true;
                continue;
            }
            if (t == null || !t.isAfter(Type.SPACE)) continue;
            if (hasSpace) {
                return;
            }
            if (hasCustom || BreweryPlugin.useNBT) {
                this.lore.add(i, Type.SPACE.id);
            }
            return;
        }
        if (hasSpace) {
            this.removeLore(Type.SPACE);
        }
    }

    public void addCauldronLore(List<String> l) {
        int index = -1;
        for (String line : l) {
            if (index == -1) {
                index = this.addLore(Type.CUSTOM, "", line);
                ++index;
                continue;
            }
            this.lore.add(index, Type.CUSTOM.id + line);
            ++index;
        }
    }

    public void updateIngredientLore(boolean qualityColor) {
        if (qualityColor && this.brew.hasRecipe() && !this.brew.isStripped()) {
            int quality = this.brew.getIngredients().getIngredientQuality(this.brew.getCurrentRecipe());
            String prefix = BrewLore.getQualityColor(quality);
            char icon = BrewLore.getQualityIcon(quality);
            this.addOrReplaceLore(Type.INGR, prefix, BreweryPlugin.getInstance().languageReader.get("Brew_Ingredients", new String[0]), " " + icon);
        } else {
            this.removeLore(Type.INGR, BreweryPlugin.getInstance().languageReader.get("Brew_Ingredients", new String[0]));
        }
    }

    public void updateCookLore(boolean qualityColor) {
        if (qualityColor && this.brew.hasRecipe() && this.brew.getDistillRuns() > 0 == this.brew.getCurrentRecipe().needsDistilling() && !this.brew.isStripped()) {
            BIngredients ingredients = this.brew.getIngredients();
            int quality = ingredients.getCookingQuality(this.brew.getCurrentRecipe(), this.brew.getDistillRuns() > 0);
            String prefix = BrewLore.getQualityColor(quality) + ingredients.getCookedTime() + " " + BreweryPlugin.getInstance().languageReader.get("Brew_minute", new String[0]);
            if (ingredients.getCookedTime() > 1) {
                prefix = prefix + BreweryPlugin.getInstance().languageReader.get("Brew_MinutePluralPostfix", new String[0]);
            }
            this.addOrReplaceLore(Type.COOK, prefix, " " + BreweryPlugin.getInstance().languageReader.get("Brew_fermented", new String[0]), " " + BrewLore.getQualityIcon(quality));
        } else {
            this.removeLore(Type.COOK, BreweryPlugin.getInstance().languageReader.get("Brew_fermented", new String[0]));
        }
    }

    public void updateDistillLore(boolean qualityColor) {
        Object prefix;
        if (this.brew.getDistillRuns() <= 0) {
            return;
        }
        Object suffix = "";
        byte distillRuns = this.brew.getDistillRuns();
        if (qualityColor && !this.brew.isUnlabeled() && this.brew.hasRecipe()) {
            int quality = this.brew.getIngredients().getDistillQuality(this.brew.getCurrentRecipe(), distillRuns);
            prefix = BrewLore.getQualityColor(quality);
            suffix = " " + BrewLore.getQualityIcon(quality);
        } else {
            prefix = "\u00a77";
        }
        if (!this.brew.isUnlabeled() && distillRuns > 1) {
            prefix = (String)prefix + distillRuns + BreweryPlugin.getInstance().languageReader.get("Brew_-times", new String[0]) + " ";
        }
        if (this.brew.isUnlabeled() && this.brew.hasRecipe() && distillRuns < this.brew.getCurrentRecipe().getDistillRuns()) {
            this.addOrReplaceLore(Type.DISTILL, (String)prefix, BreweryPlugin.getInstance().languageReader.get("Brew_LessDistilled", new String[0]), (String)suffix);
        } else {
            this.addOrReplaceLore(Type.DISTILL, (String)prefix, BreweryPlugin.getInstance().languageReader.get("Brew_Distilled", new String[0]), (String)suffix);
        }
    }

    public void updateAgeLore(boolean qualityColor) {
        Object prefix;
        if (this.brew.isStripped()) {
            return;
        }
        Object suffix = "";
        float age = this.brew.getAgeTime();
        if (qualityColor && !this.brew.isUnlabeled() && this.brew.hasRecipe()) {
            int quality = this.brew.getIngredients().getAgeQuality(this.brew.getCurrentRecipe(), age);
            prefix = BrewLore.getQualityColor(quality);
            suffix = " " + BrewLore.getQualityIcon(quality);
        } else {
            prefix = "\u00a77";
        }
        if (!this.brew.isUnlabeled()) {
            prefix = age >= 1.0f && age < 2.0f ? (String)prefix + BreweryPlugin.getInstance().languageReader.get("Brew_OneYear", new String[0]) + " " : (age < 201.0f ? (String)prefix + (int)Math.floor(age) + " " + BreweryPlugin.getInstance().languageReader.get("Brew_Years", new String[0]) + " " : (String)prefix + BreweryPlugin.getInstance().languageReader.get("Brew_HundredsOfYears", new String[0]) + " ");
        }
        this.addOrReplaceLore(Type.AGE, (String)prefix, BreweryPlugin.getInstance().languageReader.get("Brew_BarrelRiped", new String[0]), (String)suffix);
    }

    public void updateWoodLore(boolean qualityColor) {
        if (qualityColor && this.brew.hasRecipe() && !this.brew.isUnlabeled()) {
            int quality = this.brew.getIngredients().getWoodQuality(this.brew.getCurrentRecipe(), this.brew.getWood());
            this.addOrReplaceLore(Type.WOOD, BrewLore.getQualityColor(quality), BreweryPlugin.getInstance().languageReader.get("Brew_Woodtype", new String[0]), " " + BrewLore.getQualityIcon(quality));
        } else {
            this.removeLore(Type.WOOD, BreweryPlugin.getInstance().languageReader.get("Brew_Woodtype", new String[0]));
        }
    }

    public void updateCustomLore() {
        this.removeLore(Type.CUSTOM);
        BRecipe recipe = this.brew.getCurrentRecipe();
        if (recipe != null && recipe.hasLore()) {
            int index = -1;
            for (String line : recipe.getLoreForQuality(this.brew.getQuality())) {
                if (index == -1) {
                    index = this.addLore(Type.CUSTOM, "", line);
                    ++index;
                    continue;
                }
                this.lore.add(index, Type.CUSTOM.id + line);
                ++index;
            }
        }
    }

    public void updateQualityStars(boolean qualityColor) {
        this.updateQualityStars(qualityColor, false);
    }

    public void updateQualityStars(boolean qualityColor, boolean withBars) {
        if (this.brew.isStripped()) {
            return;
        }
        if (this.brew.hasRecipe() && this.brew.getCurrentRecipe().needsToAge() && (double)this.brew.getAgeTime() < 0.5) {
            return;
        }
        int quality = this.brew.getQuality();
        if (quality > 0 && (qualityColor || BConfig.alwaysShowQuality)) {
            int stars = quality / 2;
            boolean half = quality % 2 > 0;
            int noStars = 5 - stars - (half ? 1 : 0);
            StringBuilder b = new StringBuilder(24);
            Object color = qualityColor ? BrewLore.getQualityColor(quality) : "\u00a77";
            if (withBars) {
                color = "\u00a78[" + (String)color;
            }
            while (stars > 0) {
                b.append("\u2b51");
                --stars;
            }
            if (half) {
                if (!qualityColor) {
                    b.append("\u00a78");
                }
                b.append("\u2b52");
            }
            if (withBars) {
                if (noStars > 0) {
                    b.append("\u00a70");
                    while (noStars > 0) {
                        b.append("\u2b51");
                        --noStars;
                    }
                }
                b.append("\u00a78]");
            }
            this.addOrReplaceLore(Type.STARS, (String)color, b.toString());
        } else {
            this.removeLore(Type.STARS);
        }
    }

    public void updateAlc(boolean inDistiller) {
        if (!(this.brew.isUnlabeled() || !inDistiller && !BConfig.alwaysShowAlc || this.brew.hasRecipe() && this.brew.getCurrentRecipe().getAlcohol() == 0)) {
            int alc = this.brew.getOrCalcAlc();
            this.addOrReplaceLore(Type.ALC, "\u00a78", BreweryPlugin.getInstance().languageReader.get("Brew_Alc", "" + alc));
        } else {
            this.removeLore(Type.ALC);
        }
    }

    public void updateBrewer(String name) {
        if (name != null && BConfig.showBrewer) {
            this.addOrReplaceLore(Type.BREWER, "\u00a78", BreweryPlugin.getInstance().languageReader.get("Brew_Brewer", name));
        } else {
            this.removeLore(Type.BREWER);
        }
    }

    public void convertLore(boolean toQuality) {
        if (!this.brew.hasRecipe()) {
            return;
        }
        this.updateCustomLore();
        if (toQuality && this.brew.isUnlabeled()) {
            return;
        }
        this.updateQualityStars(toQuality);
        this.updateIngredientLore(toQuality);
        this.updateCookLore(toQuality);
        this.updateDistillLore(toQuality);
        if (this.brew.getAgeTime() >= 1.0f) {
            this.updateAgeLore(toQuality);
        }
        if ((double)this.brew.getAgeTime() > 0.5) {
            this.updateWoodLore(toQuality);
        }
        this.updateAlc(false);
    }

    public int addOrReplaceLore(Type type, String prefix, String line) {
        return this.addOrReplaceLore(type, prefix, line, "");
    }

    public int addOrReplaceLore(Type type, String prefix, String line, String suffix) {
        int index = type.findInLore(this.lore);
        if (index > -1) {
            this.lore.set(index, type.id + prefix + line + suffix);
            return index;
        }
        index = BUtil.indexOfSubstring(this.lore, line);
        if (index > -1) {
            this.lore.remove(index);
        }
        return this.addLore(type, prefix, line, suffix);
    }

    public int addLore(Type type, String prefix, String line) {
        return this.addLore(type, prefix, line, "");
    }

    public int addLore(Type type, String prefix, String line, String suffix) {
        this.lineAddedOrRem = true;
        for (int i = 0; i < this.lore.size(); ++i) {
            Type existing = Type.get(this.lore.get(i));
            if (existing == null || !existing.isAfter(type)) continue;
            this.lore.add(i, type.id + prefix + line + suffix);
            return i;
        }
        this.lore.add(type.id + prefix + line + suffix);
        return this.lore.size() - 1;
    }

    public void removeLore(Type type, String line) {
        int index = type.findInLore(this.lore);
        if (index == -1) {
            index = BUtil.indexOfSubstring(this.lore, line);
        }
        if (index > -1) {
            this.lineAddedOrRem = true;
            this.lore.remove(index);
        }
    }

    public void removeLore(Type type) {
        if (type != Type.CUSTOM) {
            int index = type.findInLore(this.lore);
            if (index > -1) {
                this.lineAddedOrRem = true;
                this.lore.remove(index);
            }
        } else {
            for (int i = this.lore.size() - 1; i >= 0; --i) {
                if (Type.get(this.lore.get(i)) != type) continue;
                this.lore.remove(i);
                this.lineAddedOrRem = true;
            }
        }
    }

    public void removeAll() {
        for (int i = this.lore.size() - 1; i >= 0; --i) {
            if (Type.get(this.lore.get(i)) == null) continue;
            this.lore.remove(i);
            this.lineAddedOrRem = true;
        }
    }

    public void addOrReplaceEffects(List<BEffect> effects, int quality) {
        if (BreweryPlugin.getMCVersion().isOrEarlier(MinecraftVersion.V1_9) && effects != null) {
            for (BEffect effect : effects) {
                if (effect.isHidden()) continue;
                effect.writeInto(this.meta, quality);
            }
        }
    }

    public boolean isBrewLore(int index) {
        return index < this.lore.size() && Type.get(this.lore.get(index)) != null;
    }

    public void removeEffects() {
        if (this.meta.hasCustomEffects()) {
            for (PotionEffect effect : new ArrayList(this.meta.getCustomEffects())) {
                PotionEffectType type = effect.getType();
                this.meta.removeCustomEffect(type);
            }
        }
    }

    public void removeLegacySpacing() {
        if (BreweryPlugin.useNBT) {
            return;
        }
        if (this.lore.size() > 0 && this.lore.get(0).equals("")) {
            this.lore.remove(0);
            this.write();
        }
    }

    public void removeLoreData() {
        int index = BUtil.indexOfStart(this.lore, "\u00a7%");
        if (index != -1) {
            this.lore.set(index, "");
            this.write();
        }
    }

    public static boolean hasColorLore(PotionMeta meta) {
        if (meta == null) {
            return false;
        }
        if (!meta.hasLore()) {
            return false;
        }
        List lore = meta.getLore();
        if (lore.size() < 2) {
            return false;
        }
        return Type.INGR.findInLore(lore) != -1;
    }

    public static String getQualityColor(int quality) {
        String color = quality > 8 ? "&a" : (quality > 6 ? "&e" : (quality > 4 ? "&6" : (quality > 2 ? "&c" : "&4")));
        return BreweryPlugin.getInstance().color(color);
    }

    public static char getQualityIcon(int quality) {
        int icon = quality > 8 ? 9733 : (quality > 6 ? 11242 : (quality > 4 ? 9734 : (quality > 2 ? 10008 : 9760)));
        return (char)icon;
    }

    public static enum Type {
        CUSTOM("\u00a7t"),
        SPACE("\u00a7u"),
        STARS("\u00a7s"),
        INGR("\u00a7v"),
        COOK("\u00a7w"),
        DISTILL("\u00a7p"),
        AGE("\u00a7y"),
        WOOD("\u00a7z"),
        ALC("\u00a7q"),
        BREWER("\u00a7g");

        public final String id;

        private Type(String id) {
            this.id = id;
        }

        public int findInLore(List<String> lore) {
            return BUtil.indexOfStart(lore, this.id);
        }

        public boolean isAfter(Type other) {
            return other.ordinal() <= this.ordinal();
        }

        @Nullable
        public static Type get(String loreLine) {
            if (loreLine.length() >= 2) {
                return Type.getById(loreLine.substring(0, 2));
            }
            return null;
        }

        @Nullable
        public static Type getById(String id) {
            for (Type t : Type.values()) {
                if (!t.id.equals(id)) continue;
                return t;
            }
            return null;
        }
    }
}

