/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.listeners;

import com.dre.brewery.BCauldron;
import com.dre.brewery.utility.LegacyUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Levelled;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.CauldronLevelChangeEvent;

public class CauldronListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCauldronChange(CauldronLevelChangeEvent event) {
        if (LegacyUtil.WATER_CAULDRON == null) {
            this.oldCauldronChange(event);
            return;
        }
        Material currentType = event.getBlock().getType();
        BlockState newState = event.getNewState();
        Material newType = newState.getType();
        if (currentType == Material.WATER_CAULDRON) {
            if (newType != Material.WATER_CAULDRON) {
                if (event.getReason() != CauldronLevelChangeEvent.ChangeReason.BOTTLE_FILL) {
                    BCauldron.remove(event.getBlock());
                }
            } else {
                Levelled oldCauldron = (Levelled)event.getBlock().getBlockData();
                Levelled newCauldron = (Levelled)newState.getBlockData();
                if (newCauldron.getLevel() > oldCauldron.getLevel()) {
                    BCauldron.remove(event.getBlock());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            if (!BCauldron.bcauldrons.containsKey(block)) continue;
            BCauldron.remove(block);
        }
    }

    private void oldCauldronChange(CauldronLevelChangeEvent event) {
        if (event.getNewLevel() == 0 && event.getOldLevel() != 0) {
            if (event.getReason() == CauldronLevelChangeEvent.ChangeReason.BOTTLE_FILL) {
                return;
            }
            BCauldron.remove(event.getBlock());
        } else if (event.getNewLevel() == 3 && event.getOldLevel() != 3) {
            BCauldron.remove(event.getBlock());
        }
    }
}

