/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration.bstats;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.Wakeup;
import com.dre.brewery.filedata.BConfig;
import com.dre.brewery.integration.bstats.Metrics;
import com.dre.brewery.recipe.BRecipe;
import java.util.HashMap;
import org.bukkit.Bukkit;

public class Stats {
    public int brewsCreated;
    public int brewsCreatedCmd;
    public int exc;
    public int good;
    public int norm;
    public int bad;
    public int terr;

    public void metricsForCreate(boolean byCmd) {
        if (this.brewsCreated == Integer.MAX_VALUE) {
            return;
        }
        ++this.brewsCreated;
        if (byCmd) {
            if (this.brewsCreatedCmd == Integer.MAX_VALUE) {
                return;
            }
            ++this.brewsCreatedCmd;
        }
    }

    public void forDrink(Brew brew) {
        if (brew.getQuality() >= 9) {
            ++this.exc;
        } else if (brew.getQuality() >= 7) {
            ++this.good;
        } else if (brew.getQuality() >= 5) {
            ++this.norm;
        } else if (brew.getQuality() >= 3) {
            ++this.bad;
        } else {
            ++this.terr;
        }
    }

    public void setupBStats() {
        try {
            Metrics metrics = new Metrics(BreweryPlugin.getInstance(), 3494);
            metrics.addCustomChart(new Metrics.SingleLineChart("drunk_players", BPlayer::numDrunkPlayers));
            metrics.addCustomChart(new Metrics.SingleLineChart("brews_in_existence", () -> this.brewsCreated));
            metrics.addCustomChart(new Metrics.SingleLineChart("barrels_built", Barrel.barrels::size));
            metrics.addCustomChart(new Metrics.SingleLineChart("cauldrons_boiling", BCauldron.bcauldrons::size));
            metrics.addCustomChart(new Metrics.AdvancedPie("brew_quality", () -> {
                HashMap<String, Integer> map = new HashMap<String, Integer>(8);
                map.put("excellent", this.exc);
                map.put("good", this.good);
                map.put("normal", this.norm);
                map.put("bad", this.bad);
                map.put("terrible", this.terr);
                return map;
            }));
            metrics.addCustomChart(new Metrics.AdvancedPie("brews_created", () -> {
                HashMap<String, Integer> map = new HashMap<String, Integer>(4);
                map.put("by command", this.brewsCreatedCmd);
                map.put("brewing", this.brewsCreated - this.brewsCreatedCmd);
                return map;
            }));
            metrics.addCustomChart(new Metrics.SimplePie("number_of_recipes", () -> {
                int recipes = BRecipe.getAllRecipes().size();
                if (recipes < 7) {
                    return "Less than 7";
                }
                if (recipes < 11) {
                    return "7-10";
                }
                if (recipes == 11) {
                    return "11";
                }
                if (recipes == 20) {
                    return "20";
                }
                if (recipes <= 29) {
                    if (recipes % 2 == 0) {
                        return recipes + "-" + (recipes + 1);
                    }
                    return recipes - 1 + "-" + recipes;
                }
                if (recipes < 35) {
                    return "30-34";
                }
                if (recipes < 40) {
                    return "35-39";
                }
                if (recipes < 45) {
                    return "40-44";
                }
                if (recipes <= 50) {
                    return "45-50";
                }
                return "More than 50";
            }));
            metrics.addCustomChart(new Metrics.SimplePie("cauldron_particles", () -> {
                if (!BConfig.enableCauldronParticles) {
                    return "disabled";
                }
                if (BConfig.minimalParticles) {
                    return "minimal";
                }
                return "enabled";
            }));
            metrics.addCustomChart(new Metrics.SimplePie("wakeups", () -> {
                if (!BConfig.enableWake) {
                    return "disabled";
                }
                int wakeups = Wakeup.wakeups.size();
                if (wakeups == 0) {
                    return "0";
                }
                if (wakeups <= 5) {
                    return "1-5";
                }
                if (wakeups <= 10) {
                    return "6-10";
                }
                if (wakeups <= 20) {
                    return "11-20";
                }
                return "More than 20";
            }));
            metrics.addCustomChart(new Metrics.SimplePie("v2_mc_version", () -> {
                String mcv = Bukkit.getBukkitVersion();
                int index = (mcv = mcv.substring(0, mcv.indexOf(46, 2))).indexOf(45);
                if (index > -1) {
                    mcv = mcv.substring(0, index);
                }
                if (mcv.matches("^\\d\\.\\d{1,2}$")) {
                    return mcv;
                }
                return "undef";
            }));
            metrics.addCustomChart(new Metrics.DrilldownPie("plugin_mc_version", () -> {
                HashMap map = new HashMap(3);
                Object mcv = Bukkit.getBukkitVersion();
                int index = ((String)(mcv = ((String)mcv).substring(0, ((String)mcv).indexOf(46, 2)))).indexOf(45);
                if (index > -1) {
                    mcv = ((String)mcv).substring(0, index);
                }
                mcv = ((String)mcv).matches("^\\d\\.\\d{1,2}$") ? "MC " + (String)mcv : "undef";
                HashMap<Object, Integer> innerMap = new HashMap<Object, Integer>(3);
                innerMap.put(mcv, 1);
                map.put(BreweryPlugin.getInstance().getDescription().getVersion(), innerMap);
                return map;
            }));
            metrics.addCustomChart(new Metrics.SimplePie("language", () -> BreweryPlugin.getInstance().language));
            metrics.addCustomChart(new Metrics.SimplePie("config_scramble", () -> BConfig.enableEncode ? "enabled" : "disabled"));
            metrics.addCustomChart(new Metrics.SimplePie("config_lore_color", () -> {
                if (BConfig.colorInBarrels) {
                    if (BConfig.colorInBrewer) {
                        return "both";
                    }
                    return "in barrels";
                }
                if (BConfig.colorInBrewer) {
                    return "in distiller";
                }
                return "none";
            }));
            metrics.addCustomChart(new Metrics.SimplePie("config_always_show", () -> {
                if (BConfig.alwaysShowQuality) {
                    if (BConfig.alwaysShowAlc) {
                        return "both";
                    }
                    return "quality stars";
                }
                if (BConfig.alwaysShowAlc) {
                    return "alc content";
                }
                return "none";
            }));
        }
        catch (Exception | LinkageError e) {
            e.printStackTrace();
        }
    }
}

