/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.filedata;

import com.dre.brewery.BreweryPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UpdateChecker {
    private static final BreweryPlugin plugin = BreweryPlugin.getInstance();
    private final int resourceID;
    private static String latestVersion = plugin.getDescription().getVersion();
    private static boolean updateAvailable = false;

    public UpdateChecker(int resourceID) {
        this.resourceID = resourceID;
    }

    public static void notify(Player player) {
        if (!updateAvailable || !player.hasPermission("brewery.update")) {
            return;
        }
        plugin.msg((CommandSender)player, UpdateChecker.plugin.languageReader.get("Etc_UpdateAvailable", "v" + plugin.getDescription().getVersion(), "v" + latestVersion));
    }

    public void query(Consumer<String> consumer) {
        BreweryPlugin.getScheduler().runTaskAsynchronously(() -> {
            try (InputStream is = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceID + "/~").openStream();
                 Scanner scann = new Scanner(is);){
                if (scann.hasNext()) {
                    consumer.accept(scann.next());
                }
            }
            catch (IOException e) {
                plugin.getLogger().log(Level.WARNING, "Cannot look for updates: " + e);
            }
        });
    }

    public static void setLatestVersion(String version) {
        latestVersion = version;
    }

    public static String getLatestVersion() {
        return latestVersion;
    }

    public static void setUpdateAvailable(boolean available) {
        updateAvailable = available;
    }

    public static int parseVersion(String version) {
        StringBuilder sb = new StringBuilder();
        for (char c : version.toCharArray()) {
            if (!Character.isDigit(c)) continue;
            sb.append(c);
        }
        return Integer.parseInt(sb.toString());
    }
}

