/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.filedata;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.utility.LegacyUtil;
import com.dre.brewery.utility.MinecraftVersion;
import com.dre.brewery.utility.Tuple;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigUpdater {
    private static final MinecraftVersion VERSION = BreweryPlugin.getMCVersion();
    private ArrayList<String> config = new ArrayList();
    private File file;

    public ConfigUpdater(File file) {
        this.file = file;
        this.getConfigString();
    }

    public int indexOfStart(String lineStart) {
        for (int i = 0; i < this.config.size(); ++i) {
            if (!this.config.get(i).startsWith(lineStart)) continue;
            return i;
        }
        return -1;
    }

    public void appendLines(String ... lines) {
        this.config.addAll(Arrays.asList(lines));
    }

    public void setLine(int index, String newLine) {
        this.config.set(index, newLine);
    }

    public void addLines(int index, String ... newLines) {
        this.config.addAll(index, Arrays.asList(newLines));
    }

    public void removeLine(int index) {
        this.config.remove(index);
    }

    public void addLinesAt(String[] search, int offset, String ... newLines) {
        this.addLinesAt(search, offset, true, newLines);
    }

    public void addLinesAt(String[] search, int offset, boolean appendIfNotFound, String ... newLines) {
        int index = this.indexOfStart(search[0]);
        for (int s = 1; index == -1 && s < search.length; ++s) {
            index = this.indexOfStart(search[s]);
        }
        if (index != -1) {
            this.addLines(index + offset, newLines);
        } else if (appendIfNotFound) {
            this.appendLines(newLines);
        }
    }

    public void saveConfig() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String line : this.config) {
            stringBuilder.append(line).append("\n");
        }
        String configString = stringBuilder.toString().trim();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));
            writer.write(configString);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void getConfigString() {
        try {
            String currentLine;
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            while ((currentLine = reader.readLine()) != null) {
                this.config.add(currentLine);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setEncodeKey(long key) {
        int index = this.indexOfStart("encodeKey:");
        if (index != -1) {
            this.setLine(index, "encodeKey: " + key);
            return;
        }
        index = this.indexOfStart("enableEncode:");
        if (index == -1) {
            index = this.indexOfStart("# So enable this if you want to make recipe cheating harder");
        }
        if (index == -1) {
            index = this.indexOfStart("version:");
        }
        if (index != -1) {
            this.addLines(index + 1, "encodeKey: " + key);
        } else {
            this.addLines(1, "encodeKey: " + key);
        }
    }

    public void update(String fromVersion, boolean oldMat, String lang, FileConfiguration yml) {
        if (fromVersion.equals("0.5") && !lang.equals("de")) {
            lang = "de";
        }
        boolean de = lang.equals("de");
        if (fromVersion.equals("0.5") || fromVersion.equals("1.0")) {
            if (de) {
                this.update05de();
            } else {
                this.update10en();
            }
            fromVersion = "1.1";
        }
        if (fromVersion.equals("1.1") || fromVersion.equals("1.1.1")) {
            if (de) {
                this.update11de();
            } else {
                this.update11en();
            }
            fromVersion = "1.2";
        }
        if (fromVersion.equals("1.2")) {
            if (de) {
                this.update12de();
            } else {
                this.update12en();
            }
            fromVersion = "1.3";
        }
        if (fromVersion.equals("1.3")) {
            if (de) {
                this.update13de();
            } else {
                this.update13en();
            }
            fromVersion = "1.3.1";
        }
        if (fromVersion.equals("1.3.1")) {
            if (de) {
                this.update131de();
            } else {
                this.update131en();
            }
            fromVersion = "1.4";
        }
        if (fromVersion.equals("1.4")) {
            if (de) {
                this.update14de();
            } else {
                this.update14en();
            }
            fromVersion = "1.5";
        }
        if (fromVersion.equals("1.5") || fromVersion.equals("1.6")) {
            this.update15(VERSION.isOrLater(MinecraftVersion.V1_13), de);
            fromVersion = "1.7";
            oldMat = false;
        }
        if (fromVersion.equals("1.7")) {
            if (de) {
                this.update17de();
            } else {
                this.update17en();
            }
            fromVersion = "1.8";
        }
        if (fromVersion.equals("1.8")) {
            if (de) {
                this.update18de(yml);
            } else if (lang.equals("fr")) {
                this.update18fr(yml);
            } else {
                this.update18en(yml);
            }
            fromVersion = "2.0";
        }
        if (fromVersion.equals("2.0")) {
            if (de) {
                this.update20de();
            } else if (lang.equals("fr")) {
                this.update20fr();
            } else {
                this.update20en();
            }
            fromVersion = "2.1";
        }
        if (fromVersion.equals("2.1")) {
            if (de) {
                this.update21de();
            } else if (lang.equals("fr")) {
                this.update21fr();
            } else {
                this.update21en();
            }
            fromVersion = "2.1.1";
        }
        if (fromVersion.equals("2.1.1")) {
            this.update30CauldronParticles();
            if (de) {
                this.update30de();
            } else {
                this.update30en();
            }
            fromVersion = "3.0";
        }
        if (fromVersion.equals("3.0")) {
            if (de) {
                this.update31de();
            } else {
                this.update31en();
            }
            this.updateVersion("3.1");
            fromVersion = "3.1";
        }
        if (VERSION.isOrLater(MinecraftVersion.V1_13) && oldMat) {
            this.updateMaterials(true);
            this.updateMaterialDescriptions(de);
        }
        if (!fromVersion.equals("3.1")) {
            BreweryPlugin.getInstance().log(BreweryPlugin.getInstance().languageReader.get("Error_ConfigUpdate", fromVersion));
            return;
        }
        this.saveConfig();
    }

    private void updateVersion(String to) {
        int index = this.indexOfStart("version");
        String line = "version: '" + to + "'";
        if (index != -1) {
            this.setLine(index, line);
        } else {
            index = this.indexOfStart("# Config Version");
            if (index == -1) {
                index = this.indexOfStart("autosave");
            }
            if (index == -1) {
                this.appendLines(line);
            } else {
                this.addLines(index, line);
            }
        }
    }

    private void update05de() {
        this.updateVersion("1.1");
        int index = this.indexOfStart("language: en");
        if (index != -1) {
            this.setLine(index, "language: de");
            BreweryPlugin.getInstance().language = "de";
        }
        String[] entries = new String[]{"# -- Chat Ver\u00e4nderungs Einstellungen --", "", "# Text nach den angegebenen Kommandos wird bei Trunkenheit ebenfalls Ver\u00e4ndert (Liste) [- /gl]", "distortCommands:", "- /gl", "- /global", "- /fl", "- /s", "- /letter", "", "# Geschriebenen Text auf Schildern bei Trunkenheit ver\u00e4ndern [false]", "distortSignText: false", "", "# Text, der zwischen diesen Buchstaben steht, wird nicht ver\u00e4ndert (\",\" als Trennung verwenden) (Liste) [- '[,]']", "distortBypass:", "- '*,*'", "- '[,]'", ""};
        index = this.indexOfStart("# words");
        if (index == -1) {
            index = this.indexOfStart("# Diese werden von oben");
        }
        if (index == -1) {
            index = this.indexOfStart("# replace");
        }
        if (index == -1) {
            index = this.indexOfStart("words:");
        }
        if (index == -1) {
            this.appendLines(entries);
        } else {
            this.addLines(index, entries);
        }
        String line = "# -- Verschiedene Einstellungen --";
        index = this.indexOfStart("# Verschiedene Einstellungen");
        if (index != -1) {
            this.setLine(index, line);
        }
        line = "# -- Rezepte f\u00fcr Getr\u00e4nke --";
        index = this.indexOfStart("# Rezepte f\u00fcr Getr\u00e4nke");
        if (index != -1) {
            this.setLine(index, line);
        }
    }

    private void update10en() {
        this.updateVersion("1.1");
        String[] entries = new String[]{"# -- Chat Distortion Settings --", "", "# Text after specified commands will be distorted when drunk (list) [- /gl]", "distortCommands:", "- /gl", "- /global", "- /fl", "- /s", "- /letter", "", "# Distort the Text written on a Sign while drunk [false]", "distortSignText: false", "", "# Enclose a text with these Letters to bypass Chat Distortion (Use \",\" as Separator) (list) [- '[,]']", "distortBypass:", "- '*,*'", "- '[,]'", ""};
        int index = this.indexOfStart("# words");
        if (index == -1) {
            index = this.indexOfStart("# Will be processed");
        }
        if (index == -1) {
            index = this.indexOfStart("# replace");
        }
        if (index == -1) {
            index = this.indexOfStart("words:");
        }
        if (index == -1) {
            this.appendLines(entries);
        } else {
            this.addLines(index, entries);
        }
        String line = "# -- Settings --";
        index = this.indexOfStart("# Settings");
        if (index != -1) {
            this.setLine(index, line);
        }
        line = "# -- Recipes for Potions --";
        index = this.indexOfStart("# Recipes for Potions");
        if (index != -1) {
            this.setLine(index, line);
        }
    }

    private void update11de() {
        this.updateVersion("1.2");
        int index = this.indexOfStart("# Das Item kann nicht aufgesammelt werden");
        if (index != -1) {
            this.setLine(index, "# Das Item kann nicht aufgesammelt werden und bleibt bis zum Despawnen liegen. (Achtung: Kann nach Serverrestart aufgesammelt werden!)");
        }
        String[] lines = new String[]{"# Ob gro\u00dfe F\u00e4sser an jedem Block ge\u00f6ffnet werden k\u00f6nnen, nicht nur an Zapfhahn und Schild. Bei kleinen F\u00e4ssern geht dies immer. [true]", "openLargeBarrelEverywhere: true", ""};
        index = this.indexOfStart("colorInBrewer") + 2;
        if (index == 1) {
            index = this.indexOfStart("colorInBarrels") + 2;
        }
        if (index == 1) {
            index = this.indexOfStart("# Autosave");
        }
        if (index == -1) {
            index = this.indexOfStart("language") + 2;
        }
        if (index == 1) {
            this.addLines(3, lines);
        } else {
            this.addLines(index, lines);
        }
        lines = new String[]{"", "# -- Plugin Kompatiblit\u00e4t --", "", "# Andere Plugins (wenn installiert) nach Rechten zum \u00f6ffnen von F\u00e4ssern checken [true]", "useWorldGuard: true", "useLWC: true", "useGriefPrevention: true", "", "# \u00c4nderungen an Fassinventaren mit LogBlock aufzeichen [true]", "useLogBlock: true", "", ""};
        index = this.indexOfStart("# -- Chat Ver\u00e4nderungs Einstellungen");
        if (index == -1) {
            index = this.indexOfStart("# words");
        }
        if (index == -1 && (index = this.indexOfStart("distortCommands")) > 4) {
            index -= 4;
        }
        if (index != -1) {
            this.addLines(index, lines);
        } else {
            this.appendLines(lines);
        }
    }

    private void update11en() {
        this.updateVersion("1.2");
        int index = this.indexOfStart("# The item can not be collected");
        if (index != -1) {
            this.setLine(index, "# The item can not be collected and stays on the ground until it despawns. (Warning: Can be collected after Server restart!)");
        }
        String[] lines = new String[]{"# If a Large Barrel can be opened by clicking on any of its blocks, not just Spigot or Sign. This is always true for Small Barrels. [true]", "openLargeBarrelEverywhere: true", ""};
        index = this.indexOfStart("colorInBrewer") + 2;
        if (index == 1) {
            index = this.indexOfStart("colorInBarrels") + 2;
        }
        if (index == 1) {
            index = this.indexOfStart("# Autosave");
        }
        if (index == -1) {
            index = this.indexOfStart("language") + 2;
        }
        if (index == 1) {
            this.addLines(3, lines);
        } else {
            this.addLines(index, lines);
        }
        lines = new String[]{"", "# -- Plugin Compatibility --", "", "# Enable checking of other Plugins (if installed) for Barrel Permissions [true]", "useWorldGuard: true", "useLWC: true", "useGriefPrevention: true", "", "# Enable the Logging of Barrel Inventories to LogBlock [true]", "useLogBlock: true", "", ""};
        index = this.indexOfStart("# -- Chat Distortion Settings");
        if (index == -1) {
            index = this.indexOfStart("# words");
        }
        if (index == -1 && (index = this.indexOfStart("distortCommands")) > 4) {
            index -= 4;
        }
        if (index != -1) {
            this.addLines(index, lines);
        } else {
            this.appendLines(lines);
        }
    }

    private void update12de() {
        this.updateVersion("1.3");
        int index = this.indexOfStart("# wood:");
        if (index != -1) {
            this.setLine(index, "# wood: Holz des Fasses 0=alle Holzsorten 1=Birke 2=Eiche 3=Jungel 4=Fichte 5=Akazie 6=Schwarzeiche");
        }
        if ((index = this.indexOfStart("# cooked:")) != -1) {
            this.addLines(index + 1, "# [Beispiel] MATERIAL_oder_id: Name nach G\u00e4hren");
        }
        String replacedLine = "# ingredients: Auflistung von 'Material oder ID,Data/Anzahl'";
        String[] lines = new String[]{"#   (Item-ids anstatt Material werden von Bukkit nicht mehr unterst\u00fctzt und funktionieren m\u00f6glicherweise in Zukunft nicht mehr!)", "#   Eine Liste von allen Materialien kann hier gefunden werden: http://jd.bukkit.org/beta/apidocs/org/bukkit/Material.html", "#   Es kann ein Data-Wert angegeben werden, weglassen ignoriert diesen beim hinzuf\u00fcgen einer Zutat"};
        index = this.indexOfStart("# ingredients:");
        if (index != -1) {
            this.setLine(index, replacedLine);
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("# name:");
            if (index != -1) {
                this.addLines(index + 1, lines);
                this.addLines(index + 1, replacedLine);
            } else {
                index = this.indexOfStart("# -- Rezepte f\u00fcr Getr\u00e4nke --");
                if (index != -1) {
                    this.addLines(index + 2, lines);
                    this.addLines(index + 2, "", replacedLine);
                }
            }
        }
        replacedLine = "# color: Farbe des Getr\u00e4nks nach destillieren/reifen.";
        lines = new String[]{"#   Benutzbare Farben: DARK_RED, RED, BRIGHT_RED, ORANGE, PINK, BLUE, CYAN, WATER, GREEN, BLACK, GREY, BRIGHT_GREY"};
        index = this.indexOfStart("# color:");
        if (index != -1) {
            this.setLine(index, replacedLine);
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("# age:");
            if (index != -1) {
                this.addLines(index + 1, lines);
                this.addLines(index + 1, replacedLine);
            }
        }
        replacedLine = "# effects: Auflistung Effekt/Level/Dauer  Besonderere Trank-Effekte beim Trinken, Dauer in sek.";
        lines = new String[]{"#   Ein 'X' an den Namen anh\u00e4ngen, um ihn zu verbergen. Bsp: 'POISONX/2/10' (WEAKNESS, INCREASE_DAMAGE, SLOW und SPEED sind immer verborgen.)", "#   M\u00f6gliche Effekte: http://jd.bukkit.org/rb/apidocs/org/bukkit/potion/PotionEffectType.html", "#   Minimale und Maximale Level/Dauer k\u00f6nnen durch \"-\" festgelegt werden, Bsp: 'SPEED/1-2/30-40' = Level 1 und 30 sek minimal, Level 2 und 40 sek maximal", "#   Diese Bereiche funktionieren auch umgekehrt, Bsp: 'POISON/3-1/20-5' f\u00fcr abschw\u00e4chende Effekte bei guter Qualit\u00e4t", "#   L\u00e4ngste m\u00f6gliche Effektdauer: 1638 sek. Es muss keine Dauer f\u00fcr Effekte mit sofortiger Wirkung angegeben werden."};
        index = this.indexOfStart("# effects:");
        if (index != -1) {
            this.setLine(index, replacedLine);
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("# alcohol:");
            if (index != -1) {
                this.addLines(index + 1, lines);
                this.addLines(index + 1, replacedLine);
            } else {
                index = this.indexOfStart("# -- Rezepte f\u00fcr Getr\u00e4nke --");
                if (index != -1) {
                    this.addLines(index + 2, lines);
                    this.addLines(index + 2, "", replacedLine);
                }
            }
        }
        if (index != -1 && (index = this.indexOfStart("#   (WEAKNESS, INCREASE_DAMAGE, SLOW und SPEED sind immer verborgen.)  M\u00f6gliche Effekte:")) != -1) {
            this.removeLine(index);
        }
        if ((index = this.indexOfStart("#   Bei Effekten mit sofortiger Wirkung ")) != -1) {
            this.removeLine(index);
        }
    }

    private void update12en() {
        this.updateVersion("1.3");
        int index = this.indexOfStart("# wood:");
        if (index != -1) {
            this.setLine(index, "# wood: Wood of the barrel 0=any 1=Birch 2=Oak 3=Jungle 4=Spruce 5=Acacia 6=Dark Oak");
        }
        if ((index = this.indexOfStart("# cooked:")) != -1) {
            this.addLines(index + 1, "# [Example] MATERIAL_or_id: Name after cooking");
        }
        String replacedLine = "# ingredients: List of 'material or id,data/amount'";
        String[] lines = new String[]{"#   (Item-ids instead of material are deprecated by bukkit and may not work in the future!)", "#   A list of materials can be found here: http://jd.bukkit.org/beta/apidocs/org/bukkit/Material.html", "#   You can specify a data value, omitting it will ignore the data value of the added ingredient"};
        index = this.indexOfStart("# ingredients:");
        if (index != -1) {
            this.setLine(index, replacedLine);
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("# name:");
            if (index != -1) {
                this.addLines(index + 1, lines);
                this.addLines(index + 1, replacedLine);
            } else {
                index = this.indexOfStart("# -- Recipes for Potions --");
                if (index != -1) {
                    this.addLines(index + 2, lines);
                    this.addLines(index + 2, "", replacedLine);
                }
            }
        }
        replacedLine = "# color: Color of the potion after distilling/aging.";
        lines = new String[]{"#   Usable Colors: DARK_RED, RED, BRIGHT_RED, ORANGE, PINK, BLUE, CYAN, WATER, GREEN, BLACK, GREY, BRIGHT_GREY"};
        index = this.indexOfStart("# color:");
        if (index != -1) {
            this.setLine(index, replacedLine);
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("# age:");
            if (index != -1) {
                this.addLines(index + 1, lines);
                this.addLines(index + 1, replacedLine);
            }
        }
        replacedLine = "# effects: List of effect/level/duration  Special potion-effect when drinking, duration in sek.";
        lines = new String[]{"#   Suffix name with 'X' to hide effect from label. Sample: 'POISONX/2/10' (WEAKNESS, INCREASE_DAMAGE, SLOW and SPEED are always hidden.)", "#   Possible Effects: http://jd.bukkit.org/rb/apidocs/org/bukkit/potion/PotionEffectType.html", "#   Level or Duration ranges may be specified with a \"-\", ex. 'SPEED/1-2/30-40' = lvl 1 and 30 sec at worst and lvl 2 and 40 sec at best", "#   Ranges also work high-low, ex. 'POISON/3-1/20-5' for weaker effects at good quality.", "#   Highest possible Duration: 1638 sec. Instant Effects dont need any duration specified."};
        index = this.indexOfStart("# effects:");
        if (index != -1) {
            this.setLine(index, replacedLine);
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("# alcohol:");
            if (index != -1) {
                this.addLines(index + 1, lines);
                this.addLines(index + 1, replacedLine);
            } else {
                index = this.indexOfStart("# -- Recipes for Potions --");
                if (index != -1) {
                    this.addLines(index + 2, lines);
                    this.addLines(index + 2, "", replacedLine);
                }
            }
        }
        if (index != -1 && (index = this.indexOfStart("#   (WEAKNESS, INCREASE_DAMAGE, SLOW and SPEED are always hidden.)  Possible Effects:")) != -1) {
            this.removeLine(index);
        }
        if ((index = this.indexOfStart("#   instant effects ")) != -1) {
            this.removeLine(index);
        }
    }

    private void update13de() {
        this.updateVersion("1.3.1");
        int index = this.indexOfStart("# Autosave");
        String[] lines = new String[]{"# Aktiviert das Suchen nach Updates f\u00fcr Brewery mit der curseforge api [true]", "# Wenn ein Update gefunden wurde, wird dies bei Serverstart im log angezeigt, sowie ops benachrichtigt", "updateCheck: true", ""};
        if (index == -1 && (index = this.indexOfStart("autosave:")) == -1 && (index = this.indexOfStart("# Sprachedatei")) == -1) {
            index = this.indexOfStart("language:");
        }
        if (index == -1) {
            this.appendLines(lines);
        } else {
            this.addLines(index, lines);
        }
    }

    private void update13en() {
        this.updateVersion("1.3.1");
        int index = this.indexOfStart("# Autosave");
        String[] lines = new String[]{"# Enable checking for Updates, Checks the curseforge api for updates to Brewery [true]", "# If an Update is found a Message is logged on Server-start and displayed to ops joining the game", "updateCheck: true", ""};
        if (index == -1 && (index = this.indexOfStart("autosave:")) == -1 && (index = this.indexOfStart("# Languagefile")) == -1) {
            index = this.indexOfStart("language:");
        }
        if (index == -1) {
            this.appendLines(lines);
        } else {
            this.addLines(index, lines);
        }
    }

    private void update131de() {
        this.updateVersion("1.4");
        int index = this.indexOfStart("# SamplePlugin = installiertes home plugin. Unterst\u00fctzt: ManagerXL.");
        if (index != -1) {
            this.removeLine(index);
        }
        if ((index = this.indexOfStart("# Ob der Spieler nach etwas k\u00fcrzerem Ausloggen an einem zuf\u00e4lligen Ort \"aufwacht\" (diese m\u00fcssen durch '/br Wakeup add")) != -1) {
            this.setLine(index, "# Ob der Spieler nach etwas k\u00fcrzerem Ausloggen an einem zuf\u00e4lligen Ort \"aufwacht\" (diese m\u00fcssen durch '/brew Wakeup add' von einem Admin festgelegt werden)");
        }
        if ((index = this.indexOfStart("# Ob der Spieler sich bei gro\u00dfer Trunkenheit teilweise nicht einloggen kann und kurz warten muss, da sein Charakter nicht reagiert")) != -1) {
            this.setLine(index, "# Ob der Spieler bei gro\u00dfer Trunkenheit mehrmals probieren muss sich einzuloggen, da sein Charakter kurz nicht reagiert [true]");
        }
        if ((index = this.indexOfStart("# Ob der Spieler sich \u00fcbertrinken kann und dann in Ohnmacht f\u00e4llt (gekickt wird)")) != -1) {
            this.setLine(index, "# Ob der Spieler kurz in Ohnmacht f\u00e4llt (vom Server gekickt wird) wenn er die maximale Trunkenheit erreicht [false]");
        }
        if ((index = this.indexOfStart("# Das Item kann nicht aufgesammelt werden und bleibt bis zum Despawnen liegen. (Achtung:")) != -1) {
            this.setLine(index, "# Das Item kann nicht aufgesammelt werden und bleibt bis zum Despawnen liegen.");
        }
        String[] lines = new String[]{"", "# Zeit in Sekunden bis die pukeitems despawnen, (mc standard w\u00e4re 300 = 5 min) [60]", "# Wurde die item Despawnzeit in der spigot.yml ver\u00e4ndert, ver\u00e4ndert sich auch die pukeDespawnzeit in Abh\u00e4ngigkeit.", "pukeDespawntime: 60"};
        index = this.indexOfStart("pukeItem:");
        if (index == -1 && (index = this.indexOfStart("enablePuke:")) == -1 && (index = this.indexOfStart("# Konsumierbares Item") - 1) == -2 && (index = this.indexOfStart("enableKickOnOverdrink:")) == -1) {
            index = this.indexOfStart("language:");
        }
        if (index == -1) {
            this.appendLines(lines);
        } else {
            this.addLines(index + 1, lines);
        }
        index = this.indexOfStart("# F\u00e4rben der Iteminformationen je nach Qualit\u00e4t w\u00e4hrend sie sich 1. im Fass und/oder 2. im Braustand befinden [true, false]");
        if (index != -1) {
            this.setLine(index, "# F\u00e4rben der Iteminformationen je nach Qualit\u00e4t w\u00e4hrend sie sich 1. im Fass und/oder 2. im Braustand befinden [true, true]");
        }
        if ((index = this.indexOfStart("# Wenn ein Update gefunden wurde, wird dies bei Serverstart im log angezeigt, sowie ops benachrichtigt")) != -1) {
            this.setLine(index, "# Wenn ein Update gefunden wurde, wird dies bei Serverstart im log angezeigt, sowie OPs benachrichtigt");
        }
        if ((index = this.indexOfStart("#   Eine Liste von allen Materialien kann hier gefunden werden: http://jd.bukkit.org")) != -1) {
            this.setLine(index, "#   Eine Liste von allen Materialien kann hier gefunden werden: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Material.html");
        }
        lines = new String[]{"#   Wenn Vault installiert ist k\u00f6nnen normale englische Item Namen verwendet werden, anstatt Material, ID und Data!", "#   Vault erkennt Namen wie \"Jungle Leaves\" anstatt \"LEAVES,3\". Dies macht es viel einfacher!"};
        index = this.indexOfStart("#   Es kann ein Data-Wert angegeben werden, weglassen");
        if (index != -1) {
            this.setLine(index, "#   Es kann ein Data-Wert (durability) angegeben werden, weglassen ignoriert diesen beim hinzuf\u00fcgen einer Zutat");
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("#   Eine Liste von allen Materialien kann hier");
            if (index == -1 && (index = this.indexOfStart("# cookingtime: ") - 1) == -2 && (index = this.indexOfStart("# ingredients: Auflistung von")) == -1 && (index = this.indexOfStart("# -- Rezepte f\u00fcr Getr\u00e4nke --") + 1) == 0) {
                index = this.indexOfStart("# -- Verschiedene Einstellungen --");
            }
            if (index == -1) {
                this.appendLines(lines);
            } else {
                this.addLines(index + 1, lines);
            }
        }
        lines = new String[]{"#   Effekte sind ab der 1.9 immer verborgen, wegen \u00c4nderungen an den Tr\u00e4nken."};
        index = this.indexOfStart("#   M\u00f6gliche Effekte: http://jd.bukkit.org");
        if (index != -1) {
            this.setLine(index, "#   M\u00f6gliche Effekte: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/potion/PotionEffectType.html");
            this.addLines(index, lines);
        } else {
            index = this.indexOfStart("#   Ein 'X' an den Namen anh\u00e4ngen, um");
            if (index == -1 && (index = this.indexOfStart("# effects: ")) == -1) {
                index = this.indexOfStart("# -- Rezepte f\u00fcr Getr\u00e4nke --") + 1;
            }
            if (index == 0) {
                this.appendLines(lines);
            } else {
                this.addLines(index + 1, lines);
            }
        }
        index = this.indexOfStart("# Text, der zwischen diesen Buchstaben");
        if (index != -1) {
            this.setLine(index, "# Im Chat geschriebener Text, der zwischen diesen Buchstaben steht, wird nicht ver\u00e4ndert (\",\" als Trennung verwenden) (Liste) [- '[,]']");
        }
    }

    private void update131en() {
        this.updateVersion("1.4");
        int index = this.indexOfStart("# SamplePlugin = installed home plugin. Supports: ManagerXL.");
        if (index != -1) {
            this.removeLine(index);
        }
        if ((index = this.indexOfStart("# If the player \"wakes up\" at a random place when offline for some time while drinking (the places have to be defined with '/br Wakeup add'")) != -1) {
            this.setLine(index, "# If the player \"wakes up\" at a random place when offline for some time while drinking (the places have to be defined with '/brew Wakeup add' through an admin)");
        }
        if ((index = this.indexOfStart("# If the Player may get some logins denied, when his character is drunk")) != -1) {
            this.setLine(index, "# If the Player may have to try multiple times when logging in while extremely drunk [true]");
        }
        if ((index = this.indexOfStart("# If the Player faints (gets kicked) for some minutes if he overdrinks")) != -1) {
            this.setLine(index, "# If the Player faints shortly (gets kicked from the server) if he drinks the max amount of alcohol possible [false]");
        }
        if ((index = this.indexOfStart("# The item can not be collected and stays on the ground until it despawns. (Warning:")) != -1) {
            this.setLine(index, "# The item can not be collected and stays on the ground until it despawns.");
        }
        String[] lines = new String[]{"", "# Time in seconds until the pukeitems despawn, (mc default is 300 = 5 min) [60]", "# If the item despawn time was changed in the spigot.yml, the pukeDespawntime changes as well.", "pukeDespawntime: 60"};
        index = this.indexOfStart("pukeItem:");
        if (index == -1 && (index = this.indexOfStart("enablePuke:")) == -1 && (index = this.indexOfStart("# Consumable Item") - 1) == -2 && (index = this.indexOfStart("enableKickOnOverdrink:")) == -1) {
            index = this.indexOfStart("language:");
        }
        if (index == -1) {
            this.appendLines(lines);
        } else {
            this.addLines(index + 1, lines);
        }
        index = this.indexOfStart("# Color the Item information (lore) depending on quality while it is 1. in a barrel and/or 2. in a brewing stand [true, false]");
        if (index != -1) {
            this.setLine(index, "# Color the Item information (lore) depending on quality while it is 1. in a barrel and/or 2. in a brewing stand [true, true]");
        }
        if ((index = this.indexOfStart("# If an Update is found a Message is logged on Server-start and displayed to ops joining the game")) != -1) {
            this.setLine(index, "# If an Update is found a Message is logged on Server-start and displayed to OPs joining the game");
        }
        if ((index = this.indexOfStart("#   A list of materials can be found here: http://jd.bukkit.org")) != -1) {
            this.setLine(index, "#   A list of materials can be found here: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Material.html");
        }
        lines = new String[]{"#   If Vault is installed normal names can be used instead of material or id, so using Vault is highly recommended.", "#   Vault will recognize things like \"Jungle Leaves\" instead of \"LEAVES,3\""};
        index = this.indexOfStart("#   You can specify a data value, omitting");
        if (index != -1) {
            this.setLine(index, "#   You can specify a data (durability) value, omitting it will ignore the data value of the added ingredient");
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("#   A list of materials can be found");
            if (index == -1 && (index = this.indexOfStart("# cookingtime: Time in real minutes") - 1) == -2 && (index = this.indexOfStart("# ingredients: ")) == -1 && (index = this.indexOfStart("# -- Recipes for Potions --") + 1) == 0) {
                index = this.indexOfStart("# -- Settings --");
            }
            if (index == -1) {
                this.appendLines(lines);
            } else {
                this.addLines(index + 1, lines);
            }
        }
        lines = new String[]{"#   Effects are always hidden in 1.9 and newer, because of changes in the potion mechanics."};
        index = this.indexOfStart("#   Possible Effects: http://jd.bukkit.org");
        if (index != -1) {
            this.setLine(index, "#   Possible Effects: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/potion/PotionEffectType.html");
            this.addLines(index, lines);
        } else {
            index = this.indexOfStart("#   Suffix name with");
            if (index == -1 && (index = this.indexOfStart("# effects: ")) == -1) {
                index = this.indexOfStart("# -- Recipes for Potions --") + 1;
            }
            if (index == 0) {
                this.appendLines(lines);
            } else {
                this.addLines(index + 1, lines);
            }
        }
        index = this.indexOfStart("# Enclose a text with these Letters to bypass Chat Distortion");
        if (index != -1) {
            this.setLine(index, "# Enclose a Chat text with these Letters to bypass Chat Distortion (Use \",\" as Separator) (list) [- '[,]']");
        }
    }

    private void update14de() {
        this.updateVersion("1.5");
        String[] lines = new String[]{"", "# Ob geschriebener Chat bei gro\u00dfer Trunkenheit abgef\u00e4lscht werden soll,", "# so dass es etwas betrunken aussieht was geschrieben wird.", "# Wie stark der Chat ver\u00e4ndert wird h\u00e4ngt davon ab wie betrunken der Spieler ist", "# Unten kann noch eingestellt werden wie und was ver\u00e4ndert wird", "enableChatDistortion: true"};
        int index = this.indexOfStart("# -- Chat") + 2;
        if (index == 1 && (index = this.indexOfStart("distortCommands:") - 1) == -2 && (index = this.indexOfStart("distortSignText:") - 1) == -2 && (index = this.indexOfStart("# words:")) == -1) {
            index = this.indexOfStart("words:");
        }
        if (index == -1) {
            this.appendLines(lines);
        } else {
            this.addLines(index - 1, lines);
        }
        lines = new String[]{"# Also zum Beispiel im Chat: Hallo ich bin betrunken *Ich teste Brewery*"};
        index = this.indexOfStart("# Im Chat geschriebener Text, der zwischen");
        if (index != -1) {
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("distortBypass:");
            if (index != -1) {
                this.addLines(index, lines);
            }
        }
        lines = new String[]{"# distilltime: Wie lange (in sekunden) ein Destillations-Durchlauf braucht (0=Standard Zeit von 40 sek) MC Standard w\u00e4re 20 sek"};
        index = this.indexOfStart("# distillruns:");
        if (index == -1 && (index = this.indexOfStart("# wood:") - 1) == -2 && (index = this.indexOfStart("# -- Rezepte") + 1) == 0) {
            index = -1;
        }
        if (index != -1) {
            this.addLines(index + 1, lines);
        }
        if ((index = this.indexOfStart("      name: Schlechtes Beispiel/Beispiel/Gutes Beispiel")) != -1) {
            this.addLines(index + 1, "      distilltime: 60");
        }
        if ((index = this.indexOfStart("      name: Bitterer Rum/W\u00fcrziger Rum/&6Goldener Rum")) != -1) {
            this.addLines(index + 1, "      distilltime: 30");
        }
        if ((index = this.indexOfStart("      name: minderwertiger Absinth/Absinth/Starker Absinth")) != -1) {
            this.addLines(index + 1, "      distilltime: 80");
        }
    }

    private void update14en() {
        this.updateVersion("1.5");
        String[] lines = new String[]{"", "# If written Chat is distorted when the Player is Drunk,", "# so that it looks like drunk writing", "# How much the chat is distorted depends on how drunk the Player is", "# Below are settings for what and how changes in chat occur", "enableChatDistortion: true"};
        int index = this.indexOfStart("# -- Chat") + 2;
        if (index == 1 && (index = this.indexOfStart("distortCommands:") - 1) == -2 && (index = this.indexOfStart("distortSignText:") - 1) == -2 && (index = this.indexOfStart("# words:")) == -1) {
            index = this.indexOfStart("words:");
        }
        if (index == -1) {
            this.appendLines(lines);
        } else {
            this.addLines(index - 1, lines);
        }
        lines = new String[]{"# Chat Example: Hello i am drunk *I am testing Brewery*"};
        index = this.indexOfStart("# Enclose a Chat text with these Letters");
        if (index != -1) {
            this.addLines(index + 1, lines);
        } else {
            index = this.indexOfStart("distortBypass:");
            if (index != -1) {
                this.addLines(index, lines);
            }
        }
        lines = new String[]{"# distilltime: How long (in seconds) one distill-run takes (0=Default time of 40 sec) MC Default would be 20 sec"};
        index = this.indexOfStart("# distillruns:");
        if (index == -1 && (index = this.indexOfStart("# wood:") - 1) == -2 && (index = this.indexOfStart("# -- Recipes") + 1) == 0) {
            index = -1;
        }
        if (index != -1) {
            this.addLines(index + 1, lines);
        }
        if ((index = this.indexOfStart("      name: Bad Example/Example/Good Example")) != -1) {
            this.addLines(index + 1, "      distilltime: 60");
        }
        if ((index = this.indexOfStart("      name: Bitter Rum/Spicy Rum/&6Golden Rum")) != -1) {
            this.addLines(index + 1, "      distilltime: 30");
        }
        if ((index = this.indexOfStart("      name: Poor Absinthe/Absinthe/Strong Absinthe")) != -1) {
            this.addLines(index + 1, "      distilltime: 80");
        }
    }

    private void update15(boolean mc113, boolean langDE) {
        this.updateVersion("1.7");
        this.updateMaterials(mc113);
        if (langDE) {
            int index = this.indexOfStart("# ingredients: Auflistung von 'Material oder ID");
            if (index != -1) {
                this.setLine(index, "# ingredients: Auflistung von 'Material,Data/Anzahl'");
            }
            if ((index = this.indexOfStart("#   (Item-ids anstatt Material")) != -1) {
                this.setLine(index, "#   (Item-ids anstatt Material k\u00f6nnen in Bukkit nicht mehr benutzt werden)");
            }
            if ((index = this.indexOfStart("# [Beispiel] MATERIAL_oder_id: Name")) != -1) {
                this.setLine(index, "# [Beispiel] MATERIAL: Name nach G\u00e4hren");
            }
        } else {
            int index = this.indexOfStart("# ingredients: List of 'material or id");
            if (index != -1) {
                this.setLine(index, "# ingredients: List of 'material,data/amount'");
            }
            if ((index = this.indexOfStart("#   (Item-ids instead of material are deprecated")) != -1) {
                this.setLine(index, "#   (Item-ids instead of material are not supported by bukkit anymore and will not work)");
            }
            if ((index = this.indexOfStart("# [Example] MATERIAL_or_id: Name")) != -1) {
                this.setLine(index, "# [Example] MATERIAL: Name after cooking");
            }
        }
    }

    private void update17de() {
        this.updateVersion("1.8");
        int index = this.indexOfStart("openLargeBarrelEverywhere");
        if (index == -1 && (index = this.indexOfStart("colorInBrewer")) == -1 && (index = this.indexOfStart("colorInBarrels")) == -1 && (index = this.indexOfStart("hangoverDays")) == -1) {
            index = this.indexOfStart("language");
        }
        String[] lines = new String[]{"", "# Wie viele Brewery Getr\u00e4nke in die Minecraft F\u00e4sser getan werden k\u00f6nnen [6]", "maxBrewsInMCBarrels: 6"};
        if (index == -1) {
            this.appendLines(lines);
        } else {
            this.addLines(index + 1, lines);
        }
        index = this.indexOfStart("#   Benutzbare Farben");
        if (index == -1) {
            index = this.indexOfStart("# color:");
        }
        if (index != -1) {
            this.addLines(index + 1, "#   Oder RGB Farben (Hex: also zB '99FF33') (Ohne #) (mit '') (Einfach nach \"HTML color\" im Internet suchen)");
        }
        if ((index = this.indexOfStart("# ingredients:")) == -1 && (index = this.indexOfStart("#   Eine Liste von allen Materialien")) == -1) {
            index = this.indexOfStart("# -- Rezepte");
        }
        if (index != -1) {
            this.addLines(index + 1, "#   Halte ein Item in der Hand und benutze /brew ItemName um dessen Material herauszufinden und f\u00fcr ein Rezept zu benutzen");
        }
        if ((index = this.indexOfStart("# wood: Holz des Fasses")) != -1) {
            this.addLines(index + 1, "#   Das Minecraft Fass besteht aus Eiche");
        }
        if (VERSION.isOrLater(MinecraftVersion.V1_13)) {
            this.updateMaterialDescriptions(true);
        }
    }

    private void update17en() {
        this.updateVersion("1.8");
        int index = this.indexOfStart("openLargeBarrelEverywhere");
        if (index == -1 && (index = this.indexOfStart("colorInBrewer")) == -1 && (index = this.indexOfStart("colorInBarrels")) == -1 && (index = this.indexOfStart("hangoverDays")) == -1) {
            index = this.indexOfStart("language");
        }
        String[] lines = new String[]{"", "# How many Brewery drinks can be put into the Minecraft barrels [6]", "maxBrewsInMCBarrels: 6"};
        if (index == -1) {
            this.appendLines(lines);
        } else {
            this.addLines(index + 1, lines);
        }
        index = this.indexOfStart("#   Usable Colors");
        if (index == -1) {
            index = this.indexOfStart("# color:");
        }
        if (index != -1) {
            this.addLines(index + 1, "#   Or RGB colors (hex: for example '99FF33') (with '') (search for \"HTML color\" on the internet)");
        }
        if ((index = this.indexOfStart("# ingredients:")) == -1 && (index = this.indexOfStart("#   A list of materials")) == -1) {
            index = this.indexOfStart("# -- Recipes");
        }
        if (index != -1) {
            this.addLines(index + 1, "#   With an item in your hand, use /brew ItemName to get its material for use in a recipe");
        }
        if ((index = this.indexOfStart("# wood: Wood of the barrel")) != -1) {
            this.addLines(index + 1, "#   The Minecraft barrel is made of oak");
        }
        if (VERSION.isOrLater(MinecraftVersion.V1_13)) {
            this.updateMaterialDescriptions(false);
        }
    }

    private void update18de(FileConfiguration yml) {
        int index = this.indexOfStart("# L\u00f6schen einzelner Einstellungen");
        if (index != -1) {
            this.removeLine(index);
        }
        this.addLinesAt(new String[]{"colorInBrewer:", "colorInBarrels:", "hangoverDays:", "language:"}, 1, "", "# Ob in den Iteminformationen immer 1-5 Sterne f\u00fcr die Qualit\u00e4t angezeigt werden sollen, oder nur beim brauen [true]", "alwaysShowQuality: true", "", "# Ob in den Iteminformationen immer der Alkoholgehalt angezeigt weden soll, oder nur im Braustand [false]", "alwaysShowAlc: false");
        this.addLinesAt(new String[]{"maxBrewsInMCBarrels:", "openLargeBarrelEverywhere:", "language:"}, 1, "", "# Benutzte Zutaten und andere Brau-Daten werden in allen Brewery Tr\u00e4nken gespeichert. Um zu verhindern,", "# dass gehackte clients diese Daten auslesen um Rezepte herauszufinden, k\u00f6nnen diese encodiert werden.", "# Einziger Nachteil: Tr\u00e4nke k\u00f6nnen nur auf Servern mit dem gleichen encodeKey benutzt werden.", "# Dies kann also aktiviert werden um Rezept-cheating schwerer zu machen, aber keine Tr\u00e4nke per World Download, Schematic, o.\u00e4. geteilt werden. [false]", "enableEncode: false", "encodeKey: 0");
        if (this.indexOfStart("debug:") == -1) {
            this.addLinesAt(new String[]{"autosave:", "version:"}, 1, "", "# Debug Nachrichten im Log anzeigen [false]", "debug: false");
        }
        if ((index = this.indexOfStart("oldMat:") + 1) == 0 && (index = this.indexOfStart("version:") + 1) == 0) {
            index = 2;
        }
        this.applyPatch("config/patches/de18.txt", index);
        index = this.indexOfStart("%%%%MAT1%%%%");
        if (index != -1) {
            if (VERSION.isOrLater(MinecraftVersion.V1_13)) {
                this.setLine(index, "    material: Barrier");
            } else {
                this.setLine(index, "    material: BEDROCK");
            }
        }
        if ((index = this.indexOfStart("%%%%MAT2%%%%")) != -1) {
            this.removeLine(index);
            if (VERSION.isOrLater(MinecraftVersion.V1_13)) {
                this.addLines(index, "    material:", "      - Acacia_Door", "      - Oak_Door", "      - Spruce_Door");
            } else {
                this.addLines(index, "    material:", "      - WOODEN_DOOR", "      - IRON_DOOR");
            }
        }
        if ((index = this.indexOfStart("# -- Eine Zutat:")) == -1 && (index = this.indexOfStart("cauldron:")) == -1) {
            index = this.indexOfStart("version:");
            if (index == -1) {
                index = 0;
            }
            this.addLines(index + 1, "cauldron:");
            ++index;
        }
        this.convertCookedSection(yml, index + 1);
        this.addLinesAt(new String[]{"#   Eine Liste von allen Materialien", "# ingredients:"}, 1, "#   Plugin Items mit 'Plugin:Id' (Im Moment ExoticGarden, Slimefun, MMOItems, Brewery)", "#   Oder ein oben definiertes Custom Item");
        this.addLinesAt(new String[]{"# alcohol:", "# difficulty:", "# ingredients:", "# -- Rezepte"}, 1, "# lore: Auflistung von zus\u00e4tzlichem Text auf dem fertigen Trank. (Farbcodes m\u00f6glich: z.b. &6)", "#   Lore nur f\u00fcr bestimmte Qualit\u00e4t m\u00f6glich mit + Schlecht, ++ Mittel, +++ Gut, vorne anh\u00e4ngen.", "# servercommands: Liste von Befehlen ausgef\u00fchrt vom Server wenn der Trank getrunken wird", "# playercommands: Liste von Befehlen ausgef\u00fchrt vom Spieler wenn der Trank getrunken wird", "# drinkmessage: Nachricht im Chat beim trinken des Trankes", "# drinktitle: Nachricht als Titel auf dem Bildschirm an den Spieler beim trinken des Trankes");
        this.addLinesAt(new String[]{"useGriefPrevention:", "useWorldGuard:", "# -- Plugin Kompatiblit"}, 1, "useGMInventories: true");
        index = this.indexOfStart("# cooked:");
        if (index != -1) {
            this.removeLine(index);
        }
        if ((index = this.indexOfStart("# [Beispiel] MATERIAL:")) != -1) {
            this.removeLine(index);
        }
    }

    private void update18fr(FileConfiguration yml) {
        int index = this.indexOfStart("# Supprimer un para");
        if (index != -1) {
            this.removeLine(index);
        }
        this.addLinesAt(new String[]{"colorInBrewer:", "colorInBarrels:", "hangoverDays:", "language:"}, 1, "\n# Toujours montrer les 1-5 \u00e9toiles sur les objets en fonction de leur qualit\u00e9. S'ils sont faux, ils n'appara\u00eetront que lors de l'infusion. [true]", "alwaysShowQuality: true", "", "# Toujours indiquer la teneur en alcool sur les objets. S'il est false, il n'appara\u00eetra que dans le stand de brassage. [false]", "alwaysShowAlc: false");
        this.addLinesAt(new String[]{"maxBrewsInMCBarrels:", "openLargeBarrelEverywhere:", "language:"}, 1, "", "# Les ingr\u00e9dients et autres donn\u00e9es de brassage utilis\u00e9s sont sauvegard\u00e9s dans tous les articles de brasserie. [false]", "# Pour emp\u00eacher les clients pirat\u00e9s de lire exactement ce qui a \u00e9t\u00e9 utilis\u00e9 pour infuser un \u00e9l\u00e9ment, les donn\u00e9es peuvent \u00eatre encod\u00e9es/brouill\u00e9es.", "# Il s'agit d'un processus rapide pour emp\u00eacher les joueurs de pirater des recettes, une fois qu'ils mettent la main sur une bi\u00e8re.", "# Seul inconv\u00e9nient: Les boissons brassicoles ne peuvent \u00eatre utilis\u00e9s que sur un autre serveur avec la m\u00eame cl\u00e9 de chiffrement.", "# Activez cette option si vous voulez rendre la tricherie des recettes plus difficile, mais ne partagez pas les infusions par t\u00e9l\u00e9chargement mondial, sch\u00e9mas ou autres moyens.", "enableEncode: false", "encodeKey: 0");
        if (this.indexOfStart("debug:") == -1) {
            this.addLinesAt(new String[]{"autosave:", "version:"}, 1, "", "# Show debug messages in log [false]", "debug: false");
        }
        if ((index = this.indexOfStart("oldMat:") + 1) == 0 && (index = this.indexOfStart("version:") + 1) == 0) {
            index = 2;
        }
        this.applyPatch("config/patches/fr18.txt", index);
        index = this.indexOfStart("%%%%MAT1%%%%");
        if (index != -1) {
            if (VERSION.isOrLater(MinecraftVersion.V1_13)) {
                this.setLine(index, "    material: Barrier");
            } else {
                this.setLine(index, "    material: BEDROCK");
            }
        }
        if ((index = this.indexOfStart("%%%%MAT2%%%%")) != -1) {
            this.removeLine(index);
            if (VERSION.isOrLater(MinecraftVersion.V1_13)) {
                this.addLines(index, "    material:", "      - Acacia_Door", "      - Oak_Door", "      - Spruce_Door");
            } else {
                this.addLines(index, "    material:", "      - WOODEN_DOOR", "      - IRON_DOOR");
            }
        }
        if ((index = this.indexOfStart("  # -- Un ingr")) == -1 && (index = this.indexOfStart("cauldron:")) == -1) {
            index = this.indexOfStart("version:");
            if (index == -1) {
                index = 0;
            }
            this.addLines(index + 1, "cauldron:");
            ++index;
        }
        this.convertCookedSection(yml, index + 1);
        this.addLinesAt(new String[]{"#   Une liste des mat", "# ingredients:"}, 1, "#   Plugin items avec 'plugin:id' (Actuellement support\u00e9 ExoticGarden, Slimefun, MMOItems, Brewery)", "#   Ou un \u00e9l\u00e9ment personnalis\u00e9 d\u00e9fini ci-dessus");
        this.addLinesAt(new String[]{"# alcohol:", "# difficulty:", "# ingredients:", "# -- Recette "}, 1, "# lore: Liste des textes suppl\u00e9mentaires sur le breuvage fini. (Codes de formatage possibles : tels que &6)", "#   Texte sp\u00e9cifique de qualit\u00e9 possible, en utilisant + mauvais, ++ normal, +++ bon, ajout\u00e9 \u00e0 l'avant de la ligne.", "# servercommands: Liste des commandes ex\u00e9cut\u00e9es par le serveur lors de la consommation de la potion", "# playercommands: Liste des commandes ex\u00e9cut\u00e9es par le joueur lors de la consommation de la potion", "# drinkmessage: Chat-message au joueur lorsqu'il boit la potion", "# drinktitle: Titre \u00e0 l'\u00e9cran du joueur lorsqu'il boit la potion");
        this.addLinesAt(new String[]{"useGriefPrevention:", "useWorldGuard:", "# -- Plugin Compatibility"}, 1, "useGMInventories: true");
        index = this.indexOfStart("# cooked:");
        if (index != -1) {
            this.removeLine(index);
        }
        if ((index = this.indexOfStart("# [Exemple] MATERIEL")) != -1) {
            this.removeLine(index);
        }
    }

    private void update18en(FileConfiguration yml) {
        int index = this.indexOfStart("# Deleting of single settings");
        if (index != -1) {
            this.removeLine(index);
        }
        this.addLinesAt(new String[]{"colorInBrewer:", "colorInBarrels:", "hangoverDays:", "language:"}, 1, "", "# Always show the 1-5 stars on the item depending on the quality. If false, they will only appear when brewing [true]", "alwaysShowQuality: true", "", "# Always show the alcohol content on the item. If false, it will only show in the brewing stand [false]", "alwaysShowAlc: false");
        this.addLinesAt(new String[]{"maxBrewsInMCBarrels:", "openLargeBarrelEverywhere:", "language:"}, 1, "", "# The used Ingredients and other brewing-data is saved to all Brewery Items. To prevent", "# hacked clients from reading what exactly was used to brew an item, the data can be encoded/scrambled.", "# This is a fast process to stop players from hacking out recipes, once they get hold of a brew.", "# Only drawback: brew items can only be used on another server with the same encodeKey.", "# So enable this if you want to make recipe cheating harder, but don't share any brews by world download, schematics, or other means. [false]", "enableEncode: false", "encodeKey: 0");
        if (this.indexOfStart("debug:") == -1) {
            this.addLinesAt(new String[]{"autosave:", "version:"}, 1, "", "# Show debug messages in log [false]", "debug: false");
        }
        if ((index = this.indexOfStart("oldMat:") + 1) == 0 && (index = this.indexOfStart("version:") + 1) == 0) {
            index = 2;
        }
        this.applyPatch("config/patches/en18.txt", index);
        index = this.indexOfStart("%%%%MAT1%%%%");
        if (index != -1) {
            if (VERSION.isOrLater(MinecraftVersion.V1_13)) {
                this.setLine(index, "    material: Barrier");
            } else {
                this.setLine(index, "    material: BEDROCK");
            }
        }
        if ((index = this.indexOfStart("%%%%MAT2%%%%")) != -1) {
            this.removeLine(index);
            if (VERSION.isOrLater(MinecraftVersion.V1_13)) {
                this.addLines(index, "    material:", "      - Acacia_Door", "      - Oak_Door", "      - Spruce_Door");
            } else {
                this.addLines(index, "    material:", "      - WOODEN_DOOR", "      - IRON_DOOR");
            }
        }
        if ((index = this.indexOfStart("  # -- One Ingredient")) == -1 && (index = this.indexOfStart("cauldron:")) == -1) {
            index = this.indexOfStart("version:");
            if (index == -1) {
                index = 0;
            }
            this.addLines(index + 1, "cauldron:");
            ++index;
        }
        this.convertCookedSection(yml, index + 1);
        this.addLinesAt(new String[]{"#   A list of materials", "# ingredients:"}, 1, "#   Plugin items with 'plugin:id' (Currently supporting ExoticGarden, Slimefun, MMOItems, Brewery)", "#   Or a custom item defined above");
        this.addLinesAt(new String[]{"# alcohol:", "# difficulty:", "# ingredients:", "# -- Recipes"}, 1, "# lore: List of additional text on the finished brew. (Formatting codes possible: such as &6)", "#   Specific lore for quality possible, using + bad, ++ normal, +++ good, added to the front of the line.", "# servercommands: List of Commands executed by the Server when drinking the brew", "# playercommands: List of Commands executed by the Player when drinking the brew", "# drinkmessage: Chat-message to the Player when drinking the Brew", "# drinktitle: Title on Screen to the Player when drinking the Brew");
        this.addLinesAt(new String[]{"useGriefPrevention:", "useWorldGuard:", "# -- Plugin Compatibility"}, 1, "useGMInventories: true");
        index = this.indexOfStart("# cooked:");
        if (index != -1) {
            this.removeLine(index);
        }
        if ((index = this.indexOfStart("# [Example] MATERIAL:")) != -1) {
            this.removeLine(index);
        }
    }

    private void update20de() {
        this.addLinesAt(new String[]{"hangoverDays", "colorInBrewer", "encodeKey"}, 1, "", "# Ob das craften und das benutzen des Trank-Versiegelungs-Tisches aktiviert ist (2 Flaschen \u00fcber 4 Holz) [true, true]", "craftSealingTable: true", "enableSealingTable: true");
        this.addLinesAt(new String[]{"useLogBlock", "useGMInventories", "# -- Plugin Kompatibli", "# Es gibt noch viele Minecraft Items", "version"}, 1, "", "", "# -- MultiServer/BungeeCord --", "# Wenn Brewery auf mehreren Servern l\u00e4uft und diese zB mit BungeeCord verbunden sind,", "# sollte hier eine gemeinsame Datenbank eingetragen werden.", "# Dann wird Betrunkenheit auf den Servern synchronisiert und encodierte Tr\u00e4nke k\u00f6nnen auf allen Servern benutzt werden.", "", "multiServerDB:", "  # Soll die Datenbank-Synchronisation aktiviert sein", "  enabled: false", "  # Soll die Betrunkenheit von Spielern synchronisiert werden", "  syncDrunkeness: true", "  host: localhost", "  port: '3306'", "  user: minec", "  password: xyz", "  database: base", "", "", "# -- Verschiedene weitere Einstellungen --", "", "# Ob Items in der Zweithand auch in den Kessel geworfen werden sollen [false]", "useOffhandForCauldron: false");
    }

    private void update20fr() {
        this.addLinesAt(new String[]{"hangoverDays", "colorInBrewer", "encodeKey"}, 1, "", "# If crafting and using of the Brew Sealing Table is enabled (2 Bottles over 4 Planks) [true, true]", "craftSealingTable: true", "enableSealingTable: true");
        this.addLinesAt(new String[]{"useLogBlock", "useGMInventories", "# -- Compatibilit", "# There are a lot of items in Minecraft ", "version"}, 1, "", "", "# -- MultiServer/BungeeCord --", "# Si Brewery est ex\u00e9cut\u00e9 sur plusieurs serveurs connect\u00e9s (via BungeeCord), une base de donn\u00e9es partag\u00e9e peut \u00eatre utilis\u00e9e", "# ici pour synchroniser l'ivresse et pour pouvoir utiliser des boissons cod\u00e9es entre elles.", "", "multiServerDB:", "  # Si l'utilisation de la base de donn\u00e9es est activ\u00e9e", "  enabled: false", "  # Si l'ivresse des joueurs devait \u00eatre synchronis\u00e9e entre les serveurs", "  syncDrunkeness: true", "  host: localhost", "  port: '3306'", "  user: minec", "  password: xyz", "  database: base", "", "", "# -- Divers autres param\u00e8tres --", "", "# If items in Offhand should be added to the cauldron as well [false]", "useOffhandForCauldron: false");
    }

    private void update20en() {
        this.addLinesAt(new String[]{"hangoverDays", "colorInBrewer", "encodeKey"}, 1, "", "# If crafting and using of the Brew Sealing Table is enabled (2 Bottles over 4 Planks) [true, true]", "craftSealingTable: true", "enableSealingTable: true");
        this.addLinesAt(new String[]{"useLogBlock", "useGMInventories", "# -- Plugin Compatibility", "# # There are a lot of items in Minecraft", "version"}, 1, "", "", "# -- MultiServer/BungeeCord --", "# If Brewery is running on multiple connected Servers (via BungeeCord)", "# a shared Database can be used here to synchronise drunkenness and to be able to use encoded brews between them.", "", "multiServerDB:", "  # If using the Database is enabled", "  enabled: false", "  # If the drunkenness of players should be synchronised between Servers", "  syncDrunkeness: true", "  host: localhost", "  port: '3306'", "  user: minec", "  password: xyz", "  database: base", "", "", "# -- Various Other Settings --", "", "# If items in Offhand should be added to the cauldron as well [false]", "useOffhandForCauldron: false");
    }

    private void update21de() {
        int index = this.indexOfStart("# Wie viele Brewery Getr\u00e4nke in die Minecraft F\u00e4sser getan werden k\u00f6nnen");
        if (index != -1) {
            this.setLine(index, "# Ob das reifen in -Minecraft- F\u00e4ssern aktiviert ist und wie viele Brewery Getr\u00e4nke in die diese getan werden k\u00f6nnen [6]");
        }
        String add = "ageInMCBarrels: true";
        index = this.indexOfStart("maxBrewsInMCBarrels:");
        if (index != -1) {
            this.addLines(index, add);
        } else {
            this.addLinesAt(new String[]{"debug", "version"}, 1, "", add);
        }
        this.addLinesAt(new String[]{"# Hier kann angegeben werden welche Zutaten in den Kessel getan werden k\u00f6nnen"}, 1, "# Es braucht nur etwas hier eingetragen werden falls der Basistrank besondere Eigenschaften wie Name und Farbe haben soll");
        this.addLinesAt(new String[]{" # lore:", " # ingredients:"}, 1, " # customModelData: Custom Model Data Modelldaten. Mit dieser Zahl kann die Tranktextur mit einem Resourcepack ge\u00e4ndert werden");
        index = this.indexOfStart("# servercommands: Liste von Befehlen ausgef\u00fchrt vom Server wenn");
        if (index != -1) {
            this.setLine(index, "# servercommands: Liste von Befehlen ausgef\u00fchrt vom -Server- wenn der Trank getrunken wird (%player_name%  %quality% benutzbar)");
        }
        if ((index = this.indexOfStart("# playercommands: Liste von Befehlen ausgef\u00fchrt vom Spieler wenn")) != -1) {
            this.setLine(index, "# playercommands: Liste von Befehlen ausgef\u00fchrt vom -Spieler- wenn der Trank getrunken wird (%player_name%  %quality% benutzbar)");
        }
        this.addLinesAt(new String[]{"# drinktitle:", "# drinkmessage:", "# playercommands:", "# alcohol:"}, 1, "# customModelData: Custom Model Data Modelldaten. Mit dieser Zahl kann die Tranktextur mit einem Resourcepack ge\u00e4ndert werden", "#   Es kann eine f\u00fcr alle, oder drei f\u00fcr die qualit\u00e4ten schlecht/normal/gut agegeben werden, mit / getrennt");
        this.addLinesAt(new String[]{"useOffhandForCauldron:", "# -- Verschiedene weitere Einstellungen", "# -- Plugin Kompatiblit"}, 1, "", "# Of Fass- und Kesseldaten Async/im Hintergrund geladen werden k\u00f6nnen [true]", "loadDataAsync: true");
    }

    private void update21fr() {
        int index = this.indexOfStart("# Combien de boissons de brasserie peuvent");
        if (index != -1) {
            this.setLine(index, "# Combien de boissons de brasserie peuvent \u00eatre mises dans les barils -Minecraft- [6]");
        }
        String add = "ageInMCBarrels: true";
        index = this.indexOfStart("maxBrewsInMCBarrels:");
        if (index != -1) {
            this.addLines(index, add);
        } else {
            this.addLinesAt(new String[]{"debug", "version"}, 1, "", add);
        }
        this.addLinesAt(new String[]{"# Quels sont les ingr\u00e9dients accept\u00e9s par le chaudron"}, 1, "# Il vous suffit d'ajouter quelque chose ici si vous voulez sp\u00e9cifier un nom ou une couleur pour la potion de base");
        this.addLinesAt(new String[]{" # lore:", " # ingredients:"}, 1, " # customModelData: Custom Model Data Tag. This is a number that can be used to add custom textures to the item.");
        index = this.indexOfStart("# servercommands: Liste des commandes ex\u00e9cut\u00e9es par le serveur");
        if (index != -1) {
            this.setLine(index, "# servercommands: Liste des commandes ex\u00e9cut\u00e9es par le -serveur- lors de la consommation de la potion (Peut utiliser %player_name%  %quality%)");
        }
        if ((index = this.indexOfStart("# playercommands: Liste des commandes ex\u00e9cut\u00e9es par le joueur")) != -1) {
            this.setLine(index, "# playercommands: Liste des commandes ex\u00e9cut\u00e9es par le -joueur- lors de la consommation de la potion (Peut utiliser %player_name%  %quality%)");
        }
        this.addLinesAt(new String[]{"# drinktitle:", "# drinkmessage:", "# playercommands:", "# alcohol:"}, 1, "# customModelData: Custom Model Data Tag. This is a number that can be used to add custom textures to the item.", "#   Can specify one for all, or one for each quality, separated by /");
        this.addLinesAt(new String[]{"useOffhandForCauldron:", "# -- Divers autres param", "# -- Compatibilit\u00e9 entre Plugins"}, 1, "", "# If Barrel and Cauldron data can be loaded Async/in the Background [true]", "loadDataAsync: true");
    }

    private void update21en() {
        int index = this.indexOfStart("# How many Brewery drinks can be put into");
        if (index != -1) {
            this.setLine(index, "# If aging in -Minecraft- Barrels in enabled [true] and how many Brewery drinks can be put into them [6]");
        }
        String add = "ageInMCBarrels: true";
        index = this.indexOfStart("maxBrewsInMCBarrels:");
        if (index != -1) {
            this.addLines(index, add);
        } else {
            this.addLinesAt(new String[]{"debug", "version"}, 1, "", add);
        }
        this.addLinesAt(new String[]{"# Which Ingredients are accepted by the Cauldron and the base potion resulting"}, 1, "# You only need to add something here if you want to specify a custom name or color for the base potion");
        this.addLinesAt(new String[]{" # lore:", " # ingredients:"}, 1, " # customModelData: Custom Model Data Tag. This is a number that can be used to add custom textures to the item.");
        index = this.indexOfStart("# servercommands: List of Commands executed by the Server when drinking");
        if (index != -1) {
            this.setLine(index, "# servercommands: List of Commands executed by the -Server- when drinking the brew (Can use %player_name%  %quality%)");
        }
        if ((index = this.indexOfStart("# playercommands: List of Commands executed by the Player when drinking the brew")) != -1) {
            this.setLine(index, "# playercommands: List of Commands executed by the -Player- when drinking the brew (Can use %player_name%  %quality%)");
        }
        this.addLinesAt(new String[]{"# drinktitle:", "# drinkmessage:", "# playercommands:", "# alcohol:"}, 1, "# customModelData: Custom Model Data Tag. This is a number that can be used to add custom textures to the item.", "#   Can specify one for all, or one for each quality, separated by /");
        this.addLinesAt(new String[]{"useOffhandForCauldron:", "# -- Various Other Settings", "# -- Plugin Compatibility"}, 1, "", "# If Barrel and Cauldron data can be loaded Async/in the Background [true]", "loadDataAsync: true");
    }

    private void update30CauldronParticles() {
        int start = this.config.indexOf("cauldron:");
        int end = this.config.indexOf("recipes:");
        if (start < 0 || end < 0 || start >= end) {
            return;
        }
        String c = "    cookParticles:";
        ArrayList<Tuple<String[], String[]>> additions = new ArrayList<Tuple<String[], String[]>>();
        additions.add(new Tuple<String[], String[]>(new String[]{"  ex:", "  bsp:"}, new String[]{c, "      - 'RED/5'", "      - 'WHITE/10'", "      - '800000/25' # maroon"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  wheat:", "  wheat:"}, new String[]{c, "      - '2d8686/8' # Dark Aqua"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  sugarcane:"}, new String[]{c, "      - 'f1ffad/4'", "      - '858547/10' # dark olive"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  sugar:"}, new String[]{c, "      - 'WHITE/4'", "      - 'BRIGHT_GREY/25'"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  berries:"}, new String[]{c, "      - 'ff6666/2' # bright red", "      - 'RED/7'", "      - 'ac6553/13' # brown-red"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  grass:"}, new String[]{c, "      - 'GREEN/2'", "      - '99ff99/20' # faded green"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  rmushroom:"}, new String[]{c, "      - 'fab09e/15' # faded red"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  bmushroom:"}, new String[]{c, "      - 'c68c53/15'"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  cocoa:"}, new String[]{c, "      - 'a26011/1'", "      - '5c370a/3'", "      - '4d4133/8' # Gray-brown"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  milk:"}, new String[]{c, "      - 'fbfbd0/1' # yellow-white", "      - 'WHITE/6'"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  bl_flow:"}, new String[]{c, "      - '0099ff'"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  cactus:"}, new String[]{c, "      - '00b300/16'"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  vine:"}, new String[]{c, "      - 'GREEN/2'", "      - '99ff99/20' # faded green"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  rot_flesh:"}, new String[]{c, "      - '263300/8'", "      - 'BLACK/20'"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  cookie:"}, new String[]{c, "      - 'a26011/1'", "      - '5c370a/3'", "      - '4d4133/8' # Gray-brown"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  Gold_Nugget:"}, new String[]{c, "      - 'ffd11a'"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  glowstone_dust:"}, new String[]{c, "      - 'ffff99/3'", "      - 'd9d926/15' # faded yellow"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  applemead_base:", "  apfelmet_basis:"}, new String[]{c, "      - 'e1ff4d/4'"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  poi_grass:"}, new String[]{c, "      - 'GREEN/2'", "      - '99ff99/20' # faded green"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  juniper:"}, new String[]{c, "      - '00ccff/8'"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  gin_base:"}, new String[]{c, "      - 'c68c53/15'"}));
        additions.add(new Tuple<String[], String[]>(new String[]{"  eggnog_base:"}, new String[]{c, "      - 'ffecb3/2'"}));
        for (Tuple tuple : additions) {
            end = this.config.indexOf("recipes:");
            int index = this.indexOfStart(((String[])tuple.a())[0]);
            if (index == -1 && ((String[])tuple.a()).length > 1) {
                index = this.indexOfStart(((String[])tuple.a())[1]);
            }
            if (index < start || index > end || !this.config.get(++index).startsWith("    name:")) continue;
            if (this.config.get(++index).startsWith("    ingredients:")) {
                if (this.config.get(index + 1).startsWith("    color:")) {
                    index += 2;
                } else if (this.config.get(index + 1).equals("")) {
                    ++index;
                }
            }
            this.addLines(index, (String[])tuple.b());
        }
    }

    private void update30de() {
        this.addLinesAt(new String[]{"pukeDespawntime:", "enableKickOnOverdrink:", "language:"}, 1, "", "# Wie stark in Prozent der Spieler taumelt, je nach dem wie viel Alkohol er getrunken hat. Kann auf 0 und h\u00f6her als 100 gesetzt werden", "stumblePercent: 100", "", "# Ob seine Betrunkenheit dem Spieler kurz angezeigt werden soll wenn er etwas trinkt oder ein drainItem isst. [true]", "showStatusOnDrink: true");
        this.addLinesAt(new String[]{"hangoverDays:", "enableSealingTable:", "showStatusOnDrink:"}, 1, "", "# Partikel steigen von Kesseln auf wenn sie Zutaten und eine Feuerquelle haben [true]", "# Die sich \u00e4ndernde Farbe der Partikel kann beim Fermentieren mancher Rezepte helfen", "enableCauldronParticles: true");
        this.addLinesAt(new String[]{" #   Oder RGB Farben", " #   Eine Liste von allen Materialien", " # lore: Auflistung von zus\u00e4tzlichem Text"}, 1, " # cookParticles:", " #   Farbe der Partikel \u00fcber dem Kessel w\u00e4hrend verschiedener Kochzeiten", " #   Farbe und Minute w\u00e4hrend die Farbe erscheinen soll. Z.B. eine Farbe bei 8 Minuten, \u00fcbergehend zu einer anderen bei 18 minuten", " #   Als Liste, jede Farbe als Name oder RGB wie oben. Geschrieben 'Farbe/Minute'", " #   Zum Ende geht es in die letzte Farbe \u00fcber, gibt es nur eine Farbe in der Liste, wird es von dieser langsam zu grau.");
        int index = this.indexOfStart("# wood: Holz des Fasses 0=alle Holzsorten 1=Birke 2=Eiche");
        if (index > -1) {
            this.setLine(index, "# wood: Holz des Fasses 0=alle Holzsorten 1=Birke 2=Eiche 3=Jungel 4=Fichte 5=Akazie 6=Schwarzeiche 7=Karmesin 8=Wirr");
        }
        this.addLinesAt(new String[]{"# playercommands: Liste von Befehlen ausgef\u00fchrt vom -Spieler-", "# drinktitle: Nachricht als Titel"}, 1, false, "#   Befehle nur f\u00fcr bestimmte Qualit\u00e4t m\u00f6glich mit + Schlecht, ++ Mittel, +++ Gut, vorne anh\u00e4ngen.");
        this.addLinesAt(new String[]{"# Andere Plugins (wenn installiert) nach Rechten zum \u00f6ffnen von F\u00e4ssern checken"}, 1, false, "# Plugins 'Landlord' und 'Protection Stones' nutzen WorldGuard. 'ClaimChunk' wird nativ unterst\u00fctzt.");
        this.addLinesAt(new String[]{"useGriefPrevention:", "useLWC:", "useWorldGuard:"}, 1, "useTowny: true", "useBlockLocker: true");
        this.addLinesAt(new String[]{"useGMInventories:", "# Plugins 'Landlord' und 'Prote", "# -- Plugin Kompatiblit\u00e4t --"}, 1, "", "# Beim Fass \u00f6ffnen eine virtuelle Kiste nutzen um Rechte bei allen anderen Plugins abzufragen", "# K\u00f6nnte Anti-Cheat plugins verwirren aber sonst ok zu aktivieren", "# Diese Option f\u00fcr das Plugin 'Residence' aktivieren, und andere Plugins, die nicht alle F\u00e4lle des PlayerInteractEvent checken", "useVirtualChestPerms: false", "");
        this.addLinesAt(new String[]{"loadDataAsync:", "useOffhandForCauldron:", "# -- Verschiedene weitere", "useLogBlock:"}, 1, "", "# Ob nur ein Minimum an Kessel-Partikeln dargestellt werden sollen [false]", "minimalParticles: false");
    }

    private void update30en() {
        this.addLinesAt(new String[]{"pukeDespawntime:", "enableKickOnOverdrink:", "language:"}, 1, "", "# How much the Player stumbles depending on the amount of alcohol he drank. Can be set to 0 and higher than 100 [100]", "stumblePercent: 100", "", "# Display his drunkenness to the player when he drinks a brew or eats a drainItem [true]", "showStatusOnDrink: true");
        this.addLinesAt(new String[]{"hangoverDays:", "enableSealingTable:", "showStatusOnDrink:"}, 1, "", "# Show Particles over Cauldrons when they have ingredients and a heat source. [true]", "# The changing color of the particles can help with timing some recipes", "enableCauldronParticles: true");
        this.addLinesAt(new String[]{" #   Or RGB colors", " #   A list of materials can be found", " # lore: "}, 1, " # cookParticles:", " #   Color of the Particles above the cauldron at different cooking-times", " #   Color and minute during which each color should appear, i.e. one color at 8 minutes fading to another at 18 minutes.", " #   As List, each Color as name or RGB, see above. Written as 'Color/Minute'", " #   It will fade to the last color in the end, if there is only one color in the list, it will fade to grey");
        int index = this.indexOfStart("# wood: Wood of the barrel 0=any 1=Birch 2=Oak");
        if (index > -1) {
            this.setLine(index, "# wood: Wood of the barrel 0=any 1=Birch 2=Oak 3=Jungle 4=Spruce 5=Acacia 6=Dark Oak 7=Crimson 8=Warped");
        }
        this.addLinesAt(new String[]{"# playercommands: "}, 1, false, "#   Specific Commands for quality possible, using + bad, ++ normal, +++ good, added to the front of the line.");
        this.addLinesAt(new String[]{"# Enable checking of other Plugins (if installed) for"}, 1, false, "# Plugins 'Landlord' and 'Protection Stones' use the WorldGuard Flag. 'ClaimChunk' is natively supported.");
        this.addLinesAt(new String[]{"useGriefPrevention:", "useLWC:", "useWorldGuard:"}, 1, "useTowny: true", "useBlockLocker: true");
        this.addLinesAt(new String[]{"useGMInventories:", "# Plugins 'Landlord' and 'Protectio", "# -- Plugin Compatibility --"}, 1, "", "# Use a virtual chest when opening a Barrel to check with all other protection plugins", "# This could confuse Anti-Cheat plugins, but is otherwise good to use", "# use this for 'Residence' Plugin and any others that don't check all cases in the PlayerInteractEvent", "useVirtualChestPerms: false", "");
        this.addLinesAt(new String[]{"loadDataAsync:", "useOffhandForCauldron:", "# -- Various Other Settings", "useLogBlock:"}, 1, "", "# If Cauldron Particles should be reduced to the bare minimum [false]", "minimalParticles: false");
    }

    private void update31en() {
        this.addLinesAt(new String[]{"minimalParticles:", "loadDataAsync:", "openLargeBarrelEverywhere:", "colorInBrewer:"}, 1, "", "# Allow emptying brews into hoppers to discard brews while keeping the glass bottle [true]", "brewHopperDump: true");
    }

    private void update31de() {
        this.addLinesAt(new String[]{"minimalParticles:", "loadDataAsync:", "openLargeBarrelEverywhere:", "colorInBrewer:"}, 1, "", "# Ob das Entleeren von Brewery Tr\u00e4nken mit Hilfe von Trichtern m\u00f6glich ist, um die Glasflasche zur\u00fcck zu bekommen [true]", "brewHopperDump: true");
    }

    private void convertCookedSection(FileConfiguration yml, int toLine) {
        ConfigurationSection cookedSection = yml.getConfigurationSection("cooked");
        if (cookedSection != null) {
            for (String ing : cookedSection.getKeys(false)) {
                String name = cookedSection.getString(ing);
                this.addLines(toLine, "  " + ing.toLowerCase() + ":", "    name: " + name, "    ingredients:", "      - " + ing, "");
                toLine += 5;
            }
            int index = this.indexOfStart("cooked:");
            if (index != -1) {
                for (int size = cookedSection.getKeys(false).size(); size >= 0; --size) {
                    this.removeLine(index);
                }
            }
        }
    }

    public void applyPatch(String resourcePath, int toLine) {
        try {
            String currentLine;
            ArrayList<String> patch = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(BreweryPlugin.getInstance().getResource(resourcePath), "Resource not found")));
            while ((currentLine = reader.readLine()) != null) {
                patch.add(currentLine);
            }
            reader.close();
            this.config.addAll(toLine, patch);
        }
        catch (IOException | NullPointerException e) {
            BreweryPlugin.getInstance().errorLog("Could not apply Patch: " + resourcePath);
            e.printStackTrace();
        }
    }

    private void updateMaterials(boolean toMC113) {
        int endIndex;
        String line;
        int index;
        if (toMC113) {
            index = this.indexOfStart("oldMat:");
            if (index != -1) {
                this.removeLine(index);
            }
        } else {
            index = this.indexOfStart("version:");
            if (index != -1) {
                this.addLines(index + 1, "oldMat: true");
            }
        }
        if ((index = this.indexOfStart("pukeItem: ")) != -1 && (line = this.config.get(index)).length() > 10) {
            this.setLine(index, this.convertMaterial(line, "pukeItem: ", "", toMC113));
        }
        if ((index = this.indexOfStart("drainItems:")) != -1) {
            ++index;
            while (this.config.get(index).startsWith("-")) {
                this.setLine(index, this.convertMaterial(this.config.get(index), "- ", "(,.*|)/.*", toMC113));
                ++index;
            }
        }
        if ((index = this.indexOfStart("recipes:")) != -1) {
            endIndex = this.indexOfStart("useWorldGuard:");
            if (endIndex < ++index) {
                endIndex = this.indexOfStart("enableChatDistortion:");
            }
            if (endIndex < index) {
                endIndex = this.indexOfStart("words:");
            }
            if (endIndex < index) {
                endIndex = this.config.size();
            }
            while (index < endIndex) {
                if (this.config.get(index).matches("^\\s+ingredients:.*")) {
                    ++index;
                    while (this.config.get(index).matches("^\\s+- .+")) {
                        line = this.config.get(index);
                        this.setLine(index, this.convertMaterial(line, "^\\s+- ", "(,.*|)/.*", toMC113));
                        ++index;
                    }
                } else if (this.config.get(index).startsWith("cooked:")) {
                    ++index;
                    while (this.config.get(index).matches("^\\s\\s+.+")) {
                        line = this.config.get(index);
                        this.setLine(index, this.convertMaterial(line, "^\\s\\s+", ":.*", toMC113));
                        ++index;
                    }
                }
                ++index;
            }
        }
        if ((index = this.indexOfStart("cauldron:")) != -1) {
            endIndex = this.indexOfStart("recipes:");
            if (endIndex < ++index) {
                endIndex = this.indexOfStart("      cookingtime:");
            }
            if (endIndex < index) {
                endIndex = this.indexOfStart("useWorldGuard:");
            }
            while (index < endIndex) {
                if (this.config.get(index).matches("^\\s+ingredients:.*")) {
                    ++index;
                    while (this.config.get(index).matches("^\\s+- .+")) {
                        line = this.config.get(index);
                        this.setLine(index, this.convertMaterial(line, "^\\s+- ", "(,.*|)/.*", toMC113));
                        ++index;
                    }
                }
                ++index;
            }
        }
    }

    private String convertMaterial(String line, String regexPrefix, String regexPostfix, boolean toMC113) {
        if (!toMC113) {
            return this.convertIdtoMaterial(line, regexPrefix, regexPostfix);
        }
        String mat = line.replaceFirst(regexPrefix, "").replaceFirst(regexPostfix, "");
        Material material = mat.equalsIgnoreCase("LONG_GRASS") ? Material.GRASS : Material.matchMaterial((String)mat, (boolean)true);
        if (material == null) {
            return line;
        }
        String matnew = material.name();
        if (!mat.equalsIgnoreCase(matnew)) {
            return line.replaceAll(mat, matnew);
        }
        return line;
    }

    private String convertIdtoMaterial(String line, String regexPrefix, String regexPostfix) {
        String idString = line.replaceFirst(regexPrefix, "").replaceFirst(regexPostfix, "");
        int id = BreweryPlugin.getInstance().parseInt(idString);
        if (id > 0) {
            Material material = LegacyUtil.getMaterial(id);
            if (material == null) {
                BreweryPlugin.getInstance().errorLog("Could not find Material with id: " + line);
                return line;
            }
            return line.replaceAll(idString, material.name());
        }
        return line;
    }

    private void updateMaterialDescriptions(boolean de) {
        if (de) {
            int index = this.indexOfStart("# ingredients: Auflistung von 'Material,Data/Anzahl'");
            if (index != -1) {
                this.setLine(index, "# ingredients: Auflistung von 'Material/Anzahl'");
            }
            if ((index = this.indexOfStart("#   Es kann ein Data-Wert (durability) angegeben werden")) != -1) {
                this.removeLine(index);
            }
            if ((index = this.indexOfStart("#   Wenn Vault installiert ist")) != -1) {
                this.removeLine(index);
            }
            if ((index = this.indexOfStart("#   Vault erkennt Namen wie")) != -1) {
                this.removeLine(index);
            }
            if ((index = this.indexOfStart("#     - Jungle Leaves/64  # Nur mit Vault")) != -1) {
                this.removeLine(index);
            }
            if ((index = this.indexOfStart("#     - Green Dye/6       # Nur mit Vault")) != -1) {
                this.removeLine(index);
            }
            if ((index = this.indexOfStart("#   Ein 'X' an den Namen")) != -1) {
                this.removeLine(index);
            }
            if ((index = this.indexOfStart("#   Effekte sind ab der 1.9 immer verborgen")) != -1) {
                this.removeLine(index);
            }
        } else {
            int index = this.indexOfStart("# ingredients: List of 'material,data/amount'");
            if (index != -1) {
                this.setLine(index, "# ingredients: List of 'material/amount'");
            }
            if ((index = this.indexOfStart("#   You can specify a data (durability) value")) != -1) {
                this.removeLine(index);
            }
            if ((index = this.indexOfStart("#   If Vault is installed normal names can be used")) != -1) {
                this.removeLine(index);
            }
            if ((index = this.indexOfStart("#   Vault will recognize things")) != -1) {
                this.removeLine(index);
            }
            if ((index = this.indexOfStart("#     - Jungle Leaves/64  # Only with Vault")) != -1) {
                this.removeLine(index);
            }
            if ((index = this.indexOfStart("#     - Green Dye/6       # Only with Vault")) != -1) {
                this.removeLine(index);
            }
            if ((index = this.indexOfStart("#   Suffix name with 'X' to hide effect")) != -1) {
                this.removeLine(index);
            }
            if ((index = this.indexOfStart("#   Effects are always hidden in 1.9 and newer")) != -1) {
                this.removeLine(index);
            }
        }
    }
}

