/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.filedata;

import com.dre.brewery.BSealer;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.DistortChat;
import com.dre.brewery.MCBarrel;
import com.dre.brewery.api.events.ConfigLoadEvent;
import com.dre.brewery.filedata.ConfigUpdater;
import com.dre.brewery.filedata.LanguageReader;
import com.dre.brewery.integration.barrel.BlocklockerBarrel;
import com.dre.brewery.integration.barrel.WGBarrel;
import com.dre.brewery.integration.barrel.WGBarrel5;
import com.dre.brewery.integration.barrel.WGBarrel6;
import com.dre.brewery.integration.barrel.WGBarrel7;
import com.dre.brewery.integration.item.BreweryPluginItem;
import com.dre.brewery.integration.item.ItemsAdderPluginItem;
import com.dre.brewery.integration.item.MMOItemsPluginItem;
import com.dre.brewery.integration.item.OraxenPluginItem;
import com.dre.brewery.integration.item.SlimefunPluginItem;
import com.dre.brewery.recipe.BCauldronRecipe;
import com.dre.brewery.recipe.BRecipe;
import com.dre.brewery.recipe.PluginItem;
import com.dre.brewery.recipe.RecipeItem;
import com.dre.brewery.storage.DataManagerType;
import com.dre.brewery.storage.records.ConfiguredDataManager;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.MinecraftVersion;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.milkbowl.vault.item.ItemInfo;
import net.milkbowl.vault.item.Items;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class BConfig {
    public static final BreweryPlugin breweryPlugin = BreweryPlugin.getInstance();
    private static final MinecraftVersion VERSION = BreweryPlugin.getMCVersion();
    public static final String configVersion = "3.1";
    public static CommandSender reloader;
    public static boolean updateCheck;
    public static ConfiguredDataManager configuredDataManager;
    public static int autoSaveInterval;
    public static boolean useWG;
    public static WGBarrel wg;
    public static boolean useLWC;
    public static boolean useLB;
    public static boolean useGP;
    public static boolean useTowny;
    public static boolean useBlocklocker;
    public static boolean hasVault;
    public static boolean useCitadel;
    public static boolean useGMInventories;
    public static boolean hasSlimefun;
    public static Boolean hasMMOItems;
    public static boolean hasChestShop;
    public static boolean hasShopKeepers;
    public static boolean hasOraxen;
    public static boolean hasItemsAdder;
    public static boolean openEverywhere;
    public static boolean loadDataAsync;
    public static boolean virtualChestPerms;
    public static int agingYearDuration;
    public static boolean requireKeywordOnSigns;
    public static boolean useOffhandForCauldron;
    public static boolean enableCauldronParticles;
    public static boolean minimalParticles;
    public static Map<Material, Integer> drainItems;
    public static List<Material> pukeItem;
    public static boolean showStatusOnDrink;
    public static int pukeDespawntime;
    public static float stumbleModifier;
    public static int hangoverTime;
    public static boolean overdrinkKick;
    public static boolean enableHome;
    public static boolean enableLoginDisallow;
    public static boolean enablePuke;
    public static String homeType;
    public static boolean enableWake;
    public static boolean colorInBarrels;
    public static boolean colorInBrewer;
    public static boolean enableEncode;
    public static boolean alwaysShowQuality;
    public static boolean alwaysShowAlc;
    public static boolean showBrewer;
    public static boolean brewHopperDump;
    public static boolean craftSealingTable;
    public static boolean enableSealingTable;
    public static String pluginPrefix;
    public static List<RecipeItem> customItems;

    private static boolean createConfigs() {
        File cfg = new File(breweryPlugin.getDataFolder(), "config.yml");
        if (!cfg.exists()) {
            breweryPlugin.log("\u00a71\u00a7lNo config.yml found, creating default file! You may want to choose a config according to your language!");
            breweryPlugin.log("\u00a71\u00a7lYou can find them in plugins/Brewery/configs/");
            breweryPlugin.log("\u00a71\u00a7lJust copy the config for your language into the Brewery folder and /brew reload");
            InputStream defconf = breweryPlugin.getResource("config/" + (VERSION.isOrLater(MinecraftVersion.V1_13) ? "v13/" : "v12/") + "en/config.yml");
            if (defconf == null) {
                breweryPlugin.errorLog("default config file not found, your jarfile may be corrupt. Disabling Brewery!");
                return false;
            }
            try {
                BUtil.saveFile(defconf, breweryPlugin.getDataFolder(), "config.yml", false);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (!cfg.exists()) {
            breweryPlugin.errorLog("default config file could not be copied, your jarfile may be corrupt. Disabling Brewery!");
            return false;
        }
        BConfig.copyDefaultConfigAndLangs(false);
        return true;
    }

    private static void copyDefaultConfigAndLangs(boolean overwrite) {
        File configs = new File(breweryPlugin.getDataFolder(), "configs");
        File languages = new File(breweryPlugin.getDataFolder(), "languages");
        ArrayList<String> configTypes = new ArrayList<String>(List.of("de", "en", "es", "fr", "it", "zh"));
        ArrayList<String> langTypes = new ArrayList<String>(List.of("de", "en", "es", "fr", "it", "ru", "tw", "zh"));
        if (VERSION.isOrEarlier(MinecraftVersion.V1_13)) {
            configTypes.removeAll(List.of("es", "it", "zh"));
        }
        for (String l : configTypes) {
            try {
                BUtil.saveFile(breweryPlugin.getResource("config/" + (VERSION.isOrLater(MinecraftVersion.V1_13) ? "v13/" : "v12/") + l + "/config.yml"), new File(configs, l), "config.yml", overwrite);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (String type : langTypes) {
            try {
                BUtil.saveFile(breweryPlugin.getResource("languages/" + type + ".yml"), languages, type + ".yml", false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static FileConfiguration loadConfigFile() {
        File file = new File(breweryPlugin.getDataFolder(), "config.yml");
        if (!BConfig.createConfigs()) {
            return null;
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public static void readConfig(FileConfiguration config) {
        Object recipe;
        Iterator<BCauldronRecipe> configRecipes;
        configuredDataManager = new ConfiguredDataManager(DataManagerType.valueOf(config.getString("storage.type", "FLATFILE").toUpperCase()), config.getString("storage.database", "brewery-data"), config.getString("storage.tablePrefix", "brewery_"), config.getString("storage.address"), config.getString("storage.username"), config.getString("storage.password"));
        autoSaveInterval = config.getInt("autosave", 3);
        BConfig.breweryPlugin.language = config.getString("language", "en");
        BConfig.breweryPlugin.languageReader = new LanguageReader(new File(breweryPlugin.getDataFolder(), "languages/" + BConfig.breweryPlugin.language + ".yml"), "languages/" + BConfig.breweryPlugin.language + ".yml");
        boolean oldMat = config.getBoolean("oldMat", false);
        String version = config.getString("version", null);
        if (version != null && (!version.equals(configVersion) || oldMat && VERSION.isOrLater(MinecraftVersion.V1_13))) {
            File file = new File(BreweryPlugin.getInstance().getDataFolder(), "config.yml");
            BConfig.copyDefaultConfigAndLangs(true);
            new ConfigUpdater(file).update(version, oldMat, BConfig.breweryPlugin.language, config);
            BreweryPlugin.getInstance().log("Config Updated to version: 3.1");
            config = YamlConfiguration.loadConfiguration((File)file);
        }
        updateCheck = config.getBoolean("updateCheck", false);
        PluginManager plMan = breweryPlugin.getServer().getPluginManager();
        useWG = config.getBoolean("useWorldGuard", true) && plMan.isPluginEnabled("WorldGuard");
        useLWC = config.getBoolean("useLWC", true) && plMan.isPluginEnabled("LWC");
        useTowny = config.getBoolean("useTowny", true) && plMan.isPluginEnabled("Towny");
        useGP = config.getBoolean("useGriefPrevention", true) && plMan.isPluginEnabled("GriefPrevention");
        useLB = config.getBoolean("useLogBlock", false) && plMan.isPluginEnabled("LogBlock");
        useGMInventories = config.getBoolean("useGMInventories", false);
        useCitadel = config.getBoolean("useCitadel", false) && plMan.isPluginEnabled("Citadel");
        useBlocklocker = config.getBoolean("useBlockLocker", false) && plMan.isPluginEnabled("BlockLocker");
        virtualChestPerms = config.getBoolean("useVirtualChestPerms", false);
        hasVault = plMan.isPluginEnabled("Vault") && Integer.parseInt(plMan.getPlugin("Vault").getDescription().getVersion().split("\\.")[1]) <= 6;
        hasChestShop = plMan.isPluginEnabled("ChestShop");
        hasShopKeepers = plMan.isPluginEnabled("Shopkeepers");
        hasSlimefun = plMan.isPluginEnabled("Slimefun");
        hasOraxen = plMan.isPluginEnabled("Oraxen");
        hasItemsAdder = plMan.isPluginEnabled("ItemsAdder");
        BreweryPlugin.debug = config.getBoolean("debug", false);
        pukeItem = !config.getStringList("pukeItem").isEmpty() ? config.getStringList("pukeItem").stream().map(BUtil::getMaterialSafely).collect(Collectors.toList()) : List.of(BUtil.getMaterialSafely(config.getString("pukeItem")));
        hangoverTime = config.getInt("hangoverDays", 0) * 24 * 60;
        overdrinkKick = config.getBoolean("enableKickOnOverdrink", false);
        enableHome = config.getBoolean("enableHome", false);
        enableLoginDisallow = config.getBoolean("enableLoginDisallow", false);
        enablePuke = config.getBoolean("enablePuke", false);
        pukeDespawntime = config.getInt("pukeDespawntime", 60) * 20;
        stumbleModifier = (float)config.getInt("stumblePercent", 100) / 100.0f;
        showStatusOnDrink = config.getBoolean("showStatusOnDrink", false);
        homeType = config.getString("homeType", null);
        enableWake = config.getBoolean("enableWake", false);
        craftSealingTable = config.getBoolean("craftSealingTable", false);
        enableSealingTable = config.getBoolean("enableSealingTable", false);
        pluginPrefix = config.getString("pluginPrefix", "&2[Brewery]&f ");
        colorInBarrels = config.getBoolean("colorInBarrels", false);
        colorInBrewer = config.getBoolean("colorInBrewer", false);
        alwaysShowQuality = config.getBoolean("alwaysShowQuality", false);
        alwaysShowAlc = config.getBoolean("alwaysShowAlc", false);
        showBrewer = config.getBoolean("showBrewer", false);
        enableEncode = config.getBoolean("enableEncode", false);
        openEverywhere = config.getBoolean("openLargeBarrelEverywhere", false);
        enableCauldronParticles = VERSION.isOrLater(MinecraftVersion.V1_9) && config.getBoolean("enableCauldronParticles", false);
        minimalParticles = config.getBoolean("minimalParticles", false);
        useOffhandForCauldron = config.getBoolean("useOffhandForCauldron", false);
        loadDataAsync = config.getBoolean("loadDataAsync", true);
        brewHopperDump = config.getBoolean("brewHopperDump", false);
        agingYearDuration = config.getInt("agingYearDuration", 20);
        requireKeywordOnSigns = config.getBoolean("requireKeywordOnSigns", true);
        if (VERSION.isOrLater(MinecraftVersion.V1_14)) {
            MCBarrel.maxBrews = config.getInt("maxBrewsInMCBarrels", 6);
            MCBarrel.enableAging = config.getBoolean("ageInMCBarrels", true);
        }
        Brew.loadSeed((ConfigurationSection)config, new File(BreweryPlugin.getInstance().getDataFolder(), "config.yml"));
        if (VERSION.isOrEarlier(MinecraftVersion.V1_13)) {
            loadDataAsync = false;
        }
        PluginItem.registerForConfig("brewery", BreweryPluginItem::new);
        PluginItem.registerForConfig("mmoitems", MMOItemsPluginItem::new);
        PluginItem.registerForConfig("slimefun", SlimefunPluginItem::new);
        PluginItem.registerForConfig("exoticgarden", SlimefunPluginItem::new);
        PluginItem.registerForConfig("oraxen", OraxenPluginItem::new);
        PluginItem.registerForConfig("itemsadder", ItemsAdderPluginItem::new);
        ConfigurationSection configSection = config.getConfigurationSection("customItems");
        if (configSection != null) {
            for (String string : configSection.getKeys(false)) {
                RecipeItem custom = RecipeItem.fromConfigCustom(configSection, string);
                if (custom != null) {
                    custom.makeImmutable();
                    customItems.add(custom);
                    continue;
                }
                breweryPlugin.errorLog("Loading the Custom Item with id: '" + string + "' failed!");
            }
        }
        if ((configSection = config.getConfigurationSection("recipes")) != null) {
            configRecipes = BRecipe.getConfigRecipes();
            for (String recipeId : configSection.getKeys(false)) {
                recipe = BRecipe.fromConfig(configSection, recipeId);
                if (recipe != null && ((BRecipe)recipe).isValid()) {
                    configRecipes.add((BCauldronRecipe)recipe);
                    continue;
                }
                breweryPlugin.errorLog("Loading the Recipe with id: '" + recipeId + "' failed!");
            }
            BRecipe.numConfigRecipes = configRecipes.size();
        }
        if ((configSection = config.getConfigurationSection("cauldron")) != null) {
            configRecipes = BCauldronRecipe.getConfigRecipes();
            for (String id : configSection.getKeys(false)) {
                recipe = BCauldronRecipe.fromConfig(configSection, id);
                if (recipe != null) {
                    configRecipes.add((BCauldronRecipe)recipe);
                    continue;
                }
                breweryPlugin.errorLog("Loading the Cauldron-Recipe with id: '" + id + "' failed!");
            }
            BCauldronRecipe.numConfigRecipes = configRecipes.size();
        }
        for (BRecipe bRecipe : BRecipe.getAddedRecipes()) {
            bRecipe.updateAcceptedLists();
        }
        for (BCauldronRecipe bCauldronRecipe : BCauldronRecipe.getAddedRecipes()) {
            bCauldronRecipe.updateAcceptedLists();
        }
        List drainList = config.getStringList("drainItems");
        for (String drainString : drainList) {
            String[] drainSplit = drainString.split("/");
            if (drainSplit.length <= 1) continue;
            Material mat = BUtil.getMaterialSafely(drainSplit[0]);
            int strength = breweryPlugin.parseInt(drainSplit[1]);
            if (mat == null && hasVault && strength > 0) {
                try {
                    ItemInfo vaultItem = Items.itemByString((String)drainSplit[0]);
                    if (vaultItem != null) {
                        mat = vaultItem.getType();
                    }
                }
                catch (Exception e) {
                    BreweryPlugin.getInstance().errorLog("Could not check vault for Item Name");
                    e.printStackTrace();
                }
            }
            if (mat == null || strength <= 0) continue;
            drainItems.put(mat, strength);
        }
        DistortChat.words = new ArrayList<DistortChat>();
        DistortChat.ignoreText = new ArrayList<String[]>();
        if (config.getBoolean("enableChatDistortion", false)) {
            for (Map map : config.getMapList("words")) {
                new DistortChat(map);
            }
            for (String bypass : config.getStringList("distortBypass")) {
                DistortChat.ignoreText.add(bypass.split(","));
            }
            DistortChat.commands = config.getStringList("distortCommands");
        }
        DistortChat.log = config.getBoolean("logRealChat", false);
        DistortChat.doSigns = config.getBoolean("distortSignText", false);
        if (VERSION.isOrLater(MinecraftVersion.V1_14)) {
            if (craftSealingTable && !BSealer.recipeRegistered) {
                BSealer.registerRecipe();
            } else if (!craftSealingTable && BSealer.recipeRegistered) {
                BSealer.unregisterRecipe();
            }
        }
        if (useWG) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin("WorldEdit");
            if (plugin != null) {
                String wgv = plugin.getDescription().getVersion();
                wg = wgv.startsWith("6.") ? new WGBarrel6() : (wgv.startsWith("5.") ? new WGBarrel5() : new WGBarrel7());
            }
            if (wg == null) {
                BreweryPlugin.getInstance().errorLog("Failed loading WorldGuard Integration! Opening Barrels will NOT work!");
                BreweryPlugin.getInstance().errorLog("Brewery was tested with version 5.8, 6.1 and 7.0 of WorldGuard!");
                BreweryPlugin.getInstance().errorLog("Disable the WorldGuard support in the config and do /brew reload");
            }
        }
        if (useBlocklocker) {
            try {
                Class.forName("nl.rutgerkok.blocklocker.BlockLockerAPIv2");
                Class.forName("nl.rutgerkok.blocklocker.ProtectableBlocksSettings");
                BlocklockerBarrel.registerBarrelAsProtectable();
            }
            catch (ClassNotFoundException classNotFoundException) {
                useBlocklocker = false;
                BreweryPlugin.getInstance().log("Unsupported Version of 'BlockLocker', locking Brewery Barrels disabled");
            }
        }
        ConfigLoadEvent configLoadEvent = new ConfigLoadEvent();
        BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)configLoadEvent);
    }

    static {
        hasMMOItems = null;
        drainItems = new HashMap<Material, Integer>();
        pluginPrefix = "&2[BreweryX]&f ";
        customItems = new ArrayList<RecipeItem>();
    }
}

