/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.commands;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.commands.CommandUtil;
import com.dre.brewery.commands.SubCommand;
import com.dre.brewery.commands.subcommands.CopyCommand;
import com.dre.brewery.commands.subcommands.CreateCommand;
import com.dre.brewery.commands.subcommands.DataManagerCommand;
import com.dre.brewery.commands.subcommands.DebugInfoCommand;
import com.dre.brewery.commands.subcommands.DeleteCommand;
import com.dre.brewery.commands.subcommands.DrinkCommand;
import com.dre.brewery.commands.subcommands.HelpCommand;
import com.dre.brewery.commands.subcommands.InfoCommand;
import com.dre.brewery.commands.subcommands.ItemName;
import com.dre.brewery.commands.subcommands.PukeCommand;
import com.dre.brewery.commands.subcommands.ReloadAddonsCommand;
import com.dre.brewery.commands.subcommands.ReloadCommand;
import com.dre.brewery.commands.subcommands.SealCommand;
import com.dre.brewery.commands.subcommands.SetCommand;
import com.dre.brewery.commands.subcommands.ShowStatsCommand;
import com.dre.brewery.commands.subcommands.StaticCommand;
import com.dre.brewery.commands.subcommands.UnLabelCommand;
import com.dre.brewery.commands.subcommands.VersionCommand;
import com.dre.brewery.commands.subcommands.WakeupCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManager
implements TabExecutor {
    private static final BreweryPlugin plugin = BreweryPlugin.getInstance();
    private static final Map<String, SubCommand> subCommands = new HashMap<String, SubCommand>();

    public CommandManager() {
        subCommands.put("help", new HelpCommand());
        subCommands.put("reload", new ReloadCommand());
        subCommands.put("wakeup", new WakeupCommand());
        subCommands.put("itemName", new ItemName());
        subCommands.put("create", new CreateCommand(plugin));
        subCommands.put("info", new InfoCommand(plugin));
        subCommands.put("seal", new SealCommand());
        subCommands.put("copy", new CopyCommand(plugin));
        subCommands.put("delete", new DeleteCommand(plugin));
        subCommands.put("static", new StaticCommand());
        subCommands.put("set", new SetCommand());
        subCommands.put("unLabel", new UnLabelCommand());
        subCommands.put("debuginfo", new DebugInfoCommand(plugin));
        subCommands.put("showstats", new ShowStatsCommand());
        subCommands.put("puke", new PukeCommand());
        subCommands.put("drink", new DrinkCommand());
        subCommands.put("reloadaddons", new ReloadAddonsCommand());
        subCommands.put("version", new VersionCommand());
        subCommands.put("data", new DataManagerCommand());
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length < 1) {
            CommandUtil.cmdHelp(sender, args);
            return true;
        }
        SubCommand subCommand = subCommands.get(args[0]);
        if (subCommand == null) {
            CommandUtil.cmdHelp(sender, args);
            return true;
        }
        boolean playerOnly = subCommand.playerOnly();
        String permission = subCommand.permission();
        if (playerOnly && !(sender instanceof Player)) {
            plugin.msg(sender, CommandManager.plugin.languageReader.get("Error_NotPlayer", new String[0]));
            return true;
        }
        if (permission != null && !sender.hasPermission(permission)) {
            plugin.msg(sender, CommandManager.plugin.languageReader.get("Error_NoPermission", new String[0]));
            return true;
        }
        subCommand.execute(plugin, sender, s, args);
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] strings) {
        if (strings.length == 1) {
            ArrayList<String> commands = new ArrayList<String>();
            for (Map.Entry<String, SubCommand> entry : subCommands.entrySet()) {
                String perm = entry.getValue().permission();
                if (perm == null || !commandSender.hasPermission(perm)) continue;
                commands.add(entry.getKey());
            }
            return commands;
        }
        SubCommand subCommand = subCommands.get(strings[0].toLowerCase());
        if (subCommand != null) {
            return subCommand.tabComplete(plugin, commandSender, s, strings);
        }
        return null;
    }

    public static void addSubCommand(String name, SubCommand subCommand) {
        subCommands.put(name, subCommand);
    }

    public static void removeSubCommand(String name) {
        subCommands.remove(name);
    }
}

