/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.api.events.brew;

import com.dre.brewery.BPlayer;
import com.dre.brewery.Brew;
import com.dre.brewery.api.events.brew.BrewEvent;
import com.dre.brewery.utility.PermissionUtil;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class BrewDrinkEvent
extends BrewEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Player player;
    private final BPlayer bPlayer;
    private int alc;
    private int quality;
    private boolean cancelled;

    public BrewDrinkEvent(Brew brew, ItemMeta meta, Player player, BPlayer bPlayer) {
        super(brew, meta);
        this.player = player;
        this.bPlayer = bPlayer;
        this.alc = this.calcAlcWSensitivity(brew.getOrCalcAlc());
        this.quality = brew.getQuality();
    }

    @Contract(pure=true)
    public int calcAlcWSensitivity(int alc) {
        int sensitive = PermissionUtil.getDrinkSensitive((Permissible)this.player);
        if (sensitive == 0) {
            alc = 0;
        } else if (sensitive > 0) {
            alc = (int)((float)alc * ((float)sensitive / 100.0f));
        }
        return alc;
    }

    public Player getPlayer() {
        return this.player;
    }

    public BPlayer getbPlayer() {
        return this.bPlayer;
    }

    public int getAddedAlcohol() {
        return this.alc;
    }

    public void setAddedAlcohol(int alc) {
        this.alc = alc;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        if (quality > 10 || quality < 0) {
            throw new IllegalArgumentException("Quality must be in range from 0 to 10");
        }
        this.quality = quality;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

