/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.api.addons;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.addons.AddonFileManager;
import com.dre.brewery.api.addons.AddonInfo;
import com.dre.brewery.api.addons.AddonLogger;
import com.dre.brewery.api.addons.AddonManager;
import com.dre.brewery.commands.CommandManager;
import com.dre.brewery.commands.SubCommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class BreweryAddon {
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<String> commands = new ArrayList<String>();
    private AddonLogger logger = null;
    private AddonFileManager addonFileManager = null;
    private AddonInfo addonInfo = null;
    private AddonManager addonManager = null;

    public void onAddonPreEnable() {
    }

    public void onAddonEnable() {
    }

    public void onAddonDisable() {
    }

    public void onBreweryReload() {
    }

    @NotNull
    public BreweryPlugin getBreweryPlugin() {
        return BreweryPlugin.getInstance();
    }

    @NotNull
    public AddonFileManager getAddonFileManager() {
        return this.addonFileManager;
    }

    @NotNull
    public AddonLogger getAddonLogger() {
        return this.logger;
    }

    @NotNull
    public AddonInfo getAddonInfo() {
        return this.addonInfo;
    }

    @NotNull
    public AddonManager getAddonManager() {
        return this.addonManager;
    }

    public void registerListener(Listener listener) {
        this.getBreweryPlugin().getServer().getPluginManager().registerEvents(listener, (Plugin)this.getBreweryPlugin());
        this.listeners.add(listener);
    }

    public void unregisterListener(Listener listener) {
        HandlerList.unregisterAll((Listener)listener);
        this.listeners.remove(listener);
    }

    public void registerCommand(String name, SubCommand command) {
        CommandManager.addSubCommand(name, command);
        this.commands.add(name);
    }

    public void unregisterCommand(String name) {
        CommandManager.removeSubCommand(name);
        this.commands.remove(name);
    }

    public void unregisterListeners() {
        for (Listener listener : this.listeners) {
            HandlerList.unregisterAll((Listener)listener);
        }
        this.listeners.clear();
    }

    public void unregisterCommands() {
        for (String command : this.commands) {
            CommandManager.removeSubCommand(command);
        }
        this.commands.clear();
    }
}

