/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.api.addons;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.addons.AddonCommand;
import com.dre.brewery.api.addons.AddonFileManager;
import com.dre.brewery.api.addons.AddonInfo;
import com.dre.brewery.api.addons.AddonLogger;
import com.dre.brewery.api.addons.BreweryAddon;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddonManager
extends ClassLoader {
    private final BreweryPlugin plugin;
    private final File addonsFolder;
    private static final List<BreweryAddon> addons = new ArrayList<BreweryAddon>();
    private static final List<AddonCommand> addonCommands = new ArrayList<AddonCommand>();

    public AddonManager(BreweryPlugin plugin) {
        this.plugin = plugin;
        this.addonsFolder = new File(plugin.getDataFolder(), "addons");
        if (!this.addonsFolder.exists()) {
            this.addonsFolder.mkdirs();
        }
    }

    public void unloadAddons() {
        for (BreweryAddon addon : addons) {
            try {
                addon.onAddonDisable();
                addon.unregisterListeners();
                addon.unregisterCommands();
                addon.getAddonLogger().info("Disabled.");
            }
            catch (Throwable t) {
                this.plugin.errorLog("Failed to disable addon " + addon.getClass().getSimpleName(), t);
            }
        }
        int loaded = addons.size();
        if (loaded > 0) {
            this.plugin.log("Disabled " + loaded + " addon(s)");
        }
        addons.clear();
    }

    public void unloadAddon(BreweryAddon addon) {
        try {
            addon.onAddonDisable();
            addon.unregisterListeners();
            addon.unregisterCommands();
            addon.getAddonLogger().info("Disabled.");
        }
        catch (Throwable t) {
            this.plugin.errorLog("Failed to disable addon " + addon.getClass().getSimpleName(), t);
        }
        addons.remove(addon);
    }

    public void reloadAddons() {
        for (BreweryAddon addon : addons) {
            try {
                addon.onBreweryReload();
            }
            catch (Throwable t) {
                this.plugin.errorLog("Failed to reload addon " + addon.getClass().getSimpleName(), t);
            }
        }
        int loaded = addons.size();
        if (loaded > 0) {
            this.plugin.log("Reloaded " + loaded + " addon(s)");
        }
    }

    public List<BreweryAddon> getAddons() {
        return addons;
    }

    public void loadAddons() {
        File[] files = this.addonsFolder.listFiles((dir, name) -> name.endsWith(".jar"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            this.loadAddon(file);
        }
        for (BreweryAddon addon : addons) {
            try {
                addon.onAddonEnable();
            }
            catch (Throwable t) {
                this.plugin.errorLog("Failed to enable addon " + addon.getClass().getSimpleName(), t);
            }
        }
        int loaded = addons.size();
        if (loaded > 0) {
            this.plugin.log("Loaded " + loaded + " addon(s)");
        }
    }

    public void loadAddon(File file) {
        try {
            List<Class<?>> classes = this.loadAllClassesFromJar(file);
            for (Class<?> clazz : classes) {
                if (!BreweryAddon.class.isAssignableFrom(clazz)) continue;
                Class<BreweryAddon> addonClass = clazz.asSubclass(BreweryAddon.class);
                try {
                    BreweryAddon addon = addonClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    Class<BreweryAddon> breweryAddonClass = BreweryAddon.class;
                    Field loggerField = breweryAddonClass.getDeclaredField("logger");
                    Field fileManagerField = breweryAddonClass.getDeclaredField("addonFileManager");
                    Field infoField = breweryAddonClass.getDeclaredField("addonInfo");
                    Field managerField = breweryAddonClass.getDeclaredField("addonManager");
                    loggerField.setAccessible(true);
                    fileManagerField.setAccessible(true);
                    infoField.setAccessible(true);
                    managerField.setAccessible(true);
                    loggerField.set(addon, new AddonLogger(addonClass));
                    fileManagerField.set(addon, new AddonFileManager(addon, file));
                    infoField.set(addon, addonClass.getAnnotation(AddonInfo.class));
                    managerField.set(addon, this);
                    if (addon.getAddonInfo() == null) {
                        this.plugin.errorLog("Addon " + addonClass.getSimpleName() + " is missing the AddonInfo annotation. It will not be loaded.");
                        continue;
                    }
                    addon.getAddonLogger().info("Loading &a" + addon.getAddonInfo().name() + " &f-&a v" + addon.getAddonInfo().version() + " &fby &a" + addon.getAddonInfo().author());
                    addons.add(addon);
                    addon.onAddonPreEnable();
                }
                catch (Exception e) {
                    this.plugin.errorLog("Failed to load addon class " + clazz.getSimpleName(), e);
                }
            }
        }
        catch (Throwable ex) {
            this.plugin.errorLog("Failed to load addon classes from jar " + file.getName(), ex);
        }
    }

    @NotNull
    private static <T> List<Class<? extends T>> findClasses(@NotNull File file, @NotNull Class<T> clazz) throws CompletionException {
        if (!file.exists()) {
            return Collections.emptyList();
        }
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        List<String> matches = AddonManager.matchingNames(file);
        for (String match : matches) {
            try {
                URL jar = file.toURI().toURL();
                try (URLClassLoader loader = new URLClassLoader(new URL[]{jar}, clazz.getClassLoader());){
                    Class<T> addonClass = AddonManager.loadClass(loader, match, clazz);
                    if (addonClass == null) continue;
                    classes.add(addonClass);
                }
            }
            catch (VerifyError jar) {
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CompletionException(e.getCause());
            }
        }
        return classes;
    }

    private List<Class<?>> loadAllClassesFromJar(File jarFile) {
        ArrayList classes = new ArrayList();
        try (URLClassLoader classLoader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, this.getClass().getClassLoader());
             JarInputStream jarInputStream = new JarInputStream(new FileInputStream(jarFile));){
            JarEntry jarEntry;
            String mainDir = "";
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                if (!jarEntry.getName().endsWith(".class")) continue;
                String className = jarEntry.getName().replaceAll("/", ".").replace(".class", "");
                try {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName(className, false, classLoader);
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        continue;
                    }
                    if (BreweryAddon.class.isAssignableFrom(clazz)) {
                        classLoader.loadClass(className);
                        mainDir = className.substring(0, className.lastIndexOf(46));
                    }
                    if (!clazz.getName().contains(mainDir)) continue;
                    classes.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to load class " + className, e);
                }
            }
            for (Class<?> clazz : classes) {
                if (BreweryAddon.class.isAssignableFrom(clazz)) continue;
                try {
                    classLoader.loadClass(clazz.getName());
                }
                catch (ClassNotFoundException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to load class " + clazz.getName(), e);
                }
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error loading classes from JAR", e);
        }
        return classes;
    }

    @NotNull
    private static List<String> matchingNames(File file) {
        ArrayList<String> matches = new ArrayList<String>();
        try {
            URL jar = file.toURI().toURL();
            try (JarInputStream stream = new JarInputStream(jar.openStream());){
                JarEntry entry;
                while ((entry = stream.getNextJarEntry()) != null) {
                    String name = entry.getName();
                    if (!name.endsWith(".class")) continue;
                    matches.add(name.substring(0, name.lastIndexOf(46)).replace('/', '.'));
                }
            }
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
        return matches;
    }

    @Nullable
    private static <T> Class<? extends T> loadClass(@NotNull URLClassLoader loader, String match, @NotNull Class<T> clazz) throws ClassNotFoundException {
        try {
            Class<?> loaded = loader.loadClass(match);
            if (clazz.isAssignableFrom(loaded)) {
                return loaded.asSubclass(clazz);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }
}

