/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.api.addons;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.addons.BreweryAddon;
import java.util.logging.Level;

public class AddonLogger {
    private static final BreweryPlugin plugin = BreweryPlugin.getInstance();
    private final String addonName;
    private final String prefix;

    public AddonLogger(Class<? extends BreweryAddon> addonUninstantiated) {
        this.addonName = addonUninstantiated.getSimpleName();
        this.prefix = "&2[" + this.addonName + "] &r";
    }

    public void info(String message) {
        plugin.log(this.prefix + message);
    }

    public void warning(String message) {
        plugin.warningLog(this.prefix + message);
    }

    public void severe(String message) {
        plugin.errorLog(this.prefix + message);
    }

    public void info(String message, Throwable throwable) {
        this.info(message);
        plugin.getLogger().log(Level.INFO, "Stacktrace from " + this.addonName, throwable);
    }

    public void warning(String message, Throwable throwable) {
        this.warning(message);
        plugin.getLogger().log(Level.WARNING, "Stacktrace from " + this.addonName, throwable);
    }

    public void severe(String message, Throwable throwable) {
        this.severe(message);
        plugin.getLogger().log(Level.SEVERE, "Stacktrace from " + this.addonName, throwable);
    }
}

