/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BPlayer;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.events.PlayerChatDistortEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class DistortChat {
    public static List<DistortChat> words = new ArrayList<DistortChat>();
    public static List<String> commands;
    private static List<String> playerParameterCommands;
    public static List<String[]> ignoreText;
    public static Boolean doSigns;
    public static Boolean log;
    private static final Map<String, Long> waitPlayers;
    private String from;
    private String to;
    private String[] pre;
    private Boolean match = false;
    private int alcohol = 1;
    private int percentage = 100;

    public DistortChat(Map<?, ?> part) {
        for (Map.Entry<?, ?> wordPart : part.entrySet()) {
            String key = (String)wordPart.getKey();
            if (wordPart.getValue() instanceof String) {
                if (key.equalsIgnoreCase("replace")) {
                    this.from = (String)wordPart.getValue();
                    continue;
                }
                if (key.equalsIgnoreCase("to")) {
                    this.to = (String)wordPart.getValue();
                    continue;
                }
                if (!key.equalsIgnoreCase("pre")) continue;
                String fullPre = (String)wordPart.getValue();
                this.pre = fullPre.split(",");
                continue;
            }
            if (wordPart.getValue() instanceof Boolean) {
                if (!key.equalsIgnoreCase("match")) continue;
                this.match = (Boolean)wordPart.getValue();
                continue;
            }
            if (!(wordPart.getValue() instanceof Integer)) continue;
            if (key.equalsIgnoreCase("alcohol")) {
                this.alcohol = (Integer)wordPart.getValue();
                continue;
            }
            if (!key.equalsIgnoreCase("percentage")) continue;
            this.percentage = (Integer)wordPart.getValue();
        }
        if (this.from != null && this.to != null) {
            words.add(this);
        }
    }

    public static void playerCommand(PlayerCommandPreprocessEvent event) {
        String name;
        BPlayer bPlayer = BPlayer.get((OfflinePlayer)event.getPlayer());
        if (bPlayer == null) {
            return;
        }
        if (!(commands == null || commands.isEmpty() || words.isEmpty() || waitPlayers.containsKey(name = event.getPlayer().getName()) && waitPlayers.get(name) + 500L >= System.currentTimeMillis())) {
            String chat = event.getMessage();
            for (String command : commands) {
                if (command.length() + 1 >= chat.length() || !Character.isSpaceChar(chat.charAt(command.length())) || !chat.toLowerCase().startsWith(command.toLowerCase())) continue;
                if (log.booleanValue()) {
                    BreweryPlugin.getInstance().log(BreweryPlugin.getInstance().languageReader.get("Player_TriedToSay", name, chat));
                }
                String message = playerParameterCommands.contains(command.toLowerCase()) ? chat.substring(chat.indexOf(32, chat.indexOf(32, 0) + 1) + 1).trim() : chat.substring(chat.indexOf(32) + 1).trim();
                String distorted = DistortChat.distortMessage(message, bPlayer.getDrunkeness());
                PlayerChatDistortEvent call = new PlayerChatDistortEvent(event.isAsynchronous(), event.getPlayer(), bPlayer, message, distorted);
                BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)call);
                if (call.isCancelled()) {
                    return;
                }
                distorted = call.getDistortedMessage();
                event.setMessage(playerParameterCommands.contains(command.toLowerCase()) ? chat.substring(0, chat.indexOf(32, chat.indexOf(32, 0) + 1) + 1) + distorted : chat.substring(0, chat.indexOf(32) + 1) + distorted);
                waitPlayers.put(name, System.currentTimeMillis());
                return;
            }
        }
    }

    public static void signWrite(SignChangeEvent event) {
        BPlayer bPlayer = BPlayer.get((OfflinePlayer)event.getPlayer());
        if (bPlayer != null && !words.isEmpty()) {
            int index = 0;
            for (String message : event.getLines()) {
                if (message.length() > 1) {
                    String distorted = DistortChat.distortMessage(message, bPlayer.getDrunkeness());
                    PlayerChatDistortEvent call = new PlayerChatDistortEvent(event.isAsynchronous(), event.getPlayer(), bPlayer, message, distorted);
                    BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)call);
                    if (!call.isCancelled()) {
                        distorted = call.getDistortedMessage();
                        if (distorted.length() > 15) {
                            distorted = distorted.substring(0, 14);
                        }
                        event.setLine(index, distorted);
                    }
                }
                ++index;
            }
        }
    }

    public static void playerChat(AsyncPlayerChatEvent event) {
        BPlayer bPlayer = BPlayer.get((OfflinePlayer)event.getPlayer());
        if (bPlayer != null && !words.isEmpty()) {
            String message = event.getMessage();
            if (log.booleanValue()) {
                BreweryPlugin.getInstance().log(BreweryPlugin.getInstance().languageReader.get("Player_TriedToSay", event.getPlayer().getName(), message));
            }
            String distorted = DistortChat.distortMessage(message, bPlayer.getDrunkeness());
            PlayerChatDistortEvent call = new PlayerChatDistortEvent(event.isAsynchronous(), event.getPlayer(), bPlayer, message, distorted);
            BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)call);
            if (call.isCancelled()) {
                return;
            }
            distorted = call.getDistortedMessage();
            event.setMessage(distorted);
        }
    }

    public static String distortMessage(String message, int drunkenness) {
        if (!ignoreText.isEmpty()) {
            for (String[] bypass : ignoreText) {
                int indexStart = 0;
                if (!bypass[0].equals("")) {
                    indexStart = message.indexOf(bypass[0]);
                }
                int indexEnd = message.length() - 1;
                if (!bypass[1].equals("")) {
                    indexEnd = message.indexOf(bypass[1], indexStart + 2);
                }
                if (indexStart == -1 || indexEnd == -1 || indexEnd <= indexStart + 1) continue;
                String ignoredMessage = message.substring(indexStart, indexEnd);
                String msg0 = message.substring(0, indexStart);
                String msg1 = message.substring(indexEnd);
                if (msg0.length() > 1) {
                    msg0 = DistortChat.distortMessage(msg0, drunkenness);
                }
                if (msg1.length() > 1) {
                    msg1 = DistortChat.distortMessage(msg1, drunkenness);
                }
                return msg0 + ignoredMessage + msg1;
            }
        }
        return DistortChat.distortString(message, drunkenness);
    }

    private static String distortString(String message, int drunkenness) {
        if (message.length() > 1) {
            List<DistortChat> words = DistortChat.words;
            for (DistortChat word : words) {
                if (word.alcohol > drunkenness) continue;
                message = word.distort(message);
            }
        }
        return message;
    }

    public String distort(String words) {
        String from = this.from;
        Object to = this.to;
        if (from.equalsIgnoreCase("-end")) {
            from = words;
            to = (String)words + (String)to;
        } else if (from.equalsIgnoreCase("-start")) {
            from = words;
            to = (String)to + (String)words;
        } else if (from.equalsIgnoreCase("-all")) {
            from = words;
        } else if (from.equalsIgnoreCase("-space")) {
            from = " ";
        } else if (from.equalsIgnoreCase("-random")) {
            int charIndex = (int)(Math.random() * (double)(((String)words).length() - 1));
            if (charIndex < ((String)words).length() / 2) {
                from = ((String)words).substring(charIndex);
                to = (String)to + from;
            } else {
                from = ((String)words).substring(0, charIndex);
                to = from + (String)to;
            }
        }
        if (((String)words).contains(from)) {
            try {
                if (this.pre == null && this.percentage == 100) {
                    return ((String)words).replaceAll(from, (String)to);
                }
                StringBuilder newWords = new StringBuilder();
                if (((String)words).endsWith(from)) {
                    words = (String)words + " ";
                }
                String[] splitted = ((String)words).split(Pattern.quote(from));
                if (splitted.length > 1) {
                    String part;
                    int index;
                    for (index = 0; index < splitted.length - 1; ++index) {
                        part = splitted[index];
                        newWords.append(part);
                        if (this.doesPreMatch(part) && Math.random() * 100.0 <= (double)this.percentage) {
                            newWords.append((String)to);
                            continue;
                        }
                        newWords.append(from);
                    }
                    part = splitted[index];
                    if (part.equals(" ")) {
                        return newWords.toString();
                    }
                    return newWords.append(part).toString();
                }
            }
            catch (PatternSyntaxException e) {
                return words;
            }
        }
        return words;
    }

    public boolean doesPreMatch(String part) {
        boolean isBefore;
        boolean bl = isBefore = this.match == false;
        if (this.pre != null) {
            for (String pr : this.pre) {
                if (!part.endsWith(pr)) continue;
                isBefore = this.match;
                break;
            }
        } else {
            isBefore = true;
        }
        return isBefore;
    }

    static {
        playerParameterCommands = Arrays.asList("/msg", "/tell", "/whisper", "/w");
        ignoreText = new ArrayList<String[]>();
        waitPlayers = new HashMap<String, Long>();
    }
}

