/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Brew;
import com.dre.brewery.DistortChat;
import com.dre.brewery.MCBarrel;
import com.dre.brewery.Wakeup;
import com.dre.brewery.api.addons.AddonManager;
import com.dre.brewery.commands.CommandManager;
import com.dre.brewery.commands.CommandUtil;
import com.dre.brewery.depend.universalScheduler.UniversalScheduler;
import com.dre.brewery.depend.universalScheduler.scheduling.schedulers.TaskScheduler;
import com.dre.brewery.filedata.BConfig;
import com.dre.brewery.filedata.LanguageReader;
import com.dre.brewery.filedata.UpdateChecker;
import com.dre.brewery.integration.ChestShopListener;
import com.dre.brewery.integration.IntegrationListener;
import com.dre.brewery.integration.ShopKeepersListener;
import com.dre.brewery.integration.SlimefunListener;
import com.dre.brewery.integration.barrel.BlocklockerBarrel;
import com.dre.brewery.integration.barrel.LogBlockBarrel;
import com.dre.brewery.integration.bstats.Stats;
import com.dre.brewery.integration.papi.PlaceholderAPI;
import com.dre.brewery.listeners.BlockListener;
import com.dre.brewery.listeners.CauldronListener;
import com.dre.brewery.listeners.EntityListener;
import com.dre.brewery.listeners.InventoryListener;
import com.dre.brewery.listeners.PlayerListener;
import com.dre.brewery.recipe.BCauldronRecipe;
import com.dre.brewery.recipe.BRecipe;
import com.dre.brewery.recipe.CustomItem;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.recipe.ItemLoader;
import com.dre.brewery.recipe.PluginItem;
import com.dre.brewery.recipe.SimpleItem;
import com.dre.brewery.storage.DataManager;
import com.dre.brewery.storage.StorageInitException;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.LegacyUtil;
import com.dre.brewery.utility.MinecraftVersion;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BreweryPlugin
extends JavaPlugin {
    private static final int RESOURCE_ID = 114777;
    private static AddonManager addonManager;
    private static TaskScheduler scheduler;
    private static BreweryPlugin breweryPlugin;
    private static MinecraftVersion minecraftVersion;
    private static DataManager dataManager;
    private static boolean isFolia;
    public static boolean debug;
    public static boolean useNBT;
    public PlayerListener playerListener;
    public Map<String, Function<ItemLoader, Ingredient>> ingredientLoaders = new HashMap<String, Function<ItemLoader, Ingredient>>();
    public String language;
    public LanguageReader languageReader;
    public Stats stats = new Stats();

    public void onLoad() {
        breweryPlugin = this;
        minecraftVersion = MinecraftVersion.getIt();
        scheduler = UniversalScheduler.getScheduler((Plugin)this);
    }

    public void onEnable() {
        FileConfiguration cfg;
        this.migrateBreweryDataFolder();
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            isFolia = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (LegacyUtil.initNbt()) {
            useNBT = true;
        }
        if (BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_14)) {
            this.getServer().createBlockData(Material.CAMPFIRE);
        }
        if ((cfg = BConfig.loadConfigFile()) != null) {
            BConfig.readConfig(cfg);
        } else {
            this.errorLog("Something went wrong when trying to load the config file! Please check your config.yml");
        }
        addonManager = new AddonManager(this);
        addonManager.loadAddons();
        CustomItem.registerItemLoader(this);
        SimpleItem.registerItemLoader(this);
        PluginItem.registerItemLoader(this);
        this.log("Minecraft version&7:&a " + minecraftVersion.getVersion());
        if (minecraftVersion == MinecraftVersion.UNKNOWN) {
            this.warningLog("This version of Minecraft is not known to Brewery! Please be wary of bugs or other issues that may occur in this version.");
        }
        try {
            dataManager = DataManager.createDataManager(BConfig.configuredDataManager);
        }
        catch (StorageInitException e) {
            this.errorLog("Failed to initialize DataManager!", e);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
        DataManager.loadMiscData(dataManager.getBreweryMiscData());
        Barrel.getBarrels().addAll(dataManager.getAllBarrels());
        for (BCauldron cauldron : dataManager.getAllCauldrons()) {
            BCauldron.getBcauldrons().put(cauldron.getBlock(), cauldron);
        }
        for (BPlayer player : dataManager.getAllPlayers()) {
            BPlayer.getPlayers().put(player.getUuid(), player);
        }
        Wakeup.getWakeups().addAll(dataManager.getAllWakeups());
        this.stats.setupBStats();
        this.getCommand("breweryx").setExecutor((CommandExecutor)new CommandManager());
        this.playerListener = new PlayerListener();
        this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new IntegrationListener(), (Plugin)this);
        if (BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_9)) {
            this.getServer().getPluginManager().registerEvents((Listener)new CauldronListener(), (Plugin)this);
        }
        if (BConfig.hasChestShop && BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_13)) {
            this.getServer().getPluginManager().registerEvents((Listener)new ChestShopListener(), (Plugin)this);
        }
        if (BConfig.hasShopKeepers) {
            this.getServer().getPluginManager().registerEvents((Listener)new ShopKeepersListener(), (Plugin)this);
        }
        if (BConfig.hasSlimefun && BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_14)) {
            this.getServer().getPluginManager().registerEvents((Listener)new SlimefunListener(), (Plugin)this);
        }
        BreweryPlugin.getScheduler().runTaskTimer(new BreweryRunnable(), 650L, 1200L);
        BreweryPlugin.getScheduler().runTaskTimer(new DrunkRunnable(), 120L, 120L);
        if (BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_9)) {
            BreweryPlugin.getScheduler().runTaskTimer(new CauldronParticles(), 1L, 1L);
        }
        if (BConfig.updateCheck) {
            new UpdateChecker(114777).query(latestVersion -> {
                String currentVersion = this.getDescription().getVersion();
                if (UpdateChecker.parseVersion(latestVersion) > UpdateChecker.parseVersion(currentVersion)) {
                    UpdateChecker.setUpdateAvailable(true);
                    this.log(this.languageReader.get("Etc_UpdateAvailable", "v" + currentVersion, "v" + latestVersion));
                }
                UpdateChecker.setLatestVersion(latestVersion);
            });
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderAPI().register();
        }
        this.log("Using scheduler&7: &a" + scheduler.getClass().getSimpleName());
        this.log(this.getDescription().getName() + " enabled!");
    }

    public void onDisable() {
        if (addonManager != null) {
            addonManager.unloadAddons();
        }
        HandlerList.unregisterAll((Plugin)this);
        BreweryPlugin.getScheduler().cancelTasks((Plugin)this);
        if (breweryPlugin == null) {
            return;
        }
        if (dataManager != null) {
            dataManager.exit(true, false);
        }
        this.clearConfigData();
        this.log(this.getDescription().getName() + " disabled!");
    }

    private void migrateBreweryDataFolder() {
        File[] files;
        String pluginsFolder = this.getDataFolder().getParentFile().getPath();
        File breweryFolder = new File(pluginsFolder + File.separator + "Brewery");
        File breweryXFolder = new File(pluginsFolder + File.separator + "BreweryX");
        if (!breweryFolder.exists() || breweryXFolder.exists()) {
            return;
        }
        if (!breweryXFolder.exists()) {
            breweryXFolder.mkdirs();
        }
        if ((files = breweryFolder.listFiles()) != null) {
            for (File file : files) {
                try {
                    Files.copy(file.toPath(), new File(breweryXFolder, file.getName()).toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    this.errorLog("Failed to move file: " + file.getName(), e);
                }
            }
            this.log("&5Moved files from Brewery to BreweryX's data folder");
        }
    }

    public void reload(CommandSender sender) {
        FileConfiguration cfg;
        if (sender != null && !sender.equals(this.getServer().getConsoleSender())) {
            BConfig.reloader = sender;
        }
        if ((cfg = BConfig.loadConfigFile()) == null) {
            this.log("Something went wrong when trying to load the config file! Please check your config.yml");
            return;
        }
        this.clearConfigData();
        try {
            BConfig.readConfig(cfg);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log("Something went wrong when trying to load the config file! Please check your config.yml");
            return;
        }
        BCauldron.reload();
        CommandUtil.reloadTabCompleter();
        boolean successful = true;
        for (Brew brew : Brew.legacyPotions.values()) {
            if (brew.reloadRecipe()) continue;
            successful = false;
        }
        if (sender != null) {
            if (!successful) {
                this.msg(sender, BreweryPlugin.breweryPlugin.languageReader.get("Error_Recipeload", new String[0]));
            } else {
                breweryPlugin.msg(sender, BreweryPlugin.breweryPlugin.languageReader.get("CMD_Reload", new String[0]));
            }
        }
        BConfig.reloader = null;
    }

    public void clearConfigData() {
        BRecipe.getConfigRecipes().clear();
        BRecipe.numConfigRecipes = 0;
        BCauldronRecipe.acceptedMaterials.clear();
        BCauldronRecipe.acceptedCustom.clear();
        BCauldronRecipe.acceptedSimple.clear();
        BCauldronRecipe.getConfigRecipes().clear();
        BCauldronRecipe.numConfigRecipes = 0;
        BConfig.customItems.clear();
        BConfig.hasMMOItems = null;
        DistortChat.commands = null;
        BConfig.drainItems.clear();
        if (BConfig.useLB) {
            try {
                LogBlockBarrel.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void registerForItemLoader(String saveID, Function<ItemLoader, Ingredient> loadFct) {
        this.ingredientLoaders.put(saveID, loadFct);
    }

    public void unRegisterItemLoader(String saveID) {
        this.ingredientLoaders.remove(saveID);
    }

    public static BreweryPlugin getInstance() {
        return breweryPlugin;
    }

    public static TaskScheduler getScheduler() {
        return scheduler;
    }

    public static MinecraftVersion getMCVersion() {
        return minecraftVersion;
    }

    public static AddonManager getAddonManager() {
        return addonManager;
    }

    public static void setDataManager(DataManager dataManager) {
        BreweryPlugin.dataManager = dataManager;
    }

    public static DataManager getDataManager() {
        return dataManager;
    }

    public static boolean isFolia() {
        return isFolia;
    }

    public void msg(CommandSender sender, String msg) {
        sender.sendMessage(this.color(BConfig.pluginPrefix + msg));
    }

    public void log(String msg) {
        Bukkit.getConsoleSender().sendMessage(this.color(BConfig.pluginPrefix + msg));
    }

    public void debugLog(String msg) {
        if (debug) {
            this.msg((CommandSender)Bukkit.getConsoleSender(), "&2[Debug] &f" + msg);
        }
    }

    public void warningLog(String msg) {
        Bukkit.getConsoleSender().sendMessage(this.color(BConfig.pluginPrefix + "&eWARNING: " + msg));
    }

    public void errorLog(String msg) {
        Bukkit.getConsoleSender().sendMessage(this.color(BConfig.pluginPrefix + "&cERROR: " + msg));
        if (BConfig.reloader != null) {
            BConfig.reloader.sendMessage(this.color(BConfig.pluginPrefix + "&cERROR: " + msg));
        }
    }

    public void errorLog(String msg, Throwable throwable) {
        this.errorLog(msg);
        this.errorLog("&6" + throwable.toString());
        for (StackTraceElement ste : throwable.getStackTrace()) {
            this.errorLog(ste.toString());
        }
    }

    public int parseInt(String string) {
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    public double parseDouble(String string) {
        if (string == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException ignored) {
            return 0.0;
        }
    }

    public float parseFloat(String string) {
        if (string == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException ignored) {
            return 0.0f;
        }
    }

    public String color(String msg) {
        return BUtil.color(msg);
    }

    static {
        isFolia = false;
    }

    public class BreweryRunnable
    implements Runnable {
        @Override
        public void run() {
            long start = System.currentTimeMillis();
            BConfig.reloader = null;
            for (BCauldron bCauldron : BCauldron.bcauldrons.values()) {
                BreweryPlugin.getScheduler().runTask(bCauldron.getBlock().getLocation(), () -> {
                    if (!bCauldron.onUpdate()) {
                        BCauldron.bcauldrons.remove(bCauldron.getBlock());
                    }
                });
            }
            Barrel.onUpdate();
            if (BreweryPlugin.getMCVersion().isOrLater(MinecraftVersion.V1_14)) {
                MCBarrel.onUpdate();
            }
            if (BConfig.useBlocklocker) {
                BlocklockerBarrel.clearBarrelSign();
            }
            BPlayer.onUpdate();
            dataManager.tryAutoSave();
            BreweryPlugin.this.debugLog("BreweryRunnable: " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    public static class DrunkRunnable
    implements Runnable {
        @Override
        public void run() {
            if (!BPlayer.isEmpty()) {
                BPlayer.drunkenness();
            }
        }
    }

    public static class CauldronParticles
    implements Runnable {
        @Override
        public void run() {
            if (!BConfig.enableCauldronParticles) {
                return;
            }
            if (BConfig.minimalParticles && BCauldron.particleRandom.nextFloat() > 0.5f) {
                return;
            }
            BCauldron.processCookEffects();
        }
    }
}

