/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.BarrelBody;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.events.barrel.BarrelAccessEvent;
import com.dre.brewery.api.events.barrel.BarrelCreateEvent;
import com.dre.brewery.api.events.barrel.BarrelDestroyEvent;
import com.dre.brewery.api.events.barrel.BarrelRemoveEvent;
import com.dre.brewery.depend.universalScheduler.UniversalRunnable;
import com.dre.brewery.filedata.BConfig;
import com.dre.brewery.integration.barrel.LogBlockBarrel;
import com.dre.brewery.lore.BrewLore;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.BoundingBox;
import com.dre.brewery.utility.LegacyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Barrel
implements InventoryHolder {
    public static volatile List<Barrel> barrels = new ArrayList<Barrel>();
    private static int check = 0;
    private final Block spigot;
    private final BarrelBody body;
    private boolean checked;
    private Inventory inventory;
    private float time;
    private final UUID id;

    public Barrel(Block spigot, byte signoffset) {
        this.spigot = spigot;
        this.inventory = this.isLarge() ? BreweryPlugin.getInstance().getServer().createInventory((InventoryHolder)this, 27, BreweryPlugin.getInstance().languageReader.get("Etc_Barrel", new String[0])) : BreweryPlugin.getInstance().getServer().createInventory((InventoryHolder)this, 9, BreweryPlugin.getInstance().languageReader.get("Etc_Barrel", new String[0]));
        this.body = new BarrelBody(this, signoffset);
        this.id = UUID.randomUUID();
    }

    public Barrel(Block spigot, byte sign, BoundingBox bounds, @Nullable Map<String, Object> items, float time, UUID id) {
        this.spigot = spigot;
        this.inventory = this.isLarge() ? BreweryPlugin.getInstance().getServer().createInventory((InventoryHolder)this, 27, BreweryPlugin.getInstance().languageReader.get("Etc_Barrel", new String[0])) : BreweryPlugin.getInstance().getServer().createInventory((InventoryHolder)this, 9, BreweryPlugin.getInstance().languageReader.get("Etc_Barrel", new String[0]));
        if (items != null) {
            for (String slot : items.keySet()) {
                if (!(items.get(slot) instanceof ItemStack)) continue;
                this.inventory.setItem(BreweryPlugin.getInstance().parseInt(slot), (ItemStack)items.get(slot));
            }
        }
        this.time = time;
        this.id = id;
        this.body = new BarrelBody(this, sign, bounds);
    }

    public Barrel(Block spigot, byte sign, BoundingBox bounds, ItemStack[] items, float time, UUID id) {
        this.spigot = spigot;
        this.inventory = this.isLarge() ? BreweryPlugin.getInstance().getServer().createInventory((InventoryHolder)this, 27, BreweryPlugin.getInstance().languageReader.get("Etc_Barrel", new String[0])) : BreweryPlugin.getInstance().getServer().createInventory((InventoryHolder)this, 9, BreweryPlugin.getInstance().languageReader.get("Etc_Barrel", new String[0]));
        if (items != null) {
            for (int slot = 0; slot < items.length; ++slot) {
                if (items[slot] == null) continue;
                this.inventory.setItem(slot, items[slot]);
            }
        }
        this.time = time;
        this.id = id;
        this.body = new BarrelBody(this, sign, bounds);
    }

    public static void onUpdate() {
        for (Barrel barrel : barrels) {
            if (barrel == null) continue;
            barrel.time += (float)(1.0 / (double)BConfig.agingYearDuration);
        }
        int numBarrels = barrels.size();
        if (check == 0 && numBarrels > 0) {
            Barrel randomInTheBack;
            Barrel random = barrels.get((int)Math.floor(Math.random() * (double)numBarrels));
            if (random != null) {
                random.checked = false;
            }
            if (numBarrels > 50 && (randomInTheBack = barrels.get(numBarrels - 1 - (int)(Math.random() * (double)(numBarrels >>> 2)))) != null) {
                randomInTheBack.checked = false;
            }
            new BarrelCheck().runTaskTimer((Plugin)BreweryPlugin.getInstance(), 1L, 1L);
        }
    }

    public boolean hasPermsOpen(Player player, PlayerInteractEvent event) {
        if (this.isLarge()) {
            if (!player.hasPermission("brewery.openbarrel.big")) {
                BreweryPlugin.getInstance().msg((CommandSender)player, BreweryPlugin.getInstance().languageReader.get("Error_NoBarrelAccess", new String[0]));
                return false;
            }
        } else if (!player.hasPermission("brewery.openbarrel.small")) {
            BreweryPlugin.getInstance().msg((CommandSender)player, BreweryPlugin.getInstance().languageReader.get("Error_NoBarrelAccess", new String[0]));
            return false;
        }
        BarrelAccessEvent accessEvent = new BarrelAccessEvent(this, player, event.getClickedBlock(), event.getBlockFace());
        BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)accessEvent);
        return !accessEvent.isCancelled();
    }

    public boolean hasPermsDestroy(Player player, Block block, BarrelDestroyEvent.Reason reason) {
        BarrelDestroyEvent destroyEvent = new BarrelDestroyEvent(this, block, reason, player);
        BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)destroyEvent);
        return !destroyEvent.isCancelled();
    }

    public void open(Player player) {
        if (this.inventory == null) {
            this.inventory = this.isLarge() ? BreweryPlugin.getInstance().getServer().createInventory((InventoryHolder)this, 27, BreweryPlugin.getInstance().languageReader.get("Etc_Barrel", new String[0])) : BreweryPlugin.getInstance().getServer().createInventory((InventoryHolder)this, 9, BreweryPlugin.getInstance().languageReader.get("Etc_Barrel", new String[0]));
        } else if (this.time > 0.0f && this.inventory.getViewers().isEmpty() && this.inventory.contains(Material.POTION)) {
            byte wood = this.body.getWood();
            long loadTime = System.nanoTime();
            for (ItemStack item : this.inventory.getContents()) {
                Brew brew;
                if (item == null || (brew = Brew.get(item)) == null) continue;
                brew.age(item, this.time, wood);
            }
            loadTime = System.nanoTime() - loadTime;
            float ftime = (float)((double)loadTime / 1000000.0);
            BreweryPlugin.getInstance().debugLog("opening Barrel with potions (" + ftime + "ms)");
        }
        this.time = 0.0f;
        if (BConfig.useLB) {
            try {
                LogBlockBarrel.openBarrel((HumanEntity)player, this.inventory, this.spigot.getLocation());
            }
            catch (Throwable e) {
                BreweryPlugin.getInstance().errorLog("Failed to Log Barrel to LogBlock!", e);
            }
        }
        player.openInventory(this.inventory);
    }

    public void playOpeningSound() {
        float randPitch = (float)(Math.random() * 0.1);
        Location location = this.getSpigot().getLocation();
        if (location.getWorld() == null) {
            return;
        }
        if (this.isLarge()) {
            location.getWorld().playSound(location, Sound.BLOCK_CHEST_OPEN, SoundCategory.BLOCKS, 0.4f, 0.55f + randPitch);
            location.getWorld().playSound(location, Sound.BLOCK_BREWING_STAND_BREW, SoundCategory.BLOCKS, 0.4f, 0.45f + randPitch);
        } else {
            location.getWorld().playSound(location, Sound.BLOCK_BARREL_OPEN, SoundCategory.BLOCKS, 0.5f, 0.8f + randPitch);
        }
    }

    public void playClosingSound() {
        float randPitch = (float)(Math.random() * 0.1);
        Location location = this.getSpigot().getLocation();
        if (location.getWorld() == null) {
            return;
        }
        if (this.isLarge()) {
            location.getWorld().playSound(location, Sound.BLOCK_BARREL_CLOSE, SoundCategory.BLOCKS, 0.5f, 0.5f + randPitch);
            location.getWorld().playSound(location, Sound.ITEM_BUCKET_EMPTY, SoundCategory.BLOCKS, 0.2f, 0.6f + randPitch);
        } else {
            location.getWorld().playSound(location, Sound.BLOCK_BARREL_CLOSE, SoundCategory.BLOCKS, 0.5f, 0.8f + randPitch);
        }
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public Block getSpigot() {
        return this.spigot;
    }

    @NotNull
    public BarrelBody getBody() {
        return this.body;
    }

    public float getTime() {
        return this.time;
    }

    public static List<Barrel> getBarrels() {
        return barrels;
    }

    public UUID getId() {
        return this.id;
    }

    public boolean hasBlock(Block block) {
        return this.body.hasBlock(block);
    }

    @Deprecated
    public boolean hasWoodBlock(Block block) {
        return this.body.hasBlock(block);
    }

    @Deprecated
    public boolean hasStairsBlock(Block block) {
        return this.body.hasBlock(block);
    }

    @Nullable
    public static Barrel get(Block block) {
        if (block == null) {
            return null;
        }
        Material type = block.getType();
        if (LegacyUtil.isFence(type) || LegacyUtil.isSign(type)) {
            return Barrel.getBySpigot(block);
        }
        return Barrel.getByWood(block);
    }

    @Nullable
    public static Barrel getBySpigot(Block sign) {
        Block spigot = BarrelBody.getSpigotOfSign(sign);
        byte signoffset = 0;
        if (!spigot.equals(sign)) {
            signoffset = (byte)(sign.getY() - spigot.getY());
        }
        int i = 0;
        for (Barrel barrel : barrels) {
            if (barrel != null && barrel.body.isSignOfBarrel(signoffset) && barrel.spigot.equals(spigot)) {
                if (barrel.body.getSignoffset() == 0 && signoffset != 0) {
                    barrel.body.setSignoffset(signoffset);
                }
                Barrel.moveMRU(i);
                return barrel;
            }
            ++i;
        }
        return null;
    }

    @Nullable
    public static Barrel getByWood(Block wood) {
        if (LegacyUtil.isWoodPlanks(wood.getType()) || LegacyUtil.isWoodStairs(wood.getType())) {
            int i = 0;
            for (Barrel barrel : barrels) {
                if (barrel.getSpigot().getWorld().equals(wood.getWorld()) && barrel.body.getBounds().contains(wood)) {
                    Barrel.moveMRU(i);
                    return barrel;
                }
                ++i;
            }
        }
        return null;
    }

    private static void moveMRU(int index) {
        if (index > 0) {
            barrels.set(index - 1, barrels.set(index, barrels.get(index - 1)));
        }
    }

    public static boolean create(Block sign, Player player) {
        Barrel barrel;
        Block spigot = BarrelBody.getSpigotOfSign(sign);
        if (Barrel.get(spigot) != null) {
            return false;
        }
        byte signoffset = 0;
        if (!spigot.equals(sign)) {
            signoffset = (byte)(sign.getY() - spigot.getY());
        }
        if ((barrel = Barrel.getBySpigot(spigot)) == null) {
            barrel = new Barrel(spigot, signoffset);
            if (barrel.body.getBrokenBlock(true) == null) {
                if (LegacyUtil.isSign(spigot.getType())) {
                    if (!player.hasPermission("brewery.createbarrel.small")) {
                        BreweryPlugin.getInstance().msg((CommandSender)player, BreweryPlugin.getInstance().languageReader.get("Perms_NoSmallBarrelCreate", new String[0]));
                        return false;
                    }
                } else if (!player.hasPermission("brewery.createbarrel.big")) {
                    BreweryPlugin.getInstance().msg((CommandSender)player, BreweryPlugin.getInstance().languageReader.get("Perms_NoBigBarrelCreate", new String[0]));
                    return false;
                }
                BarrelCreateEvent createEvent = new BarrelCreateEvent(barrel, player);
                BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)createEvent);
                if (!createEvent.isCancelled()) {
                    barrels.add(0, barrel);
                    return true;
                }
            }
        } else if (barrel.body.getSignoffset() == 0 && signoffset != 0) {
            barrel.body.setSignoffset(signoffset);
            return true;
        }
        return false;
    }

    public void remove(@Nullable Block broken, @Nullable Player breaker, boolean dropItems) {
        BarrelRemoveEvent event = new BarrelRemoveEvent(this, dropItems);
        BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)event);
        if (this.inventory != null) {
            ArrayList viewers = new ArrayList(this.inventory.getViewers());
            for (HumanEntity viewer : viewers) {
                viewer.closeInventory();
            }
            ItemStack[] items = this.inventory.getContents();
            this.inventory.clear();
            if (BConfig.useLB && breaker != null) {
                try {
                    LogBlockBarrel.breakBarrel(breaker, items, this.spigot.getLocation());
                }
                catch (Throwable e) {
                    BreweryPlugin.getInstance().errorLog("Failed to Log Barrel-break to LogBlock!");
                    BreweryPlugin.getInstance().errorLog("Brewery was tested with version 1.94 of LogBlock!");
                    e.printStackTrace();
                }
            }
            if (event.willDropItems()) {
                if (this.body == null) {
                    BreweryPlugin.getInstance().debugLog("Barrel Body is null, can't drop items: " + this.id);
                    barrels.remove(this);
                    return;
                }
                byte wood = this.body.getWood();
                for (ItemStack item : items) {
                    if (item == null) continue;
                    Brew brew = Brew.get(item);
                    if (brew != null) {
                        brew.age(item, this.time, wood);
                        PotionMeta meta = (PotionMeta)item.getItemMeta();
                        if (BrewLore.hasColorLore(meta)) {
                            BrewLore lore = new BrewLore(brew, meta);
                            lore.convertLore(false);
                            lore.write();
                            item.setItemMeta((ItemMeta)meta);
                        }
                    }
                    if (broken != null) {
                        broken.getWorld().dropItem(broken.getLocation(), item);
                        continue;
                    }
                    this.spigot.getWorld().dropItem(this.spigot.getLocation(), item);
                }
            }
        }
        barrels.remove(this);
    }

    public boolean isLarge() {
        return !this.isSmall();
    }

    public boolean isSmall() {
        if (!BreweryPlugin.isFolia()) {
            return LegacyUtil.isSign(this.spigot.getType());
        }
        AtomicBoolean type = new AtomicBoolean(false);
        BreweryPlugin.getScheduler().runTask(this.spigot.getLocation(), () -> type.set(LegacyUtil.isSign(this.spigot.getType())));
        return type.get();
    }

    public Block getSignOfSpigot() {
        return this.body.getSignOfSpigot();
    }

    public static Block getSpigotOfSign(Block block) {
        return BarrelBody.getSpigotOfSign(block);
    }

    public Block getBrokenBlock(boolean force) {
        return this.body.getBrokenBlock(force);
    }

    public static boolean hasDataInWorld(World world) {
        return barrels.stream().anyMatch(barrel -> barrel.spigot.getWorld().equals(world));
    }

    public static void onUnload(World world) {
        barrels.removeIf(barrel -> barrel.spigot.getWorld().equals(world));
    }

    public static void unloadWorlds() {
        List worlds = BreweryPlugin.getInstance().getServer().getWorlds();
        barrels.removeIf(barrel -> !worlds.contains(barrel.spigot.getWorld()));
    }

    public static void save(ConfigurationSection config, ConfigurationSection oldData) {
        BUtil.createWorldSections(config);
        if (!barrels.isEmpty()) {
            int id = 0;
            for (Barrel barrel : barrels) {
                String worldName = barrel.spigot.getWorld().getName();
                String prefix = worldName.startsWith("DXL_") ? BUtil.getDxlName(worldName) + "." + id : barrel.spigot.getWorld().getUID() + "." + id;
                config.set(prefix + ".spigot", (Object)(barrel.spigot.getX() + "/" + barrel.spigot.getY() + "/" + barrel.spigot.getZ()));
                barrel.body.save(config, prefix);
                if (barrel.inventory != null) {
                    ConfigurationSection invConfig = null;
                    for (int slot = 0; slot < barrel.inventory.getSize(); ++slot) {
                        ItemStack item = barrel.inventory.getItem(slot);
                        if (item == null) continue;
                        if (invConfig == null) {
                            if (barrel.time != 0.0f) {
                                config.set(prefix + ".time", (Object)Float.valueOf(barrel.time));
                            }
                            invConfig = config.createSection(prefix + ".inv");
                        }
                        invConfig.set("" + slot, (Object)item);
                    }
                }
                ++id;
            }
        }
        if (oldData != null) {
            for (String uuid : oldData.getKeys(false)) {
                if (config.contains(uuid)) continue;
                config.set(uuid, oldData.get(uuid));
            }
        }
    }

    public static class BarrelCheck
    extends UniversalRunnable {
        @Override
        public void run() {
            boolean repeat = true;
            while (repeat) {
                if (check < barrels.size()) {
                    Barrel barrel = barrels.get(check);
                    if (!barrel.checked) {
                        BreweryPlugin.getScheduler().runTask(barrel.getSpigot().getLocation(), () -> {
                            Block broken = barrel.body.getBrokenBlock(false);
                            if (broken != null) {
                                BreweryPlugin.getInstance().debugLog("Barrel at " + broken.getWorld().getName() + "/" + broken.getX() + "/" + broken.getY() + "/" + broken.getZ() + " has been destroyed unexpectedly, contents will drop");
                                barrel.remove(broken, null, true);
                            } else {
                                barrel.checked = true;
                            }
                        });
                        repeat = false;
                    }
                    ++check;
                    continue;
                }
                check = 0;
                repeat = false;
                this.cancel();
            }
        }
    }
}

