/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery;

import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.Wakeup;
import com.dre.brewery.api.events.PlayerEffectEvent;
import com.dre.brewery.api.events.PlayerPukeEvent;
import com.dre.brewery.api.events.PlayerPushEvent;
import com.dre.brewery.api.events.brew.BrewDrinkEvent;
import com.dre.brewery.depend.universalScheduler.scheduling.tasks.MyScheduledTask;
import com.dre.brewery.filedata.BConfig;
import com.dre.brewery.lore.BrewLore;
import com.dre.brewery.recipe.BEffect;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.MinecraftVersion;
import com.dre.brewery.utility.PermissionUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class BPlayer {
    private static final MinecraftVersion VERSION = BreweryPlugin.getMCVersion();
    private static final ConcurrentHashMap<String, BPlayer> players = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Player, Integer> pTasks = new ConcurrentHashMap();
    private static MyScheduledTask task;
    private static Random pukeRand;
    private final String uuid;
    private int quality = 0;
    private int drunkenness = 0;
    private int offlineDrunk = 0;
    private int alcRecovery = -1;
    private Vector push = new Vector(0, 0, 0);
    private int time = 20;

    public BPlayer(String uuid) {
        this.uuid = uuid;
    }

    public BPlayer(String uuid, int quality, int drunkenness, int offlineDrunk) {
        this.quality = quality;
        this.drunkenness = drunkenness;
        this.offlineDrunk = offlineDrunk;
        this.uuid = uuid;
    }

    public BPlayer(UUID uuid, int quality, int drunkenness, int offlineDrunk) {
        this(uuid.toString(), quality, drunkenness, offlineDrunk);
    }

    public BPlayer(UUID uuid) {
        this(uuid.toString());
    }

    @Nullable
    public static BPlayer get(OfflinePlayer player) {
        if (!players.isEmpty()) {
            return players.get(BUtil.playerString(player));
        }
        return null;
    }

    @Nullable
    public static BPlayer getByName(String playerName) {
        for (Map.Entry<String, BPlayer> entry : players.entrySet()) {
            OfflinePlayer p = BreweryPlugin.getInstance().getServer().getOfflinePlayer(UUID.fromString(entry.getKey()));
            String name = p.getName();
            if (name == null || !name.equalsIgnoreCase(playerName)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static boolean hasPlayerbyName(String playerName) {
        for (Map.Entry<String, BPlayer> entry : players.entrySet()) {
            String name;
            OfflinePlayer p = BreweryPlugin.getInstance().getServer().getOfflinePlayer(UUID.fromString(entry.getKey()));
            if (p == null || (name = p.getName()) == null || !name.equalsIgnoreCase(playerName)) continue;
            return true;
        }
        return false;
    }

    public static ConcurrentHashMap<String, BPlayer> getPlayers() {
        return players;
    }

    public static boolean isEmpty() {
        return players.isEmpty();
    }

    public static boolean hasPlayer(OfflinePlayer player) {
        return players.containsKey(BUtil.playerString(player));
    }

    public static BPlayer addPlayer(OfflinePlayer player) {
        BPlayer bPlayer = new BPlayer(BUtil.playerString(player));
        players.put(BUtil.playerString(player), bPlayer);
        return bPlayer;
    }

    public static void remove(OfflinePlayer player) {
        players.remove(BUtil.playerString(player));
    }

    public static int numDrunkPlayers() {
        return players.size();
    }

    public void remove() {
        Iterator<Map.Entry<String, BPlayer>> iterator = players.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BPlayer> entry = iterator.next();
            if (entry.getValue() != this) continue;
            iterator.remove();
            return;
        }
    }

    public static void clear() {
        players.clear();
    }

    public static boolean drink(Brew brew, ItemMeta meta, Player player) {
        BPlayer bPlayer = BPlayer.get((OfflinePlayer)player);
        if (bPlayer == null) {
            bPlayer = BPlayer.addPlayer((OfflinePlayer)player);
        }
        BrewDrinkEvent drinkEvent = new BrewDrinkEvent(brew, meta, player, bPlayer);
        if (meta != null) {
            BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)drinkEvent);
            if (brew != drinkEvent.getBrew()) {
                brew = drinkEvent.getBrew();
            }
            if (drinkEvent.isCancelled()) {
                if (bPlayer.drunkenness <= 0) {
                    bPlayer.remove();
                }
                return false;
            }
        }
        if (brew.hasRecipe()) {
            brew.getCurrentRecipe().applyDrinkFeatures(player, brew.getQuality());
        }
        BreweryPlugin.getInstance().stats.forDrink(brew);
        int brewAlc = drinkEvent.getAddedAlcohol();
        int quality = drinkEvent.getQuality();
        List<PotionEffect> effects = BPlayer.getBrewEffects(brew.getEffects(), quality);
        BPlayer.applyEffects(effects, player, PlayerEffectEvent.EffectType.DRINK);
        if (brewAlc < 0) {
            bPlayer.drain(player, -brewAlc);
        } else if (brewAlc > 0) {
            bPlayer.drunkenness += brewAlc;
            bPlayer.quality = quality > 0 ? (bPlayer.quality += quality * brewAlc) : (bPlayer.quality += brewAlc);
            BPlayer.applyEffects(BPlayer.getQualityEffects(quality, brewAlc), player, PlayerEffectEvent.EffectType.QUALITY);
        }
        if (bPlayer.drunkenness > 100) {
            bPlayer.drinkCap(player);
        }
        if (BConfig.showStatusOnDrink && (brewAlc != 0 || bPlayer.drunkenness > 0)) {
            bPlayer.showDrunkeness(player);
        }
        if (bPlayer.drunkenness <= 0) {
            bPlayer.remove();
        }
        return true;
    }

    public void showDrunkeness(Player player) {
        try {
            if (this.sendDrunkenessMessage(player)) {
                BreweryPlugin.getScheduler().runTaskLater(() -> this.sendDrunkenessMessage(player), 40L);
                BreweryPlugin.getScheduler().runTaskLater(() -> this.sendDrunkenessMessage(player), 80L);
            }
        }
        catch (Exception e) {
            BreweryPlugin.getInstance().errorLog("Failed to show drunkenness to " + player.getName(), e);
        }
    }

    public boolean sendDrunkenessMessage(Player player) {
        StringBuilder b = new StringBuilder(100);
        int strength = this.drunkenness;
        boolean hangover = false;
        if (this.offlineDrunk > 0) {
            strength = this.offlineDrunk;
            hangover = true;
        }
        b.append(BreweryPlugin.getInstance().languageReader.get(hangover ? "Player_Hangover" : "Player_Drunkeness", new String[0]));
        b.append(": \u00a77[");
        b.append(this.generateBars(strength, hangover));
        b.append("\u00a77] ");
        int quality = hangover ? 11 - this.getHangoverQuality() : (strength > 0 ? this.getQuality() : 0);
        b.append("\u00a77[");
        b.append(this.generateStars(quality));
        b.append("\u00a77]");
        String text = b.toString();
        if (hangover && VERSION.isOrLater(MinecraftVersion.V1_11)) {
            BreweryPlugin.getScheduler().runTaskLater(() -> player.sendTitle("", text, 30, 100, 90), 160L);
            return false;
        }
        try {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)text));
            return true;
        }
        catch (NoSuchMethodError | UnsupportedOperationException e) {
            player.sendMessage(text);
            return false;
        }
    }

    private String generateBars(int strength, boolean hangover) {
        StringBuilder b = new StringBuilder();
        int bars = strength <= 0 ? 0 : (strength == 1 ? 1 : Math.round((float)strength / 4.0f));
        int noBars = 25 - bars;
        if (bars > 0) {
            b.append(hangover ? "\u00a7c" : "\u00a76");
        }
        for (int addedBars = 0; addedBars < bars; ++addedBars) {
            b.append("|");
            if (addedBars != 20) continue;
            b.append("\u00a7c");
        }
        if (noBars > 0) {
            b.append("\u00a70");
            while (noBars > 0) {
                b.append("|");
                --noBars;
            }
        }
        return b.toString();
    }

    public String generateBars() {
        return this.generateBars(this.offlineDrunk > 0 ? this.offlineDrunk : this.drunkenness, this.offlineDrunk > 0);
    }

    private String generateStars(int quality) {
        int stars;
        StringBuilder b = new StringBuilder();
        boolean half = quality % 2 > 0;
        int noStars = 5 - stars - (half ? 1 : 0);
        b.append(BrewLore.getQualityColor(quality));
        for (stars = quality / 2; stars > 0; --stars) {
            b.append("\u2b51");
        }
        if (half) {
            b.append("\u2b52");
        }
        if (noStars > 0) {
            b.append("\u00a70");
            while (noStars > 0) {
                b.append("\u2b51");
                --noStars;
            }
        }
        return b.toString();
    }

    public String generateStars() {
        return this.generateStars(this.offlineDrunk > 0 ? 11 - this.getHangoverQuality() : (this.drunkenness > 0 ? this.getQuality() : 0));
    }

    public void drinkCap(Player player) {
        this.quality = this.getQuality() * 100;
        this.drunkenness = 100;
        if (BConfig.overdrinkKick && !player.hasPermission("brewery.bypass.overdrink")) {
            BreweryPlugin.getScheduler().runTaskLater(() -> this.passOut(player), 1L);
        } else {
            BPlayer.addPuke(player, 60 + (int)(Math.random() * 60.0));
            BreweryPlugin.getInstance().msg((CommandSender)player, BreweryPlugin.getInstance().languageReader.get("Player_CantDrink", new String[0]));
        }
    }

    public static void playerMove(PlayerMoveEvent event) {
        BPlayer bPlayer = BPlayer.get((OfflinePlayer)event.getPlayer());
        if (bPlayer != null) {
            bPlayer.move(event);
        }
    }

    public void drainByItem(Player player, Material mat) {
        int strength = BConfig.drainItems.get(mat);
        if (this.drain(player, strength)) {
            BPlayer.remove((OfflinePlayer)player);
        }
    }

    public boolean drain(@Nullable Player player, int amount) {
        if (this.drunkenness > 0) {
            this.quality -= this.getQuality() * amount;
        }
        this.drunkenness -= amount;
        if (this.drunkenness > 0) {
            if (this.offlineDrunk == 0 && player == null) {
                this.offlineDrunk = this.drunkenness;
            }
        } else {
            if (this.offlineDrunk == 0) {
                return true;
            }
            if (this.drunkenness == 0) {
                --this.drunkenness;
            }
            this.quality = this.getQuality();
            if (this.drunkenness <= -this.offlineDrunk) {
                return this.drunkenness <= -BConfig.hangoverTime;
            }
        }
        return false;
    }

    public void move(PlayerMoveEvent event) {
        if (this.drunkenness >= 10 && BConfig.stumbleModifier > 0.001f && this.drunkenness <= 100) {
            Player player;
            if (this.time > 1) {
                --this.time;
            } else if ((event.getFrom().getX() != event.getTo().getX() || event.getFrom().getZ() != event.getTo().getZ()) && (player = event.getPlayer()).isOnGround()) {
                --this.time;
                if (this.time == 0) {
                    if (VERSION.isOrLater(MinecraftVersion.V1_9)) {
                        this.push.setX((Math.random() - 0.5) / 2.0);
                        this.push.setZ((Math.random() - 0.5) / 2.0);
                    } else {
                        this.push.setX(Math.random() - 0.5);
                        this.push.setZ(Math.random() - 0.5);
                    }
                    this.push.multiply(BConfig.stumbleModifier);
                    PlayerPushEvent pushEvent = new PlayerPushEvent(player, this.push, this);
                    BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)pushEvent);
                    this.push = pushEvent.getPush();
                    if (pushEvent.isCancelled() || this.push.lengthSquared() <= 0.0) {
                        this.time = -10;
                        return;
                    }
                    player.setVelocity(this.push);
                } else if (this.time < 0 && this.time > -10) {
                    player.setVelocity(this.push);
                } else {
                    this.time = (int)(Math.random() * (201.0 - (double)(this.drunkenness * 2)));
                }
            }
        }
    }

    public void passOut(Player player) {
        player.kickPlayer(BreweryPlugin.getInstance().languageReader.get("Player_DrunkPassOut", new String[0]));
        this.offlineDrunk = this.drunkenness;
    }

    public boolean canJoinSimpleStatus() {
        return this.canJoin() == 0;
    }

    public int canJoin() {
        if (this.drunkenness <= 70) {
            return 0;
        }
        if (!BConfig.enableLoginDisallow) {
            if (this.drunkenness <= 100) {
                return 0;
            }
            return 3;
        }
        if (this.drunkenness <= 90) {
            if (Math.random() > 0.4) {
                return 0;
            }
            return 2;
        }
        if (this.drunkenness <= 100) {
            if (Math.random() > 0.6) {
                return 0;
            }
            return 2;
        }
        return 3;
    }

    public void join(Player player) {
        if (this.offlineDrunk == 0) {
            return;
        }
        BreweryPlugin.getScheduler().runTaskLater(() -> this.login(player), 1L);
    }

    public void login(Player player) {
        if (this.drunkenness < 10) {
            if (this.offlineDrunk > 60 && BConfig.enableHome && !player.hasPermission("brewery.bypass.teleport")) {
                this.goHome(player);
            }
            if (this.offlineDrunk > 20) {
                this.hangoverEffects(player);
                this.showDrunkeness(player);
            }
            if (this.drunkenness <= 0) {
                BPlayer.remove((OfflinePlayer)player);
            }
        } else if (this.offlineDrunk - this.drunkenness >= 30) {
            Location randomLoc;
            if (BConfig.enableWake && !player.hasPermission("brewery.bypass.teleport") && (randomLoc = Wakeup.getRandom(player.getLocation())) != null) {
                player.teleport(randomLoc);
                BreweryPlugin.getInstance().msg((CommandSender)player, BreweryPlugin.getInstance().languageReader.get("Player_Wake", new String[0]));
            }
            this.offlineDrunk = 0;
        }
        this.offlineDrunk = 0;
    }

    public void disconnecting() {
        this.offlineDrunk = this.drunkenness;
    }

    public void goHome(Player player) {
        String homeType = BConfig.homeType;
        if (homeType != null) {
            Location home = null;
            if (homeType.equalsIgnoreCase("bed")) {
                home = player.getBedSpawnLocation();
            } else if (homeType.startsWith("cmd: ")) {
                player.performCommand(homeType.substring(5));
            } else if (homeType.startsWith("cmd:")) {
                player.performCommand(homeType.substring(4));
            } else {
                BreweryPlugin.getInstance().errorLog("Config.yml 'homeType: " + homeType + "' unknown!");
            }
            if (home != null) {
                player.teleport(home);
            }
        }
    }

    public void recalculateAlcRecovery(@Nullable Player player) {
        int rec;
        this.setAlcRecovery(2);
        if (player != null && (rec = PermissionUtil.getAlcRecovery((Permissible)player)) > -1) {
            this.setAlcRecovery(rec);
        }
    }

    public void drunkPuke(Player player) {
        if (this.drunkenness >= 90) {
            if (Math.random() < (double)(0.2f - (float)this.getQuality() / 100.0f)) {
                BPlayer.addPuke(player, 20 + (int)(Math.random() * 40.0));
            }
        } else if (this.drunkenness >= 80) {
            if (Math.random() < (double)(0.15f - (float)this.getQuality() / 66.0f)) {
                BPlayer.addPuke(player, 10 + (int)(Math.random() * 30.0));
            }
        } else if (this.drunkenness >= 70 && Math.random() < (double)(0.1f - (float)this.getQuality() / 60.0f)) {
            BPlayer.addPuke(player, 10 + (int)(Math.random() * 20.0));
        }
    }

    public static void addPuke(Player player, int count) {
        if (!BConfig.enablePuke) {
            return;
        }
        PlayerPukeEvent event = new PlayerPukeEvent(player, count);
        BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getCount() < 1) {
            return;
        }
        BUtil.reapplyPotionEffect(player, PotionEffectType.HUNGER.createEffect(80, 4), true);
        if (pTasks.isEmpty()) {
            task = BreweryPlugin.getScheduler().runTaskTimer((Entity)player, BPlayer::pukeTask, 1L, 1L);
        }
        pTasks.put(player, event.getCount());
    }

    public static void pukeTask() {
        Iterator<Map.Entry<Player, Integer>> iter = pTasks.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Player, Integer> entry = iter.next();
            Player player = entry.getKey();
            int count = entry.getValue();
            if (!player.isValid() || !player.isOnline()) {
                iter.remove();
            }
            BPlayer.puke(player);
            if (count <= 1) {
                iter.remove();
                continue;
            }
            entry.setValue(count - 1);
        }
        if (pTasks.isEmpty()) {
            task.cancel();
        }
    }

    public static void puke(Player player) {
        int pukeDespawntime;
        if (pukeRand == null) {
            pukeRand = new Random();
        }
        if (BConfig.pukeItem == null || BConfig.pukeItem.isEmpty()) {
            BConfig.pukeItem = List.of(Material.SOUL_SAND);
        }
        Location loc = player.getLocation();
        loc.setY(loc.getY() + 1.1);
        loc.setPitch(loc.getPitch() - 10.0f + (float)pukeRand.nextInt(20));
        loc.setYaw(loc.getYaw() - 10.0f + (float)pukeRand.nextInt(20));
        Vector direction = loc.getDirection();
        direction.multiply(0.5);
        loc.add(direction);
        Item item = player.getWorld().dropItem(loc, new ItemStack(BConfig.pukeItem.get(new Random().nextInt(BConfig.pukeItem.size()))));
        item.setVelocity(direction);
        item.setPickupDelay(Short.MAX_VALUE);
        item.setMetadata("brewery_puke", (MetadataValue)new FixedMetadataValue((Plugin)BreweryPlugin.getInstance(), (Object)true));
        if (VERSION.isOrLater(MinecraftVersion.V1_14)) {
            item.setPersistent(false);
        }
        if ((pukeDespawntime = BConfig.pukeDespawntime) >= 5800) {
            return;
        }
        if (pukeDespawntime <= 0) {
            item.setTicksLived(5996);
        } else if (pukeDespawntime <= 120) {
            item.setTicksLived(6000 - pukeDespawntime + pukeRand.nextInt((int)((float)pukeDespawntime / 2.0f)));
        } else {
            item.setTicksLived(6000 - pukeDespawntime + pukeRand.nextInt(100));
        }
    }

    public static void applyEffects(List<PotionEffect> effects, Player player, PlayerEffectEvent.EffectType effectType) {
        PlayerEffectEvent event = new PlayerEffectEvent(player, effectType, effects);
        BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)event);
        effects = event.getEffects();
        if (event.isCancelled() || effects == null) {
            return;
        }
        for (PotionEffect effect : effects) {
            BUtil.reapplyPotionEffect(player, effect, true);
        }
    }

    public void drunkEffects(Player player) {
        int duration = 10 - this.getQuality();
        duration += this.drunkenness / 2;
        if ((duration *= 5) > 240) {
            duration *= 5;
        } else if (duration < 115) {
            duration = 115;
        }
        if (VERSION.isOrEarlier(MinecraftVersion.V1_14)) {
            duration *= 4;
        }
        List<PotionEffect> l = new ArrayList<PotionEffect>(1);
        l.add(PotionEffectType.CONFUSION.createEffect(duration, 0));
        PlayerEffectEvent event = new PlayerEffectEvent(player, PlayerEffectEvent.EffectType.ALCOHOL, l);
        BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)event);
        l = event.getEffects();
        if (event.isCancelled() || l == null) {
            return;
        }
        for (PotionEffect effect : l) {
            BreweryPlugin.getScheduler().runTask((Entity)player, () -> effect.apply((LivingEntity)player));
        }
    }

    public static List<PotionEffect> getQualityEffects(int quality, int brewAlc) {
        ArrayList<PotionEffect> out = new ArrayList<PotionEffect>(2);
        int duration = 7 - quality;
        if (quality == 0) {
            duration *= 125;
        } else if (quality <= 5) {
            duration *= 62;
        } else {
            duration = 25;
            if (brewAlc <= 10) {
                duration = 0;
            }
        }
        if (VERSION.isOrEarlier(MinecraftVersion.V1_14)) {
            duration *= 4;
        }
        if (duration > 0) {
            out.add(PotionEffectType.POISON.createEffect(duration, 0));
        }
        if (brewAlc > 10) {
            if (quality <= 5) {
                duration = 10 - quality;
                duration += brewAlc;
                duration *= 15;
            } else {
                duration = 30;
            }
            if (VERSION.isOrEarlier(MinecraftVersion.V1_14)) {
                duration *= 4;
            }
            out.add(PotionEffectType.BLINDNESS.createEffect(duration, 0));
        }
        return out;
    }

    public static void addQualityEffects(int quality, int brewAlc, Player player) {
        List<PotionEffect> list = BPlayer.getQualityEffects(quality, brewAlc);
        PlayerEffectEvent event = new PlayerEffectEvent(player, PlayerEffectEvent.EffectType.QUALITY, list);
        BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)event);
        list = event.getEffects();
        if (event.isCancelled() || list == null) {
            return;
        }
        for (PotionEffect effect : list) {
            BUtil.reapplyPotionEffect(player, effect, true);
        }
    }

    public static List<PotionEffect> getBrewEffects(List<BEffect> effects, int quality) {
        ArrayList<PotionEffect> out = new ArrayList<PotionEffect>();
        if (effects != null) {
            for (BEffect effect : effects) {
                PotionEffect e = effect.generateEffect(quality);
                if (e == null) continue;
                out.add(e);
            }
        }
        return out;
    }

    public static void addBrewEffects(Brew brew, Player player) {
        List<BEffect> effects = brew.getEffects();
        if (effects != null) {
            for (BEffect effect : effects) {
                effect.apply(brew.getQuality(), player);
            }
        }
    }

    public void hangoverEffects(Player player) {
        int duration = this.offlineDrunk * 25 * this.getHangoverQuality();
        if (VERSION.isOrEarlier(MinecraftVersion.V1_14)) {
            duration *= 2;
        }
        int amplifier = this.getHangoverQuality() / 3;
        List<PotionEffect> list = new ArrayList<PotionEffect>(2);
        list.add(PotionEffectType.SLOW.createEffect(duration, amplifier));
        list.add(PotionEffectType.HUNGER.createEffect(duration, amplifier));
        PlayerEffectEvent event = new PlayerEffectEvent(player, PlayerEffectEvent.EffectType.HANGOVER, list);
        BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)event);
        list = event.getEffects();
        if (event.isCancelled() || list == null) {
            return;
        }
        for (PotionEffect effect : list) {
            BUtil.reapplyPotionEffect(player, effect, true);
        }
    }

    public static void drunkenness() {
        for (Map.Entry<String, BPlayer> entry : players.entrySet()) {
            Player player;
            String name = entry.getKey();
            BPlayer bplayer = entry.getValue();
            if (bplayer.drunkenness <= 30 || bplayer.offlineDrunk != 0 || (player = BUtil.getPlayerfromString(name)) == null) continue;
            bplayer.drunkEffects(player);
            if (!BConfig.enablePuke) continue;
            bplayer.drunkPuke(player);
        }
    }

    public static void onUpdate() {
        if (!players.isEmpty()) {
            Iterator<Map.Entry<String, BPlayer>> iter = players.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, BPlayer> entry = iter.next();
                String uuid = entry.getKey();
                BPlayer bplayer = entry.getValue();
                Player playerIfOnline = BUtil.getPlayerfromString(uuid);
                if (bplayer.getAlcRecovery() == -1) {
                    bplayer.recalculateAlcRecovery(playerIfOnline);
                }
                if (!bplayer.drain(playerIfOnline, bplayer.getAlcRecovery())) continue;
                iter.remove();
            }
        }
    }

    public static void save(ConfigurationSection config) {
        for (Map.Entry<String, BPlayer> entry : players.entrySet()) {
            ConfigurationSection section = config.createSection(entry.getKey());
            BPlayer bPlayer = entry.getValue();
            section.set("quality", (Object)bPlayer.quality);
            section.set("drunk", (Object)bPlayer.drunkenness);
            if (bPlayer.offlineDrunk == 0) continue;
            section.set("offDrunk", (Object)bPlayer.offlineDrunk);
        }
    }

    public String getUuid() {
        return this.uuid;
    }

    public int getDrunkeness() {
        return this.drunkenness;
    }

    public void setDrunkeness(int value) {
        this.drunkenness = value;
    }

    public void setData(int drunkenness, int quality) {
        this.quality = quality > 0 ? quality * drunkenness : (this.quality == 0 ? 5 * drunkenness : this.getQuality() * drunkenness);
        this.drunkenness = drunkenness;
    }

    public int getQuality() {
        if (this.drunkenness == 0) {
            return this.quality;
        }
        if (this.drunkenness < 0) {
            return this.quality;
        }
        return Math.round((float)this.quality / (float)this.drunkenness);
    }

    public int getQualityData() {
        return this.quality;
    }

    public void setQuality(int value) {
        this.quality = value;
    }

    public int getHangoverQuality() {
        if (this.drunkenness < 0) {
            return this.quality + 11;
        }
        return -this.getQuality() + 11;
    }

    public int getOfflineDrunkeness() {
        return this.offlineDrunk;
    }

    public int getAlcRecovery() {
        return this.alcRecovery;
    }

    public void setAlcRecovery(int alcRecovery) {
        this.alcRecovery = alcRecovery;
    }

    public String getName() {
        Player player = BUtil.getPlayerfromString(this.uuid);
        if (player != null) {
            return player.getName();
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.uuid));
        return offlinePlayer.getName();
    }
}

