/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.utility;

import com.dre.brewery.BPlayer;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.filedata.BConfig;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class SQLSync {
    private BlockingQueue<Object> saveDataQueue = new ArrayBlockingQueue<Object>(64);
    private static boolean sqlTaskRunning = false;
    private Connection connection;
    private String connector;
    private String user;
    private String password;

    public void updatePlayer(UUID uuid, BPlayer bPlayer, boolean offlineDrain) {
        SQLData_BP bP = new SQLData_BP();
        bP.uuid = uuid;
        bP.drunkeness = bPlayer.getDrunkeness();
        bP.offlineDrunk = bPlayer.getOfflineDrunkeness();
        bP.quality = bPlayer.getQualityData();
        bP.data = null;
        bP.offlineDrain = offlineDrain;
        this.addSaveData(bP);
    }

    public void updateData(String name, String data) {
        SQLData_BD bD = new SQLData_BD();
        bD.name = name;
        bD.data = data;
        this.addSaveData(bD);
    }

    public void removePlayer(UUID uuid) {
        SQLRemove_BP r = new SQLRemove_BP();
        r.uuid = uuid;
        this.addSaveData(r);
    }

    public void removeData(String name) {
        SQLRemove_BD r = new SQLRemove_BD();
        r.name = name;
        this.addSaveData(r);
    }

    private void addSaveData(Object object) {
        this.initAsyncTask();
        try {
            if (!this.saveDataQueue.offer(object, 5L, TimeUnit.SECONDS)) {
                BConfig.sqlSync = null;
                this.closeConnection();
                BreweryPlugin.getInstance().errorLog("SQL saving queue overrun, disabling SQL saving");
            }
        }
        catch (InterruptedException | SQLException e) {
            e.printStackTrace();
        }
    }

    public void fetchPlayerLoginData(UUID uuid) {
        try {
            ResultSet result;
            if (!this.checkConnection() && !this.openConnection()) {
                BreweryPlugin.getInstance().errorLog("Opening SQL Connection failed");
                return;
            }
            Statement statement = this.connection.createStatement();
            if (statement.execute("SELECT * FROM Brewery_Z_BPlayers WHERE uuid = '" + uuid.toString() + "';") && (result = statement.getResultSet()).next()) {
                BreweryPlugin.getScheduler().runTask(() -> {
                    try {
                        new BPlayer(uuid.toString(), result.getInt("quality"), result.getInt("drunkeness"), result.getInt("offlineDrunk"));
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                });
                return;
            }
            BreweryPlugin.getScheduler().runTask(() -> BPlayer.sqlRemoved(uuid));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initAsyncTask() {
        if (sqlTaskRunning) {
            return;
        }
        sqlTaskRunning = true;
        BreweryPlugin.getScheduler().runTaskAsynchronously(new SQLSaver());
    }

    public boolean init(String user, String password) {
        this.user = user;
        this.password = password;
        if (BConfig.sqlHost == null || BConfig.sqlPort == null || user == null || BConfig.sqlDB == null || password == null) {
            BreweryPlugin.getInstance().errorLog("Mysql settings not correctly defined!");
            return false;
        }
        try {
            Class.forName("com.mysql.jdbc.Driver");
            String str = "jdbc:mysql://" + BConfig.sqlHost + ":" + BConfig.sqlPort + "/" + BConfig.sqlDB;
            this.connection = DriverManager.getConnection(str, user, password);
            Statement statement = this.connection.createStatement();
            statement.execute("CREATE TABLE IF NOT EXISTS Brewery_Z_BPlayers (uuid CHAR(36) NOT NULL, quality INT, drunkeness INT, offlineDrunk INT, data VARCHAR(127), PRIMARY KEY (uuid));");
            statement = this.connection.createStatement();
            statement.execute("CREATE TABLE IF NOT EXISTS Brewery_Z_BData (id SMALLINT AUTO_INCREMENT, name VARCHAR(127) NOT NULL UNIQUE, data TEXT, PRIMARY KEY (id));");
            this.connector = str;
        }
        catch (ClassNotFoundException | SQLException e) {
            if (BreweryPlugin.debug) {
                e.printStackTrace();
            } else {
                BreweryPlugin.getInstance().errorLog("SQL Exception occured, set 'debug: true' for more info");
                BreweryPlugin.getInstance().errorLog(e.getMessage());
                Throwable cause = e.getCause();
                if (cause != null) {
                    BreweryPlugin.getInstance().errorLog(cause.getMessage());
                }
            }
            return false;
        }
        return true;
    }

    public boolean openConnection() {
        if (this.connector == null) {
            return false;
        }
        try {
            this.connection = DriverManager.getConnection(this.connector, this.user, this.password);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean checkConnection() throws SQLException {
        return this.connection != null && !this.connection.isClosed();
    }

    public synchronized boolean closeConnection() throws SQLException {
        if (this.connection == null) {
            return false;
        }
        this.connection.close();
        return true;
    }

    private static class SQLData_BP {
        public UUID uuid;
        public int quality;
        public int drunkeness;
        public int offlineDrunk;
        public String data;
        public boolean offlineDrain;

        private SQLData_BP() {
        }
    }

    private static class SQLData_BD {
        public String name;
        public String data;

        private SQLData_BD() {
        }
    }

    private static class SQLRemove_BP {
        public UUID uuid;

        private SQLRemove_BP() {
        }
    }

    private static class SQLRemove_BD {
        public String name;

        private SQLRemove_BD() {
        }
    }

    private class SQLSaver
    implements Runnable {
        private SQLSaver() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) lbl-1000:
            // 8 sources

            {
                o = SQLSync.this.saveDataQueue.take();
                if (!SQLSync.this.checkConnection() && !SQLSync.this.openConnection()) {
                    BreweryPlugin.getInstance().errorLog("Opening SQL Connection failed");
                    return;
                }
                try {
                    if (o instanceof SQLData_BP) {
                        d = (SQLData_BP)o;
                        if (d.offlineDrain) {
                            ps = SQLSync.this.connection.prepareStatement("SELECT offlineDrunk FROM Brewery_Z_BPlayers WHERE uuid = ?;");
                            ps.setString(1, d.uuid.toString());
                            resultSet = ps.executeQuery();
                            if (resultSet.next() && (storedOfflineDrunk = resultSet.getInt("offlineDrunk")) != d.offlineDrunk) {
                                BreweryPlugin.getScheduler().runTask((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$run$0(com.dre.brewery.utility.SQLSync$SQLData_BP ), ()V)((SQLData_BP)d));
                            }
                        }
                        ps = SQLSync.this.connection.prepareStatement("REPLACE INTO Brewery_Z_BPlayers (uuid, quality, drunkeness, offlineDrunk, data) VALUES (?, ?, ?, ?, ?);");
                        ps.setString(1, d.uuid.toString());
                        ps.setInt(2, d.quality);
                        ps.setInt(3, d.drunkeness);
                        ps.setInt(4, d.offlineDrunk);
                        ps.setString(5, d.data);
                        ps.executeUpdate();
                    }
                    if (o instanceof SQLData_BD) {
                        d = (SQLData_BD)o;
                        ps = SQLSync.this.connection.prepareStatement("REPLACE INTO Brewery_Z_BData (name, data) VALUES (?, ?);");
                        ps.setString(1, d.name);
                        ps.setString(2, d.data);
                        ps.executeUpdate();
                    }
                    if (o instanceof SQLRemove_BP) {
                        r = (SQLRemove_BP)o;
                        ps = SQLSync.this.connection.prepareStatement("DELETE FROM Brewery_Z_BPlayers WHERE uuid = ?;");
                        ps.setString(1, r.uuid.toString());
                        ps.executeUpdate();
                    }
                    if (!(o instanceof SQLRemove_BD)) ** GOTO lbl-1000
                    r = (SQLRemove_BD)o;
                    ps = SQLSync.this.connection.prepareStatement("DELETE FROM Brewery_Z_BData WHERE name = ?;");
                    ps.setString(1, r.name);
                    ps.executeUpdate();
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                SQLSync.sqlTaskRunning = false;
            }
        }

        private static /* synthetic */ void lambda$run$0(SQLData_BP d) {
            BPlayer.sqlRemoved(d.uuid);
        }
    }
}

