/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.utility;

import com.dre.brewery.BreweryPlugin;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.TreeSpecies;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Lightable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.tags.ItemTagType;
import org.bukkit.material.Cauldron;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Stairs;
import org.bukkit.material.Tree;
import org.bukkit.material.Wood;
import org.bukkit.persistence.PersistentDataType;

public class LegacyUtil {
    private static Method GET_MATERIAL;
    private static Method GET_BLOCK_TYPE_ID_AT;
    private static Method SET_DATA;
    public static boolean NewNbtVer;
    public static final Material WATER_CAULDRON;
    public static final Material MAGMA_BLOCK;
    public static final Material CAMPFIRE;
    public static final Material SOUL_CAMPFIRE;
    public static final Material SOUL_FIRE;
    public static final Material CLOCK;
    public static final Set<Material> PLANKS;
    public static final Set<Material> WOOD_STAIRS;
    public static final Set<Material> FENCES;
    public static final List<String> UNKNOWN_WOOD;
    public static final int TOTAL_WOOD_TYPES;
    public static final Material STATIONARY_LAVA;
    public static final Material SIGN_POST;
    public static final Material WOOD;

    private static Material get(String name) {
        try {
            return Material.valueOf((String)name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static Material get(String newName, String oldName) {
        try {
            return Material.valueOf((String)(BreweryPlugin.use1_13 ? newName : oldName));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static boolean isWoodPlanks(Material type) {
        return WOOD != null && type == WOOD || PLANKS.contains(type);
    }

    public static boolean isWoodStairs(Material type) {
        return WOOD_STAIRS.contains(type);
    }

    public static boolean isFence(Material type) {
        return FENCES.contains(type);
    }

    public static boolean isSign(Material type) {
        return type.name().endsWith("SIGN") || !BreweryPlugin.use1_13 && type == SIGN_POST;
    }

    public static boolean isCauldronHeatsource(Block block) {
        Material type = block.getType();
        return type != null && (type == Material.FIRE || type == SOUL_FIRE || type == MAGMA_BLOCK || LegacyUtil.litCampfire(block) || LegacyUtil.isLava(type));
    }

    public static boolean isLava(Material type) {
        return type == Material.LAVA || !BreweryPlugin.use1_13 && type == STATIONARY_LAVA;
    }

    public static boolean litCampfire(Block block) {
        BlockData data;
        if ((block.getType() == CAMPFIRE || block.getType() == SOUL_CAMPFIRE) && (data = block.getBlockData()) instanceof Lightable) {
            return ((Lightable)data).isLit();
        }
        return false;
    }

    public static boolean isBottle(Material type) {
        if (type == Material.POTION) {
            return true;
        }
        if (!BreweryPlugin.use1_9) {
            return false;
        }
        if (type == Material.LINGERING_POTION || type == Material.SPLASH_POTION) {
            return true;
        }
        if (!BreweryPlugin.use1_13) {
            return false;
        }
        if (type == Material.EXPERIENCE_BOTTLE) {
            return true;
        }
        if (type.name().equals("DRAGON_BREATH")) {
            return true;
        }
        return type.name().equals("HONEY_BOTTLE");
    }

    public static boolean areStairsInverted(Block block) {
        if (!BreweryPlugin.use1_13) {
            MaterialData data = block.getState().getData();
            return data instanceof Stairs && ((Stairs)data).isInverted();
        }
        BlockData data = block.getBlockData();
        return data instanceof org.bukkit.block.data.type.Stairs && ((org.bukkit.block.data.type.Stairs)data).getHalf() == Bisected.Half.TOP;
    }

    public static byte getWoodType(Block wood) throws NoSuchFieldError, NoClassDefFoundError {
        TreeSpecies woodType;
        if (BreweryPlugin.use1_13 || LegacyUtil.isWoodStairs(wood.getType())) {
            String material = wood.getType().name();
            if (material.startsWith("OAK")) {
                return 2;
            }
            if (material.startsWith("SPRUCE")) {
                return 4;
            }
            if (material.startsWith("BIRCH")) {
                return 1;
            }
            if (material.startsWith("JUNGLE")) {
                return 3;
            }
            if (material.startsWith("ACACIA")) {
                return 5;
            }
            if (material.startsWith("DARK_OAK")) {
                return 6;
            }
            if (material.startsWith("CRIMSON")) {
                return 7;
            }
            if (material.startsWith("WARPED")) {
                return 8;
            }
            if (material.startsWith("MANGROVE")) {
                return 9;
            }
            if (material.startsWith("CHERRY")) {
                return 10;
            }
            if (material.startsWith("BAMBOO")) {
                return 11;
            }
            if (!UNKNOWN_WOOD.isEmpty()) {
                for (int i = 0; i < UNKNOWN_WOOD.size(); ++i) {
                    if (!material.startsWith(UNKNOWN_WOOD.get(i))) continue;
                    return (byte)(i + 12);
                }
                return 0;
            }
            return 0;
        }
        MaterialData data = wood.getState().getData();
        if (data instanceof Tree) {
            woodType = ((Tree)data).getSpecies();
        } else if (data instanceof Wood) {
            woodType = ((Wood)data).getSpecies();
        } else {
            return 0;
        }
        switch (woodType) {
            case GENERIC: {
                return 2;
            }
            case REDWOOD: {
                return 4;
            }
            case BIRCH: {
                return 1;
            }
            case JUNGLE: {
                return 3;
            }
            case ACACIA: {
                return 5;
            }
            case DARK_OAK: {
                return 6;
            }
        }
        return 0;
    }

    public static boolean isWaterCauldron(Material type) {
        return WATER_CAULDRON != null ? type == WATER_CAULDRON : type == Material.CAULDRON;
    }

    public static byte getFillLevel(Block block) {
        if (!LegacyUtil.isWaterCauldron(block.getType())) {
            return 0;
        }
        if (BreweryPlugin.use1_13) {
            Levelled cauldron = (Levelled)block.getBlockData();
            if (cauldron.getLevel() == 0) {
                return 0;
            }
            if (cauldron.getLevel() == cauldron.getMaximumLevel()) {
                return 2;
            }
            return 1;
        }
        Cauldron cauldron = (Cauldron)block.getState().getData();
        if (cauldron.isEmpty()) {
            return 0;
        }
        if (cauldron.isFull()) {
            return 2;
        }
        return 1;
    }

    public static Material getMaterial(int id) {
        try {
            return GET_MATERIAL != null ? (Material)GET_MATERIAL.invoke(null, id) : null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return null;
        }
    }

    public static int getBlockTypeIdAt(Location location) {
        try {
            return GET_BLOCK_TYPE_ID_AT != null ? (Integer)GET_BLOCK_TYPE_ID_AT.invoke((Object)location.getWorld(), location) : 0;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return 0;
        }
    }

    public static void setData(Block block, byte data) {
        try {
            SET_DATA.invoke((Object)block, data);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static boolean initNbt() {
        try {
            Class.forName("org.bukkit.persistence.PersistentDataContainer");
            NewNbtVer = true;
            return true;
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("org.bukkit.inventory.meta.tags.CustomItemTagContainer");
                NewNbtVer = false;
                return true;
            }
            catch (ClassNotFoundException ex) {
                NewNbtVer = false;
                return false;
            }
        }
    }

    public static void writeBytesItem(byte[] bytes, ItemMeta meta, NamespacedKey key) {
        if (NewNbtVer) {
            meta.getPersistentDataContainer().set(key, PersistentDataType.BYTE_ARRAY, (Object)bytes);
        } else {
            meta.getCustomTagContainer().setCustomTag(key, ItemTagType.BYTE_ARRAY, (Object)bytes);
        }
    }

    public static byte[] readBytesItem(ItemMeta meta, NamespacedKey key) {
        if (NewNbtVer) {
            return (byte[])meta.getPersistentDataContainer().get(key, PersistentDataType.BYTE_ARRAY);
        }
        return (byte[])meta.getCustomTagContainer().getCustomTag(key, ItemTagType.BYTE_ARRAY);
    }

    public static boolean hasBytesItem(ItemMeta meta, NamespacedKey key) {
        if (NewNbtVer) {
            return meta.getPersistentDataContainer().has(key, PersistentDataType.BYTE_ARRAY);
        }
        return meta.getCustomTagContainer().hasCustomTag(key, ItemTagType.BYTE_ARRAY);
    }

    static {
        try {
            GET_MATERIAL = Material.class.getDeclaredMethod("getMaterial", Integer.TYPE);
            GET_BLOCK_TYPE_ID_AT = World.class.getDeclaredMethod("getBlockTypeIdAt", Location.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        try {
            SET_DATA = Class.forName(Bukkit.getServer().getClass().getPackage().getName() + ".block.CraftBlock").getDeclaredMethod("setData", Byte.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        HashSet<Material> planks = new HashSet<Material>();
        HashSet<String> allWoodTypes = new HashSet<String>();
        ArrayList<String> unknownWoodTypes = new ArrayList<String>();
        for (Material m : Material.values()) {
            String name = m.name();
            if (!name.endsWith("PLANKS")) continue;
            String woodName = name.substring(0, name.lastIndexOf("_"));
            planks.add(m);
            allWoodTypes.add(woodName);
            if (name.startsWith("OAK") || name.startsWith("SPRUCE") || name.startsWith("BIRCH") || name.startsWith("JUNGLE") || name.startsWith("ACACIA") || name.startsWith("DARK_OAK") || name.startsWith("CRIMSON") || name.startsWith("WARPED") || name.startsWith("MANGROVE") || name.startsWith("CHERRY") || name.startsWith("BAMBOO")) continue;
            unknownWoodTypes.add(woodName);
        }
        unknownWoodTypes.sort(null);
        PLANKS = planks;
        UNKNOWN_WOOD = unknownWoodTypes;
        TOTAL_WOOD_TYPES = allWoodTypes.size();
        if (!unknownWoodTypes.isEmpty()) {
            BreweryPlugin.getInstance().log("New wood types detected. Assigning recipe numbers:");
            int lastKnownNumber = 12;
            for (int i = 0; i < unknownWoodTypes.size(); ++i) {
                BreweryPlugin.getInstance().log("  " + (String)unknownWoodTypes.get(i) + ": " + (i + lastKnownNumber));
            }
        }
        HashSet<Material> woodStairs = new HashSet<Material>();
        for (String wood : allWoodTypes) {
            Material stair = LegacyUtil.get(wood + "_STAIRS");
            if (stair == null) continue;
            woodStairs.add(stair);
        }
        if (!BreweryPlugin.use1_13) {
            Material[] legacyStairs;
            for (Material stair : legacyStairs = new Material[]{LegacyUtil.get("OAK_STAIRS", "WOOD_STAIRS"), LegacyUtil.get("SPRUCE_STAIRS", "SPRUCE_WOOD_STAIRS"), LegacyUtil.get("BIRCH_STAIRS", "BIRCH_WOOD_STAIRS"), LegacyUtil.get("JUNGLE_STAIRS", "JUNGLE_WOOD_STAIRS")}) {
                if (stair == null) continue;
                woodStairs.add(stair);
            }
        }
        WOOD_STAIRS = woodStairs;
        if (LegacyUtil.get("BAMBOO_MOSAIC") != null) {
            planks.add(LegacyUtil.get("BAMBOO_MOSAIC"));
        }
        if (LegacyUtil.get("BAMBOO_MOSAIC_STAIRS") != null) {
            woodStairs.add(LegacyUtil.get("BAMBOO_MOSAIC_STAIRS"));
        }
        HashSet<Material> fences = new HashSet<Material>();
        for (Material m : Material.values()) {
            if (!m.name().endsWith("FENCE")) continue;
            fences.add(m);
        }
        FENCES = fences;
        WATER_CAULDRON = LegacyUtil.get("WATER_CAULDRON");
        MAGMA_BLOCK = LegacyUtil.get("MAGMA_BLOCK", "MAGMA");
        CAMPFIRE = LegacyUtil.get("CAMPFIRE");
        SOUL_CAMPFIRE = LegacyUtil.get("SOUL_CAMPFIRE");
        SOUL_FIRE = LegacyUtil.get("SOUL_FIRE");
        CLOCK = LegacyUtil.get("CLOCK", "WATCH");
        STATIONARY_LAVA = LegacyUtil.get("STATIONARY_LAVA");
        SIGN_POST = LegacyUtil.get("SIGN_POST");
        WOOD = LegacyUtil.get("WOOD");
    }
}

