/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.utility;

import org.bukkit.Location;
import org.bukkit.block.Block;

public class BoundingBox {
    private final int x1;
    private final int y1;
    private final int z1;
    private final int x2;
    private final int y2;
    private final int z2;

    public BoundingBox(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.x1 = Math.min(x1, x2);
        this.y1 = Math.min(y1, y2);
        this.z1 = Math.min(z1, z2);
        this.x2 = Math.max(x2, x1);
        this.y2 = Math.max(y2, y1);
        this.z2 = Math.max(z2, z1);
    }

    public boolean contains(int x, int y, int z) {
        return x >= this.x1 && x <= this.x2 && y >= this.y1 && y <= this.y2 && z >= this.z1 && z <= this.z2;
    }

    public boolean contains(Location loc) {
        return this.contains(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public boolean contains(Block block) {
        return this.contains(block.getX(), block.getY(), block.getZ());
    }

    public long area() {
        return (long)(this.x2 - this.x1 + 1) * (long)(this.y2 - this.y1 + 1) * (long)(this.z2 - this.z1 + 1);
    }

    public String serialize() {
        return this.x1 + "," + this.y1 + "," + this.z1 + "," + this.x2 + "," + this.y2 + "," + this.z2;
    }

    public static BoundingBox fromPoints(int[] locations) {
        if (locations.length % 3 != 0) {
            throw new IllegalArgumentException("Locations has to be pairs of three");
        }
        int length = locations.length - 2;
        int minx = Integer.MAX_VALUE;
        int miny = Integer.MAX_VALUE;
        int minz = Integer.MAX_VALUE;
        int maxx = Integer.MIN_VALUE;
        int maxy = Integer.MIN_VALUE;
        int maxz = Integer.MIN_VALUE;
        for (int i = 0; i < length; i += 3) {
            minx = Math.min(locations[i], minx);
            miny = Math.min(locations[i + 1], miny);
            minz = Math.min(locations[i + 2], minz);
            maxx = Math.max(locations[i], maxx);
            maxy = Math.max(locations[i + 1], maxy);
            maxz = Math.max(locations[i + 2], maxz);
        }
        return new BoundingBox(minx, miny, minz, maxx, maxy, maxz);
    }
}

