/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.utility;

import com.dre.brewery.BCauldron;
import com.dre.brewery.Barrel;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.events.barrel.BarrelDestroyEvent;
import com.dre.brewery.utility.LegacyUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class BUtil {
    private static final String WITH_DELIMITER = "((?<=%1$s)|(?=%1$s))";

    public static boolean isChunkLoaded(Block block) {
        return block.getWorld().isChunkLoaded(block.getX() >> 4, block.getZ() >> 4);
    }

    public static String color(String msg) {
        if (msg == null) {
            return null;
        }
        String[] texts = msg.split(String.format(WITH_DELIMITER, "&"));
        StringBuilder finalText = new StringBuilder();
        for (int i = 0; i < texts.length; ++i) {
            if (texts[i].equalsIgnoreCase("&")) {
                if (texts[++i].charAt(0) == '#') {
                    finalText.append(net.md_5.bungee.api.ChatColor.of((String)texts[i].substring(0, 7)) + texts[i].substring(7));
                    continue;
                }
                finalText.append(ChatColor.translateAlternateColorCodes((char)'&', (String)("&" + texts[i])));
                continue;
            }
            finalText.append(texts[i]);
        }
        return finalText.toString();
    }

    public static Color weightedMixColor(Color prevColor, int prevPos, int currentPos, Color nextColor, int nextPos) {
        float diffPrev = currentPos - prevPos;
        float diffNext = nextPos - currentPos;
        float total = diffNext + diffPrev;
        float percentNext = diffPrev / total;
        float percentPrev = diffNext / total;
        return Color.fromRGB((int)Math.min(255, (int)((float)nextColor.getRed() * percentNext + (float)prevColor.getRed() * percentPrev)), (int)Math.min(255, (int)((float)nextColor.getGreen() * percentNext + (float)prevColor.getGreen() * percentPrev)), (int)Math.min(255, (int)((float)nextColor.getBlue() * percentNext + (float)prevColor.getBlue() * percentPrev)));
    }

    public static void setItemInHand(PlayerInteractEvent event, Material mat, boolean swapped) {
        if (BreweryPlugin.use1_9) {
            if (event.getHand() == EquipmentSlot.OFF_HAND != swapped) {
                event.getPlayer().getInventory().setItemInOffHand(new ItemStack(mat));
            } else {
                event.getPlayer().getInventory().setItemInMainHand(new ItemStack(mat));
            }
        } else {
            event.getPlayer().setItemInHand(new ItemStack(mat));
        }
    }

    public static String playerString(Player player) {
        if (BreweryPlugin.useUUID) {
            return player.getUniqueId().toString();
        }
        return player.getName();
    }

    public static Player getPlayerfromString(String name) {
        if (BreweryPlugin.useUUID) {
            try {
                return Bukkit.getPlayer((UUID)UUID.fromString(name));
            }
            catch (Exception e) {
                return Bukkit.getPlayerExact((String)name);
            }
        }
        return Bukkit.getPlayerExact((String)name);
    }

    public static void reapplyPotionEffect(Player player, PotionEffect effect, boolean onlyIfStronger) {
        PotionEffectType type = effect.getType();
        if (player.hasPotionEffect(type)) {
            PotionEffect plEffect = BreweryPlugin.use1_11 ? player.getPotionEffect(type) : player.getActivePotionEffects().stream().filter(e -> e.getType().equals((Object)type)).findAny().get();
            if (!onlyIfStronger || plEffect.getAmplifier() < effect.getAmplifier() || plEffect.getAmplifier() == effect.getAmplifier() && plEffect.getDuration() < effect.getDuration()) {
                player.removePotionEffect(type);
            } else {
                return;
            }
        }
        effect.apply((LivingEntity)player);
    }

    @Nullable
    public static List<String> loadCfgStringList(ConfigurationSection cfg, String path) {
        if (cfg.isString(path)) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(cfg.getString(path));
            return list;
        }
        if (cfg.isList(path)) {
            return cfg.getStringList(path);
        }
        return null;
    }

    @Nullable
    public static String loadCfgString(ConfigurationSection cfg, String path) {
        List list;
        if (cfg.isString(path)) {
            return cfg.getString(path);
        }
        if (cfg.isList(path) && !(list = cfg.getStringList(path)).isEmpty()) {
            return (String)list.get(0);
        }
        return null;
    }

    public static int indexOfSubstring(List<String> list, String substring) {
        if (list.isEmpty()) {
            return -1;
        }
        int size = list.size();
        for (int index = 0; index < size; ++index) {
            String string = list.get(index);
            if (!string.contains(substring)) continue;
            return index;
        }
        return -1;
    }

    public static int indexOfStart(List<String> list, String lineStart) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!list.get(i).startsWith(lineStart)) continue;
            return i;
        }
        return -1;
    }

    public static String applyPlaceholders(String input, String player, int quality) {
        return input.replaceAll("%player_name%", player).replaceAll("%quality%", String.valueOf(quality));
    }

    public static void createWorldSections(ConfigurationSection section) {
        for (World world : BreweryPlugin.getInstance().getServer().getWorlds()) {
            String worldName = world.getName();
            worldName = worldName.startsWith("DXL_") ? BUtil.getDxlName(worldName) : world.getUID().toString();
            section.createSection(worldName);
        }
    }

    public static boolean blockDestroy(Block block, Player player, BarrelDestroyEvent.Reason reason) {
        Barrel barrel3;
        if (block == null || block.getType() == null) {
            return true;
        }
        Material type = block.getType();
        if (type == Material.CAULDRON || type == LegacyUtil.WATER_CAULDRON) {
            BCauldron.remove(block);
            return true;
        }
        if (LegacyUtil.isFence(type)) {
            Barrel barrel = Barrel.getBySpigot(block);
            if (barrel != null) {
                if (barrel.hasPermsDestroy(player, block, reason)) {
                    barrel.remove(null, player, true);
                    return true;
                }
                return false;
            }
            return true;
        }
        if (LegacyUtil.isSign(type)) {
            Barrel barrel2 = Barrel.getBySpigot(block);
            if (barrel2 != null) {
                if (!barrel2.isLarge()) {
                    if (barrel2.hasPermsDestroy(player, block, reason)) {
                        barrel2.remove(null, player, true);
                        return true;
                    }
                    return false;
                }
                barrel2.getBody().destroySign();
            }
            return true;
        }
        if ((LegacyUtil.isWoodPlanks(type) || LegacyUtil.isWoodStairs(type)) && (barrel3 = Barrel.getByWood(block)) != null) {
            if (barrel3.hasPermsDestroy(player, block, reason)) {
                barrel3.remove(block, player, true);
            } else {
                return false;
            }
        }
        return true;
    }

    public static void list(CommandSender sender, ArrayList<String> strings, int page) {
        int pages = (int)Math.ceil((float)strings.size() / 7.0f);
        if (page > pages || page < 1) {
            page = 1;
        }
        sender.sendMessage(BUtil.color("&7-------------- &f" + BreweryPlugin.getInstance().languageReader.get("Etc_Page", new String[0]) + " &6" + page + "&f/&6" + pages + " &7--------------"));
        ListIterator<String> iter = strings.listIterator((page - 1) * 7);
        for (int i = 0; i < 7 && iter.hasNext(); ++i) {
            sender.sendMessage(BUtil.color(iter.next()));
        }
    }

    public static String getDxlName(String worldName) {
        File dungeonFolder = new File(worldName);
        if (dungeonFolder.isDirectory()) {
            for (File file : dungeonFolder.listFiles()) {
                if (file.isDirectory() || !file.getName().startsWith(".id_")) continue;
                return file.getName().substring(1).toLowerCase();
            }
        }
        return worldName;
    }

    public static void saveFile(InputStream in, File dest, String name, boolean overwrite) throws IOException {
        int length;
        File result;
        if (in == null) {
            return;
        }
        if (!dest.exists()) {
            dest.mkdirs();
        }
        if ((result = new File(dest, name)).exists()) {
            if (overwrite) {
                result.delete();
            } else {
                return;
            }
        }
        FileOutputStream out = new FileOutputStream(result);
        byte[] buffer = new byte[1024];
        while ((length = in.read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, length);
        }
        in.close();
        ((OutputStream)out).close();
    }
}

