/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.recipe;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.filedata.BConfig;
import com.dre.brewery.recipe.BCauldronRecipe;
import com.dre.brewery.recipe.CustomItem;
import com.dre.brewery.recipe.CustomMatchAnyItem;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.recipe.PluginItem;
import com.dre.brewery.recipe.SimpleItem;
import com.dre.brewery.utility.BUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.milkbowl.vault.item.ItemInfo;
import net.milkbowl.vault.item.Items;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeItem
implements Cloneable {
    private String cfgId;
    private int amount;
    private boolean immutable = false;

    public abstract boolean matches(ItemStack var1);

    public abstract boolean matches(Ingredient var1);

    @NotNull
    public abstract Ingredient toIngredient(ItemStack var1);

    @NotNull
    public abstract Ingredient toIngredientGeneric();

    public abstract boolean hasMaterials();

    @Nullable
    public abstract List<Material> getMaterials();

    @Nullable
    public String getConfigId() {
        return this.cfgId;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        if (this.immutable) {
            throw new IllegalStateException("Setting amount only possible on mutable copy");
        }
        this.amount = amount;
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public RecipeItem getMutableCopy() {
        try {
            RecipeItem i = (RecipeItem)super.clone();
            i.immutable = false;
            return i;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Nullable
    @Contract(value="_, true -> !null")
    public static RecipeItem getMatchingRecipeItem(ItemStack item, boolean acceptAll) {
        RecipeItem rItem = null;
        boolean multiMatch = false;
        for (RecipeItem ri : BCauldronRecipe.acceptedCustom) {
            if (multiMatch && !(ri instanceof PluginItem) || !ri.matches(item)) continue;
            if (ri instanceof PluginItem) {
                return ri;
            }
            if (rItem == null) {
                rItem = ri;
                continue;
            }
            multiMatch = true;
        }
        if (multiMatch) {
            return new CustomItem(item);
        }
        if (rItem == null && (acceptAll || BCauldronRecipe.acceptedSimple.contains(item.getType()))) {
            if (BreweryPlugin.use1_13) {
                return new SimpleItem(item.getType());
            }
            short durability = item.getDurability();
            return new SimpleItem(item.getType(), durability);
        }
        return rItem;
    }

    @Nullable
    public static RecipeItem fromConfigCustom(ConfigurationSection cfg, String id) {
        ArrayList<Integer> customModelDatas;
        List<Object> names;
        List<Object> materials;
        RecipeItem rItem = cfg.getBoolean(id + ".matchAny", false) ? new CustomMatchAnyItem() : new CustomItem();
        rItem.cfgId = id;
        rItem.immutable = true;
        List<String> load = BUtil.loadCfgStringList(cfg, id + ".material");
        if (load != null && !load.isEmpty()) {
            materials = RecipeItem.loadMaterials(load);
            if (materials == null) {
                return null;
            }
        } else {
            materials = new ArrayList(0);
        }
        if ((load = BUtil.loadCfgStringList(cfg, id + ".name")) != null && !load.isEmpty()) {
            names = load.stream().map(l -> BreweryPlugin.getInstance().color((String)l)).collect(Collectors.toList());
            if (BreweryPlugin.use1_13) {
                names = names.stream().map(l -> l.startsWith("\u00a7f") ? l.substring(2) : l).collect(Collectors.toList());
            }
        } else {
            names = new ArrayList(0);
        }
        List<Object> lore = (load = BUtil.loadCfgStringList(cfg, id + ".lore")) != null && !load.isEmpty() ? load.stream().map(l -> BreweryPlugin.getInstance().color((String)l)).collect(Collectors.toList()) : new ArrayList(0);
        load = BUtil.loadCfgStringList(cfg, id + ".modeldata");
        if (load != null && !load.isEmpty()) {
            customModelDatas = new ArrayList(load.size());
            for (String s : load) {
                customModelDatas.add(BreweryPlugin.getInstance().parseInt(s));
            }
        } else {
            customModelDatas = new ArrayList<Integer>(0);
        }
        if (materials.isEmpty() && names.isEmpty() && lore.isEmpty() && customModelDatas.isEmpty()) {
            BreweryPlugin.getInstance().errorLog("No Config Entries found for Custom Item");
            return null;
        }
        if (rItem instanceof CustomItem) {
            CustomItem cItem = (CustomItem)rItem;
            if (!materials.isEmpty()) {
                cItem.setMat((Material)materials.get(0));
            }
            if (!names.isEmpty()) {
                cItem.setName((String)names.get(0));
            }
            cItem.setLore(lore);
            if (!customModelDatas.isEmpty()) {
                cItem.setCustomModelData((Integer)customModelDatas.get(0));
            }
        } else {
            RecipeItem maItem = rItem;
            ((CustomMatchAnyItem)maItem).setMaterials(materials);
            ((CustomMatchAnyItem)maItem).setNames(names);
            ((CustomMatchAnyItem)maItem).setLore(lore);
            ((CustomMatchAnyItem)maItem).setCustomModelDatas(customModelDatas);
        }
        return rItem;
    }

    @Nullable
    protected static List<Material> loadMaterials(List<String> ingredientsList) {
        ArrayList<Material> materials = new ArrayList<Material>(ingredientsList.size());
        for (String item : ingredientsList) {
            String[] ingredParts = item.split("/");
            if (ingredParts.length == 2) {
                BreweryPlugin.getInstance().errorLog("Item Amount can not be specified for Custom Items: " + item);
                return null;
            }
            Material mat = Material.matchMaterial((String)ingredParts[0]);
            if (mat == null && !BreweryPlugin.use1_14 && ingredParts[0].equalsIgnoreCase("cornflower")) {
                materials.add(Material.BEDROCK);
                continue;
            }
            if (mat == null && BConfig.hasVault) {
                try {
                    ItemInfo vaultItem = Items.itemByString((String)ingredParts[0]);
                    if (vaultItem != null) {
                        mat = vaultItem.getType();
                    }
                }
                catch (Exception e) {
                    BreweryPlugin.getInstance().errorLog("Could not check vault for Item Name");
                    e.printStackTrace();
                }
            }
            if (mat != null) {
                materials.add(mat);
                continue;
            }
            BreweryPlugin.getInstance().errorLog("Unknown Material: " + ingredParts[0]);
            return null;
        }
        return materials;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecipeItem)) {
            return false;
        }
        RecipeItem that = (RecipeItem)o;
        return this.amount == that.amount && this.immutable == that.immutable && Objects.equals(this.cfgId, that.cfgId);
    }

    public int hashCode() {
        return Objects.hash(this.cfgId, this.amount, this.immutable);
    }

    public String toString() {
        return "RecipeItem{(" + this.getClass().getSimpleName() + ") ID: " + this.getConfigId() + " Materials: " + (this.hasMaterials() ? this.getMaterials().size() : 0) + " Amount: " + this.getAmount();
    }
}

