/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.recipe;

import com.dre.brewery.recipe.CustomItem;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.recipe.RecipeItem;
import com.dre.brewery.recipe.SimpleItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomMatchAnyItem
extends RecipeItem {
    private List<Material> materials;
    private List<String> names;
    private List<String> lore;
    private List<Integer> customModelDatas;

    @Override
    public boolean hasMaterials() {
        return this.materials != null && !this.materials.isEmpty();
    }

    public boolean hasNames() {
        return this.names != null && !this.names.isEmpty();
    }

    public boolean hasLore() {
        return this.lore != null && !this.lore.isEmpty();
    }

    public boolean hasCustomModelDatas() {
        return this.customModelDatas != null && !this.customModelDatas.isEmpty();
    }

    @Override
    @Nullable
    public List<Material> getMaterials() {
        return this.materials;
    }

    protected void setMaterials(List<Material> materials) {
        this.materials = materials;
    }

    @Nullable
    public List<String> getNames() {
        return this.names;
    }

    protected void setNames(List<String> names) {
        this.names = names;
    }

    @Nullable
    public List<String> getLore() {
        return this.lore;
    }

    protected void setLore(List<String> lore) {
        this.lore = lore;
    }

    @Nullable
    public List<Integer> getCustomModelDatas() {
        return this.customModelDatas;
    }

    protected void setCustomModelDatas(List<Integer> customModelDatas) {
        this.customModelDatas = customModelDatas;
    }

    @Override
    @NotNull
    public Ingredient toIngredient(ItemStack forItem) {
        Material mat = this.getMaterialMatch(forItem);
        if (mat != null) {
            return new CustomItem(mat);
        }
        String name = this.getNameMatch(forItem);
        if (name != null) {
            return new CustomItem(null, name, null);
        }
        String l = this.getLoreMatch(forItem);
        if (l != null) {
            ArrayList<String> lore = new ArrayList<String>(1);
            lore.add(l);
            return new CustomItem(null, null, lore);
        }
        return new SimpleItem(Material.GOLDEN_HOE);
    }

    @Override
    @NotNull
    public Ingredient toIngredientGeneric() {
        if (this.hasMaterials()) {
            return new CustomItem(this.materials.get(0));
        }
        if (this.hasNames()) {
            return new CustomItem(null, this.names.get(0), null);
        }
        if (this.hasLore()) {
            ArrayList<String> l = new ArrayList<String>(1);
            l.add(this.lore.get(0));
            return new CustomItem(null, null, l);
        }
        if (this.hasCustomModelDatas()) {
            return new CustomItem(null, null, null, this.customModelDatas.get(0));
        }
        return new SimpleItem(Material.GOLDEN_HOE);
    }

    public Material getMaterialMatch(ItemStack item) {
        if (!this.hasMaterials()) {
            return null;
        }
        Material usedMat = item.getType();
        for (Material mat : this.materials) {
            if (usedMat != mat) continue;
            return mat;
        }
        return null;
    }

    public String getNameMatch(ItemStack item) {
        if (!item.hasItemMeta() || !this.hasNames()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        if (meta.hasDisplayName()) {
            return this.getNameMatch(meta.getDisplayName());
        }
        return null;
    }

    public String getNameMatch(String usedName) {
        if (!this.hasNames()) {
            return null;
        }
        for (String name : this.names) {
            if (!name.equalsIgnoreCase(usedName)) continue;
            return name;
        }
        return null;
    }

    public String getLoreMatch(ItemStack item) {
        if (!item.hasItemMeta() || !this.hasLore()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        if (meta.hasLore()) {
            return this.getLoreMatch(meta.getLore());
        }
        return null;
    }

    public String getLoreMatch(List<String> usedLore) {
        if (!this.hasLore()) {
            return null;
        }
        for (String line : this.lore) {
            for (String usedLine : usedLore) {
                if (!line.equalsIgnoreCase(usedLine) && !line.equalsIgnoreCase(ChatColor.stripColor((String)usedLine))) continue;
                return line;
            }
        }
        return null;
    }

    public int getCustomModelDataMatch(ItemStack item) {
        if (!item.hasItemMeta() || !this.hasCustomModelDatas()) {
            return 0;
        }
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        if (meta.hasCustomModelData()) {
            return this.getCustomModelDataMatch(meta.getCustomModelData());
        }
        return 0;
    }

    public int getCustomModelDataMatch(int usedCustomModelData) {
        if (!this.hasCustomModelDatas()) {
            return 0;
        }
        for (int customModelData : this.customModelDatas) {
            if (customModelData != usedCustomModelData) continue;
            return customModelData;
        }
        return 0;
    }

    @Override
    public boolean matches(ItemStack item) {
        if (this.getMaterialMatch(item) != null) {
            return true;
        }
        if (this.getNameMatch(item) != null) {
            return true;
        }
        if (this.getLoreMatch(item) != null) {
            return true;
        }
        return this.getCustomModelDataMatch(item) != 0;
    }

    @Override
    public boolean matches(Ingredient ingredient) {
        if (ingredient instanceof CustomItem) {
            CustomItem ci = (CustomItem)ingredient;
            if (this.hasMaterials() && ci.hasMaterials() && this.materials.contains(ci.getMaterial())) {
                return true;
            }
            if (this.hasNames() && ci.hasName() && this.getNameMatch(ci.getName()) != null) {
                return true;
            }
            if (this.hasLore() && ci.hasLore()) {
                return this.getLoreMatch(ci.getLore()) != null;
            }
            if (this.hasCustomModelDatas() && ci.hasCustomModelData()) {
                return this.getCustomModelDataMatch(ci.getCustomModelData()) != 0;
            }
        } else if (ingredient instanceof SimpleItem) {
            SimpleItem si = (SimpleItem)ingredient;
            return this.hasMaterials() && this.materials.contains(si.getMaterial());
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomMatchAnyItem that = (CustomMatchAnyItem)o;
        return Objects.equals(this.materials, that.materials) && Objects.equals(this.names, that.names) && Objects.equals(this.lore, that.lore) && Objects.equals(this.customModelDatas, that.customModelDatas);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.materials, this.names, this.lore, this.customModelDatas);
    }

    @Override
    public String toString() {
        return "CustomMatchAnyItem{id=" + this.getConfigId() + ", materials: " + (this.materials != null ? this.materials.size() : 0) + ", names:" + (this.names != null ? this.names.size() : 0) + ", loresize: " + (this.lore != null ? this.lore.size() : 0) + ", customDatas: " + (this.customModelDatas != null ? this.customModelDatas.size() : 0) + "}";
    }
}

