/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.recipe;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.utility.BUtil;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BEffect {
    private PotionEffectType type;
    private short minlvl;
    private short maxlvl;
    private short minduration;
    private short maxduration;
    private boolean hidden = false;

    public BEffect(PotionEffectType type, short minlvl, short maxlvl, short minduration, short maxduration, boolean hidden) {
        this.type = type;
        this.minlvl = minlvl;
        this.maxlvl = maxlvl;
        this.minduration = minduration;
        this.maxduration = maxduration;
        this.hidden = hidden;
    }

    public BEffect(String effectString) {
        String[] effectSplit = effectString.split("/");
        String effect = effectSplit[0];
        if (effect.equalsIgnoreCase("WEAKNESS") || effect.equalsIgnoreCase("INCREASE_DAMAGE") || effect.equalsIgnoreCase("SLOW") || effect.equalsIgnoreCase("SPEED") || effect.equalsIgnoreCase("REGENERATION")) {
            this.hidden = true;
        } else if (effect.endsWith("X")) {
            this.hidden = true;
            effect = effect.substring(0, effect.length() - 1);
        }
        this.type = PotionEffectType.getByName((String)effect);
        if (this.type == null) {
            BreweryPlugin.getInstance().errorLog("Effect: " + effect + " does not exist!");
            return;
        }
        if (effectSplit.length == 3) {
            String[] range = effectSplit[1].split("-");
            if (this.type.isInstant()) {
                this.setLvl(range);
            } else {
                this.setLvl(range);
                range = effectSplit[2].split("-");
                this.setDuration(range);
            }
        } else if (effectSplit.length == 2) {
            String[] range = effectSplit[1].split("-");
            if (this.type.isInstant()) {
                this.setLvl(range);
            } else {
                this.setDuration(range);
                this.maxlvl = (short)3;
                this.minlvl = 1;
            }
        } else {
            this.maxduration = (short)20;
            this.minduration = (short)10;
            this.maxlvl = (short)3;
            this.minlvl = 1;
        }
    }

    private void setLvl(String[] range) {
        if (range.length == 1) {
            this.maxlvl = (short)BreweryPlugin.getInstance().parseInt(range[0]);
            this.minlvl = 1;
        } else {
            this.maxlvl = (short)BreweryPlugin.getInstance().parseInt(range[1]);
            this.minlvl = (short)BreweryPlugin.getInstance().parseInt(range[0]);
        }
    }

    private void setDuration(String[] range) {
        if (range.length == 1) {
            this.maxduration = (short)BreweryPlugin.getInstance().parseInt(range[0]);
            this.minduration = (short)(this.maxduration / 8);
        } else {
            this.maxduration = (short)BreweryPlugin.getInstance().parseInt(range[1]);
            this.minduration = (short)BreweryPlugin.getInstance().parseInt(range[0]);
        }
    }

    public PotionEffect generateEffect(int quality) {
        int duration = this.calcDuration(quality);
        int lvl = this.calcLvl(quality);
        if (lvl < 1 || duration < 1 && !this.type.isInstant()) {
            return null;
        }
        duration *= 20;
        if (!BreweryPlugin.use1_14) {
            double modifier = this.type.getDurationModifier();
            duration = (int)((double)duration / modifier);
        }
        return this.type.createEffect(duration, lvl - 1);
    }

    public void apply(int quality, Player player) {
        PotionEffect effect = this.generateEffect(quality);
        if (effect != null) {
            BUtil.reapplyPotionEffect(player, effect, true);
        }
    }

    public int calcDuration(float quality) {
        return (int)Math.round((double)this.minduration + (double)(this.maxduration - this.minduration) * ((double)quality / 10.0));
    }

    public int calcLvl(float quality) {
        return (int)Math.round((double)this.minlvl + (double)(this.maxlvl - this.minlvl) * ((double)quality / 10.0));
    }

    public void writeInto(PotionMeta meta, int quality) {
        if ((this.calcDuration(quality) > 0 || this.type.isInstant()) && this.calcLvl(quality) > 0) {
            meta.addCustomEffect(this.type.createEffect(0, 0), true);
        } else {
            meta.removeCustomEffect(this.type);
        }
    }

    public boolean isValid() {
        return this.type != null && this.minlvl >= 0 && this.maxlvl >= 0 && this.minduration >= 0 && this.maxduration >= 0;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public PotionEffectType getType() {
        return this.type;
    }
}

