/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.recipe;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.recipe.BRecipe;
import com.dre.brewery.recipe.CustomItem;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.recipe.PotionColor;
import com.dre.brewery.recipe.RecipeItem;
import com.dre.brewery.recipe.SimpleItem;
import com.dre.brewery.utility.StringParser;
import com.dre.brewery.utility.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BCauldronRecipe {
    public static List<BCauldronRecipe> recipes = new ArrayList<BCauldronRecipe>();
    public static int numConfigRecipes;
    public static List<RecipeItem> acceptedCustom;
    public static Set<Material> acceptedSimple;
    public static Set<Material> acceptedMaterials;
    private String name;
    private List<RecipeItem> ingredients;
    private PotionColor color;
    private List<Tuple<Integer, Color>> particleColor = new ArrayList<Tuple<Integer, Color>>();
    private List<String> lore;
    private int cmData;
    private boolean saveInData;

    public BCauldronRecipe(String name) {
        this.name = name;
        this.color = PotionColor.CYAN;
    }

    @Nullable
    public static BCauldronRecipe fromConfig(ConfigurationSection cfg, String id) {
        List<Tuple<Integer, String>> lore;
        String name = cfg.getString(id + ".name");
        if (name == null) {
            BreweryPlugin.getInstance().errorLog("Missing name for Cauldron-Recipe: " + id);
            return null;
        }
        name = BreweryPlugin.getInstance().color(name);
        BCauldronRecipe recipe = new BCauldronRecipe(name);
        recipe.ingredients = BRecipe.loadIngredients(cfg, id);
        if (recipe.ingredients == null || recipe.ingredients.isEmpty()) {
            BreweryPlugin.getInstance().errorLog("No ingredients for Cauldron-Recipe: " + recipe.name);
            return null;
        }
        String col = cfg.getString(id + ".color");
        recipe.color = col != null ? PotionColor.fromString(col) : PotionColor.CYAN;
        if (recipe.color == PotionColor.WATER && !col.equals("WATER")) {
            recipe.color = PotionColor.CYAN;
        }
        for (String entry : cfg.getStringList(id + ".cookParticles")) {
            int minute;
            String[] split = entry.split("/");
            if (split.length == 1) {
                minute = 10;
            } else if (split.length == 2) {
                minute = BreweryPlugin.getInstance().parseInt(split[1]);
            } else {
                BreweryPlugin.getInstance().errorLog("cookParticle: '" + entry + "' in: " + recipe.name);
                return null;
            }
            if (minute < 1) {
                BreweryPlugin.getInstance().errorLog("cookParticle: '" + entry + "' in: " + recipe.name);
                return null;
            }
            PotionColor partCol = PotionColor.fromString(split[0]);
            if (partCol == PotionColor.WATER && !split[0].equals("WATER")) {
                BreweryPlugin.getInstance().errorLog("Color of cookParticle: '" + entry + "' in: " + recipe.name);
                return null;
            }
            recipe.particleColor.add(new Tuple<Integer, Color>(minute, partCol.getColor()));
        }
        if (!recipe.particleColor.isEmpty()) {
            recipe.particleColor.sort(Comparator.comparing(Tuple::first));
        }
        if ((lore = BRecipe.loadQualityStringList(cfg, id + ".lore", StringParser.ParseType.LORE)) != null && !lore.isEmpty()) {
            recipe.lore = lore.stream().map(Tuple::second).collect(Collectors.toList());
        }
        recipe.cmData = cfg.getInt(id + ".customModelData", 0);
        return recipe;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<RecipeItem> getIngredients() {
        return this.ingredients;
    }

    @NotNull
    public PotionColor getColor() {
        return this.color;
    }

    @NotNull
    public List<Tuple<Integer, Color>> getParticleColor() {
        return this.particleColor;
    }

    @Nullable
    public List<String> getLore() {
        return this.lore;
    }

    public boolean isSaveInData() {
        return this.saveInData;
    }

    public void setIngredients(@NotNull List<RecipeItem> ingredients) {
        this.ingredients = ingredients;
    }

    public void setColor(@NotNull PotionColor color) {
        this.color = color;
    }

    public void setLore(List<String> lore) {
        this.lore = lore;
    }

    public int getCmData() {
        return this.cmData;
    }

    public void setSaveInData(boolean saveInData) {
        this.saveInData = saveInData;
    }

    public float getIngredientMatch(List<Ingredient> items) {
        if (items.size() < this.ingredients.size()) {
            return 0.0f;
        }
        float match = 10.0f;
        block0: for (RecipeItem recipeIng : this.ingredients) {
            for (Ingredient ing : items) {
                if (!recipeIng.matches(ing)) continue;
                double difference = Math.abs(recipeIng.getAmount() - ing.getAmount());
                if (difference >= 1000.0) {
                    return 0.0f;
                }
                double factor = (double)ing.getAmount() * (1.0 - difference / 1000.0);
                double mod = 1.0 + 0.9 * -Math.exp(-0.03 * factor);
                match = (float)((double)match * mod);
                continue block0;
            }
            return 0.0f;
        }
        if (items.size() > this.ingredients.size()) {
            float tooMuch = items.size() - this.ingredients.size();
            double mod = Math.pow(0.1, tooMuch);
            match = (float)((double)match * mod);
        }
        BreweryPlugin.getInstance().debugLog("Match for Cauldron Recipe " + this.name + ": " + match);
        return match;
    }

    public void updateAcceptedLists() {
        for (RecipeItem ingredient : this.getIngredients()) {
            if (ingredient.hasMaterials()) {
                acceptedMaterials.addAll(ingredient.getMaterials());
            }
            if (ingredient instanceof SimpleItem) {
                acceptedSimple.add(((SimpleItem)ingredient).getMaterial());
                continue;
            }
            if (acceptedCustom.contains(ingredient)) continue;
            acceptedCustom.add(ingredient);
        }
    }

    public String toString() {
        return "BCauldronRecipe{" + this.name + "}";
    }

    @Nullable
    public static BCauldronRecipe get(String name) {
        for (BCauldronRecipe recipe : recipes) {
            if (!recipe.name.equalsIgnoreCase(name)) continue;
            return recipe;
        }
        return null;
    }

    public static List<BCauldronRecipe> getConfigRecipes() {
        return recipes.subList(0, numConfigRecipes);
    }

    public static List<BCauldronRecipe> getAddedRecipes() {
        return recipes.subList(numConfigRecipes, recipes.size());
    }

    public static List<BCauldronRecipe> getAllRecipes() {
        return recipes;
    }

    static {
        acceptedCustom = new ArrayList<RecipeItem>();
        acceptedSimple = new HashSet<Material>();
        acceptedMaterials = new HashSet<Material>();
    }

    public static class Builder {
        private BCauldronRecipe recipe;

        public Builder(String name) {
            this.recipe = new BCauldronRecipe(name);
        }

        public Builder addIngredient(RecipeItem ... item) {
            if (this.recipe.ingredients == null) {
                this.recipe.ingredients = new ArrayList<RecipeItem>();
            }
            Collections.addAll(this.recipe.ingredients, item);
            return this;
        }

        public Builder addIngredient(ItemStack ... item) {
            if (this.recipe.ingredients == null) {
                this.recipe.ingredients = new ArrayList<RecipeItem>();
            }
            for (ItemStack i : item) {
                this.recipe.ingredients.add(new CustomItem(i));
            }
            return this;
        }

        public Builder color(String colorString) {
            this.recipe.color = PotionColor.fromString(colorString);
            return this;
        }

        public Builder color(PotionColor color) {
            this.recipe.color = color;
            return this;
        }

        public Builder color(Color color) {
            this.recipe.color = PotionColor.fromColor(color);
            return this;
        }

        public Builder addParticleColor(int atMinute, Color color) {
            this.recipe.particleColor.add(new Tuple<Integer, Color>(atMinute, color));
            return this;
        }

        public Builder addLore(String line) {
            if (this.recipe.lore == null) {
                this.recipe.lore = new ArrayList<String>();
            }
            this.recipe.lore.add(line);
            return this;
        }

        public BCauldronRecipe get() {
            if (this.recipe.name == null) {
                throw new IllegalArgumentException("CauldronRecipe name is null");
            }
            if (BCauldronRecipe.get(this.recipe.getName()) != null) {
                throw new IllegalArgumentException("CauldronRecipe with name " + this.recipe.getName() + " already exists");
            }
            if (this.recipe.color == null) {
                throw new IllegalArgumentException("CauldronRecipe has no color");
            }
            if (this.recipe.ingredients == null || this.recipe.ingredients.isEmpty()) {
                throw new IllegalArgumentException("CauldronRecipe has no ingredients");
            }
            if (!this.recipe.particleColor.isEmpty()) {
                this.recipe.particleColor.sort(Comparator.comparing(Tuple::first));
            }
            return this.recipe;
        }
    }
}

