/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.listeners;

import com.dre.brewery.BDistiller;
import com.dre.brewery.BSealer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.MCBarrel;
import com.dre.brewery.filedata.BConfig;
import com.dre.brewery.lore.BrewLore;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class InventoryListener
implements Listener {
    private HashSet<UUID> trackedBrewmen = new HashSet();

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBrewerOpen(InventoryOpenEvent event) {
        if (!BreweryPlugin.use1_9) {
            return;
        }
        HumanEntity player = event.getPlayer();
        Inventory inv = event.getInventory();
        if (player == null || !(inv instanceof BrewerInventory)) {
            return;
        }
        BreweryPlugin.getInstance().debugLog("Starting brew inventory tracking");
        this.trackedBrewmen.add(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBrewerClose(InventoryCloseEvent event) {
        if (!BreweryPlugin.use1_9) {
            return;
        }
        HumanEntity player = event.getPlayer();
        Inventory inv = event.getInventory();
        if (player == null || !(inv instanceof BrewerInventory)) {
            return;
        }
        BreweryPlugin.getInstance().debugLog("Stopping brew inventory tracking");
        this.trackedBrewmen.remove(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBrewerDrag(InventoryDragEvent event) {
        if (!BreweryPlugin.use1_9) {
            return;
        }
        if (event.getInventory() instanceof BrewerInventory) {
            this.onBrewerClick(new InventoryClickEvent(event.getView(), InventoryType.SlotType.CONTAINER, 0, ClickType.LEFT, InventoryAction.PLACE_ALL));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBrewerClick(InventoryClickEvent event) {
        if (!BreweryPlugin.use1_9) {
            return;
        }
        HumanEntity player = event.getWhoClicked();
        Inventory inv = event.getInventory();
        if (player == null || !(inv instanceof BrewerInventory)) {
            return;
        }
        UUID puid = player.getUniqueId();
        if (!this.trackedBrewmen.contains(puid)) {
            return;
        }
        if (InventoryType.BREWING != inv.getType()) {
            return;
        }
        if (event.getAction() == InventoryAction.NOTHING) {
            return;
        }
        BDistiller.distillerClick(event);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBrew(BrewEvent event) {
        if (BreweryPlugin.use1_9) {
            if (BDistiller.hasBrew(event.getContents(), BDistiller.getDistillContents(event.getContents())) != 0) {
                event.setCancelled(true);
            }
            return;
        }
        if (BDistiller.runDistill(event.getContents(), BDistiller.getDistillContents(event.getContents()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=false)
    public void onInventoryClickLow(InventoryClickEvent event) {
        ItemStack item;
        if (event.getCurrentItem() != null && event.getCurrentItem().getType().equals((Object)Material.POTION) && (item = event.getCurrentItem()).hasItemMeta()) {
            Brew brew;
            PotionMeta potion = (PotionMeta)item.getItemMeta();
            assert (potion != null);
            if (BreweryPlugin.use1_11) {
                Brew brew2;
                if (potion.getColor() == null && (brew2 = Brew.get((ItemMeta)potion)) != null) {
                    brew2.convertPre1_11(item);
                }
            } else if (BreweryPlugin.use1_9 && !potion.hasItemFlag(ItemFlag.HIDE_POTION_EFFECTS) && (brew = Brew.get((ItemMeta)potion)) != null) {
                brew.convertPre1_9(item);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory().getType() == InventoryType.BREWING ? event.getSlot() > 2 : !(event.getInventory().getHolder() instanceof Barrel) && (!BreweryPlugin.use1_14 || !(event.getInventory().getHolder() instanceof org.bukkit.block.Barrel))) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (item != null && item.getType() == Material.POTION && item.hasItemMeta()) {
            PotionMeta meta = (PotionMeta)item.getItemMeta();
            assert (meta != null);
            Brew brew = Brew.get((ItemMeta)meta);
            if (brew != null) {
                BrewLore lore = null;
                if (BrewLore.hasColorLore(meta)) {
                    lore = new BrewLore(brew, meta);
                    lore.convertLore(false);
                } else if (!BConfig.alwaysShowAlc && event.getInventory().getType() == InventoryType.BREWING) {
                    lore = new BrewLore(brew, meta);
                    lore.updateAlc(false);
                }
                if (lore != null) {
                    lore.write();
                    item.setItemMeta((ItemMeta)meta);
                    if (event.getWhoClicked() instanceof Player) {
                        switch (event.getAction()) {
                            case MOVE_TO_OTHER_INVENTORY: 
                            case HOTBAR_SWAP: {
                                BreweryPlugin.getScheduler().runTask(() -> ((Player)event.getWhoClicked()).updateInventory());
                            }
                        }
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryClickMCBarrel(InventoryClickEvent event) {
        if (!BreweryPlugin.use1_14) {
            return;
        }
        if (event.getInventory().getType() != InventoryType.BARREL) {
            return;
        }
        if (!MCBarrel.enableAging) {
            return;
        }
        Inventory inv = event.getInventory();
        for (MCBarrel barrel : MCBarrel.openBarrels) {
            if (!barrel.getInventory().equals(inv)) continue;
            barrel.clickInv(event);
            return;
        }
        MCBarrel barrel = new MCBarrel(inv);
        MCBarrel.openBarrels.add(barrel);
        barrel.clickInv(event);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onInventoryClickBSealer(InventoryClickEvent event) {
        if (!BreweryPlugin.use1_13) {
            return;
        }
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof BSealer)) {
            return;
        }
        ((BSealer)holder).clickInv();
    }

    @EventHandler(ignoreCancelled=false)
    public void onInventoryOpenLegacyConvert(InventoryOpenEvent event) {
        if (Brew.noLegacy()) {
            return;
        }
        if (event.getInventory().getType() == InventoryType.PLAYER) {
            return;
        }
        for (ItemStack item : event.getInventory().getContents()) {
            int uid;
            if (item == null || item.getType() != Material.POTION || (uid = Brew.getUID(item)) >= 0 || !Brew.legacyPotions.containsKey(uid)) continue;
            Brew.get(item);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!BreweryPlugin.use1_14) {
            return;
        }
        if (!MCBarrel.enableAging) {
            return;
        }
        if (event.getInventory().getType() == InventoryType.BARREL) {
            Inventory inv = event.getInventory();
            for (MCBarrel barrel : MCBarrel.openBarrels) {
                if (!barrel.getInventory().equals(inv)) continue;
                barrel.open();
                return;
            }
            MCBarrel barrel = new MCBarrel(inv);
            MCBarrel.openBarrels.add(barrel);
            barrel.open();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onHopperPickupPuke(InventoryPickupItemEvent event) {
        if (event.getItem().getPickupDelay() > 1000 && BConfig.pukeItem.contains(event.getItem().getItemStack().getType())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onHopperMove(InventoryMoveItemEvent event) {
        ItemStack item;
        if (event.getSource() instanceof BrewerInventory) {
            if (BDistiller.isTrackingDistiller(((BrewerInventory)event.getSource()).getHolder().getBlock())) {
                event.setCancelled(true);
            }
            return;
        }
        if (!BreweryPlugin.use1_14) {
            return;
        }
        if (event.getSource().getType() == InventoryType.BARREL && (item = event.getItem()).getType() == Material.POTION && Brew.isBrew(item)) {
            Brew brew;
            PotionMeta meta = (PotionMeta)item.getItemMeta();
            assert (meta != null);
            if (BrewLore.hasColorLore(meta) && (brew = Brew.get((ItemMeta)meta)) != null) {
                BrewLore lore = new BrewLore(brew, meta);
                lore.convertLore(false);
                lore.write();
                item.setItemMeta((ItemMeta)meta);
                event.setItem(item);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!BreweryPlugin.use1_13) {
            return;
        }
        if (event.getInventory().getHolder() instanceof BSealer) {
            ((BSealer)event.getInventory().getHolder()).closeInv();
        }
        if (!BreweryPlugin.use1_14) {
            return;
        }
        if (event.getInventory().getHolder() instanceof Barrel) {
            Barrel barrel = (Barrel)event.getInventory().getHolder();
            barrel.playClosingSound();
        }
        if (MCBarrel.enableAging && event.getInventory().getType() == InventoryType.BARREL) {
            Inventory inv = event.getInventory();
            Iterator<MCBarrel> iter = MCBarrel.openBarrels.iterator();
            while (iter.hasNext()) {
                MCBarrel barrel = iter.next();
                if (!barrel.getInventory().equals(inv)) continue;
                barrel.close();
                if (inv.getViewers().size() == 1) {
                    iter.remove();
                }
                return;
            }
            new MCBarrel(inv).close();
        }
    }
}

