/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.listeners;

import com.dre.brewery.BPlayer;
import com.dre.brewery.BSealer;
import com.dre.brewery.Barrel;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.DistortChat;
import com.dre.brewery.api.events.barrel.BarrelDestroyEvent;
import com.dre.brewery.filedata.BConfig;
import com.dre.brewery.filedata.BData;
import com.dre.brewery.integration.barrel.BlocklockerBarrel;
import com.dre.brewery.utility.BUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;

public class BlockListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        String[] lines = event.getLines();
        if (BlockListener.hasBarrelLine(lines)) {
            Player player = event.getPlayer();
            if (!player.hasPermission("brewery.createbarrel.small") && !player.hasPermission("brewery.createbarrel.big")) {
                BreweryPlugin.getInstance().msg((CommandSender)player, BreweryPlugin.getInstance().languageReader.get("Perms_NoBarrelCreate", new String[0]));
                return;
            }
            if (BData.dataMutex.get() > 0) {
                BreweryPlugin.getInstance().msg((CommandSender)player, "\u00a7cCurrently loading Data");
                return;
            }
            if (Barrel.create(event.getBlock(), player)) {
                BreweryPlugin.getInstance().msg((CommandSender)player, BreweryPlugin.getInstance().languageReader.get("Player_BarrelCreated", new String[0]));
            }
        }
    }

    public static boolean hasBarrelLine(String[] lines) {
        for (String line : lines) {
            if (!line.equalsIgnoreCase("Barrel") && !line.equalsIgnoreCase(BreweryPlugin.getInstance().languageReader.get("Etc_Barrel", new String[0]))) continue;
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSignChangeLow(SignChangeEvent event) {
        String[] lines;
        if (DistortChat.doSigns.booleanValue() && BPlayer.hasPlayer(event.getPlayer())) {
            DistortChat.signWrite(event);
        }
        if (BConfig.useBlocklocker && BlockListener.hasBarrelLine(lines = event.getLines())) {
            BlocklockerBarrel.createdBarrelSign(event.getBlock());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!BreweryPlugin.use1_14 || event.getBlock().getType() != Material.SMOKER) {
            return;
        }
        BSealer.blockPlace(event.getItemInHand(), event.getBlock());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!BUtil.blockDestroy(event.getBlock(), event.getPlayer(), BarrelDestroyEvent.Reason.PLAYER)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        if (!BUtil.blockDestroy(event.getBlock(), null, BarrelDestroyEvent.Reason.BURNED)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        if (event.isSticky()) {
            for (Block block : event.getBlocks()) {
                if (Barrel.get(block) == null) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            if (Barrel.get(block) == null) continue;
            event.setCancelled(true);
            return;
        }
    }
}

