/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration.barrel;

import com.dre.brewery.Barrel;
import com.dre.brewery.BarrelBody;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.events.barrel.BarrelAccessEvent;
import com.dre.brewery.filedata.BConfig;
import com.dre.brewery.utility.LegacyUtil;
import java.util.List;
import nl.rutgerkok.blocklocker.BlockLockerAPIv2;
import nl.rutgerkok.blocklocker.ProtectableBlocksSettings;
import nl.rutgerkok.blocklocker.ProtectionType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class BlocklockerBarrel
implements ProtectableBlocksSettings {
    private static Block lastBarrelSign;

    public boolean canProtect(Block block) {
        return this.isOrWillCreateBarrel(block);
    }

    public boolean canProtect(ProtectionType protectionType, Block block) {
        if (protectionType != ProtectionType.CONTAINER) {
            return false;
        }
        return this.isOrWillCreateBarrel(block);
    }

    public boolean isOrWillCreateBarrel(Block block) {
        if (!BreweryPlugin.getInstance().isEnabled() || !BConfig.useBlocklocker) {
            return false;
        }
        if (!LegacyUtil.isWoodPlanks(block.getType()) && !LegacyUtil.isWoodStairs(block.getType())) {
            return false;
        }
        if (Barrel.getByWood(block) != null) {
            return true;
        }
        if (lastBarrelSign == null) {
            return false;
        }
        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST}) {
            Barrel barrel;
            Block sign = block.getRelative(face);
            if (!lastBarrelSign.equals(sign)) continue;
            Block spigot = BarrelBody.getSpigotOfSign(sign);
            byte signoffset = 0;
            if (!spigot.equals(sign)) {
                signoffset = (byte)(sign.getY() - spigot.getY());
            }
            return (barrel = new Barrel(spigot, signoffset)).getBody().getBrokenBlock(true) == null;
        }
        return false;
    }

    public static boolean checkAccess(BarrelAccessEvent event) {
        Block sign = event.getBarrel().getBody().getSignOfSpigot();
        if (!LegacyUtil.isSign(sign.getType())) {
            return true;
        }
        return BlockLockerAPIv2.isAllowed((Player)event.getPlayer(), (Block)sign, (boolean)true);
    }

    public static void createdBarrelSign(Block sign) {
        lastBarrelSign = sign;
    }

    public static void clearBarrelSign() {
        lastBarrelSign = null;
    }

    public static void registerBarrelAsProtectable() {
        try {
            List extraProtectables = BlockLockerAPIv2.getPlugin().getChestSettings().getExtraProtectables();
            if (extraProtectables.stream().noneMatch(blockSettings -> blockSettings instanceof BlocklockerBarrel)) {
                extraProtectables.add(new BlocklockerBarrel());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

