/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration;

import com.dre.brewery.Brew;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.filedata.BConfig;
import com.nisovin.shopkeepers.api.events.PlayerOpenUIEvent;
import com.nisovin.shopkeepers.api.ui.DefaultUITypes;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;

public class ShopKeepersListener
implements Listener {
    Set<HumanEntity> openedEditors = new HashSet<HumanEntity>();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onShopkeeperOpen(PlayerOpenUIEvent event) {
        try {
            if (event.getUIType() == DefaultUITypes.EDITOR() || event.getUIType() == DefaultUITypes.TRADING()) {
                this.openedEditors.add((HumanEntity)event.getPlayer());
            }
        }
        catch (Throwable e) {
            this.failed(e);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClickShopKeeper(InventoryClickEvent event) {
        Brew brew;
        if (this.openedEditors.isEmpty() || !this.openedEditors.contains(event.getWhoClicked())) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        ItemStack item = event.getCursor();
        if (item != null && item.getType() == Material.POTION && event.getClickedInventory() == event.getView().getTopInventory() && (brew = Brew.get(item)) != null && !brew.isSealed()) {
            BreweryPlugin.getInstance().msg((CommandSender)event.getWhoClicked(), BreweryPlugin.getInstance().languageReader.get("Player_ShopSealBrew", new String[0]));
        }
    }

    @EventHandler
    public void onCloseInventoryShopKeeper(InventoryCloseEvent event) {
        this.openedEditors.remove(event.getPlayer());
    }

    private void failed(Throwable e) {
        HandlerList.unregisterAll((Listener)this);
        BConfig.hasShopKeepers = false;
        e.printStackTrace();
        BreweryPlugin.getInstance().errorLog("Failed to notify Player using 'ShopKeepers'. Disabling 'ShopKeepers' support");
        this.openedEditors.clear();
    }
}

