/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration;

import com.dre.brewery.Barrel;
import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.api.events.barrel.BarrelAccessEvent;
import com.dre.brewery.api.events.barrel.BarrelDestroyEvent;
import com.dre.brewery.api.events.barrel.BarrelRemoveEvent;
import com.dre.brewery.filedata.BConfig;
import com.dre.brewery.integration.barrel.BlocklockerBarrel;
import com.dre.brewery.integration.barrel.GriefPreventionBarrel;
import com.dre.brewery.integration.barrel.LWCBarrel;
import com.dre.brewery.integration.barrel.LogBlockBarrel;
import com.dre.brewery.integration.barrel.TownyBarrel;
import com.dre.brewery.integration.item.MMOItemsPluginItem;
import com.dre.brewery.recipe.BCauldronRecipe;
import com.dre.brewery.recipe.RecipeItem;
import com.dre.brewery.utility.LegacyUtil;
import io.lumine.mythic.lib.api.item.NBTItem;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class IntegrationListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBarrelAccessLowest(BarrelAccessEvent event) {
        Plugin plugin;
        if (BConfig.useWG && (plugin = BreweryPlugin.getInstance().getServer().getPluginManager().getPlugin("WorldGuard")) != null) {
            try {
                if (!BConfig.wg.checkAccess(event.getPlayer(), event.getSpigot(), plugin)) {
                    event.setCancelled(true);
                    BreweryPlugin.getInstance().msg((CommandSender)event.getPlayer(), BreweryPlugin.getInstance().languageReader.get("Error_NoBarrelAccess", new String[0]));
                }
            }
            catch (Throwable e) {
                event.setCancelled(true);
                BreweryPlugin.getInstance().errorLog("Failed to Check WorldGuard for Barrel Open Permissions!");
                BreweryPlugin.getInstance().errorLog("Brewery was tested with version 5.8, 6.1 to 7.0 of WorldGuard!");
                BreweryPlugin.getInstance().errorLog("Disable the WorldGuard support in the config and do /brew reload");
                e.printStackTrace();
                Player player = event.getPlayer();
                if (player.hasPermission("brewery.admin") || player.hasPermission("brewery.mod")) {
                    BreweryPlugin.getInstance().msg((CommandSender)player, "&cWorldGuard check Error, Brewery was tested with up to v7.0 of Worldguard");
                    BreweryPlugin.getInstance().msg((CommandSender)player, "&cSet &7useWorldGuard: false &cin the config and /brew reload");
                }
                BreweryPlugin.getInstance().msg((CommandSender)player, "&cError opening Barrel, please report to an Admin!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBarrelAccess(BarrelAccessEvent event) {
        Block sign;
        Plugin plugin;
        Player player;
        if (BConfig.useGMInventories) {
            Plugin pl = BreweryPlugin.getInstance().getServer().getPluginManager().getPlugin("GameModeInventories");
            if (pl != null && pl.isEnabled()) {
                try {
                    if (pl.getConfig().getBoolean("restrict_creative") && (player = event.getPlayer()).getGameMode() == GameMode.CREATIVE && (!pl.getConfig().getBoolean("bypass.inventories") || !player.hasPermission("gamemodeinventories.bypass") && !player.isOp())) {
                        event.setCancelled(true);
                        if (!pl.getConfig().getBoolean("dont_spam_chat")) {
                            BreweryPlugin.getInstance().msg((CommandSender)event.getPlayer(), BreweryPlugin.getInstance().languageReader.get("Error_NoBarrelAccess", new String[0]));
                        }
                        return;
                    }
                }
                catch (Throwable e) {
                    BreweryPlugin.getInstance().errorLog("Failed to Check GameModeInventories for Barrel Open Permissions!");
                    BreweryPlugin.getInstance().errorLog("Players will be able to open Barrel with GameMode Creative");
                    e.printStackTrace();
                    BConfig.useGMInventories = false;
                }
            } else {
                BConfig.useGMInventories = false;
            }
        }
        if (BConfig.useGP && BreweryPlugin.getInstance().getServer().getPluginManager().isPluginEnabled("GriefPrevention")) {
            try {
                if (!GriefPreventionBarrel.checkAccess(event)) {
                    BreweryPlugin.getInstance().msg((CommandSender)event.getPlayer(), BreweryPlugin.getInstance().languageReader.get("Error_NoBarrelAccess", new String[0]));
                    event.setCancelled(true);
                    return;
                }
            }
            catch (Throwable e) {
                event.setCancelled(true);
                BreweryPlugin.getInstance().errorLog("Failed to Check GriefPrevention for Barrel Open Permissions!");
                BreweryPlugin.getInstance().errorLog("Brewery was tested with GriefPrevention v14.5 - v16.9");
                BreweryPlugin.getInstance().errorLog("Disable the GriefPrevention support in the config and do /brew reload");
                e.printStackTrace();
                player = event.getPlayer();
                if (player.hasPermission("brewery.admin") || player.hasPermission("brewery.mod")) {
                    BreweryPlugin.getInstance().msg((CommandSender)player, "&cGriefPrevention check Error, Brewery was tested with up to v16.9 of GriefPrevention");
                    BreweryPlugin.getInstance().msg((CommandSender)player, "&cSet &7useGriefPrevention: false &cin the config and /brew reload");
                } else {
                    BreweryPlugin.getInstance().msg((CommandSender)player, "&cError opening Barrel, please report to an Admin!");
                }
                return;
            }
        }
        if (BConfig.useLWC && (plugin = BreweryPlugin.getInstance().getServer().getPluginManager().getPlugin("LWC")) != null && !LegacyUtil.isSign(event.getClickedBlock().getType()) && !(sign = event.getBarrel().getBody().getSignOfSpigot()).equals(event.getClickedBlock())) {
            Player player2 = event.getPlayer();
            try {
                if (!LWCBarrel.checkAccess(player2, sign, plugin)) {
                    BreweryPlugin.getInstance().msg((CommandSender)event.getPlayer(), BreweryPlugin.getInstance().languageReader.get("Error_NoBarrelAccess", new String[0]));
                    event.setCancelled(true);
                    return;
                }
            }
            catch (Throwable e) {
                event.setCancelled(true);
                BreweryPlugin.getInstance().errorLog("Failed to Check LWC for Barrel Open Permissions!");
                BreweryPlugin.getInstance().errorLog("Brewery was tested with version 4.5.0 of LWC!");
                BreweryPlugin.getInstance().errorLog("Disable the LWC support in the config and do /brew reload");
                e.printStackTrace();
                if (player2.hasPermission("brewery.admin") || player2.hasPermission("brewery.mod")) {
                    BreweryPlugin.getInstance().msg((CommandSender)player2, "&cLWC check Error, Brewery was tested with up to v4.5.0 of LWC");
                    BreweryPlugin.getInstance().msg((CommandSender)player2, "&cSet &7useLWC: false &cin the config and /brew reload");
                } else {
                    BreweryPlugin.getInstance().msg((CommandSender)player2, "&cError opening Barrel, please report to an Admin!");
                }
                return;
            }
        }
        if (BConfig.useTowny && BreweryPlugin.getInstance().getServer().getPluginManager().isPluginEnabled("Towny")) {
            try {
                if (!TownyBarrel.checkAccess(event)) {
                    BreweryPlugin.getInstance().msg((CommandSender)event.getPlayer(), BreweryPlugin.getInstance().languageReader.get("Error_NoBarrelAccess", new String[0]));
                    event.setCancelled(true);
                    return;
                }
            }
            catch (Throwable e) {
                event.setCancelled(true);
                BreweryPlugin.getInstance().errorLog("Failed to Check Towny for Barrel Open Permissions!");
                BreweryPlugin.getInstance().errorLog("Brewery was tested with Towny v0.96.3.0");
                BreweryPlugin.getInstance().errorLog("Disable the Towny support in the config and do /brew reload");
                e.printStackTrace();
                player = event.getPlayer();
                if (player.hasPermission("brewery.admin") || player.hasPermission("brewery.mod")) {
                    BreweryPlugin.getInstance().msg((CommandSender)player, "&cTowny check Error, Brewery was tested with up to v0.96.3.0 of Towny");
                    BreweryPlugin.getInstance().msg((CommandSender)player, "&cSet &7useTowny: false &cin the config and /brew reload");
                } else {
                    BreweryPlugin.getInstance().msg((CommandSender)player, "&cError opening Barrel, please report to an Admin!");
                }
                return;
            }
        }
        if (BConfig.useBlocklocker && BreweryPlugin.getInstance().getServer().getPluginManager().isPluginEnabled("BlockLocker")) {
            try {
                if (!BlocklockerBarrel.checkAccess(event)) {
                    BreweryPlugin.getInstance().msg((CommandSender)event.getPlayer(), BreweryPlugin.getInstance().languageReader.get("Error_NoBarrelAccess", new String[0]));
                    event.setCancelled(true);
                    return;
                }
            }
            catch (Throwable e) {
                event.setCancelled(true);
                BreweryPlugin.getInstance().errorLog("Failed to Check BlockLocker for Barrel Open Permissions!");
                BreweryPlugin.getInstance().errorLog("Brewery was tested with BlockLocker v1.9");
                BreweryPlugin.getInstance().errorLog("Disable the BlockLocker support in the config and do /brew reload");
                e.printStackTrace();
                player = event.getPlayer();
                if (player.hasPermission("brewery.admin") || player.hasPermission("brewery.mod")) {
                    BreweryPlugin.getInstance().msg((CommandSender)player, "&cBlockLocker check Error, Brewery was tested with v1.9 of BlockLocker");
                    BreweryPlugin.getInstance().msg((CommandSender)player, "&cSet &7useBlockLocker: false &cin the config and /brew reload");
                } else {
                    BreweryPlugin.getInstance().msg((CommandSender)player, "&cError opening Barrel, please report to an Admin!");
                }
                return;
            }
        }
        if (BConfig.virtualChestPerms) {
            Player player3 = event.getPlayer();
            BlockState originalBlockState = event.getClickedBlock().getState();
            event.getClickedBlock().setType(Material.CHEST, false);
            PlayerInteractEvent simulatedEvent = new PlayerInteractEvent(player3, Action.RIGHT_CLICK_BLOCK, player3.getInventory().getItemInMainHand(), event.getClickedBlock(), event.getClickedBlockFace(), EquipmentSlot.HAND);
            try {
                BreweryPlugin.getInstance().getServer().getPluginManager().callEvent((Event)simulatedEvent);
            }
            catch (Throwable e) {
                BreweryPlugin.getInstance().errorLog("Failed to simulate a Chest for Barrel Open Permissions!");
                BreweryPlugin.getInstance().errorLog("Disable useVirtualChestPerms in the config and do /brew reload");
                e.printStackTrace();
                if (player3.hasPermission("brewery.admin") || player3.hasPermission("brewery.mod")) {
                    BreweryPlugin.getInstance().msg((CommandSender)player3, "&cVirtual Chest Error");
                    BreweryPlugin.getInstance().msg((CommandSender)player3, "&cSet &7useVirtualChestPerms: false &cin the config and /brew reload");
                } else {
                    BreweryPlugin.getInstance().msg((CommandSender)player3, "&cError opening Barrel, please report to an Admin!");
                }
            }
            finally {
                event.getClickedBlock().setType(Material.AIR, false);
                originalBlockState.update(true);
            }
            if (simulatedEvent.useInteractedBlock() == Event.Result.DENY) {
                event.setCancelled(true);
                BreweryPlugin.getInstance().msg((CommandSender)event.getPlayer(), BreweryPlugin.getInstance().languageReader.get("Error_NoBarrelAccess", new String[0]));
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onBarrelDestroy(BarrelDestroyEvent event) {
        block14: {
            if (!BConfig.useLWC) {
                return;
            }
            if (event.hasPlayer()) {
                Player player = event.getPlayerOptional();
                assert (player != null);
                try {
                    if (LWCBarrel.denyDestroy(player, event.getBarrel())) {
                        event.setCancelled(true);
                    }
                }
                catch (Throwable e) {
                    event.setCancelled(true);
                    BreweryPlugin.getInstance().errorLog("Failed to Check LWC for Barrel Break Permissions!");
                    BreweryPlugin.getInstance().errorLog("Brewery was tested with version 4.5.0 of LWC!");
                    BreweryPlugin.getInstance().errorLog("Disable the LWC support in the config and do /brew reload");
                    e.printStackTrace();
                    if (player.hasPermission("brewery.admin") || player.hasPermission("brewery.mod")) {
                        BreweryPlugin.getInstance().msg((CommandSender)player, "&cLWC check Error, Brewery was tested with up to v4.5.0 of LWC");
                        BreweryPlugin.getInstance().msg((CommandSender)player, "&cSet &7useLWC: false &cin the config and /brew reload");
                        break block14;
                    }
                    BreweryPlugin.getInstance().msg((CommandSender)player, "&cError breaking Barrel, please report to an Admin!");
                }
            } else {
                try {
                    if (event.getReason() == BarrelDestroyEvent.Reason.EXPLODED) {
                        if (LWCBarrel.denyExplosion(event.getBarrel())) {
                            event.setCancelled(true);
                        }
                    } else if (LWCBarrel.denyDestroyOther(event.getBarrel())) {
                        event.setCancelled(true);
                    }
                }
                catch (Throwable e) {
                    event.setCancelled(true);
                    BreweryPlugin.getInstance().errorLog("Failed to Check LWC on Barrel Destruction!");
                    BreweryPlugin.getInstance().errorLog("Brewery was tested with version 4.5.0 of LWC!");
                    BreweryPlugin.getInstance().errorLog("Disable the LWC support in the config and do /brew reload");
                    e.printStackTrace();
                }
            }
        }
    }

    @EventHandler
    public void onBarrelRemove(BarrelRemoveEvent event) {
        if (!BConfig.useLWC) {
            return;
        }
        try {
            LWCBarrel.remove(event.getBarrel());
        }
        catch (Throwable e) {
            BreweryPlugin.getInstance().errorLog("Failed to Remove LWC Lock from Barrel!");
            BreweryPlugin.getInstance().errorLog("Brewery was tested with version 4.5.0 of LWC!");
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (BConfig.useLB && event.getInventory().getHolder() instanceof Barrel) {
            try {
                LogBlockBarrel.closeBarrel(event.getPlayer(), event.getInventory());
            }
            catch (Exception e) {
                BreweryPlugin.getInstance().errorLog("Failed to Log Barrel to LogBlock!");
                BreweryPlugin.getInstance().errorLog("Brewery was tested with version 1.94 of LogBlock!");
                e.printStackTrace();
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent event) {
        if (!BreweryPlugin.use1_9) {
            return;
        }
        if (BConfig.hasMMOItems == null) {
            BConfig.hasMMOItems = BreweryPlugin.getInstance().getServer().getPluginManager().isPluginEnabled("MMOItems") && BreweryPlugin.getInstance().getServer().getPluginManager().isPluginEnabled("MythicLib");
        }
        if (!BConfig.hasMMOItems.booleanValue()) {
            return;
        }
        try {
            NBTItem item;
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.hasItem() && event.getHand() == EquipmentSlot.HAND && event.getClickedBlock() != null && LegacyUtil.isWaterCauldron(event.getClickedBlock().getType()) && (item = NBTItem.get((ItemStack)event.getItem())).hasType()) {
                for (RecipeItem rItem : BCauldronRecipe.acceptedCustom) {
                    MMOItemsPluginItem mmo;
                    if (!(rItem instanceof MMOItemsPluginItem) || !(mmo = (MMOItemsPluginItem)rItem).matches(event.getItem())) continue;
                    event.setCancelled(true);
                    BreweryPlugin.getInstance().playerListener.onPlayerInteract(event);
                    return;
                }
            }
        }
        catch (Throwable e) {
            BreweryPlugin.getInstance().errorLog("Could not check MMOItems for Item");
            e.printStackTrace();
            BConfig.hasMMOItems = false;
        }
    }
}

