/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.filedata;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.filedata.BData;
import com.dre.brewery.filedata.DataSave;
import com.dre.brewery.integration.universalScheduler.UniversalRunnable;
import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ReadOldData
extends UniversalRunnable {
    public FileConfiguration data;
    public boolean done = false;

    @Override
    public void run() {
        int wait = 0;
        while (!BData.dataMutex.compareAndSet(0, -1)) {
            if (wait > 300) {
                BreweryPlugin.getInstance().errorLog("Loading Process active for too long while trying to save! Mutex: " + BData.dataMutex.get());
                return;
            }
            ++wait;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        File worldDataFile = new File(BreweryPlugin.getInstance().getDataFolder(), "worlddata.yml");
        if (BData.worldData == null) {
            if (!worldDataFile.exists()) {
                this.data = new YamlConfiguration();
                this.done = true;
                return;
            }
            this.data = YamlConfiguration.loadConfiguration((File)worldDataFile);
        } else {
            this.data = BData.worldData;
        }
        if (DataSave.lastBackup > 10) {
            worldDataFile.renameTo(new File(BreweryPlugin.getInstance().getDataFolder(), "worlddataBackup.yml"));
            DataSave.lastBackup = 0;
        } else {
            ++DataSave.lastBackup;
        }
        this.done = true;
    }

    public FileConfiguration getData() {
        return this.data;
    }
}

